/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ovsdb.controller;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.onosproject.ovsdb.controller.OvsdbPortName;
import org.onosproject.ovsdb.controller.OvsdbPortNumber;

public final class OvsdbPort {
    private final OvsdbPortNumber portNumber;
    private final OvsdbPortName portName;

    public OvsdbPort(OvsdbPortNumber portNumber, OvsdbPortName portName) {
        Preconditions.checkNotNull((Object)portNumber, (Object)"portNumber is not null");
        Preconditions.checkNotNull((Object)portName, (Object)"portName is not null");
        this.portNumber = portNumber;
        this.portName = portName;
    }

    public OvsdbPortNumber portNumber() {
        return this.portNumber;
    }

    public OvsdbPortName portName() {
        return this.portName;
    }

    public int hashCode() {
        return Objects.hash(this.portNumber, this.portName);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof OvsdbPort) {
            OvsdbPort otherOvsdbPort = (OvsdbPort)obj;
            return Objects.equals(this.portNumber, otherOvsdbPort.portNumber) && Objects.equals(this.portName, otherOvsdbPort.portName);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("portNumber", (Object)String.valueOf(this.portNumber.value())).add("portName", (Object)this.portName.value()).toString();
    }
}

