/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ovsdb.controller;

import com.google.common.collect.Maps;
import java.util.concurrent.ConcurrentMap;
import org.onosproject.ovsdb.controller.OvsdbTableStore;

public class OvsdbStore {
    private final ConcurrentMap<String, OvsdbTableStore> ovsdbStore = Maps.newConcurrentMap();

    public OvsdbTableStore getOvsdbTableStore(String dbName) {
        OvsdbTableStore tableStore = (OvsdbTableStore)this.ovsdbStore.get(dbName);
        if (tableStore == null) {
            return null;
        }
        return tableStore;
    }

    public void createOrUpdateOvsdbStore(String dbName, OvsdbTableStore tableStore) {
        this.ovsdbStore.put(dbName, tableStore);
    }

    public void dropOvsdbStore(String dbName) {
        this.ovsdbStore.remove(dbName);
    }

    public ConcurrentMap<String, OvsdbTableStore> getOvsdbStore() {
        return this.ovsdbStore;
    }
}

