/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ovsdb.controller.driver;

import java.util.Optional;
import org.onosproject.net.behaviour.DeviceCpuStats;
import org.onosproject.net.behaviour.DeviceMemoryStats;
import org.onosproject.ovsdb.controller.OvsdbClientService;
import org.onosproject.ovsdb.controller.driver.DefaultOvsdbClient;
import org.onosproject.ovsdb.rfc.table.CpuMemoryData;
import org.onosproject.ovsdb.rfc.table.OvsdbTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PicaOvsdbClient {
    private final Logger log = LoggerFactory.getLogger(DefaultOvsdbClient.class);
    private OvsdbClientService ovsdbClientService;

    public PicaOvsdbClient(OvsdbClientService ovsdbClient) {
        this.ovsdbClientService = ovsdbClient;
    }

    public Optional<DeviceMemoryStats> getDeviceMemoryUsage() {
        Optional<Object> deviceMemoryDataObject = this.ovsdbClientService.getFirstRow("Switch_Inventory", OvsdbTable.CPUMEMORYDATA);
        if (!deviceMemoryDataObject.isPresent()) {
            this.log.debug("Could not find {} column in {} table", (Object)"memory", (Object)"Cpu_Memory_Data");
            return Optional.empty();
        }
        CpuMemoryData deviceMemoryData = (CpuMemoryData)deviceMemoryDataObject.get();
        long totalMem = deviceMemoryData.getTotalMemoryStats();
        long usedMem = deviceMemoryData.getUsedMemoryStats();
        long freeMem = deviceMemoryData.getFreeMemoryStats();
        DeviceMemoryStats deviceMemoryStats = new DeviceMemoryStats();
        deviceMemoryStats.setFree(freeMem);
        deviceMemoryStats.setUsed(usedMem);
        deviceMemoryStats.setTotal(totalMem);
        return Optional.of(deviceMemoryStats);
    }

    public Optional<DeviceCpuStats> getDeviceCpuUsage() {
        Optional<Object> deviceCpuDataObject = this.ovsdbClientService.getFirstRow("Switch_Inventory", OvsdbTable.CPUMEMORYDATA);
        if (!deviceCpuDataObject.isPresent()) {
            this.log.debug("Could not find {} column in {} table", (Object)"cpu", (Object)"Cpu_Memory_Data");
            return Optional.empty();
        }
        CpuMemoryData deviceCpuData = (CpuMemoryData)deviceCpuDataObject.get();
        this.log.debug("GOT CpuMemoryData as {} ", (Object)deviceCpuData);
        float freeCpuStat = deviceCpuData.getFreeCpuStats();
        DeviceCpuStats deviceCpuStats = new DeviceCpuStats();
        deviceCpuStats.setUsed(100.0f - freeCpuStat);
        return Optional.of(deviceCpuStats);
    }
}

