/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.p4runtime.ctl.codec;

import com.google.protobuf.ByteString;
import java.nio.ByteBuffer;
import org.onlab.util.ImmutableByteSequence;
import org.onosproject.net.pi.model.PiActionId;
import org.onosproject.net.pi.model.PiActionParamId;
import org.onosproject.net.pi.model.PiPipeconf;
import org.onosproject.net.pi.runtime.PiAction;
import org.onosproject.net.pi.runtime.PiActionParam;
import org.onosproject.p4runtime.ctl.codec.AbstractCodec;
import org.onosproject.p4runtime.ctl.codec.CodecException;
import org.onosproject.p4runtime.ctl.codec.Utils;
import org.onosproject.p4runtime.ctl.utils.P4InfoBrowser;
import p4.config.v1.P4InfoOuterClass;
import p4.v1.P4RuntimeOuterClass;

public final class ActionCodec
extends AbstractCodec<PiAction, P4RuntimeOuterClass.Action, Object> {
    @Override
    protected P4RuntimeOuterClass.Action encode(PiAction piAction, Object ignored, PiPipeconf pipeconf, P4InfoBrowser browser) throws CodecException, P4InfoBrowser.NotFoundException {
        int actionId = browser.actions().getByName(piAction.id().toString()).getPreamble().getId();
        P4RuntimeOuterClass.Action.Builder actionMsgBuilder = P4RuntimeOuterClass.Action.newBuilder().setActionId(actionId);
        for (PiActionParam p : piAction.parameters()) {
            P4InfoOuterClass.Action.Param paramInfo = browser.actionParams(actionId).getByName(p.id().toString());
            ByteString paramValue = ByteString.copyFrom((ByteBuffer)p.value().asReadOnlyBuffer());
            Utils.assertSize(String.format("param '%s' of action '%s'", p.id(), piAction.id()), paramValue, paramInfo.getBitwidth());
            actionMsgBuilder.addParams(P4RuntimeOuterClass.Action.Param.newBuilder().setParamId(paramInfo.getId()).setValue(paramValue).build());
        }
        return actionMsgBuilder.build();
    }

    @Override
    protected PiAction decode(P4RuntimeOuterClass.Action message, Object ignored, PiPipeconf pipeconf, P4InfoBrowser browser) throws P4InfoBrowser.NotFoundException {
        P4InfoBrowser.EntityBrowser<P4InfoOuterClass.Action.Param> paramInfo = browser.actionParams(message.getActionId());
        String actionName = browser.actions().getById(message.getActionId()).getPreamble().getName();
        PiAction.Builder builder = PiAction.builder().withId(PiActionId.of((String)actionName));
        for (P4RuntimeOuterClass.Action.Param p : message.getParamsList()) {
            String paramName = paramInfo.getById(p.getParamId()).getName();
            ImmutableByteSequence value = ImmutableByteSequence.copyFrom((byte[])p.getValue().toByteArray());
            builder.withParameter(new PiActionParam(PiActionParamId.of((String)paramName), value));
        }
        return builder.build();
    }
}

