/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.p4runtime.ctl.codec;

import org.onosproject.net.PortNumber;
import org.onosproject.net.pi.model.PiPipeconf;
import org.onosproject.net.pi.runtime.PiPreReplica;
import org.onosproject.p4runtime.ctl.codec.AbstractCodec;
import org.onosproject.p4runtime.ctl.codec.CodecException;
import org.onosproject.p4runtime.ctl.utils.P4InfoBrowser;
import p4.v1.P4RuntimeOuterClass;

public class PreReplicaCodec
extends AbstractCodec<PiPreReplica, P4RuntimeOuterClass.Replica, Object> {
    @Override
    protected P4RuntimeOuterClass.Replica encode(PiPreReplica replica, Object ignore, PiPipeconf pipeconf, P4InfoBrowser browser) throws CodecException, P4InfoBrowser.NotFoundException {
        int p4PortId;
        try {
            p4PortId = Math.toIntExact(replica.egressPort().toLong());
        }
        catch (ArithmeticException e) {
            throw new CodecException(String.format("Cannot cast 64 bit port value '%s' to 32 bit", replica.egressPort()));
        }
        return P4RuntimeOuterClass.Replica.newBuilder().setEgressPort(p4PortId).setInstance(replica.instanceId()).build();
    }

    @Override
    protected PiPreReplica decode(P4RuntimeOuterClass.Replica message, Object ignore, PiPipeconf pipeconf, P4InfoBrowser browser) throws CodecException, P4InfoBrowser.NotFoundException {
        return new PiPreReplica(PortNumber.portNumber((long)message.getEgressPort()), message.getInstance());
    }
}

