/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.p4runtime.ctl.utils;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.protobuf.Message;
import java.util.Map;
import p4.config.v1.P4InfoOuterClass;

public final class P4InfoBrowser {
    private final EntityBrowser<P4InfoOuterClass.Table> tables = new EntityBrowser("table");
    private final EntityBrowser<P4InfoOuterClass.Action> actions = new EntityBrowser("action");
    private final EntityBrowser<P4InfoOuterClass.ActionProfile> actionProfiles = new EntityBrowser("action profile");
    private final EntityBrowser<P4InfoOuterClass.Counter> counters = new EntityBrowser("counter");
    private final EntityBrowser<P4InfoOuterClass.DirectCounter> directCounters = new EntityBrowser("direct counter");
    private final EntityBrowser<P4InfoOuterClass.Meter> meters = new EntityBrowser("meter");
    private final EntityBrowser<P4InfoOuterClass.DirectMeter> directMeters = new EntityBrowser("direct meter");
    private final EntityBrowser<P4InfoOuterClass.ControllerPacketMetadata> ctrlPktMetadatas = new EntityBrowser("controller packet metadata");
    private final Map<Integer, EntityBrowser<P4InfoOuterClass.Action.Param>> actionParams = Maps.newHashMap();
    private final Map<Integer, EntityBrowser<P4InfoOuterClass.MatchField>> matchFields = Maps.newHashMap();
    private final Map<Integer, EntityBrowser<P4InfoOuterClass.ControllerPacketMetadata.Metadata>> ctrlPktMetadatasMetadata = Maps.newHashMap();

    public P4InfoBrowser(P4InfoOuterClass.P4Info p4info) {
        this.parseP4Info(p4info);
    }

    private void parseP4Info(P4InfoOuterClass.P4Info p4info) {
        p4info.getTablesList().forEach(entity -> {
            this.tables.addWithPreamble(entity.getPreamble(), (P4InfoOuterClass.Table)entity);
            int tableId = entity.getPreamble().getId();
            String tableName = entity.getPreamble().getName();
            EntityBrowser matchFieldBrowser = new EntityBrowser(String.format("match field for table '%s'", tableName));
            entity.getMatchFieldsList().forEach(m -> matchFieldBrowser.add(m.getName(), null, m.getId(), m));
            this.matchFields.put(tableId, matchFieldBrowser);
        });
        p4info.getActionsList().forEach(entity -> {
            this.actions.addWithPreamble(entity.getPreamble(), (P4InfoOuterClass.Action)entity);
            int actionId = entity.getPreamble().getId();
            String actionName = entity.getPreamble().getName();
            EntityBrowser paramBrowser = new EntityBrowser(String.format("param for action '%s'", actionName));
            entity.getParamsList().forEach(p -> paramBrowser.add(p.getName(), null, p.getId(), p));
            this.actionParams.put(actionId, paramBrowser);
        });
        p4info.getActionProfilesList().forEach(entity -> this.actionProfiles.addWithPreamble(entity.getPreamble(), (P4InfoOuterClass.ActionProfile)entity));
        p4info.getCountersList().forEach(entity -> this.counters.addWithPreamble(entity.getPreamble(), (P4InfoOuterClass.Counter)entity));
        p4info.getDirectCountersList().forEach(entity -> this.directCounters.addWithPreamble(entity.getPreamble(), (P4InfoOuterClass.DirectCounter)entity));
        p4info.getMetersList().forEach(entity -> this.meters.addWithPreamble(entity.getPreamble(), (P4InfoOuterClass.Meter)entity));
        p4info.getDirectMetersList().forEach(entity -> this.directMeters.addWithPreamble(entity.getPreamble(), (P4InfoOuterClass.DirectMeter)entity));
        p4info.getControllerPacketMetadataList().forEach(entity -> {
            this.ctrlPktMetadatas.addWithPreamble(entity.getPreamble(), (P4InfoOuterClass.ControllerPacketMetadata)entity);
            int ctrlPktMetadataId = entity.getPreamble().getId();
            String ctrlPktMetadataName = entity.getPreamble().getName();
            EntityBrowser metadataBrowser = new EntityBrowser(String.format("metadata field for controller packet metadata '%s'", ctrlPktMetadataName));
            entity.getMetadataList().forEach(m -> metadataBrowser.add(m.getName(), null, m.getId(), m));
            this.ctrlPktMetadatasMetadata.put(ctrlPktMetadataId, metadataBrowser);
        });
    }

    public EntityBrowser<P4InfoOuterClass.Table> tables() {
        return this.tables;
    }

    public EntityBrowser<P4InfoOuterClass.Action> actions() {
        return this.actions;
    }

    public EntityBrowser<P4InfoOuterClass.ActionProfile> actionProfiles() {
        return this.actionProfiles;
    }

    public EntityBrowser<P4InfoOuterClass.Counter> counters() {
        return this.counters;
    }

    public EntityBrowser<P4InfoOuterClass.DirectCounter> directCounters() {
        return this.directCounters;
    }

    public EntityBrowser<P4InfoOuterClass.Meter> meters() {
        return this.meters;
    }

    public EntityBrowser<P4InfoOuterClass.DirectMeter> directMeters() {
        return this.directMeters;
    }

    public EntityBrowser<P4InfoOuterClass.ControllerPacketMetadata> controllerPacketMetadatas() {
        return this.ctrlPktMetadatas;
    }

    public EntityBrowser<P4InfoOuterClass.Action.Param> actionParams(int actionId) throws NotFoundException {
        this.actions.getById(actionId);
        return this.actionParams.get(actionId);
    }

    public EntityBrowser<P4InfoOuterClass.MatchField> matchFields(int tableId) throws NotFoundException {
        this.tables.getById(tableId);
        return this.matchFields.get(tableId);
    }

    public EntityBrowser<P4InfoOuterClass.ControllerPacketMetadata.Metadata> packetMetadatas(int controllerPacketMetadataId) throws NotFoundException {
        this.ctrlPktMetadatas.getById(controllerPacketMetadataId);
        return this.ctrlPktMetadatasMetadata.get(controllerPacketMetadataId);
    }

    public static final class NotFoundException
    extends Exception {
        public NotFoundException(String entityName, String key, String hint) {
            super(String.format("No such %s in P4Info with name '%s'%s", entityName, key, hint.isEmpty() ? "" : " (" + hint + ")"));
        }

        public NotFoundException(String entityName, int id) {
            super(String.format("No such %s in P4Info with id '%d'", entityName, id));
        }
    }

    public static final class EntityBrowser<T extends Message> {
        private String entityName;
        private final Map<String, T> names = Maps.newHashMap();
        private final Map<String, String> aliasToNames = Maps.newHashMap();
        private final Map<Integer, T> ids = Maps.newHashMap();

        private EntityBrowser(String entityName) {
            this.entityName = entityName;
        }

        private void add(String name, String alias, int id, T entity) {
            Preconditions.checkNotNull((Object)name);
            Preconditions.checkArgument((!name.isEmpty() ? 1 : 0) != 0, (Object)"Name cannot be empty");
            Preconditions.checkNotNull(entity);
            this.names.put(name, entity);
            this.ids.put(id, entity);
            if (alias != null && !alias.isEmpty()) {
                this.aliasToNames.put(alias, name);
            }
        }

        private void addWithPreamble(P4InfoOuterClass.Preamble preamble, T entity) {
            Preconditions.checkNotNull((Object)preamble);
            this.add(preamble.getName(), preamble.getAlias(), preamble.getId(), entity);
        }

        public boolean hasName(String name) {
            return this.names.containsKey(name);
        }

        public T getByName(String name) throws NotFoundException {
            if (this.hasName(name)) {
                return (T)((Message)this.names.get(name));
            }
            String hint = this.aliasToNames.containsKey(name) ? String.format("Did you mean '%s'? Make sure to use entity names in PI IDs, not aliases", this.aliasToNames.get(name)) : "";
            throw new NotFoundException(this.entityName, name, hint);
        }

        public boolean hasId(int id) {
            return this.ids.containsKey(id);
        }

        public T getById(int id) throws NotFoundException {
            if (!this.hasId(id)) {
                throw new NotFoundException(this.entityName, id);
            }
            return (T)((Message)this.ids.get(id));
        }
    }
}

