/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.p4runtime.ctl.codec;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.protobuf.Message;
import com.google.protobuf.TextFormat;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.onosproject.net.pi.model.PiPipeconf;
import org.onosproject.p4runtime.ctl.codec.CodecException;
import org.onosproject.p4runtime.ctl.utils.P4InfoBrowser;
import org.onosproject.p4runtime.ctl.utils.PipeconfHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractCodec<P, M extends Message, X> {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());

    AbstractCodec() {
    }

    protected abstract M encode(P var1, X var2, PiPipeconf var3, P4InfoBrowser var4) throws CodecException, P4InfoBrowser.NotFoundException;

    protected abstract P decode(M var1, X var2, PiPipeconf var3, P4InfoBrowser var4) throws CodecException, P4InfoBrowser.NotFoundException;

    public M encode(P object, X metadata, PiPipeconf pipeconf) throws CodecException {
        Preconditions.checkNotNull(object);
        try {
            return this.encode(object, metadata, pipeconf, this.browserOrFail(pipeconf));
        }
        catch (P4InfoBrowser.NotFoundException e) {
            throw new CodecException(e.getMessage());
        }
    }

    public P decode(M message, X metadata, PiPipeconf pipeconf) throws CodecException {
        Preconditions.checkNotNull(message);
        try {
            return this.decode(message, metadata, pipeconf, this.browserOrFail(pipeconf));
        }
        catch (P4InfoBrowser.NotFoundException e) {
            throw new CodecException(e.getMessage());
        }
    }

    private M encodeOrNull(P object, X metadata, PiPipeconf pipeconf) {
        Preconditions.checkNotNull(object);
        try {
            return this.encode(object, metadata, pipeconf);
        }
        catch (CodecException e) {
            this.log.error("Unable to encode {}: {} [{}]", new Object[]{object.getClass().getSimpleName(), e.getMessage(), object.toString()});
            return null;
        }
    }

    private P decodeOrNull(M message, X metadata, PiPipeconf pipeconf) {
        Preconditions.checkNotNull(message);
        try {
            return this.decode(message, metadata, pipeconf);
        }
        catch (CodecException e) {
            this.log.error("Unable to decode {}: {} [{}]", new Object[]{message.getClass().getSimpleName(), e.getMessage(), TextFormat.shortDebugString(message)});
            return null;
        }
    }

    private List<M> encodeAllSkipException(Collection<P> objects, X metadata, PiPipeconf pipeconf) {
        Preconditions.checkNotNull(objects);
        if (objects.isEmpty()) {
            return ImmutableList.of();
        }
        return objects.stream().map(p -> this.encodeOrNull(p, metadata, pipeconf)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private List<P> decodeAllSkipException(Collection<M> messages, X metadata, PiPipeconf pipeconf) {
        Preconditions.checkNotNull(messages);
        if (messages.isEmpty()) {
            return ImmutableList.of();
        }
        return messages.stream().map(m -> this.decodeOrNull(m, metadata, pipeconf)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    List<M> encodeAll(Collection<P> objects, X metadata, PiPipeconf pipeconf) throws CodecException {
        Preconditions.checkNotNull(objects);
        if (objects.isEmpty()) {
            return ImmutableList.of();
        }
        List<M> messages = this.encodeAllSkipException(objects, metadata, pipeconf);
        if (objects.size() != messages.size()) {
            throw new CodecException(String.format("Unable to encode %d entities of %d given (see previous logs for details)", objects.size() - messages.size(), objects.size()));
        }
        return messages;
    }

    List<P> decodeAll(Collection<M> messages, X metadata, PiPipeconf pipeconf) throws CodecException {
        Preconditions.checkNotNull(messages);
        if (messages.isEmpty()) {
            return ImmutableList.of();
        }
        List<P> objects = this.decodeAllSkipException(messages, metadata, pipeconf);
        if (messages.size() != objects.size()) {
            throw new CodecException(String.format("Unable to decode %d messages of %d given (see previous logs for details)", messages.size() - objects.size(), messages.size()));
        }
        return objects;
    }

    P4InfoBrowser browserOrFail(PiPipeconf pipeconf) throws CodecException {
        Preconditions.checkNotNull((Object)pipeconf);
        P4InfoBrowser browser = PipeconfHelper.getP4InfoBrowser(pipeconf);
        if (browser == null) {
            throw new CodecException(String.format("Unable to get P4InfoBrowser for pipeconf %s", pipeconf.id()));
        }
        return browser;
    }
}

