/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.p4runtime.ctl.codec;

import com.google.protobuf.ByteString;
import java.nio.ByteBuffer;
import org.onlab.util.ImmutableByteSequence;
import org.onosproject.net.pi.model.PiMatchFieldId;
import org.onosproject.net.pi.model.PiPipeconf;
import org.onosproject.net.pi.runtime.PiExactFieldMatch;
import org.onosproject.net.pi.runtime.PiFieldMatch;
import org.onosproject.net.pi.runtime.PiLpmFieldMatch;
import org.onosproject.net.pi.runtime.PiRangeFieldMatch;
import org.onosproject.net.pi.runtime.PiTernaryFieldMatch;
import org.onosproject.p4runtime.ctl.codec.AbstractCodec;
import org.onosproject.p4runtime.ctl.codec.CodecException;
import org.onosproject.p4runtime.ctl.codec.Utils;
import org.onosproject.p4runtime.ctl.utils.P4InfoBrowser;
import p4.config.v1.P4InfoOuterClass;
import p4.v1.P4RuntimeOuterClass;

public final class FieldMatchCodec
extends AbstractCodec<PiFieldMatch, P4RuntimeOuterClass.FieldMatch, P4InfoOuterClass.Preamble> {
    private static final String VALUE_OF_PREFIX = "value of ";
    private static final String MASK_OF_PREFIX = "mask of ";
    private static final String HIGH_RANGE_VALUE_OF_PREFIX = "high range value of ";
    private static final String LOW_RANGE_VALUE_OF_PREFIX = "low range value of ";

    @Override
    public P4RuntimeOuterClass.FieldMatch encode(PiFieldMatch piFieldMatch, P4InfoOuterClass.Preamble tablePreamble, PiPipeconf pipeconf, P4InfoBrowser browser) throws CodecException, P4InfoBrowser.NotFoundException {
        P4RuntimeOuterClass.FieldMatch.Builder messageBuilder = P4RuntimeOuterClass.FieldMatch.newBuilder();
        String fieldName = (String)piFieldMatch.fieldId().id();
        P4InfoOuterClass.MatchField matchFieldInfo = browser.matchFields(tablePreamble.getId()).getByName(fieldName);
        String entityName = String.format("field match '%s' of table '%s'", matchFieldInfo.getName(), tablePreamble.getName());
        int fieldId = matchFieldInfo.getId();
        int fieldBitwidth = matchFieldInfo.getBitwidth();
        messageBuilder.setFieldId(fieldId);
        switch (piFieldMatch.type()) {
            case EXACT: {
                PiExactFieldMatch fieldMatch = (PiExactFieldMatch)piFieldMatch;
                ByteString exactValue = ByteString.copyFrom((ByteBuffer)fieldMatch.value().asReadOnlyBuffer());
                Utils.assertSize(VALUE_OF_PREFIX + entityName, exactValue, fieldBitwidth);
                return messageBuilder.setExact(P4RuntimeOuterClass.FieldMatch.Exact.newBuilder().setValue(exactValue).build()).build();
            }
            case TERNARY: {
                PiTernaryFieldMatch ternaryMatch = (PiTernaryFieldMatch)piFieldMatch;
                ByteString ternaryValue = ByteString.copyFrom((ByteBuffer)ternaryMatch.value().asReadOnlyBuffer());
                ByteString ternaryMask = ByteString.copyFrom((ByteBuffer)ternaryMatch.mask().asReadOnlyBuffer());
                Utils.assertSize(VALUE_OF_PREFIX + entityName, ternaryValue, fieldBitwidth);
                Utils.assertSize(MASK_OF_PREFIX + entityName, ternaryMask, fieldBitwidth);
                return messageBuilder.setTernary(P4RuntimeOuterClass.FieldMatch.Ternary.newBuilder().setValue(ternaryValue).setMask(ternaryMask).build()).build();
            }
            case LPM: {
                PiLpmFieldMatch lpmMatch = (PiLpmFieldMatch)piFieldMatch;
                ByteString lpmValue = ByteString.copyFrom((ByteBuffer)lpmMatch.value().asReadOnlyBuffer());
                int lpmPrefixLen = lpmMatch.prefixLength();
                Utils.assertSize(VALUE_OF_PREFIX + entityName, lpmValue, fieldBitwidth);
                Utils.assertPrefixLen(entityName, lpmPrefixLen, fieldBitwidth);
                return messageBuilder.setLpm(P4RuntimeOuterClass.FieldMatch.LPM.newBuilder().setValue(lpmValue).setPrefixLen(lpmPrefixLen).build()).build();
            }
            case RANGE: {
                PiRangeFieldMatch rangeMatch = (PiRangeFieldMatch)piFieldMatch;
                ByteString rangeHighValue = ByteString.copyFrom((ByteBuffer)rangeMatch.highValue().asReadOnlyBuffer());
                ByteString rangeLowValue = ByteString.copyFrom((ByteBuffer)rangeMatch.lowValue().asReadOnlyBuffer());
                Utils.assertSize(HIGH_RANGE_VALUE_OF_PREFIX + entityName, rangeHighValue, fieldBitwidth);
                Utils.assertSize(LOW_RANGE_VALUE_OF_PREFIX + entityName, rangeLowValue, fieldBitwidth);
                return messageBuilder.setRange(P4RuntimeOuterClass.FieldMatch.Range.newBuilder().setHigh(rangeHighValue).setLow(rangeLowValue).build()).build();
            }
        }
        throw new CodecException(String.format("Building of match type %s not implemented", piFieldMatch.type()));
    }

    @Override
    public PiFieldMatch decode(P4RuntimeOuterClass.FieldMatch message, P4InfoOuterClass.Preamble tablePreamble, PiPipeconf pipeconf, P4InfoBrowser browser) throws CodecException, P4InfoBrowser.NotFoundException {
        String fieldMatchName = browser.matchFields(tablePreamble.getId()).getById(message.getFieldId()).getName();
        PiMatchFieldId headerFieldId = PiMatchFieldId.of((String)fieldMatchName);
        P4RuntimeOuterClass.FieldMatch.FieldMatchTypeCase typeCase = message.getFieldMatchTypeCase();
        switch (typeCase) {
            case EXACT: {
                P4RuntimeOuterClass.FieldMatch.Exact exactFieldMatch = message.getExact();
                ImmutableByteSequence exactValue = ImmutableByteSequence.copyFrom((ByteBuffer)exactFieldMatch.getValue().asReadOnlyByteBuffer());
                return new PiExactFieldMatch(headerFieldId, exactValue);
            }
            case TERNARY: {
                P4RuntimeOuterClass.FieldMatch.Ternary ternaryFieldMatch = message.getTernary();
                ImmutableByteSequence ternaryValue = ImmutableByteSequence.copyFrom((ByteBuffer)ternaryFieldMatch.getValue().asReadOnlyByteBuffer());
                ImmutableByteSequence ternaryMask = ImmutableByteSequence.copyFrom((ByteBuffer)ternaryFieldMatch.getMask().asReadOnlyByteBuffer());
                return new PiTernaryFieldMatch(headerFieldId, ternaryValue, ternaryMask);
            }
            case LPM: {
                P4RuntimeOuterClass.FieldMatch.LPM lpmFieldMatch = message.getLpm();
                ImmutableByteSequence lpmValue = ImmutableByteSequence.copyFrom((ByteBuffer)lpmFieldMatch.getValue().asReadOnlyByteBuffer());
                int lpmPrefixLen = lpmFieldMatch.getPrefixLen();
                return new PiLpmFieldMatch(headerFieldId, lpmValue, lpmPrefixLen);
            }
            case RANGE: {
                P4RuntimeOuterClass.FieldMatch.Range rangeFieldMatch = message.getRange();
                ImmutableByteSequence rangeHighValue = ImmutableByteSequence.copyFrom((ByteBuffer)rangeFieldMatch.getHigh().asReadOnlyByteBuffer());
                ImmutableByteSequence rangeLowValue = ImmutableByteSequence.copyFrom((ByteBuffer)rangeFieldMatch.getLow().asReadOnlyByteBuffer());
                return new PiRangeFieldMatch(headerFieldId, rangeLowValue, rangeHighValue);
            }
        }
        throw new CodecException(String.format("Decoding of field match type '%s' not implemented", typeCase.name()));
    }
}

