/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.p4runtime.ctl.codec;

import java.nio.ByteBuffer;
import org.onlab.util.ImmutableByteSequence;
import org.onosproject.net.pi.model.PiPacketOperationType;
import org.onosproject.net.pi.model.PiPipeconf;
import org.onosproject.net.pi.runtime.PiPacketOperation;
import org.onosproject.p4runtime.ctl.codec.AbstractCodec;
import org.onosproject.p4runtime.ctl.codec.CodecException;
import org.onosproject.p4runtime.ctl.codec.Codecs;
import org.onosproject.p4runtime.ctl.utils.P4InfoBrowser;
import p4.config.v1.P4InfoOuterClass;
import p4.v1.P4RuntimeOuterClass;

public final class PacketInCodec
extends AbstractCodec<PiPacketOperation, P4RuntimeOuterClass.PacketIn, Object> {
    private static final String PACKET_IN = "packet_in";

    @Override
    protected P4RuntimeOuterClass.PacketIn encode(PiPacketOperation piEntity, Object ignored, PiPipeconf pipeconf, P4InfoBrowser browser) throws CodecException {
        throw new CodecException("Encoding of packet-in is not supported");
    }

    @Override
    protected PiPacketOperation decode(P4RuntimeOuterClass.PacketIn message, Object ignored, PiPipeconf pipeconf, P4InfoBrowser browser) throws CodecException, P4InfoBrowser.NotFoundException {
        P4InfoOuterClass.Preamble ctrlPktMetaPreamble = browser.controllerPacketMetadatas().getByName(PACKET_IN).getPreamble();
        return PiPacketOperation.builder().withType(PiPacketOperationType.PACKET_IN).withMetadatas(Codecs.CODECS.packetMetadata().decodeAll(message.getMetadataList(), ctrlPktMetaPreamble, pipeconf)).withData(ImmutableByteSequence.copyFrom((ByteBuffer)message.getPayload().asReadOnlyByteBuffer())).build();
    }
}

