/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.p4runtime.ctl.utils;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Maps;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.Message;
import com.google.protobuf.TextFormat;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.onosproject.net.pi.model.PiPipeconf;
import org.onosproject.p4runtime.ctl.utils.P4InfoBrowser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import p4.config.v1.P4InfoOuterClass;

public final class PipeconfHelper {
    private static final int P4INFO_BROWSER_EXPIRE_TIME_IN_MIN = 10;
    private static final Logger log = LoggerFactory.getLogger(PipeconfHelper.class);
    private static final Cache<Long, P4InfoBrowser> BROWSERS = CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).build();
    private static final Map<Long, P4InfoOuterClass.P4Info> P4INFOS = Maps.newConcurrentMap();

    private PipeconfHelper() {
    }

    public static P4InfoOuterClass.P4Info getP4Info(PiPipeconf pipeconf) {
        return P4INFOS.computeIfAbsent(pipeconf.fingerprint(), piPipeconfId -> {
            if (!pipeconf.extension(PiPipeconf.ExtensionType.P4_INFO_TEXT).isPresent()) {
                log.warn("Missing P4Info extension in pipeconf {}", (Object)pipeconf.id());
                return null;
            }
            InputStream p4InfoStream = (InputStream)pipeconf.extension(PiPipeconf.ExtensionType.P4_INFO_TEXT).get();
            P4InfoOuterClass.P4Info.Builder p4iInfoBuilder = P4InfoOuterClass.P4Info.newBuilder();
            try {
                TextFormat.getParser().merge((Readable)new InputStreamReader(p4InfoStream), ExtensionRegistry.getEmptyRegistry(), (Message.Builder)p4iInfoBuilder);
            }
            catch (IOException ex) {
                log.warn("Unable to parse P4Info of pipeconf {}: {}", (Object)pipeconf.id(), (Object)ex.getMessage());
                return null;
            }
            return p4iInfoBuilder.build();
        });
    }

    public static P4InfoBrowser getP4InfoBrowser(PiPipeconf pipeconf) {
        try {
            return (P4InfoBrowser)BROWSERS.get((Object)pipeconf.fingerprint(), () -> {
                P4InfoOuterClass.P4Info p4info = PipeconfHelper.getP4Info(pipeconf);
                if (p4info == null) {
                    return null;
                }
                return new P4InfoBrowser(p4info);
            });
        }
        catch (ExecutionException e) {
            log.error("Exception while accessing the P4InfoBrowser cache", (Throwable)e);
            return null;
        }
    }
}

