/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.p4runtime.ctl.codec;

import com.google.protobuf.ByteString;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.stream.Collectors;
import org.onlab.util.ImmutableByteSequence;
import org.onosproject.net.pi.model.PiData;
import org.onosproject.net.pi.runtime.data.PiBitString;
import org.onosproject.net.pi.runtime.data.PiBool;
import org.onosproject.net.pi.runtime.data.PiEnumString;
import org.onosproject.net.pi.runtime.data.PiErrorString;
import org.onosproject.net.pi.runtime.data.PiHeader;
import org.onosproject.net.pi.runtime.data.PiHeaderStack;
import org.onosproject.net.pi.runtime.data.PiHeaderUnion;
import org.onosproject.net.pi.runtime.data.PiHeaderUnionStack;
import org.onosproject.net.pi.runtime.data.PiStruct;
import org.onosproject.net.pi.runtime.data.PiTuple;
import p4.v1.P4DataOuterClass;

final class P4DataCodec {
    private P4DataCodec() {
    }

    private static P4DataOuterClass.P4Header encodeHeader(PiHeader piHeader) {
        P4DataOuterClass.P4Header.Builder builder = P4DataOuterClass.P4Header.newBuilder();
        int i = 0;
        for (ImmutableByteSequence bitString : piHeader.bitStrings()) {
            builder.setBitstrings(i, ByteString.copyFrom((byte[])bitString.asArray()));
            ++i;
        }
        return builder.setIsValid(piHeader.isValid().booleanValue()).build();
    }

    private static PiHeader decodeHeader(P4DataOuterClass.P4Header p4Header) {
        List bitStrings = p4Header.getBitstringsList().stream().map(bit -> ImmutableByteSequence.copyFrom((ByteBuffer)bit.asReadOnlyByteBuffer())).collect(Collectors.toList());
        return PiHeader.of((Boolean)p4Header.getIsValid(), bitStrings);
    }

    private static P4DataOuterClass.P4HeaderUnion encodeHeaderUnion(PiHeaderUnion headerUnion) {
        P4DataOuterClass.P4HeaderUnion.Builder builder = P4DataOuterClass.P4HeaderUnion.newBuilder();
        if (headerUnion.isValid()) {
            builder.setValidHeader(P4DataCodec.encodeHeader(headerUnion.header()));
            builder.setValidHeaderName(headerUnion.headerName());
        } else {
            builder.setValidHeaderName("");
        }
        return builder.build();
    }

    private static PiHeaderUnion decodeHeaderUnion(P4DataOuterClass.P4HeaderUnion p4HeaderUnion) {
        return PiHeaderUnion.of((String)p4HeaderUnion.getValidHeaderName(), (PiHeader)P4DataCodec.decodeHeader(p4HeaderUnion.getValidHeader()));
    }

    private static P4DataOuterClass.P4StructLike encodeStruct(PiStruct piStruct) {
        P4DataOuterClass.P4StructLike.Builder builder = P4DataOuterClass.P4StructLike.newBuilder();
        builder.addAllMembers((Iterable)piStruct.struct().stream().map(P4DataCodec::encodeP4Data).collect(Collectors.toList()));
        return builder.build();
    }

    private static PiStruct decodeStruct(P4DataOuterClass.P4StructLike p4StructLike) {
        return PiStruct.of(p4StructLike.getMembersList().stream().map(P4DataCodec::decodeP4Data).collect(Collectors.toList()));
    }

    private static P4DataOuterClass.P4StructLike encodeTuple(PiTuple piTuple) {
        P4DataOuterClass.P4StructLike.Builder builder = P4DataOuterClass.P4StructLike.newBuilder();
        builder.addAllMembers((Iterable)piTuple.tuple().stream().map(P4DataCodec::encodeP4Data).collect(Collectors.toList()));
        return builder.build();
    }

    private static PiTuple decodeTuple(P4DataOuterClass.P4StructLike p4StructLike) {
        return PiTuple.of(p4StructLike.getMembersList().stream().map(P4DataCodec::decodeP4Data).collect(Collectors.toList()));
    }

    static P4DataOuterClass.P4Data encodeP4Data(PiData piData) {
        P4DataOuterClass.P4Data.Builder builder = P4DataOuterClass.P4Data.newBuilder();
        switch (piData.type()) {
            case BITSTRING: {
                builder.setBitstring(ByteString.copyFrom((byte[])((PiBitString)piData).bitString().asArray()));
                break;
            }
            case ENUMSTRING: {
                builder.setEnum(((PiEnumString)piData).enumString());
                break;
            }
            case ERRORSTRING: {
                builder.setError(((PiErrorString)piData).errorString());
                break;
            }
            case BOOL: {
                builder.setBool(((PiBool)piData).bool().booleanValue());
                break;
            }
            case STRUCT: {
                builder.setStruct(P4DataCodec.encodeStruct((PiStruct)piData));
                break;
            }
            case TUPLE: {
                builder.setTuple(P4DataCodec.encodeTuple((PiTuple)piData));
                break;
            }
            case HEADER: {
                builder.setHeader(P4DataCodec.encodeHeader((PiHeader)piData));
                break;
            }
            case HEADERSTACK: {
                P4DataOuterClass.P4HeaderStack.Builder headerStack = P4DataOuterClass.P4HeaderStack.newBuilder();
                int i = 0;
                for (PiHeader header : ((PiHeaderStack)piData).headers()) {
                    headerStack.setEntries(i, P4DataCodec.encodeHeader(header));
                    ++i;
                }
                builder.setHeaderStack(headerStack.build());
                break;
            }
            case HEADERUNION: {
                builder.setHeaderUnion(P4DataCodec.encodeHeaderUnion((PiHeaderUnion)piData));
                break;
            }
            case HEADERUNIONSTACK: {
                P4DataOuterClass.P4HeaderUnionStack.Builder headerUnionStack = P4DataOuterClass.P4HeaderUnionStack.newBuilder();
                int j = 0;
                for (PiHeaderUnion headerUnion : ((PiHeaderUnionStack)piData).headerUnions()) {
                    headerUnionStack.setEntries(j, P4DataCodec.encodeHeaderUnion(headerUnion));
                    ++j;
                }
                builder.setHeaderUnionStack(headerUnionStack.build());
                break;
            }
        }
        return builder.build();
    }

    static PiData decodeP4Data(P4DataOuterClass.P4Data p4Data) {
        PiTuple piData = null;
        switch (p4Data.getDataCase()) {
            case BITSTRING: {
                piData = PiBitString.of((ImmutableByteSequence)ImmutableByteSequence.copyFrom((ByteBuffer)p4Data.getBitstring().asReadOnlyByteBuffer()));
                break;
            }
            case BOOL: {
                piData = PiBool.of((Boolean)p4Data.getBool());
                break;
            }
            case TUPLE: {
                piData = P4DataCodec.decodeTuple(p4Data.getTuple());
                break;
            }
            case STRUCT: {
                piData = P4DataCodec.decodeStruct(p4Data.getStruct());
                break;
            }
            case HEADER: {
                piData = P4DataCodec.decodeHeader(p4Data.getHeader());
                break;
            }
            case HEADER_UNION: {
                piData = P4DataCodec.decodeHeaderUnion(p4Data.getHeaderUnion());
                break;
            }
            case HEADER_STACK: {
                piData = PiHeaderStack.of(p4Data.getHeaderStack().getEntriesList().stream().map(P4DataCodec::decodeHeader).collect(Collectors.toList()));
                break;
            }
            case HEADER_UNION_STACK: {
                piData = PiHeaderUnionStack.of(p4Data.getHeaderUnionStack().getEntriesList().stream().map(P4DataCodec::decodeHeaderUnion).collect(Collectors.toList()));
                break;
            }
            case ENUM: {
                piData = PiEnumString.of((String)p4Data.getEnum());
                break;
            }
            case ERROR: {
                piData = PiErrorString.of((String)p4Data.getError());
                break;
            }
            case DATA_NOT_SET: {
                break;
            }
        }
        return piData;
    }
}

