/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.p4runtime.ctl.codec;

import com.google.common.base.Preconditions;
import com.google.protobuf.Message;
import java.util.OptionalInt;
import org.onosproject.net.pi.model.PiPipeconf;
import org.onosproject.net.pi.model.PiTableId;
import org.onosproject.net.pi.runtime.PiAction;
import org.onosproject.net.pi.runtime.PiActionProfileGroupId;
import org.onosproject.net.pi.runtime.PiActionProfileMemberId;
import org.onosproject.net.pi.runtime.PiCounterCellData;
import org.onosproject.net.pi.runtime.PiMatchKey;
import org.onosproject.net.pi.runtime.PiTableAction;
import org.onosproject.net.pi.runtime.PiTableEntry;
import org.onosproject.net.pi.runtime.PiTableEntryHandle;
import org.onosproject.p4runtime.ctl.codec.AbstractEntityCodec;
import org.onosproject.p4runtime.ctl.codec.CodecException;
import org.onosproject.p4runtime.ctl.codec.Codecs;
import org.onosproject.p4runtime.ctl.utils.P4InfoBrowser;
import p4.config.v1.P4InfoOuterClass;
import p4.v1.P4RuntimeOuterClass;

public final class TableEntryCodec
extends AbstractEntityCodec<PiTableEntry, PiTableEntryHandle, P4RuntimeOuterClass.TableEntry, Object> {
    @Override
    protected P4RuntimeOuterClass.TableEntry encode(PiTableEntry piTableEntry, Object ignored, PiPipeconf pipeconf, P4InfoBrowser browser) throws CodecException, P4InfoBrowser.NotFoundException {
        P4RuntimeOuterClass.TableEntry.Builder tableEntryMsgBuilder = this.keyMsgBuilder(piTableEntry.table(), piTableEntry.matchKey(), piTableEntry.priority(), pipeconf, browser);
        tableEntryMsgBuilder.setControllerMetadata(piTableEntry.cookie());
        if (piTableEntry.timeout().isPresent()) {
            this.log.warn("Found PI table entry with timeout set, not supported in P4Runtime: {}", (Object)piTableEntry);
        }
        if (piTableEntry.action() != null) {
            tableEntryMsgBuilder.setAction(this.encodePiTableAction(piTableEntry.action(), pipeconf));
        }
        if (piTableEntry.counter() != null) {
            tableEntryMsgBuilder.setCounterData(this.encodeCounter(piTableEntry.counter()));
        }
        return tableEntryMsgBuilder.build();
    }

    @Override
    protected P4RuntimeOuterClass.TableEntry encodeKey(PiTableEntryHandle handle, Object metadata, PiPipeconf pipeconf, P4InfoBrowser browser) throws CodecException, P4InfoBrowser.NotFoundException {
        return this.keyMsgBuilder(handle.tableId(), handle.matchKey(), handle.priority(), pipeconf, browser).build();
    }

    @Override
    protected P4RuntimeOuterClass.TableEntry encodeKey(PiTableEntry piEntity, Object metadata, PiPipeconf pipeconf, P4InfoBrowser browser) throws CodecException, P4InfoBrowser.NotFoundException {
        return this.keyMsgBuilder(piEntity.table(), piEntity.matchKey(), piEntity.priority(), pipeconf, browser).build();
    }

    private P4RuntimeOuterClass.TableEntry.Builder keyMsgBuilder(PiTableId tableId, PiMatchKey matchKey, OptionalInt priority, PiPipeconf pipeconf, P4InfoBrowser browser) throws P4InfoBrowser.NotFoundException, CodecException {
        P4RuntimeOuterClass.TableEntry.Builder tableEntryMsgBuilder = P4RuntimeOuterClass.TableEntry.newBuilder();
        P4InfoOuterClass.Preamble tablePreamble = browser.tables().getByName((String)tableId.id()).getPreamble();
        tableEntryMsgBuilder.setTableId(tablePreamble.getId());
        if (matchKey.equals((Object)PiMatchKey.EMPTY)) {
            tableEntryMsgBuilder.setIsDefaultAction(true);
        } else {
            tableEntryMsgBuilder.addAllMatch(Codecs.CODECS.fieldMatch().encodeAll(matchKey.fieldMatches(), tablePreamble, pipeconf));
        }
        priority.ifPresent(arg_0 -> ((P4RuntimeOuterClass.TableEntry.Builder)tableEntryMsgBuilder).setPriority(arg_0));
        return tableEntryMsgBuilder;
    }

    @Override
    protected PiTableEntry decode(P4RuntimeOuterClass.TableEntry message, Object ignored, PiPipeconf pipeconf, P4InfoBrowser browser) throws CodecException, P4InfoBrowser.NotFoundException {
        PiTableEntry.Builder piTableEntryBuilder = PiTableEntry.builder();
        P4InfoOuterClass.Preamble tablePreamble = browser.tables().getById(message.getTableId()).getPreamble();
        piTableEntryBuilder.forTable(PiTableId.of((String)tablePreamble.getName()));
        if (message.getPriority() > 0) {
            piTableEntryBuilder.withPriority(message.getPriority());
        }
        piTableEntryBuilder.withCookie(message.getControllerMetadata());
        if (message.hasAction()) {
            piTableEntryBuilder.withAction(this.decodeTableActionMsg(message.getAction(), pipeconf));
        }
        piTableEntryBuilder.withMatchKey(PiMatchKey.builder().addFieldMatches(Codecs.CODECS.fieldMatch().decodeAll(message.getMatchList(), tablePreamble, pipeconf)).build());
        if (message.hasCounterData()) {
            piTableEntryBuilder.withCounterCellData(this.decodeCounter(message.getCounterData()));
        }
        return piTableEntryBuilder.build();
    }

    private P4RuntimeOuterClass.TableAction encodePiTableAction(PiTableAction piTableAction, PiPipeconf pipeconf) throws CodecException {
        Preconditions.checkNotNull((Object)piTableAction, (Object)"Cannot encode null PiTableAction");
        P4RuntimeOuterClass.TableAction.Builder tableActionMsgBuilder = P4RuntimeOuterClass.TableAction.newBuilder();
        switch (piTableAction.type()) {
            case ACTION: {
                P4RuntimeOuterClass.Action theAction = (P4RuntimeOuterClass.Action)Codecs.CODECS.action().encode((PiAction)piTableAction, (Object)null, pipeconf);
                tableActionMsgBuilder.setAction(theAction);
                break;
            }
            case ACTION_PROFILE_GROUP_ID: {
                tableActionMsgBuilder.setActionProfileGroupId(((Integer)((PiActionProfileGroupId)piTableAction).id()).intValue());
                break;
            }
            case ACTION_PROFILE_MEMBER_ID: {
                tableActionMsgBuilder.setActionProfileMemberId(((Integer)((PiActionProfileMemberId)piTableAction).id()).intValue());
                break;
            }
            default: {
                throw new CodecException(String.format("Building of table action type %s not implemented", piTableAction.type()));
            }
        }
        return tableActionMsgBuilder.build();
    }

    private PiTableAction decodeTableActionMsg(P4RuntimeOuterClass.TableAction tableActionMsg, PiPipeconf pipeconf) throws CodecException {
        P4RuntimeOuterClass.TableAction.TypeCase typeCase = tableActionMsg.getTypeCase();
        switch (typeCase) {
            case ACTION: {
                P4RuntimeOuterClass.Action actionMsg = tableActionMsg.getAction();
                return (PiTableAction)Codecs.CODECS.action().decode((Message)actionMsg, (Object)null, pipeconf);
            }
            case ACTION_PROFILE_GROUP_ID: {
                return PiActionProfileGroupId.of((int)tableActionMsg.getActionProfileGroupId());
            }
            case ACTION_PROFILE_MEMBER_ID: {
                return PiActionProfileMemberId.of((int)tableActionMsg.getActionProfileMemberId());
            }
        }
        throw new CodecException(String.format("Decoding of table action type %s not implemented", typeCase.name()));
    }

    private P4RuntimeOuterClass.CounterData encodeCounter(PiCounterCellData piCounterCellData) {
        return P4RuntimeOuterClass.CounterData.newBuilder().setPacketCount(piCounterCellData.packets()).setByteCount(piCounterCellData.bytes()).build();
    }

    private PiCounterCellData decodeCounter(P4RuntimeOuterClass.CounterData counterData) {
        return new PiCounterCellData(counterData.getPacketCount(), counterData.getByteCount());
    }
}

