/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.protocol.http.ctl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Base64;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ssl.AllowAllHostnameVerifier;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContextBuilder;
import org.glassfish.jersey.client.authentication.HttpAuthenticationFeature;
import org.glassfish.jersey.client.oauth2.OAuth2ClientSupport;
import org.onlab.packet.IpAddress;
import org.onosproject.net.DeviceId;
import org.onosproject.protocol.http.HttpSBController;
import org.onosproject.protocol.rest.RestSBDevice;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpSBControllerImpl
implements HttpSBController {
    private static final Logger log = LoggerFactory.getLogger(HttpSBControllerImpl.class);
    private static final String XML = "xml";
    private static final String JSON = "json";
    protected static final String DOUBLESLASH = "//";
    protected static final String COLON = ":";
    private static final int STATUS_OK = Response.Status.OK.getStatusCode();
    private static final int STATUS_CREATED = Response.Status.CREATED.getStatusCode();
    private static final int STATUS_ACCEPTED = Response.Status.ACCEPTED.getStatusCode();
    private static final String HTTPS = "https";
    private static final String AUTHORIZATION_PROPERTY = "authorization";
    private static final String BASIC_AUTH_PREFIX = "Basic ";
    private static final String OAUTH2_BEARER_AUTH_PREFIX = "Bearer ";
    private final Map<DeviceId, RestSBDevice> deviceMap = new ConcurrentHashMap<DeviceId, RestSBDevice>();
    private final Map<DeviceId, Client> clientMap = new ConcurrentHashMap<DeviceId, Client>();

    public Map<DeviceId, RestSBDevice> getDeviceMap() {
        return this.deviceMap;
    }

    public Map<DeviceId, Client> getClientMap() {
        return this.clientMap;
    }

    @Override
    public Map<DeviceId, RestSBDevice> getDevices() {
        return ImmutableMap.copyOf(this.deviceMap);
    }

    @Override
    public RestSBDevice getDevice(DeviceId deviceInfo) {
        return this.deviceMap.get(deviceInfo);
    }

    @Override
    public RestSBDevice getDevice(IpAddress ip, int port) {
        return this.deviceMap.values().stream().filter(v -> v.ip().equals((Object)ip) && v.port() == port).findFirst().get();
    }

    @Override
    public void addDevice(RestSBDevice device) {
        if (!this.deviceMap.containsKey(device.deviceId())) {
            Client client = this.ignoreSslClient();
            this.authenticate(client, device);
            this.clientMap.put(device.deviceId(), client);
            this.deviceMap.put(device.deviceId(), device);
        } else {
            log.warn("Trying to add a device that is already existing {}", (Object)device.deviceId());
        }
    }

    @Override
    public void removeDevice(DeviceId deviceId) {
        this.clientMap.remove(deviceId);
        this.deviceMap.remove(deviceId);
    }

    @Override
    public int post(DeviceId device, String request, InputStream payload, MediaType mediaType) {
        Response response = this.getResponse(device, request, payload, mediaType);
        if (response == null) {
            return Response.Status.NO_CONTENT.getStatusCode();
        }
        return response.getStatus();
    }

    @Override
    public <T> T post(DeviceId device, String request, InputStream payload, MediaType mediaType, Class<T> responseClass) {
        Response response = this.getResponse(device, request, payload, mediaType);
        if (response != null && response.hasEntity()) {
            return (T)(responseClass == Response.class ? response : response.readEntity(responseClass));
        }
        log.error("Response from device {} for request {} contains no entity", (Object)device, (Object)request);
        return null;
    }

    private Response getResponse(DeviceId device, String request, InputStream payload, MediaType mediaType) {
        WebTarget wt = this.getWebTarget(device, request);
        Response response = null;
        if (payload != null) {
            try {
                response = wt.request(new MediaType[]{mediaType}).post(Entity.entity((Object)IOUtils.toString((InputStream)payload, (Charset)StandardCharsets.UTF_8), (MediaType)mediaType));
            }
            catch (IOException e) {
                log.error("Cannot do POST {} request on device {} because can't read payload", (Object)request, (Object)device);
            }
        } else {
            response = wt.request(new MediaType[]{mediaType}).post(Entity.entity(null, (MediaType)mediaType));
        }
        return response;
    }

    @Override
    public int put(DeviceId device, String request, InputStream payload, MediaType mediaType) {
        WebTarget wt = this.getWebTarget(device, request);
        Response response = null;
        if (payload != null) {
            try {
                response = wt.request(new MediaType[]{mediaType}).put(Entity.entity((Object)IOUtils.toString((InputStream)payload, (Charset)StandardCharsets.UTF_8), (MediaType)mediaType));
            }
            catch (IOException e) {
                log.error("Cannot do PUT {} request on device {} because can't read payload", (Object)request, (Object)device);
            }
        } else {
            response = wt.request(new MediaType[]{mediaType}).put(Entity.entity(null, (MediaType)mediaType));
        }
        if (response == null) {
            return Response.Status.NO_CONTENT.getStatusCode();
        }
        return response.getStatus();
    }

    @Override
    public InputStream get(DeviceId device, String request, MediaType mediaType) {
        WebTarget wt = this.getWebTarget(device, request);
        Response s = wt.request(new MediaType[]{mediaType}).get();
        if (this.checkReply(s)) {
            return new ByteArrayInputStream(((String)s.readEntity(String.class)).getBytes(StandardCharsets.UTF_8));
        }
        return null;
    }

    @Override
    public int patch(DeviceId device, String request, InputStream payload, MediaType mediaType) {
        try {
            log.debug("Url request {} ", (Object)this.getUrlString(device, request));
            HttpPatch httprequest = new HttpPatch(this.getUrlString(device, request));
            if (this.deviceMap.get(device).authentication() == RestSBDevice.AuthenticationScheme.BASIC) {
                String pwd = this.deviceMap.get(device).password() == null ? "" : COLON + this.deviceMap.get(device).password();
                String userPassword = this.deviceMap.get(device).username() + pwd;
                String base64string = Base64.getEncoder().encodeToString(userPassword.getBytes(StandardCharsets.UTF_8));
                httprequest.addHeader(AUTHORIZATION_PROPERTY, BASIC_AUTH_PREFIX + base64string);
            } else if (this.deviceMap.get(device).authentication() == RestSBDevice.AuthenticationScheme.OAUTH2) {
                String token = this.deviceMap.get(device).token();
                httprequest.addHeader(AUTHORIZATION_PROPERTY, OAUTH2_BEARER_AUTH_PREFIX + token);
            }
            if (payload != null) {
                StringEntity input = new StringEntity(IOUtils.toString((InputStream)payload, (Charset)StandardCharsets.UTF_8));
                input.setContentType(mediaType.toString());
                httprequest.setEntity((HttpEntity)input);
            }
            CloseableHttpClient httpClient = this.deviceMap.containsKey(device) && this.deviceMap.get(device).protocol().equals(HTTPS) ? this.getApacheSslBypassClient() : HttpClients.createDefault();
            return httpClient.execute((HttpUriRequest)httprequest).getStatusLine().getStatusCode();
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            log.error("Cannot do PATCH {} request on device {}", new Object[]{request, device, e});
            return Response.Status.BAD_REQUEST.getStatusCode();
        }
    }

    @Override
    public int delete(DeviceId device, String request, InputStream payload, MediaType mediaType) {
        WebTarget wt = this.getWebTarget(device, request);
        Response response = wt.request(new MediaType[]{mediaType}).delete();
        return response.getStatus();
    }

    private MediaType typeOfMediaType(String type) {
        switch (type) {
            case "xml": {
                return MediaType.APPLICATION_XML_TYPE;
            }
            case "json": {
                return MediaType.APPLICATION_JSON_TYPE;
            }
            case "*/*": {
                return MediaType.WILDCARD_TYPE;
            }
        }
        throw new IllegalArgumentException("Unsupported media type " + type);
    }

    private void authenticate(Client client, RestSBDevice device) {
        RestSBDevice.AuthenticationScheme authScheme = device.authentication();
        if (authScheme == RestSBDevice.AuthenticationScheme.NO_AUTHENTICATION) {
            log.debug("{} scheme is specified, ignoring authentication", (Object)authScheme);
            return;
        }
        if (authScheme == RestSBDevice.AuthenticationScheme.OAUTH2) {
            String token = (String)Preconditions.checkNotNull((Object)device.token());
            client.register((Object)OAuth2ClientSupport.feature((String)token));
        } else if (authScheme == RestSBDevice.AuthenticationScheme.BASIC) {
            String username = device.username();
            String password = device.password() == null ? "" : device.password();
            client.register((Object)HttpAuthenticationFeature.basic((String)username, (String)password));
        } else {
            throw new IllegalArgumentException(String.format("Unsupported authentication scheme: %s", authScheme.name()));
        }
    }

    protected WebTarget getWebTarget(DeviceId device, String request) {
        log.debug("Sending request to URL {} ", (Object)this.getUrlString(device, request));
        return this.clientMap.get(device).target(this.getUrlString(device, request));
    }

    private CloseableHttpClient getApacheSslBypassClient() throws NoSuchAlgorithmException, KeyManagementException, KeyStoreException {
        return HttpClients.custom().setHostnameVerifier((X509HostnameVerifier)new AllowAllHostnameVerifier()).setSslcontext(new SSLContextBuilder().loadTrustMaterial(null, (arg0, arg1) -> true).build()).build();
    }

    protected String getUrlString(DeviceId deviceId, String request) {
        RestSBDevice restSBDevice = this.deviceMap.get(deviceId);
        if (restSBDevice == null) {
            log.warn("restSbDevice cannot be NULL!");
            return "";
        }
        if (restSBDevice.url() != null) {
            return restSBDevice.protocol() + COLON + DOUBLESLASH + restSBDevice.url() + request;
        }
        return restSBDevice.protocol() + COLON + DOUBLESLASH + restSBDevice.ip().toString() + COLON + restSBDevice.port() + request;
    }

    private boolean checkReply(Response response) {
        if (response != null) {
            boolean statusCode = this.checkStatusCode(response.getStatus());
            if (!statusCode && response.hasEntity()) {
                log.error("Failed request, HTTP error msg : " + (String)response.readEntity(String.class));
            }
            return statusCode;
        }
        log.error("Null reply from device");
        return false;
    }

    private boolean checkStatusCode(int statusCode) {
        if (statusCode == STATUS_OK || statusCode == STATUS_CREATED || statusCode == STATUS_ACCEPTED) {
            return true;
        }
        log.error("Failed request, HTTP error code : " + statusCode);
        return false;
    }

    private Client ignoreSslClient() {
        SSLContext sslcontext = null;
        try {
            sslcontext = SSLContext.getInstance("TLS");
            sslcontext.init(null, new TrustManager[]{new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }
            }}, new SecureRandom());
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
        return ClientBuilder.newBuilder().sslContext(sslcontext).hostnameVerifier((s1, s2) -> true).build();
    }
}

