/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.protocol.rest;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.onlab.packet.IpAddress;
import org.onosproject.net.DeviceId;
import org.onosproject.protocol.rest.RestSBDevice;

public class DefaultRestSBDevice
implements RestSBDevice {
    private static final String REST = "rest";
    private static final String COLON = ":";
    private final IpAddress ip;
    private final int port;
    private final String username;
    private final String password;
    private boolean isActive;
    private String protocol;
    private String url;
    private boolean isProxy;
    private RestSBDevice.AuthenticationScheme authenticationScheme;
    private String token;
    private final Optional<String> testUrl;
    private final Optional<String> manufacturer;
    private final Optional<String> hwVersion;
    private final Optional<String> swVersion;

    public DefaultRestSBDevice(IpAddress ip, int port, String name, String password, String protocol, String url, boolean isActive) {
        this(ip, port, name, password, protocol, url, isActive, "", "", "", "", RestSBDevice.AuthenticationScheme.BASIC, "");
    }

    public DefaultRestSBDevice(IpAddress ip, int port, String name, String password, String protocol, String url, boolean isActive, String testUrl, String manufacturer, String hwVersion, String swVersion, RestSBDevice.AuthenticationScheme authenticationScheme, String token) {
        Preconditions.checkNotNull((Object)ip, (Object)"IP address cannot be null");
        Preconditions.checkArgument((port > 0 ? 1 : 0) != 0, (Object)"Port address cannot be negative");
        Preconditions.checkNotNull((Object)protocol, (Object)"protocol address cannot be null");
        this.ip = ip;
        this.port = port;
        this.username = name;
        this.password = StringUtils.isEmpty((CharSequence)password) ? null : password;
        this.isActive = isActive;
        this.protocol = protocol;
        this.url = StringUtils.isEmpty((CharSequence)url) ? null : url;
        this.authenticationScheme = authenticationScheme;
        this.token = token;
        this.manufacturer = StringUtils.isEmpty((CharSequence)manufacturer) ? Optional.empty() : Optional.ofNullable(manufacturer);
        this.hwVersion = StringUtils.isEmpty((CharSequence)hwVersion) ? Optional.empty() : Optional.ofNullable(hwVersion);
        this.swVersion = StringUtils.isEmpty((CharSequence)swVersion) ? Optional.empty() : Optional.ofNullable(swVersion);
        this.testUrl = StringUtils.isEmpty((CharSequence)testUrl) ? Optional.empty() : Optional.ofNullable(testUrl);
        this.isProxy = this.manufacturer.isPresent() && this.hwVersion.isPresent() && this.swVersion.isPresent();
    }

    @Override
    public IpAddress ip() {
        return this.ip;
    }

    @Override
    public int port() {
        return this.port;
    }

    @Override
    public String username() {
        return this.username;
    }

    @Override
    public String password() {
        return this.password;
    }

    @Override
    public DeviceId deviceId() {
        try {
            return DeviceId.deviceId((URI)new URI(REST, this.ip + COLON + this.port, null));
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Cannot create deviceID rest:" + this.ip + COLON + this.port, e);
        }
    }

    @Override
    public void setActive(boolean active) {
        this.isActive = active;
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    @Override
    public String protocol() {
        return this.protocol;
    }

    @Override
    public String url() {
        return this.url;
    }

    @Override
    public boolean isProxy() {
        return this.isProxy;
    }

    @Override
    public Optional<String> testUrl() {
        return this.testUrl;
    }

    @Override
    public Optional<String> manufacturer() {
        return this.manufacturer;
    }

    @Override
    public Optional<String> hwVersion() {
        return this.hwVersion;
    }

    @Override
    public Optional<String> swVersion() {
        return this.swVersion;
    }

    @Override
    public RestSBDevice.AuthenticationScheme authentication() {
        return this.authenticationScheme;
    }

    @Override
    public String token() {
        return this.token;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("url", (Object)this.url).add("testUrl", this.testUrl).add("protocol", (Object)this.protocol).add("username", (Object)this.username).add("port", this.port).add("ip", (Object)this.ip).add("authentication", (Object)this.authenticationScheme.name()).add("token", (Object)this.token).add("manufacturer", this.manufacturer.orElse(null)).add("hwVersion", this.hwVersion.orElse(null)).add("swVersion", this.swVersion.orElse(null)).toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof RestSBDevice)) {
            return false;
        }
        RestSBDevice that = (RestSBDevice)obj;
        return Objects.equals(this.ip, that.ip()) && this.port == that.port() && Strings.nullToEmpty((String)this.username).equals(Strings.nullToEmpty((String)that.username()));
    }

    public int hashCode() {
        return Objects.hash(this.ip, this.port, Strings.nullToEmpty((String)this.username));
    }
}

