/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.rest.resources;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.onlab.util.Tools;
import org.onosproject.app.ApplicationAdminService;
import org.onosproject.codec.CodecContext;
import org.onosproject.core.Application;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.rest.AbstractWebResource;

/*
 * Exception performing whole class analysis ignored.
 */
@Path(value="applications")
public class ApplicationsWebResource
extends AbstractWebResource {
    private static final String APP_ID_NOT_FOUND = "Application ID is not found";
    private static final String APP_NOT_FOUND = "Application is not found";
    private static final String URL = "url";
    private static final String ACTIVATE = "activate";

    @GET
    public Response getApps() {
        ApplicationAdminService service = (ApplicationAdminService)this.get(ApplicationAdminService.class);
        Set apps = service.getApplications();
        return ApplicationsWebResource.ok((Object)this.encodeArray(Application.class, "applications", (Iterable)apps)).build();
    }

    @GET
    @Path(value="{name}")
    public Response getApp(@PathParam(value="name") String name) {
        ApplicationAdminService service = (ApplicationAdminService)this.get(ApplicationAdminService.class);
        ApplicationId appId = (ApplicationId)Tools.nullIsNotFound((Object)service.getId(name), (String)"Application is not found");
        return this.response(service, appId);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response installApp(InputStream raw) {
        Application app;
        try {
            ObjectNode jsonTree = (ObjectNode)this.mapper().readTree(raw);
            URL url = new URL(jsonTree.get("url").asText());
            boolean activate = false;
            if (jsonTree.has("activate")) {
                activate = jsonTree.get("activate").asBoolean();
            }
            ApplicationAdminService service = (ApplicationAdminService)this.get(ApplicationAdminService.class);
            app = service.install(url.openStream());
            if (activate) {
                service.activate(app.id());
            }
        }
        catch (IOException ex) {
            throw new IllegalArgumentException(ex);
        }
        return ApplicationsWebResource.ok((Object)this.codec(Application.class).encode((Object)app, (CodecContext)this)).build();
    }

    @POST
    @Consumes(value={"application/octet-stream"})
    @Produces(value={"application/json"})
    public Response installApp(@QueryParam(value="activate") @DefaultValue(value="false") boolean activate, InputStream stream) {
        ApplicationAdminService service = (ApplicationAdminService)this.get(ApplicationAdminService.class);
        Application app = service.install(stream);
        if (activate) {
            service.activate(app.id());
        }
        return ApplicationsWebResource.ok((Object)this.codec(Application.class).encode((Object)app, (CodecContext)this)).build();
    }

    @DELETE
    @Path(value="{name}")
    public Response uninstallApp(@PathParam(value="name") String name) {
        ApplicationAdminService service = (ApplicationAdminService)this.get(ApplicationAdminService.class);
        ApplicationId appId = service.getId(name);
        if (appId != null) {
            service.uninstall(appId);
        }
        return Response.noContent().build();
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="{name}/active")
    public Response activateApp(@PathParam(value="name") String name) {
        ApplicationAdminService service = (ApplicationAdminService)this.get(ApplicationAdminService.class);
        ApplicationId appId = (ApplicationId)Tools.nullIsNotFound((Object)service.getId(name), (String)"Application is not found");
        service.activate(appId);
        return this.response(service, appId);
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="{name}/active")
    public Response deactivateApp(@PathParam(value="name") String name) {
        ApplicationAdminService service = (ApplicationAdminService)this.get(ApplicationAdminService.class);
        ApplicationId appId = service.getId(name);
        if (appId != null) {
            service.deactivate(appId);
        }
        return Response.noContent().build();
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="{name}/register")
    public Response registerAppId(@PathParam(value="name") String name) {
        CoreService service = (CoreService)this.get(CoreService.class);
        ApplicationId appId = service.registerApplication(name);
        return this.response(appId);
    }

    @GET
    @Produces(value={"application/octet-stream"})
    @Path(value="{name}/bits")
    public Response getAppBits(@PathParam(value="name") String name) {
        ApplicationAdminService service = (ApplicationAdminService)this.get(ApplicationAdminService.class);
        ApplicationId appId = (ApplicationId)Tools.nullIsNotFound((Object)service.getId(name), (String)"Application ID is not found");
        InputStream bits = service.getApplicationArchive(appId);
        return ApplicationsWebResource.ok((Object)bits).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="ids/entry")
    public Response getAppIdByName(@QueryParam(value="id") String id, @QueryParam(value="name") String name) {
        CoreService service = (CoreService)this.get(CoreService.class);
        ApplicationId appId = null;
        if (id != null) {
            appId = service.getAppId(Short.valueOf(id));
        } else if (name != null) {
            appId = service.getAppId(name);
        }
        return this.response(appId);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="ids")
    public Response getAppIds() {
        CoreService service = (CoreService)this.get(CoreService.class);
        Set appIds = service.getAppIds();
        return ApplicationsWebResource.ok((Object)this.encodeArray(ApplicationId.class, "applicationIds", (Iterable)appIds)).build();
    }

    private Response response(ApplicationAdminService service, ApplicationId appId) {
        Application app = (Application)Tools.nullIsNotFound((Object)service.getApplication(appId), (String)"Application is not found");
        return ApplicationsWebResource.ok((Object)this.codec(Application.class).encode((Object)app, (CodecContext)this)).build();
    }

    private Response response(ApplicationId appId) {
        ApplicationId checkedAppId = (ApplicationId)Tools.nullIsNotFound((Object)appId, (String)"Application ID is not found");
        return ApplicationsWebResource.ok((Object)this.codec(ApplicationId.class).encode((Object)checkedAppId, (CodecContext)this)).build();
    }
}

