/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.rest.resources;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.onlab.util.Tools;
import org.onosproject.cluster.ClusterAdminService;
import org.onosproject.cluster.ClusterService;
import org.onosproject.cluster.ControllerNode;
import org.onosproject.cluster.NodeId;
import org.onosproject.codec.CodecContext;
import org.onosproject.codec.JsonCodec;
import org.onosproject.rest.AbstractWebResource;

/*
 * Exception performing whole class analysis ignored.
 */
@Path(value="cluster")
public class ClusterWebResource
extends AbstractWebResource {
    private static final String NODE_NOT_FOUND = "Node is not found";

    @GET
    @Produces(value={"application/json"})
    public Response getClusterNodes() {
        Set nodes = ((ClusterService)this.get(ClusterService.class)).getNodes();
        return ClusterWebResource.ok((Object)this.encodeArray(ControllerNode.class, "nodes", (Iterable)nodes)).build();
    }

    @GET
    @Path(value="{id}")
    @Produces(value={"application/json"})
    public Response getClusterNode(@PathParam(value="id") String id) {
        ControllerNode node = (ControllerNode)Tools.nullIsNotFound((Object)((ClusterService)this.get(ClusterService.class)).getNode(new NodeId(id)), (String)"Node is not found");
        return ClusterWebResource.ok((Object)this.codec(ControllerNode.class).encode((Object)node, (CodecContext)this)).build();
    }

    @POST
    @Path(value="configuration")
    @Produces(value={"application/json"})
    public Response formCluster(InputStream config) throws IOException {
        JsonCodec codec = this.codec(ControllerNode.class);
        ObjectNode root = (ObjectNode)this.mapper().readTree(config);
        List nodes = codec.decode((ArrayNode)root.path("nodes"), (CodecContext)this);
        JsonNode partitionSizeNode = root.get("partitionSize");
        if (partitionSizeNode != null) {
            int partitionSize = partitionSizeNode.asInt();
            if (partitionSize == 0) {
                return Response.notAcceptable(null).build();
            }
            ((ClusterAdminService)this.get(ClusterAdminService.class)).formCluster(new HashSet(nodes), partitionSize);
        } else {
            ((ClusterAdminService)this.get(ClusterAdminService.class)).formCluster(new HashSet(nodes));
        }
        return Response.ok().build();
    }
}

