/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.rest.resources;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.InputStream;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.onosproject.codec.CodecContext;
import org.onosproject.incubator.net.dpi.DpiStatInfo;
import org.onosproject.incubator.net.dpi.DpiStatistics;
import org.onosproject.incubator.net.dpi.DpiStatisticsManagerService;
import org.onosproject.incubator.net.dpi.FlowStatInfo;
import org.onosproject.incubator.net.dpi.ProtocolStatInfo;
import org.onosproject.rest.AbstractWebResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
@Path(value="dpis")
public class DpisWebResource
extends AbstractWebResource {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final int MAX_TOPN = 100;
    private final DpiStatisticsManagerService service = (DpiStatisticsManagerService)this.get(DpiStatisticsManagerService.class);
    public static final Comparator<ProtocolStatInfo> PROTOCOL_STAT_INFO_COMPARATOR = new /* Unavailable Anonymous Inner Class!! */;
    public static final Comparator<FlowStatInfo> FLOW_STAT_INFO_COMPARATOR = new /* Unavailable Anonymous Inner Class!! */;

    @GET
    @Produces(value={"application/json"})
    public Response getDpisLatest(@QueryParam(value="topn") int topn) {
        DpiStatistics retDs;
        this.log.debug("getDpisLatest request with topn={}", (Object)topn);
        DpiStatistics ds = this.service.getDpiStatisticsLatest();
        if (ds == null) {
            retDs = new DpiStatistics("", new DpiStatInfo());
        } else if (topn <= 0) {
            retDs = ds;
        } else {
            List fsiListSorted;
            List fsiList;
            if (topn > 100) {
                topn = 100;
            }
            retDs = new DpiStatistics(ds.receivedTime(), new DpiStatInfo(ds.dpiStatInfo().trafficStatistics()));
            List psiList = ds.dpiStatInfo().detectedProtos();
            if (psiList != null) {
                List psiListSorted = psiList.stream().sorted(PROTOCOL_STAT_INFO_COMPARATOR).limit(topn).collect(Collectors.toList());
                retDs.dpiStatInfo().setDetectedProtos(psiListSorted);
            }
            if ((fsiList = ds.dpiStatInfo().knownFlows()) != null) {
                fsiListSorted = fsiList.stream().sorted(FLOW_STAT_INFO_COMPARATOR).limit(topn).collect(Collectors.toList());
                retDs.dpiStatInfo().setKnownFlows(fsiListSorted);
            }
            if ((fsiList = ds.dpiStatInfo().unknownFlows()) != null) {
                fsiListSorted = fsiList.stream().sorted(FLOW_STAT_INFO_COMPARATOR).limit(topn).collect(Collectors.toList());
                retDs.dpiStatInfo().setUnknownFlows(fsiListSorted);
            }
        }
        ObjectNode result = this.codec(DpiStatistics.class).encode((Object)retDs, (CodecContext)this);
        return DpisWebResource.ok((Object)result).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="traffic")
    public Response getTrafficStatistics() {
        this.log.debug("getTrafficStatistics request");
        DpiStatistics ds = this.service.getDpiStatisticsLatest();
        if (ds == null) {
            ds = new DpiStatistics("", new DpiStatInfo());
        }
        DpiStatInfo dsi = new DpiStatInfo();
        dsi.setTrafficStatistics(ds.dpiStatInfo().trafficStatistics());
        DpiStatistics dsTraffic = new DpiStatistics(ds.receivedTime(), dsi);
        ObjectNode result = this.codec(DpiStatistics.class).encode((Object)dsTraffic, (CodecContext)this);
        return DpisWebResource.ok((Object)result).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="protocols")
    public Response getDetectedProtocols(@QueryParam(value="topn") int topn) {
        DpiStatistics dsProtocol;
        this.log.debug("getDetectedProtocols request with topn={}", (Object)topn);
        DpiStatistics ds = this.service.getDpiStatisticsLatest();
        if (ds == null) {
            dsProtocol = new DpiStatistics("", new DpiStatInfo());
        } else if (topn <= 0) {
            DpiStatInfo dsi = new DpiStatInfo();
            dsi.setDetectedProtos(ds.dpiStatInfo().detectedProtos());
            dsProtocol = new DpiStatistics(ds.receivedTime(), dsi);
        } else {
            if (topn > 100) {
                topn = 100;
            }
            dsProtocol = new DpiStatistics(ds.receivedTime(), new DpiStatInfo());
            List psiList = ds.dpiStatInfo().detectedProtos();
            if (psiList != null) {
                List psiListSorted = psiList.stream().sorted(PROTOCOL_STAT_INFO_COMPARATOR).limit(topn).collect(Collectors.toList());
                dsProtocol.dpiStatInfo().setDetectedProtos(psiListSorted);
            }
        }
        ObjectNode result = this.codec(DpiStatistics.class).encode((Object)dsProtocol, (CodecContext)this);
        return DpisWebResource.ok((Object)result).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="knownFlows")
    public Response getKnownFlows(@QueryParam(value="topn") int topn) {
        DpiStatistics dsKnownFlows;
        this.log.debug("getKnownFlows request with topn={}", (Object)topn);
        DpiStatistics ds = this.service.getDpiStatisticsLatest();
        if (ds == null) {
            dsKnownFlows = new DpiStatistics("", new DpiStatInfo());
        } else if (topn <= 0) {
            DpiStatInfo dsi = new DpiStatInfo();
            dsi.setKnownFlows(ds.dpiStatInfo().knownFlows());
            dsKnownFlows = new DpiStatistics(ds.receivedTime(), dsi);
        } else {
            if (topn > 100) {
                topn = 100;
            }
            dsKnownFlows = new DpiStatistics(ds.receivedTime(), new DpiStatInfo());
            List fsiList = ds.dpiStatInfo().knownFlows();
            if (fsiList != null) {
                List fsiListSorted = fsiList.stream().sorted(FLOW_STAT_INFO_COMPARATOR).limit(topn).collect(Collectors.toList());
                dsKnownFlows.dpiStatInfo().setKnownFlows(fsiListSorted);
            }
        }
        ObjectNode result = this.codec(DpiStatistics.class).encode((Object)dsKnownFlows, (CodecContext)this);
        return DpisWebResource.ok((Object)result).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="unknownFlows")
    public Response getUnknownFlows(@QueryParam(value="topn") int topn) {
        DpiStatistics dsUnknownFlows;
        this.log.debug("getUnknownFlows request with topn={}", (Object)topn);
        DpiStatistics ds = this.service.getDpiStatisticsLatest();
        if (ds == null) {
            dsUnknownFlows = new DpiStatistics("", new DpiStatInfo());
        } else if (topn <= 0) {
            DpiStatInfo dsi = new DpiStatInfo();
            dsi.setUnknownFlows(ds.dpiStatInfo().unknownFlows());
            dsUnknownFlows = new DpiStatistics(ds.receivedTime(), dsi);
        } else {
            if (topn > 100) {
                topn = 100;
            }
            dsUnknownFlows = new DpiStatistics(ds.receivedTime(), new DpiStatInfo());
            List fsiList = ds.dpiStatInfo().unknownFlows();
            if (fsiList != null) {
                List fsiListSorted = fsiList.stream().sorted(FLOW_STAT_INFO_COMPARATOR).limit(topn).collect(Collectors.toList());
                dsUnknownFlows.dpiStatInfo().setUnknownFlows(fsiListSorted);
            }
        }
        ObjectNode result = this.codec(DpiStatistics.class).encode((Object)dsUnknownFlows, (CodecContext)this);
        return DpisWebResource.ok((Object)result).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response addDpiStatistics(InputStream stream) {
        ObjectNode result;
        try {
            ObjectNode jsonTree = (ObjectNode)this.mapper().readTree(stream);
            this.log.debug("jsonTree={}", (Object)jsonTree);
            DpiStatistics ds = (DpiStatistics)this.codec(DpiStatistics.class).decode(jsonTree, (CodecContext)this);
            if (ds == null) {
                this.log.error("Wrong DpiStatistics json format error");
            }
            DpiStatistics added = this.service.addDpiStatistics(ds);
            result = this.codec(DpiStatistics.class).encode((Object)added, (CodecContext)this);
        }
        catch (IOException ex) {
            throw new IllegalArgumentException(ex);
        }
        return DpisWebResource.ok((Object)result).build();
    }
}

