/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.rest.resources;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.StreamSupport;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.onlab.util.ItemNotFoundException;
import org.onlab.util.Tools;
import org.onosproject.app.ApplicationService;
import org.onosproject.codec.CodecContext;
import org.onosproject.core.ApplicationId;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.flow.FlowEntry;
import org.onosproject.net.flow.FlowRule;
import org.onosproject.net.flow.FlowRuleService;
import org.onosproject.rest.AbstractWebResource;

/*
 * Exception performing whole class analysis ignored.
 */
@Path(value="flows")
public class FlowsWebResource
extends AbstractWebResource {
    @Context
    private UriInfo uriInfo;
    private static final String DEVICE_NOT_FOUND = "Device is not found";
    private static final String FLOW_NOT_FOUND = "Flow is not found";
    private static final String APP_ID_NOT_FOUND = "Application Id is not found";
    private static final String FLOW_ARRAY_REQUIRED = "Flows array was not specified";
    private static final String FLOWS = "flows";
    private static final String DEVICE_ID = "deviceId";
    private static final String FLOW_ID = "flowId";
    private final FlowRuleService service = (FlowRuleService)this.get(FlowRuleService.class);
    private final ObjectNode root = this.mapper().createObjectNode();
    private final ArrayNode flowsNode = this.root.putArray("flows");

    @GET
    @Produces(value={"application/json"})
    public Response getFlows() {
        Iterable devices = ((DeviceService)this.get(DeviceService.class)).getDevices();
        for (Device device : devices) {
            Iterable flowEntries = this.service.getFlowEntries(device.id());
            if (flowEntries == null) continue;
            for (FlowEntry entry : flowEntries) {
                this.flowsNode.add((JsonNode)this.codec(FlowEntry.class).encode((Object)entry, (CodecContext)this));
            }
        }
        return FlowsWebResource.ok((Object)this.root).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createFlows(@QueryParam(value="appId") String appId, InputStream stream) {
        try {
            ObjectNode jsonTree = (ObjectNode)this.mapper().readTree(stream);
            ArrayNode flowsArray = (ArrayNode)Tools.nullIsIllegal((Object)((ArrayNode)jsonTree.get("flows")), (String)"Flows array was not specified");
            if (appId != null) {
                flowsArray.forEach(flowJson -> ((ObjectNode)flowJson).put("appId", appId));
            }
            List rules = this.codec(FlowRule.class).decode(flowsArray, (CodecContext)this);
            this.service.applyFlowRules(rules.toArray(new FlowRule[rules.size()]));
            rules.forEach(flowRule -> {
                ObjectNode flowNode = this.mapper().createObjectNode();
                flowNode.put("deviceId", flowRule.deviceId().toString()).put("flowId", Long.toString(flowRule.id().value()));
                this.flowsNode.add((JsonNode)flowNode);
            });
        }
        catch (IOException ex) {
            throw new IllegalArgumentException(ex);
        }
        return Response.ok((Object)this.root).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="{deviceId}")
    public Response getFlowByDeviceId(@PathParam(value="deviceId") String deviceId) {
        Iterable flowEntries = this.service.getFlowEntries(DeviceId.deviceId((String)deviceId));
        if (flowEntries == null || !flowEntries.iterator().hasNext()) {
            throw new ItemNotFoundException("Device is not found");
        }
        for (FlowEntry entry : flowEntries) {
            this.flowsNode.add((JsonNode)this.codec(FlowEntry.class).encode((Object)entry, (CodecContext)this));
        }
        return FlowsWebResource.ok((Object)this.root).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="{deviceId}/{flowId}")
    public Response getFlowByDeviceIdAndFlowId(@PathParam(value="deviceId") String deviceId, @PathParam(value="flowId") long flowId) {
        Iterable flowEntries = this.service.getFlowEntries(DeviceId.deviceId((String)deviceId));
        if (flowEntries == null || !flowEntries.iterator().hasNext()) {
            throw new ItemNotFoundException("Device is not found");
        }
        for (FlowEntry entry : flowEntries) {
            if (entry.id().value() != flowId) continue;
            this.flowsNode.add((JsonNode)this.codec(FlowEntry.class).encode((Object)entry, (CodecContext)this));
        }
        return FlowsWebResource.ok((Object)this.root).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="application/{appId}")
    public Response getFlowByAppId(@PathParam(value="appId") String appId) {
        ApplicationService appService = (ApplicationService)this.get(ApplicationService.class);
        ApplicationId idInstant = (ApplicationId)Tools.nullIsNotFound((Object)appService.getId(appId), (String)"Application Id is not found");
        Iterable flowEntries = this.service.getFlowEntriesById(idInstant);
        flowEntries.forEach(flow -> this.flowsNode.add((JsonNode)this.codec(FlowEntry.class).encode(flow, (CodecContext)this)));
        return FlowsWebResource.ok((Object)this.root).build();
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="application/{appId}")
    public Response removeFlowByAppId(@PathParam(value="appId") String appId) {
        ApplicationService appService = (ApplicationService)this.get(ApplicationService.class);
        ApplicationId idInstant = (ApplicationId)Tools.nullIsNotFound((Object)appService.getId(appId), (String)"Application Id is not found");
        this.service.removeFlowRulesById(idInstant);
        return Response.noContent().build();
    }

    @POST
    @Path(value="{deviceId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createFlow(@PathParam(value="deviceId") String deviceId, @QueryParam(value="appId") String appId, InputStream stream) {
        try {
            ObjectNode jsonTree = (ObjectNode)this.mapper().readTree(stream);
            JsonNode specifiedDeviceId = jsonTree.get("deviceId");
            if (specifiedDeviceId != null && !specifiedDeviceId.asText().equals(deviceId)) {
                throw new IllegalArgumentException("Invalid deviceId in flow creation request");
            }
            jsonTree.put("deviceId", deviceId);
            if (appId != null) {
                jsonTree.put("appId", appId);
            }
            FlowRule rule = (FlowRule)this.codec(FlowRule.class).decode(jsonTree, (CodecContext)this);
            this.service.applyFlowRules(new FlowRule[]{rule});
            UriBuilder locationBuilder = this.uriInfo.getBaseUriBuilder().path("flows").path(deviceId).path(Long.toString(rule.id().value()));
            return Response.created((URI)locationBuilder.build(new Object[0])).build();
        }
        catch (IOException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    @DELETE
    @Path(value="{deviceId}/{flowId}")
    public Response deleteFlowByDeviceIdAndFlowId(@PathParam(value="deviceId") String deviceId, @PathParam(value="flowId") long flowId) {
        Iterable flowEntries = this.service.getFlowEntries(DeviceId.deviceId((String)deviceId));
        if (!flowEntries.iterator().hasNext()) {
            throw new ItemNotFoundException("Device is not found");
        }
        StreamSupport.stream(flowEntries.spliterator(), false).filter(entry -> entry.id().value() == flowId).forEach(xva$0 -> this.service.removeFlowRules(new FlowRule[]{xva$0}));
        return Response.noContent().build();
    }

    @DELETE
    public Response deleteFlows(InputStream stream) {
        ArrayListMultimap deviceMap = ArrayListMultimap.create();
        ArrayList rulesToRemove = new ArrayList();
        try {
            ObjectNode jsonTree = (ObjectNode)this.mapper().readTree(stream);
            JsonNode jsonFlows = jsonTree.get("flows");
            jsonFlows.forEach(arg_0 -> FlowsWebResource.lambda$deleteFlows$5((ListMultimap)deviceMap, arg_0));
        }
        catch (IOException ex) {
            throw new IllegalArgumentException(ex);
        }
        deviceMap.keySet().forEach(arg_0 -> this.lambda$deleteFlows$8((ListMultimap)deviceMap, rulesToRemove, arg_0));
        this.service.removeFlowRules((FlowRule[])rulesToRemove.toArray(new FlowEntry[0]));
        return Response.noContent().build();
    }

    private /* synthetic */ void lambda$deleteFlows$8(ListMultimap deviceMap, List rulesToRemove, DeviceId deviceId) {
        List flowIds = deviceMap.get((Object)deviceId);
        Iterable entries = this.service.getFlowEntries(deviceId);
        flowIds.forEach(flowId -> StreamSupport.stream(entries.spliterator(), false).filter(entry -> flowId.longValue() == entry.id().value()).forEach(rulesToRemove::add));
    }

    private static /* synthetic */ void lambda$deleteFlows$5(ListMultimap deviceMap, JsonNode node) {
        DeviceId deviceId = DeviceId.deviceId((String)((JsonNode)Tools.nullIsNotFound((Object)node.get("deviceId"), (String)"Device is not found")).asText());
        long flowId = ((JsonNode)Tools.nullIsNotFound((Object)node.get("flowId"), (String)"Flow is not found")).asLong();
        deviceMap.put((Object)deviceId, (Object)flowId);
    }
}

