/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.rest.resources;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Spliterators;
import java.util.stream.StreamSupport;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.onosproject.codec.CodecContext;
import org.onosproject.codec.JsonCodec;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.PortNumber;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.device.PortStatistics;
import org.onosproject.net.flow.FlowRuleService;
import org.onosproject.net.flow.TableStatisticsEntry;
import org.onosproject.net.link.LinkService;
import org.onosproject.net.statistic.Load;
import org.onosproject.net.statistic.StatisticService;
import org.onosproject.rest.AbstractWebResource;

/*
 * Exception performing whole class analysis ignored.
 */
@Path(value="statistics")
public class StatisticsWebResource
extends AbstractWebResource {
    @Context
    private UriInfo uriInfo;

    @GET
    @Path(value="flows/link")
    @Produces(value={"application/json"})
    public Response getLoads(@QueryParam(value="device") String deviceId, @QueryParam(value="port") String port) {
        Iterable links;
        if (deviceId == null || port == null) {
            links = ((LinkService)this.get(LinkService.class)).getLinks();
        } else {
            ConnectPoint connectPoint = new ConnectPoint((ElementId)DeviceId.deviceId((String)deviceId), PortNumber.portNumber((String)port));
            links = ((LinkService)this.get(LinkService.class)).getLinks(connectPoint);
        }
        ObjectNode result = this.mapper().createObjectNode();
        ArrayNode loads = this.mapper().createArrayNode();
        JsonCodec loadCodec = this.codec(Load.class);
        StatisticService statsService = (StatisticService)this.getService(StatisticService.class);
        StreamSupport.stream(Spliterators.spliteratorUnknownSize(links.iterator(), 16), false).forEach(link -> {
            ObjectNode loadNode = loadCodec.encode((Object)statsService.load(link), (CodecContext)this);
            UriBuilder locationBuilder = this.uriInfo.getBaseUriBuilder().path("links").queryParam("device", new Object[]{link.src().deviceId().toString()}).queryParam("port", new Object[]{link.src().port().toString()});
            loadNode.put("link", locationBuilder.build(new Object[0]).toString());
            loads.add((JsonNode)loadNode);
        });
        result.set("loads", (JsonNode)loads);
        return StatisticsWebResource.ok((Object)result).build();
    }

    @GET
    @Path(value="flows/tables")
    @Produces(value={"application/json"})
    public Response getTableStatistics() {
        FlowRuleService service = (FlowRuleService)this.get(FlowRuleService.class);
        Iterable devices = ((DeviceService)this.get(DeviceService.class)).getDevices();
        ObjectNode root = this.mapper().createObjectNode();
        ArrayNode rootArrayNode = root.putArray("statistics");
        for (Device device : devices) {
            ObjectNode deviceStatsNode = this.mapper().createObjectNode();
            deviceStatsNode.put("device", device.id().toString());
            ArrayNode statisticsNode = deviceStatsNode.putArray("table");
            Iterable tableStatsEntries = service.getFlowTableStatistics(device.id());
            if (tableStatsEntries != null) {
                for (TableStatisticsEntry entry : tableStatsEntries) {
                    statisticsNode.add((JsonNode)this.codec(TableStatisticsEntry.class).encode((Object)entry, (CodecContext)this));
                }
            }
            rootArrayNode.add((JsonNode)deviceStatsNode);
        }
        return StatisticsWebResource.ok((Object)root).build();
    }

    @GET
    @Path(value="flows/tables/{deviceId}")
    @Produces(value={"application/json"})
    public Response getTableStatisticsByDeviceId(@PathParam(value="deviceId") String deviceId) {
        FlowRuleService service = (FlowRuleService)this.get(FlowRuleService.class);
        Iterable tableStatisticsEntries = service.getFlowTableStatistics(DeviceId.deviceId((String)deviceId));
        ObjectNode root = this.mapper().createObjectNode();
        ArrayNode rootArrayNode = root.putArray("statistics");
        ObjectNode deviceStatsNode = this.mapper().createObjectNode();
        deviceStatsNode.put("device", deviceId);
        ArrayNode statisticsNode = deviceStatsNode.putArray("table");
        for (TableStatisticsEntry entry : tableStatisticsEntries) {
            statisticsNode.add((JsonNode)this.codec(TableStatisticsEntry.class).encode((Object)entry, (CodecContext)this));
        }
        rootArrayNode.add((JsonNode)deviceStatsNode);
        return StatisticsWebResource.ok((Object)root).build();
    }

    @GET
    @Path(value="ports")
    @Produces(value={"application/json"})
    public Response getPortStatistics() {
        DeviceService service = (DeviceService)this.get(DeviceService.class);
        Iterable devices = service.getDevices();
        ObjectNode root = this.mapper().createObjectNode();
        ArrayNode rootArrayNode = root.putArray("statistics");
        for (Device device : devices) {
            ObjectNode deviceStatsNode = this.mapper().createObjectNode();
            deviceStatsNode.put("device", device.id().toString());
            ArrayNode statisticsNode = deviceStatsNode.putArray("ports");
            List portStatsEntries = service.getPortStatistics(device.id());
            if (portStatsEntries != null) {
                for (PortStatistics entry : portStatsEntries) {
                    statisticsNode.add((JsonNode)this.codec(PortStatistics.class).encode((Object)entry, (CodecContext)this));
                }
            }
            rootArrayNode.add((JsonNode)deviceStatsNode);
        }
        return StatisticsWebResource.ok((Object)root).build();
    }

    @GET
    @Path(value="ports/{deviceId}")
    @Produces(value={"application/json"})
    public Response getPortStatisticsByDeviceId(@PathParam(value="deviceId") String deviceId) {
        DeviceService service = (DeviceService)this.get(DeviceService.class);
        List portStatsEntries = service.getPortStatistics(DeviceId.deviceId((String)deviceId));
        ObjectNode root = this.mapper().createObjectNode();
        ArrayNode rootArrayNode = root.putArray("statistics");
        ObjectNode deviceStatsNode = this.mapper().createObjectNode();
        deviceStatsNode.put("device", deviceId);
        ArrayNode statisticsNode = deviceStatsNode.putArray("ports");
        if (portStatsEntries != null) {
            for (PortStatistics entry : portStatsEntries) {
                statisticsNode.add((JsonNode)this.codec(PortStatistics.class).encode((Object)entry, (CodecContext)this));
            }
        }
        rootArrayNode.add((JsonNode)deviceStatsNode);
        return StatisticsWebResource.ok((Object)root).build();
    }

    @GET
    @Path(value="ports/{deviceId}/{port}")
    @Produces(value={"application/json"})
    public Response getPortStatisticsByDeviceIdAndPort(@PathParam(value="deviceId") String deviceId, @PathParam(value="port") String port) {
        DeviceService service = (DeviceService)this.get(DeviceService.class);
        PortNumber portNumber = PortNumber.portNumber((String)port);
        PortStatistics portStatsEntry = service.getStatisticsForPort(DeviceId.deviceId((String)deviceId), portNumber);
        ObjectNode root = this.mapper().createObjectNode();
        ArrayNode rootArrayNode = root.putArray("statistics");
        ObjectNode deviceStatsNode = this.mapper().createObjectNode();
        deviceStatsNode.put("device", deviceId);
        ArrayNode statisticsNode = deviceStatsNode.putArray("ports");
        if (portStatsEntry != null) {
            statisticsNode.add((JsonNode)this.codec(PortStatistics.class).encode((Object)portStatsEntry, (CodecContext)this));
        }
        rootArrayNode.add((JsonNode)deviceStatsNode);
        return StatisticsWebResource.ok((Object)root).build();
    }

    @GET
    @Path(value="delta/ports")
    @Produces(value={"application/json"})
    public Response getPortDeltaStatistics() {
        DeviceService service = (DeviceService)this.get(DeviceService.class);
        Iterable devices = service.getDevices();
        ObjectNode root = this.mapper().createObjectNode();
        ArrayNode rootArrayNode = root.putArray("statistics");
        for (Device device : devices) {
            ObjectNode deviceStatsNode = this.mapper().createObjectNode();
            deviceStatsNode.put("device", device.id().toString());
            ArrayNode statisticsNode = deviceStatsNode.putArray("ports");
            List portStatsEntries = service.getPortDeltaStatistics(device.id());
            if (portStatsEntries != null) {
                for (PortStatistics entry : portStatsEntries) {
                    statisticsNode.add((JsonNode)this.codec(PortStatistics.class).encode((Object)entry, (CodecContext)this));
                }
            }
            rootArrayNode.add((JsonNode)deviceStatsNode);
        }
        return StatisticsWebResource.ok((Object)root).build();
    }

    @GET
    @Path(value="delta/ports/{deviceId}")
    @Produces(value={"application/json"})
    public Response getPortDeltaStatisticsByDeviceId(@PathParam(value="deviceId") String deviceId) {
        DeviceService service = (DeviceService)this.get(DeviceService.class);
        List portStatsEntries = service.getPortDeltaStatistics(DeviceId.deviceId((String)deviceId));
        ObjectNode root = this.mapper().createObjectNode();
        ArrayNode rootArrayNode = root.putArray("statistics");
        ObjectNode deviceStatsNode = this.mapper().createObjectNode();
        deviceStatsNode.put("device", deviceId);
        ArrayNode statisticsNode = deviceStatsNode.putArray("ports");
        if (portStatsEntries != null) {
            for (PortStatistics entry : portStatsEntries) {
                statisticsNode.add((JsonNode)this.codec(PortStatistics.class).encode((Object)entry, (CodecContext)this));
            }
        }
        rootArrayNode.add((JsonNode)deviceStatsNode);
        return StatisticsWebResource.ok((Object)root).build();
    }

    @GET
    @Path(value="delta/ports/{deviceId}/{port}")
    @Produces(value={"application/json"})
    public Response getPortDeltaStatisticsByDeviceIdAndPort(@PathParam(value="deviceId") String deviceId, @PathParam(value="port") String port) {
        DeviceService service = (DeviceService)this.get(DeviceService.class);
        PortNumber portNumber = PortNumber.portNumber((String)port);
        PortStatistics portStatsEntry = service.getDeltaStatisticsForPort(DeviceId.deviceId((String)deviceId), portNumber);
        ObjectNode root = this.mapper().createObjectNode();
        ArrayNode rootArrayNode = root.putArray("statistics");
        ObjectNode deviceStatsNode = this.mapper().createObjectNode();
        deviceStatsNode.put("device", deviceId);
        ArrayNode statisticsNode = deviceStatsNode.putArray("ports");
        if (portStatsEntry != null) {
            statisticsNode.add((JsonNode)this.codec(PortStatistics.class).encode((Object)portStatsEntry, (CodecContext)this));
        }
        rootArrayNode.add((JsonNode)deviceStatsNode);
        return StatisticsWebResource.ok((Object)root).build();
    }

    @GET
    @Path(value="flows/activeentries")
    @Produces(value={"application/json"})
    public Response getActiveEntriesCountPerDevice() {
        FlowRuleService service = (FlowRuleService)this.get(FlowRuleService.class);
        Iterable devices = ((DeviceService)this.get(DeviceService.class)).getDevices();
        ObjectNode root = this.mapper().createObjectNode();
        ArrayNode rootArrayNode = root.putArray("statistics");
        for (Device device : devices) {
            long activeEntries = service.getActiveFlowRuleCount(device.id());
            ObjectNode entry = this.mapper().createObjectNode();
            entry.put("device", device.id().toString());
            entry.put("activeEntries", activeEntries);
            rootArrayNode.add((JsonNode)entry);
        }
        return StatisticsWebResource.ok((Object)root).build();
    }
}

