/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.rest.resources;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import org.easymock.EasyMock;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onlab.osgi.ServiceDirectory;
import org.onlab.osgi.TestServiceDirectory;
import org.onosproject.app.ApplicationAdminService;
import org.onosproject.app.ApplicationService;
import org.onosproject.app.ApplicationState;
import org.onosproject.codec.CodecContext;
import org.onosproject.codec.CodecService;
import org.onosproject.codec.impl.ApplicationCodec;
import org.onosproject.codec.impl.CodecManager;
import org.onosproject.codec.impl.MockCodecContext;
import org.onosproject.core.Application;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.ApplicationRole;
import org.onosproject.core.CoreService;
import org.onosproject.core.DefaultApplication;
import org.onosproject.core.DefaultApplicationId;
import org.onosproject.core.Version;
import org.onosproject.rest.resources.ResourceTest;

public class ApplicationsResourceTest
extends ResourceTest {
    private ApplicationAdminService appService;
    private CoreService coreService;
    private ApplicationId id1 = new DefaultApplicationId(1, "app1");
    private ApplicationId id2 = new DefaultApplicationId(2, "app2");
    private ApplicationId id3 = new DefaultApplicationId(3, "app3");
    private ApplicationId id4 = new DefaultApplicationId(4, "app4");
    private static final URI FURL = URI.create("mvn:org.foo-features/1.2a/xml/features");
    private static final Version VER = Version.version((int)1, (int)2, (String)"a", null);
    private DefaultApplication.Builder baseBuilder = DefaultApplication.builder().withVersion(VER).withIcon(new byte[0]).withRole(ApplicationRole.ADMIN).withPermissions((Set)ImmutableSet.of()).withFeaturesRepo(Optional.of(FURL)).withFeatures((List)ImmutableList.of((Object)"My Feature")).withRequiredApps((List)ImmutableList.of());
    private Application app1 = DefaultApplication.builder((DefaultApplication.Builder)this.baseBuilder).withAppId(this.id1).withTitle("title1").withDescription("desc1").withOrigin("origin1").withCategory("category1").withUrl("url1").withReadme("readme1").build();
    private Application app2 = DefaultApplication.builder((DefaultApplication.Builder)this.baseBuilder).withAppId(this.id2).withTitle("title2").withDescription("desc2").withOrigin("origin2").withCategory("category2").withUrl("url2").withReadme("readme2").build();
    private Application app3 = DefaultApplication.builder((DefaultApplication.Builder)this.baseBuilder).withAppId(this.id3).withTitle("title3").withDescription("desc3").withOrigin("origin3").withCategory("category3").withUrl("url3").withReadme("readme3").build();
    private Application app4 = DefaultApplication.builder((DefaultApplication.Builder)this.baseBuilder).withAppId(this.id4).withTitle("title4").withDescription("desc4").withOrigin("origin4").withCategory("category4").withUrl("url4").withReadme("readme4").build();

    private static AppJsonMatcher matchesApp(Application app) {
        return new AppJsonMatcher(app);
    }

    private static AppIdJsonMatcher matchesAppId(ApplicationId appId) {
        return new AppIdJsonMatcher(appId);
    }

    @Before
    public void setUpMocks() {
        this.appService = (ApplicationAdminService)EasyMock.createMock(ApplicationAdminService.class);
        this.coreService = (CoreService)EasyMock.createMock(CoreService.class);
        EasyMock.expect((Object)this.appService.getId("one")).andReturn((Object)this.id1).anyTimes();
        EasyMock.expect((Object)this.appService.getId("two")).andReturn((Object)this.id2).anyTimes();
        EasyMock.expect((Object)this.appService.getId("three")).andReturn((Object)this.id3).anyTimes();
        EasyMock.expect((Object)this.appService.getId("four")).andReturn((Object)this.id4).anyTimes();
        EasyMock.expect((Object)this.appService.getApplication(this.id3)).andReturn((Object)this.app3).anyTimes();
        EasyMock.expect((Object)this.appService.getState((ApplicationId)EasyMock.isA(ApplicationId.class))).andReturn((Object)ApplicationState.ACTIVE).anyTimes();
        CodecManager codecService = new CodecManager();
        codecService.activate();
        TestServiceDirectory testDirectory = new TestServiceDirectory().add(ApplicationAdminService.class, (Object)this.appService).add(ApplicationService.class, (Object)this.appService).add(CoreService.class, (Object)this.coreService).add(CodecService.class, (Object)codecService);
        this.setServiceDirectory((ServiceDirectory)testDirectory);
    }

    @Test
    public void getAllApplicationsEmpty() {
        EasyMock.expect((Object)this.appService.getApplications()).andReturn((Object)ImmutableSet.of());
        EasyMock.replay((Object[])new Object[]{this.appService});
        WebTarget wt = this.target();
        String response = (String)wt.path("applications").request().get(String.class);
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.is((Object)"{\"applications\":[]}"));
        EasyMock.verify((Object[])new Object[]{this.appService});
    }

    @Test
    public void getAllApplicationsPopulated() {
        EasyMock.expect((Object)this.appService.getApplications()).andReturn((Object)ImmutableSet.of((Object)this.app1, (Object)this.app2, (Object)this.app3, (Object)this.app4));
        EasyMock.replay((Object[])new Object[]{this.appService});
        WebTarget wt = this.target();
        String response = (String)wt.path("applications").request().get(String.class);
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"{\"applications\":["));
        JsonObject result = Json.parse((String)response).asObject();
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)result.names(), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat(result.names().get(0), (Matcher)Matchers.is((Object)"applications"));
        JsonArray jsonApps = result.get("applications").asArray();
        MatcherAssert.assertThat((Object)jsonApps, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)jsonApps.size(), (Matcher)Matchers.is((Object)4));
        MatcherAssert.assertThat((Object)jsonApps.get(0).asObject(), (Matcher)ApplicationsResourceTest.matchesApp(this.app1));
        MatcherAssert.assertThat((Object)jsonApps.get(1).asObject(), (Matcher)ApplicationsResourceTest.matchesApp(this.app2));
        MatcherAssert.assertThat((Object)jsonApps.get(2).asObject(), (Matcher)ApplicationsResourceTest.matchesApp(this.app3));
        MatcherAssert.assertThat((Object)jsonApps.get(3).asObject(), (Matcher)ApplicationsResourceTest.matchesApp(this.app4));
        EasyMock.verify((Object[])new Object[]{this.appService});
    }

    @Test
    public void getSingleApplication() {
        EasyMock.replay((Object[])new Object[]{this.appService});
        WebTarget wt = this.target();
        String response = (String)wt.path("applications/three").request().get(String.class);
        JsonObject result = Json.parse((String)response).asObject();
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)result, (Matcher)ApplicationsResourceTest.matchesApp(this.app3));
        EasyMock.verify((Object[])new Object[]{this.appService});
    }

    @Test
    public void deleteApplication() {
        this.appService.uninstall(this.id3);
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.appService});
        WebTarget wt = this.target();
        wt.path("applications/three").request().delete();
        EasyMock.verify((Object[])new Object[]{this.appService});
    }

    @Test
    public void deleteActiveApplication() {
        this.appService.deactivate(this.id3);
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.appService});
        WebTarget wt = this.target();
        wt.path("applications/three/active").request().delete();
        EasyMock.verify((Object[])new Object[]{this.appService});
    }

    @Test
    public void postActiveApplication() {
        this.appService.activate(this.id3);
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.appService});
        WebTarget wt = this.target();
        wt.path("applications/three/active").request().post(null);
        EasyMock.verify((Object[])new Object[]{this.appService});
    }

    @Test
    public void postApplication() {
        EasyMock.expect((Object)this.appService.install((InputStream)EasyMock.isA(InputStream.class))).andReturn((Object)this.app4).once();
        EasyMock.replay((Object[])new Object[]{this.appService});
        ApplicationCodec codec = new ApplicationCodec();
        String app4Json = codec.encode(this.app4, (CodecContext)new MockCodecContextWithAppService(this.appService)).asText();
        WebTarget wt = this.target();
        String response = (String)wt.path("applications").request().post(Entity.entity((Object)app4Json, (String)"application/octet-stream"), String.class);
        JsonObject result = Json.parse((String)response).asObject();
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)result, (Matcher)ApplicationsResourceTest.matchesApp(this.app4));
        EasyMock.verify((Object[])new Object[]{this.appService});
    }

    @Test
    public void postRegisterAppId() {
        EasyMock.expect((Object)this.coreService.registerApplication("app1")).andReturn((Object)this.id1).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.coreService});
        WebTarget wt = this.target();
        wt.path("applications/app1/register").request().post(null);
        EasyMock.verify((Object[])new Object[]{this.coreService});
    }

    @Test
    public void getAllApplicationIdsEmpty() {
        EasyMock.expect((Object)this.coreService.getAppIds()).andReturn((Object)ImmutableSet.of());
        EasyMock.replay((Object[])new Object[]{this.coreService});
        WebTarget wt = this.target();
        String response = (String)wt.path("applications/ids").request().get(String.class);
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.is((Object)"{\"applicationIds\":[]}"));
        EasyMock.verify((Object[])new Object[]{this.coreService});
    }

    @Test
    public void getAllApplicationIdsPopulated() {
        EasyMock.expect((Object)this.coreService.getAppIds()).andReturn((Object)ImmutableSet.of((Object)this.id1, (Object)this.id2, (Object)this.id3, (Object)this.id4));
        EasyMock.replay((Object[])new Object[]{this.coreService});
        WebTarget wt = this.target();
        String response = (String)wt.path("applications/ids").request().get(String.class);
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"{\"applicationIds\":["));
        JsonObject result = Json.parse((String)response).asObject();
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)result.names(), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat(result.names().get(0), (Matcher)Matchers.is((Object)"applicationIds"));
        JsonArray jsonApps = result.get("applicationIds").asArray();
        MatcherAssert.assertThat((Object)jsonApps, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)jsonApps.size(), (Matcher)Matchers.is((Object)4));
        MatcherAssert.assertThat((Object)jsonApps.get(0).asObject(), (Matcher)ApplicationsResourceTest.matchesAppId(this.id1));
        MatcherAssert.assertThat((Object)jsonApps.get(1).asObject(), (Matcher)ApplicationsResourceTest.matchesAppId(this.id2));
        MatcherAssert.assertThat((Object)jsonApps.get(2).asObject(), (Matcher)ApplicationsResourceTest.matchesAppId(this.id3));
        MatcherAssert.assertThat((Object)jsonApps.get(3).asObject(), (Matcher)ApplicationsResourceTest.matchesAppId(this.id4));
        EasyMock.verify((Object[])new Object[]{this.coreService});
    }

    @Test
    public void getAppIdByShortId() {
        EasyMock.expect((Object)this.coreService.getAppId(Short.valueOf((short)1))).andReturn((Object)this.id1);
        EasyMock.replay((Object[])new Object[]{this.coreService});
        WebTarget wt = this.target();
        String response = (String)wt.path("applications/ids/entry").queryParam("id", new Object[]{1}).request().get(String.class);
        JsonObject result = Json.parse((String)response).asObject();
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)result, (Matcher)ApplicationsResourceTest.matchesAppId(this.id1));
        EasyMock.verify((Object[])new Object[]{this.coreService});
    }

    @Test
    public void getAppIdByName() {
        EasyMock.expect((Object)this.coreService.getAppId("app2")).andReturn((Object)this.id2);
        EasyMock.replay((Object[])new Object[]{this.coreService});
        WebTarget wt = this.target();
        String response = (String)wt.path("applications/ids/entry").queryParam("name", new Object[]{"app2"}).request().get(String.class);
        JsonObject result = Json.parse((String)response).asObject();
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)result, (Matcher)ApplicationsResourceTest.matchesAppId(this.id2));
        EasyMock.verify((Object[])new Object[]{this.coreService});
    }

    @Test
    public void getAppWithNoParam() {
        WebTarget wt = this.target();
        try {
            wt.path("applications/ids/entry").request().get();
        }
        catch (NotFoundException ex) {
            Assert.assertThat((Object)ex.getMessage(), (Matcher)Matchers.containsString((String)"HTTP 404 Not Found"));
        }
    }

    private static final class AppIdJsonMatcher
    extends TypeSafeMatcher<JsonObject> {
        private final ApplicationId appId;
        private String reason = "";

        private AppIdJsonMatcher(ApplicationId appId) {
            this.appId = appId;
        }

        protected boolean matchesSafely(JsonObject jsonAppId) {
            short jsonId = (short)jsonAppId.get("id").asInt();
            if (jsonId != this.appId.id()) {
                this.reason = "id " + this.appId.id();
                return false;
            }
            String jsonName = jsonAppId.get("name").asString();
            if (!jsonName.equals(this.appId.name())) {
                this.reason = "name " + this.appId.name();
                return false;
            }
            return true;
        }

        public void describeTo(Description description) {
            description.appendText(this.reason);
        }
    }

    private static class AppJsonMatcher
    extends TypeSafeMatcher<JsonObject> {
        private final Application app;
        private String reason = "";

        public AppJsonMatcher(Application appValue) {
            this.app = appValue;
        }

        public boolean matchesSafely(JsonObject jsonApp) {
            short jsonId = (short)jsonApp.get("id").asInt();
            if (jsonId != this.app.id().id()) {
                this.reason = "id " + this.app.id().id();
                return false;
            }
            String jsonName = jsonApp.get("name").asString();
            if (!jsonName.equals(this.app.id().name())) {
                this.reason = "name " + this.app.id().name();
                return false;
            }
            String jsonOrigin = jsonApp.get("origin").asString();
            if (!jsonOrigin.equals(this.app.origin())) {
                this.reason = "manufacturer " + this.app.origin();
                return false;
            }
            return true;
        }

        public void describeTo(Description description) {
            description.appendText(this.reason);
        }
    }

    private static class MockCodecContextWithCoreService
    extends MockCodecContext {
        private CoreService coreService;

        MockCodecContextWithCoreService(CoreService coreService) {
            this.coreService = coreService;
        }

        public <T> T getService(Class<T> serviceClass) {
            return (T)this.coreService;
        }
    }

    private static class MockCodecContextWithAppService
    extends MockCodecContext {
        private ApplicationAdminService appService;

        MockCodecContextWithAppService(ApplicationAdminService appService) {
            this.appService = appService;
        }

        public <T> T getService(Class<T> serviceClass) {
            return (T)this.appService;
        }
    }
}

