/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.rest.resources;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onlab.osgi.ServiceDirectory;
import org.onlab.osgi.TestServiceDirectory;
import org.onosproject.cfg.ComponentConfigAdapter;
import org.onosproject.cfg.ComponentConfigService;
import org.onosproject.cfg.ConfigProperty;
import org.onosproject.rest.resources.ResourceTest;

public class ComponentConfigWebResourceTest
extends ResourceTest {
    private TestConfigManager service;

    @Before
    public void setUpMock() {
        this.service = new TestConfigManager();
        TestServiceDirectory testDirectory = new TestServiceDirectory().add(ComponentConfigService.class, (Object)this.service);
        this.setServiceDirectory((ServiceDirectory)testDirectory);
    }

    @Test
    public void getAllConfigs() {
        WebTarget wt = this.target();
        String response = (String)wt.path("configuration").request().get(String.class);
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"\"foo\":"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"\"bar\":"));
    }

    @Test
    public void getConfigs() {
        WebTarget wt = this.target();
        String response = (String)wt.path("configuration/foo").request().get(String.class);
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"{\"foo\":"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"{\"bar\":")));
    }

    @Test
    public void setConfigs() {
        WebTarget wt = this.target();
        try {
            wt.path("configuration/foo").request().post(Entity.json((Object)"{ \"k\" : \"v\" }"), String.class);
        }
        catch (BadRequestException e) {
            Assert.assertEquals((String)"incorrect key", (Object)"foo", (Object)this.service.component);
            Assert.assertEquals((String)"incorrect key", (Object)"k", (Object)this.service.name);
            Assert.assertEquals((String)"incorrect value", (Object)"v", (Object)this.service.value);
        }
    }

    @Test
    public void unsetConfigs() {
        WebTarget wt = this.target();
        try {
            wt.path("configuration/foo").request().delete();
        }
        catch (BadRequestException e) {
            Assert.assertEquals((String)"incorrect key", (Object)"foo", (Object)this.service.component);
            Assert.assertEquals((String)"incorrect key", (Object)"k", (Object)this.service.name);
            Assert.assertEquals((String)"incorrect value", null, (Object)this.service.value);
        }
    }

    private class TestConfigManager
    extends ComponentConfigAdapter {
        private String component;
        private String name;
        private String value;

        private TestConfigManager() {
        }

        public Set<String> getComponentNames() {
            return ImmutableSet.of((Object)"foo", (Object)"bar");
        }

        public void setProperty(String componentName, String name, String value) {
            this.component = componentName;
            this.name = name;
            this.value = value;
        }

        public void unsetProperty(String componentName, String name) {
            this.component = componentName;
            this.name = name;
            this.value = null;
        }

        public Set<ConfigProperty> getProperties(String componentName) {
            return ImmutableSet.of((Object)ConfigProperty.defineProperty((String)"k1", (ConfigProperty.Type)ConfigProperty.Type.STRING, (String)"d1", (String)"dv1"), (Object)ConfigProperty.defineProperty((String)"k2", (ConfigProperty.Type)ConfigProperty.Type.INTEGER, (String)"d2", (String)"321"));
        }
    }
}

