/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.rest.resources;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import java.io.InputStream;
import java.util.HashSet;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.easymock.EasyMock;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onlab.osgi.ServiceDirectory;
import org.onlab.osgi.TestServiceDirectory;
import org.onosproject.codec.CodecService;
import org.onosproject.codec.impl.CodecManager;
import org.onosproject.net.key.DeviceKey;
import org.onosproject.net.key.DeviceKeyAdminService;
import org.onosproject.net.key.DeviceKeyId;
import org.onosproject.net.key.DeviceKeyService;
import org.onosproject.rest.resources.ResourceTest;

public class DeviceKeyWebResourceTest
extends ResourceTest {
    final DeviceKeyService mockDeviceKeyService = (DeviceKeyService)EasyMock.createMock(DeviceKeyService.class);
    final DeviceKeyAdminService mockDeviceKeyAdminService = (DeviceKeyAdminService)EasyMock.createMock(DeviceKeyAdminService.class);
    final HashSet<DeviceKey> deviceKeySet = new HashSet();
    private static final String ID = "id";
    private static final String TYPE = "type";
    private static final String LABEL = "label";
    private static final String COMMUNITY_NAME = "community_name";
    private static final String USERNAME = "username";
    private static final String PASSWORD = "password";
    private final String deviceKeyId1 = "DeviceKeyId1";
    private final String deviceKeyId2 = "DeviceKeyId2";
    private final String deviceKeyId3 = "DeviceKeyId3";
    private final String deviceKeyId4 = "DeviceKeyId4";
    private final String deviceKeyLabel = "DeviceKeyLabel";
    private final String deviceKeyCommunityName = "DeviceKeyCommunityName";
    private final String deviceKeyUsername = "DeviceKeyUsername";
    private final String deviceKeyPassword = "DeviceKeyPassword";
    private final DeviceKey deviceKey1 = DeviceKey.createDeviceKeyUsingCommunityName((DeviceKeyId)DeviceKeyId.deviceKeyId((String)"DeviceKeyId1"), (String)"DeviceKeyLabel", (String)"DeviceKeyCommunityName");
    private final DeviceKey deviceKey2 = DeviceKey.createDeviceKeyUsingUsernamePassword((DeviceKeyId)DeviceKeyId.deviceKeyId((String)"DeviceKeyId2"), null, (String)"DeviceKeyUsername", (String)"DeviceKeyPassword");
    private final DeviceKey deviceKey3 = DeviceKey.createDeviceKeyUsingUsernamePassword((DeviceKeyId)DeviceKeyId.deviceKeyId((String)"DeviceKeyId3"), null, null, null);
    private final DeviceKey deviceKey4 = DeviceKey.createDeviceKeyUsingCommunityName((DeviceKeyId)DeviceKeyId.deviceKeyId((String)"DeviceKeyId4"), null, null);

    @Before
    public void setUpMocks() {
        EasyMock.expect((Object)this.mockDeviceKeyService.getDeviceKeys()).andReturn(this.deviceKeySet).anyTimes();
        CodecManager codecService = new CodecManager();
        codecService.activate();
        TestServiceDirectory testDirectory = new TestServiceDirectory().add(DeviceKeyService.class, (Object)this.mockDeviceKeyService).add(DeviceKeyAdminService.class, (Object)this.mockDeviceKeyAdminService).add(CodecService.class, (Object)codecService);
        this.setServiceDirectory((ServiceDirectory)testDirectory);
    }

    private static DeviceKeyJsonMatcher matchesDeviceKey(DeviceKey deviceKey) {
        return new DeviceKeyJsonMatcher(deviceKey);
    }

    private static DeviceKeyJsonArrayMatcher hasDeviceKey(DeviceKey deviceKey) {
        return new DeviceKeyJsonArrayMatcher(deviceKey);
    }

    @Test
    public void testGetDeviceKeysEmptyArray() {
        EasyMock.replay((Object[])new Object[]{this.mockDeviceKeyService});
        WebTarget wt = this.target();
        String response = (String)wt.path("keys").request().get(String.class);
        Assert.assertThat((Object)response, (Matcher)Matchers.is((Object)"{\"keys\":[]}"));
        EasyMock.verify((Object[])new Object[]{this.mockDeviceKeyService});
    }

    @Test
    public void testGetDeviceKeysArray() {
        EasyMock.replay((Object[])new Object[]{this.mockDeviceKeyService});
        this.deviceKeySet.add(this.deviceKey1);
        this.deviceKeySet.add(this.deviceKey2);
        this.deviceKeySet.add(this.deviceKey3);
        this.deviceKeySet.add(this.deviceKey4);
        WebTarget wt = this.target();
        String response = (String)wt.path("keys").request().get(String.class);
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"{\"keys\":["));
        JsonObject result = Json.parse((String)response).asObject();
        Assert.assertThat((Object)result, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)result.names(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat(result.names().get(0), (Matcher)Matchers.is((Object)"keys"));
        JsonArray deviceKeys = result.get("keys").asArray();
        Assert.assertThat((Object)deviceKeys, (Matcher)Matchers.notNullValue());
        Assert.assertEquals((String)"Device keys array is not the correct size.", (long)4L, (long)deviceKeys.size());
        Assert.assertThat((Object)deviceKeys, (Matcher)DeviceKeyWebResourceTest.hasDeviceKey(this.deviceKey1));
        Assert.assertThat((Object)deviceKeys, (Matcher)DeviceKeyWebResourceTest.hasDeviceKey(this.deviceKey2));
        Assert.assertThat((Object)deviceKeys, (Matcher)DeviceKeyWebResourceTest.hasDeviceKey(this.deviceKey3));
        Assert.assertThat((Object)deviceKeys, (Matcher)DeviceKeyWebResourceTest.hasDeviceKey(this.deviceKey4));
        EasyMock.verify((Object[])new Object[]{this.mockDeviceKeyService});
    }

    @Test
    public void testGetDeviceKeyById() {
        this.deviceKeySet.add(this.deviceKey1);
        EasyMock.expect((Object)this.mockDeviceKeyService.getDeviceKey(DeviceKeyId.deviceKeyId((String)"DeviceKeyId1"))).andReturn((Object)this.deviceKey1).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.mockDeviceKeyService});
        WebTarget wt = this.target();
        String response = (String)wt.path("keys/DeviceKeyId1").request().get(String.class);
        JsonObject result = Json.parse((String)response).asObject();
        Assert.assertThat((Object)result, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)result, (Matcher)DeviceKeyWebResourceTest.matchesDeviceKey(this.deviceKey1));
        EasyMock.verify((Object[])new Object[]{this.mockDeviceKeyService});
    }

    @Test
    public void testGetNonExistentDeviceKey() {
        EasyMock.expect((Object)this.mockDeviceKeyService.getDeviceKey(DeviceKeyId.deviceKeyId((String)"DeviceKeyId1"))).andReturn(null).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.mockDeviceKeyService});
        WebTarget wt = this.target();
        try {
            wt.path("keys/DeviceKeyId1").request().get(String.class);
            Assert.fail((String)"GET of a non-existent device key did not throw an exception");
        }
        catch (NotFoundException ex) {
            Assert.assertThat((Object)ex.getMessage(), (Matcher)Matchers.containsString((String)"HTTP 404 Not Found"));
        }
        EasyMock.verify((Object[])new Object[]{this.mockDeviceKeyService});
    }

    @Test
    public void testPost() {
        this.mockDeviceKeyAdminService.addKey((DeviceKey)EasyMock.anyObject());
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.mockDeviceKeyAdminService});
        WebTarget wt = this.target();
        InputStream jsonStream = DeviceKeyWebResourceTest.class.getResourceAsStream("post-device-key.json");
        Response response = wt.path("keys").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.json((Object)jsonStream));
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)201));
        String location = response.getLocation().getPath();
        Assert.assertThat((Object)location, (Matcher)Matchers.startsWith((String)"/keys/DeviceKeyId3"));
        EasyMock.verify((Object[])new Object[]{this.mockDeviceKeyAdminService});
    }

    @Test
    public void testPostNullDeviceKey() {
        EasyMock.replay((Object[])new Object[]{this.mockDeviceKeyAdminService});
        WebTarget wt = this.target();
        try {
            wt.path("keys").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.json(null), String.class);
            Assert.fail((String)"POST of null device key did not throw an exception");
        }
        catch (BadRequestException ex) {
            Assert.assertThat((Object)ex.getMessage(), (Matcher)Matchers.containsString((String)"HTTP 400 Bad Request"));
        }
        EasyMock.verify((Object[])new Object[]{this.mockDeviceKeyAdminService});
    }

    @Test
    public void testDelete() {
        EasyMock.expect((Object)this.mockDeviceKeyService.getDeviceKey(DeviceKeyId.deviceKeyId((String)"DeviceKeyId2"))).andReturn((Object)this.deviceKey2).anyTimes();
        this.mockDeviceKeyAdminService.removeKey((DeviceKeyId)EasyMock.anyObject());
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.mockDeviceKeyService});
        EasyMock.replay((Object[])new Object[]{this.mockDeviceKeyAdminService});
        WebTarget wt = this.target();
        Response response = wt.path("keys/DeviceKeyId2").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).delete();
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
        EasyMock.verify((Object[])new Object[]{this.mockDeviceKeyService});
        EasyMock.verify((Object[])new Object[]{this.mockDeviceKeyAdminService});
    }

    @Test
    public void testDeleteNonExistentDeviceKey() {
        EasyMock.expect((Object)this.mockDeviceKeyService.getDeviceKey((DeviceKeyId)EasyMock.anyObject())).andReturn(null).anyTimes();
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.mockDeviceKeyService});
        EasyMock.replay((Object[])new Object[]{this.mockDeviceKeyAdminService});
        WebTarget wt = this.target();
        try {
            wt.path("keys/NON_EXISTENT_DEVICE_KEY").request().delete(String.class);
            Assert.fail((String)"Delete of a non-existent device key did not throw an exception");
        }
        catch (NotFoundException ex) {
            Assert.assertThat((Object)ex.getMessage(), (Matcher)Matchers.containsString((String)"HTTP 404 Not Found"));
        }
        EasyMock.verify((Object[])new Object[]{this.mockDeviceKeyService});
        EasyMock.verify((Object[])new Object[]{this.mockDeviceKeyAdminService});
    }

    public static class DeviceKeyJsonArrayMatcher
    extends TypeSafeMatcher<JsonArray> {
        private final DeviceKey deviceKey;
        private String reason = "";

        public DeviceKeyJsonArrayMatcher(DeviceKey deviceKeyValue) {
            this.deviceKey = deviceKeyValue;
        }

        public boolean matchesSafely(JsonArray json) {
            boolean deviceKeyFound = false;
            int expectedAttributes = 5;
            for (int jsonDeviceKeyIndex = 0; jsonDeviceKeyIndex < json.size(); ++jsonDeviceKeyIndex) {
                JsonObject jsonHost = json.get(jsonDeviceKeyIndex).asObject();
                if (jsonHost.names().size() < 5) {
                    this.reason = "Found a device key with the wrong number of attributes";
                    return false;
                }
                String jsonDeviceKeyId = jsonHost.get(DeviceKeyWebResourceTest.ID).asString();
                if (!jsonDeviceKeyId.equals(((String)this.deviceKey.deviceKeyId().id()).toString())) continue;
                deviceKeyFound = true;
                Assert.assertThat((Object)jsonHost, (Matcher)DeviceKeyWebResourceTest.matchesDeviceKey(this.deviceKey));
            }
            if (!deviceKeyFound) {
                this.reason = "Device key with id " + ((String)this.deviceKey.deviceKeyId().id()).toString() + " was not found";
                return false;
            }
            return true;
        }

        public void describeTo(Description description) {
            description.appendText(this.reason);
        }
    }

    public static class DeviceKeyJsonMatcher
    extends TypeSafeMatcher<JsonObject> {
        private final DeviceKey deviceKey;
        private String reason = "";

        public DeviceKeyJsonMatcher(DeviceKey deviceKeyValue) {
            this.deviceKey = deviceKeyValue;
        }

        public boolean matchesSafely(JsonObject jsonHost) {
            String jsonLabel;
            String jsonId = jsonHost.get(DeviceKeyWebResourceTest.ID).asString();
            if (!jsonId.equals(((String)this.deviceKey.deviceKeyId().id()).toString())) {
                this.reason = "id " + ((String)this.deviceKey.deviceKeyId().id()).toString();
                return false;
            }
            String string = jsonLabel = jsonHost.get(DeviceKeyWebResourceTest.LABEL).isNull() ? null : jsonHost.get(DeviceKeyWebResourceTest.LABEL).asString();
            if (!(this.deviceKey.label() == null || jsonLabel != null && jsonLabel.equals(this.deviceKey.label()))) {
                this.reason = "label " + this.deviceKey.label();
                return false;
            }
            String jsonType = jsonHost.get(DeviceKeyWebResourceTest.TYPE).asString();
            if (!jsonType.equals(this.deviceKey.type().toString())) {
                this.reason = "type " + this.deviceKey.type().toString();
                return false;
            }
            if (jsonType.equals(DeviceKey.Type.COMMUNITY_NAME.toString())) {
                String jsonCommunityName;
                String string2 = jsonCommunityName = jsonHost.get(DeviceKeyWebResourceTest.COMMUNITY_NAME).isNull() ? null : jsonHost.get(DeviceKeyWebResourceTest.COMMUNITY_NAME).asString();
                if (this.deviceKey.asCommunityName().name() != null && !jsonCommunityName.equals(this.deviceKey.asCommunityName().name().toString())) {
                    this.reason = "community_name " + this.deviceKey.asCommunityName().name().toString();
                    return false;
                }
            } else if (jsonType.equals(DeviceKey.Type.USERNAME_PASSWORD.toString())) {
                String jsonPassword;
                String jsonUsername;
                String string3 = jsonUsername = jsonHost.get(DeviceKeyWebResourceTest.USERNAME).isNull() ? null : jsonHost.get(DeviceKeyWebResourceTest.USERNAME).asString();
                if (this.deviceKey.asUsernamePassword().username() != null && !jsonUsername.equals(this.deviceKey.asUsernamePassword().username().toString())) {
                    this.reason = "username " + this.deviceKey.asUsernamePassword().username().toString();
                    return false;
                }
                String string4 = jsonPassword = jsonHost.get(DeviceKeyWebResourceTest.PASSWORD).isNull() ? null : jsonHost.get(DeviceKeyWebResourceTest.PASSWORD).asString();
                if (this.deviceKey.asUsernamePassword().password() != null && !jsonPassword.equals(this.deviceKey.asUsernamePassword().password().toString())) {
                    this.reason = "password " + this.deviceKey.asUsernamePassword().password().toString();
                    return false;
                }
            } else {
                this.reason = "Unknown type " + this.deviceKey.type().toString();
                return false;
            }
            return true;
        }

        public void describeTo(Description description) {
            description.appendText(this.reason);
        }
    }
}

