/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.rest.resources;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Map;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.client.WebTarget;
import org.easymock.EasyMock;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onlab.osgi.ServiceDirectory;
import org.onlab.osgi.TestServiceDirectory;
import org.onosproject.codec.CodecService;
import org.onosproject.codec.impl.CodecManager;
import org.onosproject.net.Annotations;
import org.onosproject.net.DefaultPort;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Element;
import org.onosproject.net.MastershipRole;
import org.onosproject.net.NetTestTools;
import org.onosproject.net.PortNumber;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.driver.DefaultDriver;
import org.onosproject.net.driver.DriverService;
import org.onosproject.net.driver.TestBehaviour;
import org.onosproject.net.driver.TestBehaviourImpl;
import org.onosproject.net.driver.TestBehaviourTwo;
import org.onosproject.net.driver.TestBehaviourTwoImpl;
import org.onosproject.rest.resources.ResourceTest;

public class DevicesResourceTest
extends ResourceTest {
    DeviceService mockDeviceService;
    DriverService mockDriverService;
    DefaultDriver driver = new DefaultDriver("ovs", new ArrayList(), "Circus", "lux", "1.2a", (Map)ImmutableMap.of(TestBehaviour.class, TestBehaviourImpl.class, TestBehaviourTwo.class, TestBehaviourTwoImpl.class), (Map)ImmutableMap.of((Object)"foo", (Object)"bar"));

    private static DeviceJsonMatcher matchesDevice(Device device) {
        return new DeviceJsonMatcher(device);
    }

    private static DeviceJsonArrayMatcher hasDevice(Device device) {
        return new DeviceJsonArrayMatcher(device);
    }

    @Before
    public void setUpMocks() {
        this.mockDeviceService = (DeviceService)EasyMock.createMock(DeviceService.class);
        this.mockDriverService = (DriverService)EasyMock.createMock(DriverService.class);
        EasyMock.expect((Object)this.mockDeviceService.isAvailable((DeviceId)EasyMock.isA(DeviceId.class))).andReturn((Object)true).anyTimes();
        EasyMock.expect((Object)this.mockDeviceService.getRole((DeviceId)EasyMock.isA(DeviceId.class))).andReturn((Object)MastershipRole.MASTER).anyTimes();
        EasyMock.expect((Object)this.mockDeviceService.getLastUpdatedInstant((DeviceId)EasyMock.isA(DeviceId.class))).andReturn((Object)0L).anyTimes();
        EasyMock.expect((Object)this.mockDeviceService.localStatus((DeviceId)EasyMock.isA(DeviceId.class))).andReturn((Object)"").anyTimes();
        CodecManager codecService = new CodecManager();
        codecService.activate();
        TestServiceDirectory testDirectory = new TestServiceDirectory().add(DeviceService.class, (Object)this.mockDeviceService).add(DriverService.class, (Object)this.mockDriverService).add(CodecService.class, (Object)codecService);
        this.setServiceDirectory((ServiceDirectory)testDirectory);
    }

    @After
    public void tearDownMocks() {
        EasyMock.verify((Object[])new Object[]{this.mockDeviceService});
    }

    @Test
    public void testDevicesEmptyArray() {
        EasyMock.expect((Object)this.mockDeviceService.getDevices()).andReturn((Object)ImmutableList.of());
        EasyMock.replay((Object[])new Object[]{this.mockDeviceService});
        WebTarget wt = this.target();
        String response = (String)wt.path("devices").request().get(String.class);
        Assert.assertThat((Object)response, (Matcher)Matchers.is((Object)"{\"devices\":[]}"));
    }

    @Test
    public void testDevices() {
        Device device1 = NetTestTools.device((String)"dev1");
        Device device2 = NetTestTools.device((String)"dev2");
        Device device3 = NetTestTools.device((String)"dev3");
        EasyMock.expect((Object)this.mockDeviceService.getDevices()).andReturn((Object)ImmutableList.of((Object)device1, (Object)device2, (Object)device3)).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.mockDeviceService});
        EasyMock.expect((Object)this.mockDriverService.getDriver(NetTestTools.did((String)"dev1"))).andReturn((Object)this.driver).anyTimes();
        EasyMock.expect((Object)this.mockDriverService.getDriver(NetTestTools.did((String)"dev2"))).andReturn((Object)this.driver).anyTimes();
        EasyMock.expect((Object)this.mockDriverService.getDriver(NetTestTools.did((String)"dev3"))).andReturn((Object)this.driver).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.mockDriverService});
        WebTarget wt = this.target();
        String response = (String)wt.path("devices").request().get(String.class);
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"{\"devices\":["));
        JsonObject result = Json.parse((String)response).asObject();
        Assert.assertThat((Object)result, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)result.names(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat(result.names().get(0), (Matcher)Matchers.is((Object)"devices"));
        JsonArray jsonDevices = result.get("devices").asArray();
        Assert.assertThat((Object)jsonDevices, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)jsonDevices.size(), (Matcher)Matchers.is((Object)3));
        Assert.assertThat((Object)jsonDevices, (Matcher)DevicesResourceTest.hasDevice(device1));
        Assert.assertThat((Object)jsonDevices, (Matcher)DevicesResourceTest.hasDevice(device2));
        Assert.assertThat((Object)jsonDevices, (Matcher)DevicesResourceTest.hasDevice(device3));
    }

    @Test
    public void testDevicesSingle() {
        String deviceIdString = "testdevice";
        DeviceId deviceId = NetTestTools.did((String)deviceIdString);
        Device device = NetTestTools.device((String)deviceIdString);
        EasyMock.expect((Object)this.mockDeviceService.getDevice(deviceId)).andReturn((Object)device).once();
        EasyMock.replay((Object[])new Object[]{this.mockDeviceService});
        EasyMock.expect((Object)this.mockDriverService.getDriver(deviceId)).andReturn((Object)this.driver).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.mockDriverService});
        WebTarget wt = this.target();
        String response = (String)wt.path("devices/" + deviceId).request().get(String.class);
        JsonObject result = Json.parse((String)response).asObject();
        Assert.assertThat((Object)result, (Matcher)DevicesResourceTest.matchesDevice(device));
    }

    @Test
    public void testDeviceAndPorts() {
        String deviceIdString = "testdevice";
        DeviceId deviceId = NetTestTools.did((String)deviceIdString);
        Device device = NetTestTools.device((String)deviceIdString);
        DefaultPort port1 = new DefaultPort((Element)device, PortNumber.portNumber((long)1L), true, new Annotations[0]);
        DefaultPort port2 = new DefaultPort((Element)device, PortNumber.portNumber((long)2L), true, new Annotations[0]);
        DefaultPort port3 = new DefaultPort((Element)device, PortNumber.portNumber((long)3L), true, new Annotations[0]);
        ImmutableList ports = ImmutableList.of((Object)port1, (Object)port2, (Object)port3);
        EasyMock.expect((Object)this.mockDeviceService.getDevice(deviceId)).andReturn((Object)device).once();
        EasyMock.expect((Object)this.mockDeviceService.getPorts(deviceId)).andReturn((Object)ports).once();
        EasyMock.replay((Object[])new Object[]{this.mockDeviceService});
        EasyMock.expect((Object)this.mockDriverService.getDriver(deviceId)).andReturn((Object)this.driver).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.mockDriverService});
        WebTarget wt = this.target();
        String response = (String)wt.path("devices/" + deviceId + "/ports").request().get(String.class);
        JsonObject result = Json.parse((String)response).asObject();
        Assert.assertThat((Object)result, (Matcher)DevicesResourceTest.matchesDevice(device));
        JsonArray jsonPorts = result.get("ports").asArray();
        Assert.assertThat((Object)jsonPorts.size(), (Matcher)Matchers.is((Object)3));
        for (int portIndex = 0; portIndex < jsonPorts.size(); ++portIndex) {
            JsonObject jsonPort = jsonPorts.get(portIndex).asObject();
            Assert.assertThat((Object)jsonPort.get("port").asString(), (Matcher)Matchers.is((Object)Integer.toString(portIndex + 1)));
            Assert.assertThat((Object)jsonPort.get("isEnabled").asBoolean(), (Matcher)Matchers.is((Object)true));
            Assert.assertThat((Object)jsonPort.get("type").asString(), (Matcher)Matchers.equalTo((Object)"copper"));
            Assert.assertThat((Object)jsonPort.get("portSpeed").asLong(), (Matcher)Matchers.is((Object)1000L));
        }
    }

    @Test
    public void testBadGet() {
        EasyMock.expect((Object)this.mockDeviceService.getDevice((DeviceId)EasyMock.isA(DeviceId.class))).andReturn(null).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.mockDeviceService});
        WebTarget wt = this.target();
        try {
            wt.path("devices/0").request().get(String.class);
            Assert.fail((String)"Fetch of non-existent device did not throw an exception");
        }
        catch (NotFoundException ex) {
            Assert.assertThat((Object)ex.getMessage(), (Matcher)Matchers.containsString((String)"HTTP 404 Not Found"));
        }
    }

    private static class DeviceJsonArrayMatcher
    extends TypeSafeMatcher<JsonArray> {
        private final Device device;
        private String reason = "";

        public DeviceJsonArrayMatcher(Device deviceValue) {
            this.device = deviceValue;
        }

        public boolean matchesSafely(JsonArray json) {
            int minExpectedAttributes = 11;
            int maxExpectedAttributes = 12;
            boolean deviceFound = false;
            for (int jsonDeviceIndex = 0; jsonDeviceIndex < json.size(); ++jsonDeviceIndex) {
                JsonObject jsonDevice = json.get(jsonDeviceIndex).asObject();
                if (jsonDevice.names().size() < 11 || jsonDevice.names().size() > 12) {
                    this.reason = "Found a device with the wrong number of attributes";
                    return false;
                }
                String jsonDeviceId = jsonDevice.get("id").asString();
                if (!jsonDeviceId.equals(this.device.id().toString())) continue;
                deviceFound = true;
                Assert.assertThat((Object)jsonDevice, (Matcher)DevicesResourceTest.matchesDevice(this.device));
            }
            if (!deviceFound) {
                this.reason = "Device with id " + this.device.id().toString() + " not found";
                return false;
            }
            return true;
        }

        public void describeTo(Description description) {
            description.appendText(this.reason);
        }
    }

    public static class DeviceJsonMatcher
    extends TypeSafeMatcher<JsonObject> {
        private final Device device;
        private String reason = "";

        public DeviceJsonMatcher(Device deviceValue) {
            this.device = deviceValue;
        }

        public boolean matchesSafely(JsonObject jsonDevice) {
            String jsonId = jsonDevice.get("id").asString();
            if (!jsonId.equals(this.device.id().toString())) {
                this.reason = "id " + this.device.id().toString();
                return false;
            }
            String jsonType = jsonDevice.get("type").asString();
            if (!jsonType.equals(this.device.type().toString())) {
                this.reason = "appId " + this.device.type().toString();
                return false;
            }
            String jsonManufacturer = jsonDevice.get("mfr").asString();
            if (!jsonManufacturer.equals(this.device.manufacturer())) {
                this.reason = "manufacturer " + this.device.manufacturer();
                return false;
            }
            String jsonHwVersion = jsonDevice.get("hw").asString();
            if (!jsonHwVersion.equals(this.device.hwVersion())) {
                this.reason = "hw Version " + this.device.hwVersion();
                return false;
            }
            String jsonSwVersion = jsonDevice.get("sw").asString();
            if (!jsonSwVersion.equals(this.device.swVersion())) {
                this.reason = "sw Version " + this.device.swVersion();
                return false;
            }
            String jsonSerialNumber = jsonDevice.get("serial").asString();
            if (!jsonSerialNumber.equals(this.device.serialNumber())) {
                this.reason = "serial number " + this.device.serialNumber();
                return false;
            }
            String jsonChassisId = jsonDevice.get("chassisId").asString();
            if (!jsonChassisId.equals(this.device.chassisId().toString())) {
                this.reason = "Chassis id " + this.device.chassisId().toString();
                return false;
            }
            return true;
        }

        public void describeTo(Description description) {
            description.appendText(this.reason);
        }
    }
}

