/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.rest.resources;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonObject;
import java.io.InputStream;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.easymock.EasyMock;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onlab.osgi.ServiceDirectory;
import org.onlab.osgi.TestServiceDirectory;
import org.onosproject.codec.CodecService;
import org.onosproject.codec.impl.CodecManager;
import org.onosproject.core.CoreService;
import org.onosproject.net.DeviceId;
import org.onosproject.net.NetTestTools;
import org.onosproject.net.flowobjective.FilteringObjective;
import org.onosproject.net.flowobjective.FlowObjectiveService;
import org.onosproject.net.flowobjective.ForwardingObjective;
import org.onosproject.net.flowobjective.NextObjective;
import org.onosproject.rest.resources.FlowsResourceTest;
import org.onosproject.rest.resources.ResourceTest;

public class FlowObjectiveResourceTest
extends ResourceTest {
    final FlowObjectiveService mockFlowObjectiveService = (FlowObjectiveService)EasyMock.createMock(FlowObjectiveService.class);
    CoreService mockCoreService = (CoreService)EasyMock.createMock(CoreService.class);
    public static final String REST_APP_ID = "org.onosproject.rest";

    @Before
    public void setUpTest() {
        EasyMock.expect((Object)this.mockCoreService.getAppId(Short.valueOf(EasyMock.anyShort()))).andReturn((Object)NetTestTools.APP_ID).anyTimes();
        EasyMock.expect((Object)this.mockCoreService.registerApplication(REST_APP_ID)).andReturn((Object)NetTestTools.APP_ID).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.mockCoreService});
        CodecManager codecService = new CodecManager();
        codecService.activate();
        TestServiceDirectory testDirectory = new TestServiceDirectory().add(FlowObjectiveService.class, (Object)this.mockFlowObjectiveService).add(CodecService.class, (Object)codecService).add(CoreService.class, (Object)this.mockCoreService);
        this.setServiceDirectory((ServiceDirectory)testDirectory);
    }

    @After
    public void tearDownTest() {
        EasyMock.verify((Object[])new Object[]{this.mockFlowObjectiveService});
        EasyMock.verify((Object[])new Object[]{this.mockCoreService});
    }

    @Test
    public void testFilteringObjectivePost() {
        this.mockFlowObjectiveService.filter((DeviceId)EasyMock.anyObject(), (FilteringObjective)EasyMock.anyObject());
        this.prepareService();
        this.testObjectiveCreation("post-filter-objective.json", "of:0000000000000001", "filter");
    }

    @Test
    public void testForwardingObjectivePost() {
        this.mockFlowObjectiveService.forward((DeviceId)EasyMock.anyObject(), (ForwardingObjective)EasyMock.anyObject());
        this.prepareService();
        this.testObjectiveCreation("post-forward-objective.json", "of:0000000000000001", "forward");
    }

    @Test
    public void testNextObjectivePost() {
        this.mockFlowObjectiveService.next((DeviceId)EasyMock.anyObject(), (NextObjective)EasyMock.anyObject());
        this.prepareService();
        this.testObjectiveCreation("post-next-objective.json", "of:0000000000000001", "next");
    }

    @Test
    public void testNextId() {
        EasyMock.expect((Object)this.mockFlowObjectiveService.allocateNextId()).andReturn((Object)10).anyTimes();
        this.prepareService();
        WebTarget wt = this.target();
        String response = (String)wt.path("flowobjectives/next").request().get(String.class);
        JsonObject result = Json.parse((String)response).asObject();
        Assert.assertThat((Object)result, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)result.names(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat(result.names().get(0), (Matcher)Matchers.is((Object)"nextId"));
        int jsonNextId = result.get("nextId").asInt();
        Assert.assertThat((Object)jsonNextId, (Matcher)Matchers.is((Object)10));
    }

    private void prepareService() {
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.mockFlowObjectiveService});
    }

    private void testObjectiveCreation(String jsonFile, String deviceId, String method) {
        WebTarget wt = this.target();
        InputStream jsonStream = FlowsResourceTest.class.getResourceAsStream(jsonFile);
        StringBuilder sb = new StringBuilder();
        sb.append("flowobjectives");
        sb.append("/");
        sb.append(deviceId);
        sb.append("/");
        sb.append(method);
        Response response = wt.path(sb.toString()).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.json((Object)jsonStream));
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)201));
        String location = response.getLocation().getPath();
        Assert.assertThat((Object)location, (Matcher)Matchers.startsWith((String)("/" + sb.toString())));
    }
}

