/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.rest.resources;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.google.common.collect.ImmutableSet;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.easymock.EasyMock;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onlab.osgi.ServiceDirectory;
import org.onlab.osgi.TestServiceDirectory;
import org.onlab.packet.MacAddress;
import org.onosproject.app.ApplicationService;
import org.onosproject.codec.CodecService;
import org.onosproject.codec.impl.CodecManager;
import org.onosproject.core.CoreService;
import org.onosproject.core.GroupId;
import org.onosproject.net.Annotations;
import org.onosproject.net.DefaultDevice;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.NetTestTools;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.FlowEntry;
import org.onosproject.net.flow.FlowEntryAdapter;
import org.onosproject.net.flow.FlowId;
import org.onosproject.net.flow.FlowRule;
import org.onosproject.net.flow.FlowRuleService;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flow.criteria.Criterion;
import org.onosproject.net.flow.instructions.Instruction;
import org.onosproject.rest.resources.ResourceTest;

public class FlowsResourceTest
extends ResourceTest {
    final FlowRuleService mockFlowService = (FlowRuleService)EasyMock.createMock(FlowRuleService.class);
    CoreService mockCoreService = (CoreService)EasyMock.createMock(CoreService.class);
    final HashMap<DeviceId, Set<FlowEntry>> rules = new HashMap();
    final DeviceService mockDeviceService = (DeviceService)EasyMock.createMock(DeviceService.class);
    final DeviceId deviceId1 = DeviceId.deviceId((String)"1");
    final DeviceId deviceId2 = DeviceId.deviceId((String)"2");
    final DeviceId deviceId3 = DeviceId.deviceId((String)"3");
    final Device device1 = new DefaultDevice(null, this.deviceId1, Device.Type.OTHER, "", "", "", "", null, new Annotations[0]);
    final Device device2 = new DefaultDevice(null, this.deviceId2, Device.Type.OTHER, "", "", "", "", null, new Annotations[0]);
    final ApplicationService mockApplicationService = (ApplicationService)EasyMock.createMock(ApplicationService.class);
    final MockFlowEntry flow1 = new MockFlowEntry(this.deviceId1, 1L);
    final MockFlowEntry flow2 = new MockFlowEntry(this.deviceId1, 2L);
    final MockFlowEntry flow3 = new MockFlowEntry(this.deviceId2, 3L);
    final MockFlowEntry flow4 = new MockFlowEntry(this.deviceId2, 4L);
    final MockFlowEntry flow5 = new MockFlowEntry(this.deviceId2, 5L);
    final MockFlowEntry flow6 = new MockFlowEntry(this.deviceId2, 6L);
    final Set<FlowEntry> flowEntries = ImmutableSet.of((Object)((Object)this.flow1), (Object)((Object)this.flow2), (Object)((Object)this.flow3), (Object)((Object)this.flow4), (Object)((Object)this.flow5), (Object)((Object)this.flow6), (Object[])new FlowEntry[0]);

    private void setupMockFlows() {
        this.flow2.treatment = DefaultTrafficTreatment.builder().setEthDst(MacAddress.BROADCAST).build();
        this.flow2.selector = DefaultTrafficSelector.builder().matchEthType((short)3).matchIPProtocol((byte)9).build();
        this.flow4.treatment = DefaultTrafficTreatment.builder().build();
        HashSet<MockFlowEntry> flows1 = new HashSet<MockFlowEntry>();
        flows1.add(this.flow1);
        flows1.add(this.flow2);
        HashSet<MockFlowEntry> flows2 = new HashSet<MockFlowEntry>();
        flows2.add(this.flow3);
        flows2.add(this.flow4);
        this.rules.put(this.deviceId1, flows1);
        this.rules.put(this.deviceId2, flows2);
        EasyMock.expect((Object)this.mockFlowService.getFlowEntries(this.deviceId1)).andReturn(this.rules.get(this.deviceId1)).anyTimes();
        EasyMock.expect((Object)this.mockFlowService.getFlowEntries(this.deviceId2)).andReturn(this.rules.get(this.deviceId2)).anyTimes();
    }

    @Before
    public void setUpTest() {
        EasyMock.expect((Object)this.mockDeviceService.getDevice(this.deviceId1)).andReturn((Object)this.device1);
        EasyMock.expect((Object)this.mockDeviceService.getDevice(this.deviceId2)).andReturn((Object)this.device2);
        EasyMock.expect((Object)this.mockDeviceService.getDevices()).andReturn((Object)ImmutableSet.of((Object)this.device1, (Object)this.device2));
        EasyMock.expect((Object)this.mockCoreService.getAppId(Short.valueOf(EasyMock.anyShort()))).andReturn((Object)NetTestTools.APP_ID).anyTimes();
        EasyMock.expect((Object)this.mockCoreService.getAppId(EasyMock.anyString())).andReturn((Object)NetTestTools.APP_ID).anyTimes();
        EasyMock.expect((Object)this.mockCoreService.registerApplication("org.onosproject.rest")).andReturn((Object)NetTestTools.APP_ID).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.mockCoreService});
        CodecManager codecService = new CodecManager();
        codecService.activate();
        TestServiceDirectory testDirectory = new TestServiceDirectory().add(FlowRuleService.class, (Object)this.mockFlowService).add(DeviceService.class, (Object)this.mockDeviceService).add(CodecService.class, (Object)codecService).add(CoreService.class, (Object)this.mockCoreService).add(ApplicationService.class, (Object)this.mockApplicationService);
        this.setServiceDirectory((ServiceDirectory)testDirectory);
    }

    @After
    public void tearDownTest() {
        EasyMock.verify((Object[])new Object[]{this.mockFlowService});
        EasyMock.verify((Object[])new Object[]{this.mockCoreService});
    }

    private static FlowEntryJsonMatcher matchesFlow(FlowEntry flow, String expectedAppName) {
        return new FlowEntryJsonMatcher(flow, expectedAppName);
    }

    private static FlowEntryJsonArrayMatcher hasFlow(FlowEntry flow) {
        return new FlowEntryJsonArrayMatcher(flow);
    }

    private static FlowRuleJsonMatcher matchesFlowRule(FlowRule flow, String expectedAppName) {
        return new FlowRuleJsonMatcher(flow, expectedAppName);
    }

    private static FlowRuleJsonArrayMatcher hasFlowRule(FlowRule flow) {
        return new FlowRuleJsonArrayMatcher(flow);
    }

    @Test
    public void testFlowsEmptyArray() {
        EasyMock.expect((Object)this.mockFlowService.getFlowEntries(this.deviceId1)).andReturn(null).anyTimes();
        EasyMock.expect((Object)this.mockFlowService.getFlowEntries(this.deviceId2)).andReturn(null).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.mockFlowService});
        EasyMock.replay((Object[])new Object[]{this.mockDeviceService});
        WebTarget wt = this.target();
        String response = (String)wt.path("flows").request().get(String.class);
        Assert.assertThat((Object)response, (Matcher)Matchers.is((Object)"{\"flows\":[]}"));
    }

    @Test
    public void testFlowsPopulatedArray() {
        this.setupMockFlows();
        EasyMock.replay((Object[])new Object[]{this.mockFlowService});
        EasyMock.replay((Object[])new Object[]{this.mockDeviceService});
        WebTarget wt = this.target();
        String response = (String)wt.path("flows").request().get(String.class);
        JsonObject result = Json.parse((String)response).asObject();
        Assert.assertThat((Object)result, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)result.names(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat(result.names().get(0), (Matcher)Matchers.is((Object)"flows"));
        JsonArray jsonFlows = result.get("flows").asArray();
        Assert.assertThat((Object)jsonFlows, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)jsonFlows, (Matcher)FlowsResourceTest.hasFlow((FlowEntry)this.flow1));
        Assert.assertThat((Object)jsonFlows, (Matcher)FlowsResourceTest.hasFlow((FlowEntry)this.flow2));
        Assert.assertThat((Object)jsonFlows, (Matcher)FlowsResourceTest.hasFlow((FlowEntry)this.flow3));
        Assert.assertThat((Object)jsonFlows, (Matcher)FlowsResourceTest.hasFlow((FlowEntry)this.flow4));
    }

    @Test
    public void testFlowsSingleDevice() {
        this.setupMockFlows();
        HashSet<MockFlowEntry> flows = new HashSet<MockFlowEntry>();
        flows.add(this.flow5);
        flows.add(this.flow6);
        EasyMock.expect((Object)this.mockFlowService.getFlowEntries((DeviceId)EasyMock.anyObject())).andReturn(flows).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.mockFlowService});
        EasyMock.replay((Object[])new Object[]{this.mockDeviceService});
        WebTarget wt = this.target();
        String response = (String)wt.path("flows/" + this.deviceId3).request().get(String.class);
        JsonObject result = Json.parse((String)response).asObject();
        Assert.assertThat((Object)result, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)result.names(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat(result.names().get(0), (Matcher)Matchers.is((Object)"flows"));
        JsonArray jsonFlows = result.get("flows").asArray();
        Assert.assertThat((Object)jsonFlows, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)jsonFlows, (Matcher)FlowsResourceTest.hasFlow((FlowEntry)this.flow5));
        Assert.assertThat((Object)jsonFlows, (Matcher)FlowsResourceTest.hasFlow((FlowEntry)this.flow6));
    }

    @Test
    public void testFlowsSingleDeviceWithFlowId() {
        this.setupMockFlows();
        HashSet<MockFlowEntry> flows = new HashSet<MockFlowEntry>();
        flows.add(this.flow5);
        flows.add(this.flow6);
        EasyMock.expect((Object)this.mockFlowService.getFlowEntries((DeviceId)EasyMock.anyObject())).andReturn(flows).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.mockFlowService});
        EasyMock.replay((Object[])new Object[]{this.mockDeviceService});
        WebTarget wt = this.target();
        String response = (String)wt.path("flows/" + this.deviceId3 + "/" + Long.toString(this.flow5.id().value())).request().get(String.class);
        JsonObject result = Json.parse((String)response).asObject();
        Assert.assertThat((Object)result, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)result.names(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat(result.names().get(0), (Matcher)Matchers.is((Object)"flows"));
        JsonArray jsonFlows = result.get("flows").asArray();
        Assert.assertThat((Object)jsonFlows, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)jsonFlows, (Matcher)FlowsResourceTest.hasFlow((FlowEntry)this.flow5));
        Assert.assertThat((Object)jsonFlows, (Matcher)Matchers.not((Matcher)FlowsResourceTest.hasFlow((FlowEntry)this.flow6)));
    }

    @Test
    public void testBadGet() {
        EasyMock.expect((Object)this.mockFlowService.getFlowEntries((DeviceId)EasyMock.anyObject())).andReturn(null).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.mockFlowService});
        EasyMock.replay((Object[])new Object[]{this.mockDeviceService});
        WebTarget wt = this.target();
        try {
            wt.path("flows/0").request().get(String.class);
            Assert.fail((String)"Fetch of non-existent device did not throw an exception");
        }
        catch (NotFoundException ex) {
            Assert.assertThat((Object)ex.getMessage(), (Matcher)Matchers.containsString((String)"HTTP 404 Not Found"));
        }
    }

    @Test
    public void testPostWithoutAppId() {
        this.mockFlowService.applyFlowRules((FlowRule[])EasyMock.anyObject());
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.mockFlowService});
        WebTarget wt = this.target();
        InputStream jsonStream = FlowsResourceTest.class.getResourceAsStream("post-flow.json");
        Response response = wt.path("flows/of:0000000000000001").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.json((Object)jsonStream));
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)201));
        String location = response.getLocation().getPath();
        Assert.assertThat((Object)location, (Matcher)Matchers.startsWith((String)"/flows/of:0000000000000001/"));
    }

    @Test
    public void testPostWithAppId() {
        this.mockFlowService.applyFlowRules((FlowRule[])EasyMock.anyObject());
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.mockFlowService});
        WebTarget wt = this.target();
        InputStream jsonStream = FlowsResourceTest.class.getResourceAsStream("post-flow.json");
        Response response = wt.path("flows/of:0000000000000001").queryParam("appId", new Object[]{"org.onosproject.rest"}).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.json((Object)jsonStream));
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)201));
        String location = response.getLocation().getPath();
        Assert.assertThat((Object)location, (Matcher)Matchers.startsWith((String)"/flows/of:0000000000000001/"));
    }

    @Test
    public void testDelete() {
        this.setupMockFlows();
        this.mockFlowService.removeFlowRules((FlowRule[])EasyMock.anyObject());
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.mockFlowService});
        WebTarget wt = this.target();
        String location = "/flows/1/155";
        Response deleteResponse = wt.path(location).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).delete();
        Assert.assertThat((Object)deleteResponse.getStatus(), (Matcher)Matchers.is((Object)204));
    }

    @Test
    public void testGetFlowByAppId() {
        this.setupMockFlows();
        EasyMock.expect((Object)this.mockApplicationService.getId((String)EasyMock.anyObject())).andReturn((Object)NetTestTools.APP_ID).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.mockApplicationService});
        EasyMock.expect((Object)this.mockFlowService.getFlowEntriesById(NetTestTools.APP_ID)).andReturn(this.flowEntries).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.mockFlowService});
        WebTarget wt = this.target();
        String response = (String)wt.path("/flows/application/1").request().get(String.class);
        JsonObject result = Json.parse((String)response).asObject();
        Assert.assertThat((Object)result, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)result.names(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat(result.names().get(0), (Matcher)Matchers.is((Object)"flows"));
        JsonArray jsonFlows = result.get("flows").asArray();
        Assert.assertThat((Object)jsonFlows, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)jsonFlows, (Matcher)FlowsResourceTest.hasFlowRule((FlowRule)this.flow1));
        Assert.assertThat((Object)jsonFlows, (Matcher)FlowsResourceTest.hasFlowRule((FlowRule)this.flow2));
        Assert.assertThat((Object)jsonFlows, (Matcher)FlowsResourceTest.hasFlowRule((FlowRule)this.flow3));
        Assert.assertThat((Object)jsonFlows, (Matcher)FlowsResourceTest.hasFlowRule((FlowRule)this.flow4));
    }

    @Test
    public void testRemoveFlowByAppId() {
        EasyMock.expect((Object)this.mockApplicationService.getId((String)EasyMock.anyObject())).andReturn((Object)NetTestTools.APP_ID).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.mockApplicationService});
        this.mockFlowService.removeFlowRulesById(NetTestTools.APP_ID);
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.mockFlowService});
        WebTarget wt = this.target();
        String location = "/flows/application/1";
        Response deleteResponse = wt.path(location).request().delete();
        Assert.assertThat((Object)deleteResponse.getStatus(), (Matcher)Matchers.is((Object)204));
    }

    public static class FlowRuleJsonArrayMatcher
    extends TypeSafeMatcher<JsonArray> {
        private final FlowRule flow;
        private String reason = "";

        public FlowRuleJsonArrayMatcher(FlowRule flowValue) {
            this.flow = flowValue;
        }

        public boolean matchesSafely(JsonArray json) {
            boolean flowFound = false;
            for (int jsonFlowIndex = 0; jsonFlowIndex < json.size(); ++jsonFlowIndex) {
                JsonObject jsonFlow = json.get(jsonFlowIndex).asObject();
                String flowId = Long.toString(this.flow.id().value());
                String jsonFlowId = jsonFlow.get("id").asString();
                if (!jsonFlowId.equals(flowId)) continue;
                flowFound = true;
                Assert.assertThat((Object)jsonFlow, (Matcher)FlowsResourceTest.matchesFlowRule(this.flow, NetTestTools.APP_ID.name()));
            }
            if (!flowFound) {
                this.reason = "Flow with id " + this.flow.id().toString() + " not found";
                return false;
            }
            return true;
        }

        public void describeTo(Description description) {
            description.appendText(this.reason);
        }
    }

    public static class FlowRuleJsonMatcher
    extends TypeSafeMatcher<JsonObject> {
        private final FlowRule flow;
        private final String expectedAppId;
        private String reason = "";

        public FlowRuleJsonMatcher(FlowRule flowValue, String expectedAppIdValue) {
            this.flow = flowValue;
            this.expectedAppId = expectedAppIdValue;
        }

        public boolean matchesSafely(JsonObject jsonFlow) {
            String jsonType;
            JsonObject jsonTreatment;
            String flowId;
            String jsonId = jsonFlow.get("id").asString();
            if (!jsonId.equals(flowId = Long.toString(this.flow.id().value()))) {
                this.reason = "id " + this.flow.id().toString();
                return false;
            }
            String jsonAppId = jsonFlow.get("appId").asString();
            if (!jsonAppId.equals(this.expectedAppId)) {
                this.reason = "appId " + Short.toString(this.flow.appId());
                return false;
            }
            String jsonDeviceId = jsonFlow.get("deviceId").asString();
            if (!jsonDeviceId.equals(this.flow.deviceId().toString())) {
                this.reason = "deviceId " + this.flow.deviceId();
                return false;
            }
            if (this.flow.treatment() != null) {
                jsonTreatment = jsonFlow.get("treatment").asObject();
                JsonArray jsonInstructions = jsonTreatment.get("instructions").asArray();
                if (this.flow.treatment().immediate().size() != jsonInstructions.size()) {
                    this.reason = "instructions array size of " + Integer.toString(this.flow.treatment().immediate().size());
                    return false;
                }
                for (Instruction instruction : this.flow.treatment().immediate()) {
                    boolean instructionFound = false;
                    for (int instructionIndex = 0; instructionIndex < jsonInstructions.size(); ++instructionIndex) {
                        String instructionType;
                        jsonType = jsonInstructions.get(instructionIndex).asObject().get("type").asString();
                        if (!jsonType.equals(instructionType = instruction.type().name())) continue;
                        instructionFound = true;
                    }
                    if (instructionFound) continue;
                    this.reason = "instruction " + instruction.toString();
                    return false;
                }
            }
            if (this.flow.selector() != null) {
                jsonTreatment = jsonFlow.get("selector").asObject();
                JsonArray jsonCriteria = jsonTreatment.get("criteria").asArray();
                if (this.flow.selector().criteria().size() != jsonCriteria.size()) {
                    this.reason = "criteria array size of " + Integer.toString(this.flow.selector().criteria().size());
                    return false;
                }
                for (Criterion criterion : this.flow.selector().criteria()) {
                    boolean criterionFound = false;
                    for (int criterionIndex = 0; criterionIndex < jsonCriteria.size(); ++criterionIndex) {
                        String criterionType;
                        jsonType = jsonCriteria.get(criterionIndex).asObject().get("type").asString();
                        if (!jsonType.equals(criterionType = criterion.type().name())) continue;
                        criterionFound = true;
                    }
                    if (criterionFound) continue;
                    this.reason = "criterion " + criterion.toString();
                    return false;
                }
            }
            return true;
        }

        public void describeTo(Description description) {
            description.appendText(this.reason);
        }
    }

    public static class FlowEntryJsonArrayMatcher
    extends TypeSafeMatcher<JsonArray> {
        private final FlowEntry flow;
        private String reason = "";

        public FlowEntryJsonArrayMatcher(FlowEntry flowValue) {
            this.flow = flowValue;
        }

        public boolean matchesSafely(JsonArray json) {
            boolean flowFound = false;
            for (int jsonFlowIndex = 0; jsonFlowIndex < json.size(); ++jsonFlowIndex) {
                JsonObject jsonFlow = json.get(jsonFlowIndex).asObject();
                String flowId = Long.toString(this.flow.id().value());
                String jsonFlowId = jsonFlow.get("id").asString();
                if (!jsonFlowId.equals(flowId)) continue;
                flowFound = true;
                Assert.assertThat((Object)jsonFlow, (Matcher)FlowsResourceTest.matchesFlow(this.flow, NetTestTools.APP_ID.name()));
            }
            if (!flowFound) {
                this.reason = "Flow with id " + this.flow.id().toString() + " not found";
                return false;
            }
            return true;
        }

        public void describeTo(Description description) {
            description.appendText(this.reason);
        }
    }

    public static class FlowEntryJsonMatcher
    extends TypeSafeMatcher<JsonObject> {
        private final FlowEntry flow;
        private final String expectedAppId;
        private String reason = "";

        public FlowEntryJsonMatcher(FlowEntry flowValue, String expectedAppIdValue) {
            this.flow = flowValue;
            this.expectedAppId = expectedAppIdValue;
        }

        public boolean matchesSafely(JsonObject jsonFlow) {
            String jsonType;
            JsonObject jsonTreatment;
            String flowId;
            String jsonId = jsonFlow.get("id").asString();
            if (!jsonId.equals(flowId = Long.toString(this.flow.id().value()))) {
                this.reason = "id " + this.flow.id().toString();
                return false;
            }
            String jsonAppId = jsonFlow.get("appId").asString();
            if (!jsonAppId.equals(this.expectedAppId)) {
                this.reason = "appId " + Short.toString(this.flow.appId());
                return false;
            }
            String jsonDeviceId = jsonFlow.get("deviceId").asString();
            if (!jsonDeviceId.equals(this.flow.deviceId().toString())) {
                this.reason = "deviceId " + this.flow.deviceId();
                return false;
            }
            if (this.flow.treatment() != null) {
                jsonTreatment = jsonFlow.get("treatment").asObject();
                JsonArray jsonInstructions = jsonTreatment.get("instructions").asArray();
                if (this.flow.treatment().immediate().size() != jsonInstructions.size()) {
                    this.reason = "instructions array size of " + Integer.toString(this.flow.treatment().immediate().size());
                    return false;
                }
                for (Instruction instruction : this.flow.treatment().immediate()) {
                    boolean instructionFound = false;
                    for (int instructionIndex = 0; instructionIndex < jsonInstructions.size(); ++instructionIndex) {
                        String instructionType;
                        jsonType = jsonInstructions.get(instructionIndex).asObject().get("type").asString();
                        if (!jsonType.equals(instructionType = instruction.type().name())) continue;
                        instructionFound = true;
                    }
                    if (instructionFound) continue;
                    this.reason = "instruction " + instruction.toString();
                    return false;
                }
            }
            if (this.flow.selector() != null) {
                jsonTreatment = jsonFlow.get("selector").asObject();
                JsonArray jsonCriteria = jsonTreatment.get("criteria").asArray();
                if (this.flow.selector().criteria().size() != jsonCriteria.size()) {
                    this.reason = "criteria array size of " + Integer.toString(this.flow.selector().criteria().size());
                    return false;
                }
                for (Criterion criterion : this.flow.selector().criteria()) {
                    boolean criterionFound = false;
                    for (int criterionIndex = 0; criterionIndex < jsonCriteria.size(); ++criterionIndex) {
                        String criterionType;
                        jsonType = jsonCriteria.get(criterionIndex).asObject().get("type").asString();
                        if (!jsonType.equals(criterionType = criterion.type().name())) continue;
                        criterionFound = true;
                    }
                    if (criterionFound) continue;
                    this.reason = "criterion " + criterion.toString();
                    return false;
                }
            }
            return true;
        }

        public void describeTo(Description description) {
            description.appendText(this.reason);
        }
    }

    private static class MockFlowEntry
    extends FlowEntryAdapter {
        final DeviceId deviceId;
        final long baseValue;
        TrafficTreatment treatment;
        TrafficSelector selector;

        public MockFlowEntry(DeviceId deviceId, long id) {
            this.deviceId = deviceId;
            this.baseValue = id * 100L;
        }

        public FlowEntry.FlowEntryState state() {
            return FlowEntry.FlowEntryState.ADDED;
        }

        public long life() {
            return this.life(TimeUnit.SECONDS);
        }

        public long life(TimeUnit timeUnit) {
            return TimeUnit.SECONDS.convert(this.baseValue + 11L, timeUnit);
        }

        public FlowEntry.FlowLiveType liveType() {
            return FlowEntry.FlowLiveType.IMMEDIATE;
        }

        public long packets() {
            return this.baseValue + 22L;
        }

        public long bytes() {
            return this.baseValue + 33L;
        }

        public long lastSeen() {
            return this.baseValue + 44L;
        }

        public FlowId id() {
            long id = this.baseValue + 55L;
            return FlowId.valueOf((long)id);
        }

        public GroupId groupId() {
            return new GroupId(3);
        }

        public short appId() {
            return 2;
        }

        public int priority() {
            return (int)(this.baseValue + 66L);
        }

        public DeviceId deviceId() {
            return this.deviceId;
        }

        public TrafficSelector selector() {
            return this.selector;
        }

        public TrafficTreatment treatment() {
            return this.treatment;
        }

        public int timeout() {
            return (int)(this.baseValue + 77L);
        }

        public FlowRule.FlowRemoveReason reason() {
            return FlowRule.FlowRemoveReason.NO_REASON;
        }
    }
}

