/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.rest.resources;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.easymock.EasyMock;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onlab.osgi.ServiceDirectory;
import org.onlab.osgi.TestServiceDirectory;
import org.onosproject.codec.CodecService;
import org.onosproject.codec.impl.CodecManager;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.core.DefaultApplicationId;
import org.onosproject.core.GroupId;
import org.onosproject.net.Annotations;
import org.onosproject.net.DefaultDevice;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.NetTestTools;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.group.DefaultGroupKey;
import org.onosproject.net.group.Group;
import org.onosproject.net.group.GroupBucket;
import org.onosproject.net.group.GroupBuckets;
import org.onosproject.net.group.GroupDescription;
import org.onosproject.net.group.GroupKey;
import org.onosproject.net.group.GroupService;
import org.onosproject.net.group.GroupServiceAdapter;
import org.onosproject.rest.resources.ResourceTest;

public class GroupsResourceTest
extends ResourceTest {
    final GroupService mockGroupService = (GroupService)EasyMock.createMock(GroupService.class);
    CoreService mockCoreService = (CoreService)EasyMock.createMock(CoreService.class);
    final DeviceService mockDeviceService = (DeviceService)EasyMock.createMock(DeviceService.class);
    final HashMap<DeviceId, Set<Group>> groups = new HashMap();
    final DeviceId deviceId1 = DeviceId.deviceId((String)"1");
    final DeviceId deviceId2 = DeviceId.deviceId((String)"2");
    final DeviceId deviceId3 = DeviceId.deviceId((String)"3");
    final Device device1 = new DefaultDevice(null, this.deviceId1, Device.Type.OTHER, "", "", "", "", null, new Annotations[0]);
    final Device device2 = new DefaultDevice(null, this.deviceId2, Device.Type.OTHER, "", "", "", "", null, new Annotations[0]);
    final MockGroup group1 = new MockGroup(this.deviceId1, 1, "0x111", 1);
    final MockGroup group2 = new MockGroup(this.deviceId1, 2, "0x222", 2);
    final MockGroup group3 = new MockGroup(this.deviceId2, 3, "0x333", 3);
    final MockGroup group4 = new MockGroup(this.deviceId2, 4, "0x444", 4);
    final MockGroup group5 = new MockGroup(this.deviceId3, 5, "0x555", 5);
    final MockGroup group6 = new MockGroup(this.deviceId3, 6, "0x666", 6);

    private void setupMockGroups() {
        HashSet<MockGroup> groups1 = new HashSet<MockGroup>();
        groups1.add(this.group1);
        groups1.add(this.group2);
        HashSet<MockGroup> groups2 = new HashSet<MockGroup>();
        groups2.add(this.group3);
        groups2.add(this.group4);
        this.groups.put(this.deviceId1, groups1);
        this.groups.put(this.deviceId2, groups2);
        EasyMock.expect((Object)this.mockGroupService.getGroups(this.deviceId1)).andReturn(this.groups.get(this.deviceId1)).anyTimes();
        EasyMock.expect((Object)this.mockGroupService.getGroups(this.deviceId2)).andReturn(this.groups.get(this.deviceId2)).anyTimes();
    }

    @Before
    public void setUpTest() {
        EasyMock.expect((Object)this.mockDeviceService.getDevice(this.deviceId1)).andReturn((Object)this.device1);
        EasyMock.expect((Object)this.mockDeviceService.getDevice(this.deviceId2)).andReturn((Object)this.device2);
        EasyMock.expect((Object)this.mockDeviceService.getDevices()).andReturn((Object)ImmutableSet.of((Object)this.device1, (Object)this.device2));
        EasyMock.expect((Object)this.mockCoreService.getAppId(Short.valueOf(EasyMock.anyShort()))).andReturn((Object)NetTestTools.APP_ID).anyTimes();
        EasyMock.expect((Object)this.mockCoreService.registerApplication("org.onosproject.rest")).andReturn((Object)NetTestTools.APP_ID).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.mockCoreService});
        CodecManager codecService = new CodecManager();
        codecService.activate();
        TestServiceDirectory testDirectory = new TestServiceDirectory().add(GroupService.class, (Object)this.mockGroupService).add(DeviceService.class, (Object)this.mockDeviceService).add(CodecService.class, (Object)codecService).add(CoreService.class, (Object)this.mockCoreService);
        this.setServiceDirectory((ServiceDirectory)testDirectory);
    }

    @After
    public void tearDownTest() {
        EasyMock.verify((Object[])new Object[]{this.mockGroupService});
        EasyMock.verify((Object[])new Object[]{this.mockCoreService});
    }

    private static GroupJsonMatcher matchesGroup(Group group, String expectedAppName) {
        return new GroupJsonMatcher(group, expectedAppName);
    }

    private static GroupJsonArrayMatcher hasGroup(Group group) {
        return new GroupJsonArrayMatcher(group);
    }

    @Test
    public void testGroupsEmptyArray() {
        EasyMock.expect((Object)this.mockGroupService.getGroups(this.deviceId1)).andReturn(null).anyTimes();
        EasyMock.expect((Object)this.mockGroupService.getGroups(this.deviceId2)).andReturn(null).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.mockGroupService});
        EasyMock.replay((Object[])new Object[]{this.mockDeviceService});
        WebTarget wt = this.target();
        String response = (String)wt.path("groups").request().get(String.class);
        Assert.assertThat((Object)response, (Matcher)Matchers.is((Object)"{\"groups\":[]}"));
    }

    @Test
    public void testGroupsPopulatedArray() {
        this.setupMockGroups();
        EasyMock.replay((Object[])new Object[]{this.mockGroupService});
        EasyMock.replay((Object[])new Object[]{this.mockDeviceService});
        WebTarget wt = this.target();
        String response = (String)wt.path("groups").request().get(String.class);
        JsonObject result = Json.parse((String)response).asObject();
        Assert.assertThat((Object)result, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)result.names(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat(result.names().get(0), (Matcher)Matchers.is((Object)"groups"));
        JsonArray jsonGroups = result.get("groups").asArray();
        Assert.assertThat((Object)jsonGroups, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)jsonGroups, (Matcher)GroupsResourceTest.hasGroup(this.group1));
        Assert.assertThat((Object)jsonGroups, (Matcher)GroupsResourceTest.hasGroup(this.group2));
        Assert.assertThat((Object)jsonGroups, (Matcher)GroupsResourceTest.hasGroup(this.group3));
        Assert.assertThat((Object)jsonGroups, (Matcher)GroupsResourceTest.hasGroup(this.group4));
    }

    @Test
    public void testGroupsSingleDevice() {
        this.setupMockGroups();
        HashSet<MockGroup> groups = new HashSet<MockGroup>();
        groups.add(this.group5);
        groups.add(this.group6);
        EasyMock.expect((Object)this.mockGroupService.getGroups((DeviceId)EasyMock.anyObject())).andReturn(groups).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.mockGroupService});
        EasyMock.replay((Object[])new Object[]{this.mockDeviceService});
        WebTarget wt = this.target();
        String response = (String)wt.path("groups/" + this.deviceId3).request().get(String.class);
        JsonObject result = Json.parse((String)response).asObject();
        Assert.assertThat((Object)result, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)result.names(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat(result.names().get(0), (Matcher)Matchers.is((Object)"groups"));
        JsonArray jsonGroups = result.get("groups").asArray();
        Assert.assertThat((Object)jsonGroups, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)jsonGroups, (Matcher)GroupsResourceTest.hasGroup(this.group5));
        Assert.assertThat((Object)jsonGroups, (Matcher)GroupsResourceTest.hasGroup(this.group6));
    }

    @Test
    public void testGroupByDeviceIdAndAppCookie() {
        this.setupMockGroups();
        EasyMock.expect((Object)this.mockGroupService.getGroup((DeviceId)EasyMock.anyObject(), (GroupKey)EasyMock.anyObject())).andReturn((Object)this.group5).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.mockGroupService});
        WebTarget wt = this.target();
        String response = (String)wt.path("groups/" + this.deviceId3 + "/0x111").request().get(String.class);
        JsonObject result = Json.parse((String)response).asObject();
        Assert.assertThat((Object)result, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)result.names(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat(result.names().get(0), (Matcher)Matchers.is((Object)"groups"));
        JsonArray jsonFlows = result.get("groups").asArray();
        Assert.assertThat((Object)jsonFlows, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)jsonFlows, (Matcher)GroupsResourceTest.hasGroup(this.group5));
    }

    @Test
    public void testGroupByDeviceIdAndAppCookieNull() {
        this.setupMockGroups();
        EasyMock.expect((Object)this.mockGroupService.getGroup((DeviceId)EasyMock.anyObject(), (GroupKey)EasyMock.anyObject())).andReturn(null).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.mockGroupService});
        WebTarget wt = this.target();
        Response response = wt.path("groups/" + this.deviceId3 + "/0x222").request().get();
        Assert.assertEquals((long)404L, (long)response.getStatus());
    }

    @Test
    public void testPost() {
        this.mockGroupService.addGroup((GroupDescription)EasyMock.anyObject());
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.mockGroupService});
        WebTarget wt = this.target();
        InputStream jsonStream = GroupsResourceTest.class.getResourceAsStream("post-group.json");
        Response response = wt.path("groups/of:0000000000000001").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.json((Object)jsonStream));
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)201));
        String location = response.getLocation().getPath();
        Assert.assertThat((Object)location, (Matcher)Matchers.startsWith((String)"/groups/of:0000000000000001/"));
    }

    @Test
    public void testDelete() {
        this.setupMockGroups();
        this.mockGroupService.removeGroup((DeviceId)EasyMock.anyObject(), (GroupKey)EasyMock.anyObject(), (ApplicationId)EasyMock.anyObject());
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.mockGroupService});
        WebTarget wt = this.target();
        String location = "/groups/1/0x111";
        Response deleteResponse = wt.path(location).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).delete();
        Assert.assertThat((Object)deleteResponse.getStatus(), (Matcher)Matchers.is((Object)204));
    }

    private JsonArray fetchAndCheckBuckets(DeviceId deviceId, int expectedBucketCount) {
        WebTarget wt = this.target();
        String fetchGroupPath = (String)wt.path("groups/" + deviceId).request().get(String.class);
        JsonObject result = Json.parse((String)fetchGroupPath).asObject();
        Assert.assertThat((Object)result, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)result.names(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat(result.names().get(0), (Matcher)Matchers.is((Object)"groups"));
        JsonArray jsonGroups = result.get("groups").asArray();
        Assert.assertThat((Object)jsonGroups, (Matcher)Matchers.notNullValue());
        JsonObject group = jsonGroups.get(0).asObject();
        JsonArray buckets = group.get("buckets").asArray();
        Assert.assertThat((Object)buckets.size(), (Matcher)Matchers.is((Object)expectedBucketCount));
        return buckets;
    }

    private void removeBucketsViaRest(String endpointPath) {
        WebTarget wt = this.target();
        Response removeResponse = wt.path(endpointPath).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).delete();
        Assert.assertThat((Object)removeResponse.getStatus(), (Matcher)Matchers.is((Object)204));
    }

    @Test
    public void testAddRemoveBucket() {
        String deviceIdBasePath = "groups/%s/";
        String endpointBasePath = deviceIdBasePath + "%s/buckets/";
        TestGroupService groupService = new TestGroupService();
        EasyMock.expect((Object)this.mockGroupService.getGroup((DeviceId)EasyMock.anyObject(), (GroupKey)EasyMock.anyObject())).andDelegateTo((Object)groupService).anyTimes();
        EasyMock.expect((Object)this.mockGroupService.getGroups((DeviceId)EasyMock.anyObject())).andDelegateTo((Object)groupService).anyTimes();
        this.mockGroupService.addBucketsToGroup((DeviceId)EasyMock.anyObject(), (GroupKey)EasyMock.anyObject(), (GroupBuckets)EasyMock.anyObject(), (GroupKey)EasyMock.anyObject(), (ApplicationId)EasyMock.anyObject());
        EasyMock.expectLastCall().andDelegateTo((Object)groupService).anyTimes();
        this.mockGroupService.removeBucketsFromGroup((DeviceId)EasyMock.anyObject(), (GroupKey)EasyMock.anyObject(), (GroupBuckets)EasyMock.anyObject(), (GroupKey)EasyMock.anyObject(), (ApplicationId)EasyMock.anyObject());
        EasyMock.expectLastCall().andDelegateTo((Object)groupService).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.mockGroupService});
        WebTarget wt = this.target();
        String addEndpointPath = String.format(endpointBasePath, this.group1.deviceId(), this.group1.appCookie());
        InputStream addJsonStream = GroupsResourceTest.class.getResourceAsStream("post-group-add-buckets.json");
        Response addResponse = wt.path(addEndpointPath).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.json((Object)addJsonStream));
        Assert.assertThat((Object)addResponse.getStatus(), (Matcher)Matchers.is((Object)204));
        JsonArray bucketsAfterAdd = this.fetchAndCheckBuckets(this.deviceId1, 4);
        String bucketId1 = Long.toString(bucketsAfterAdd.get(0).asObject().get("bucketId").asLong());
        String bucketId2 = Long.toString(bucketsAfterAdd.get(1).asObject().get("bucketId").asLong());
        String bucketId3 = Long.toString(bucketsAfterAdd.get(2).asObject().get("bucketId").asLong());
        String bucketId4 = Long.toString(bucketsAfterAdd.get(3).asObject().get("bucketId").asLong());
        String removeEndpointPath = addEndpointPath + bucketId1;
        this.removeBucketsViaRest(removeEndpointPath);
        this.fetchAndCheckBuckets(this.deviceId1, 3);
        String removeTwoEndpointPath = addEndpointPath + bucketId2 + ',' + bucketId3;
        this.removeBucketsViaRest(removeTwoEndpointPath);
        this.fetchAndCheckBuckets(this.deviceId1, 1);
        String removeNothingEndpointPath = addEndpointPath + "no-such-bucket";
        this.removeBucketsViaRest(removeNothingEndpointPath);
        this.fetchAndCheckBuckets(this.deviceId1, 1);
        String lastOneEndpointPath = addEndpointPath + bucketId4;
        this.removeBucketsViaRest(lastOneEndpointPath);
        this.fetchAndCheckBuckets(this.deviceId1, 0);
    }

    class TestGroupService
    extends GroupServiceAdapter {
        TestGroupService() {
        }

        public void addBucketsToGroup(DeviceId deviceId, GroupKey oldCookie, GroupBuckets buckets, GroupKey newCookie, ApplicationId appId) {
            GroupsResourceTest.this.group1.buckets = buckets;
        }

        public void removeBucketsFromGroup(DeviceId deviceId, GroupKey oldCookie, GroupBuckets buckets, GroupKey newCookie, ApplicationId appId) {
            if (!GroupsResourceTest.this.group1.buckets.buckets().isEmpty()) {
                ArrayList newList = new ArrayList(GroupsResourceTest.this.group1.buckets.buckets());
                for (GroupBucket bucketToRemove : buckets.buckets()) {
                    for (GroupBucket bucketToCheck : GroupsResourceTest.this.group1.buckets.buckets()) {
                        if (!bucketToCheck.equals(bucketToRemove)) continue;
                        newList.remove(bucketToCheck);
                    }
                }
                GroupsResourceTest.this.group1.buckets = new GroupBuckets(newList);
            }
        }

        public Group getGroup(DeviceId deviceId, GroupKey appCookie) {
            return GroupsResourceTest.this.group1;
        }

        public Iterable<Group> getGroups(DeviceId deviceId) {
            return ImmutableList.of((Object)GroupsResourceTest.this.group1);
        }
    }

    public static class GroupJsonArrayMatcher
    extends TypeSafeMatcher<JsonArray> {
        private final Group group;
        private String reason = "";

        public GroupJsonArrayMatcher(Group groupValue) {
            this.group = groupValue;
        }

        public boolean matchesSafely(JsonArray json) {
            boolean groupFound = false;
            for (int jsonGroupIndex = 0; jsonGroupIndex < json.size(); ++jsonGroupIndex) {
                JsonObject jsonGroup = json.get(jsonGroupIndex).asObject();
                String groupId = ((Integer)this.group.id().id()).toString();
                String jsonGroupId = jsonGroup.get("id").asString();
                if (!jsonGroupId.equals(groupId)) continue;
                groupFound = true;
                Assert.assertThat((Object)jsonGroup, (Matcher)GroupsResourceTest.matchesGroup(this.group, NetTestTools.APP_ID.name()));
            }
            if (!groupFound) {
                this.reason = "Group with id " + ((Integer)this.group.id().id()).toString() + " not found";
                return false;
            }
            return true;
        }

        public void describeTo(Description description) {
            description.appendText(this.reason);
        }
    }

    public static class GroupJsonMatcher
    extends TypeSafeMatcher<JsonObject> {
        private final Group group;
        private final String expectedAppId;
        private String reason = "";

        public GroupJsonMatcher(Group groupValue, String expectedAppIdValue) {
            this.group = groupValue;
            this.expectedAppId = expectedAppIdValue;
        }

        public boolean matchesSafely(JsonObject jsonGroup) {
            String appId;
            String groupId;
            String jsonId = jsonGroup.get("id").asString();
            if (!jsonId.equals(groupId = ((Integer)this.group.id().id()).toString())) {
                this.reason = "id " + ((Integer)this.group.id().id()).toString();
                return false;
            }
            String jsonAppId = jsonGroup.get("appId").asString();
            if (!jsonAppId.equals(appId = this.group.appId().name())) {
                this.reason = "appId " + this.group.appId().name();
                return false;
            }
            String jsonDeviceId = jsonGroup.get("deviceId").asString();
            if (!jsonDeviceId.equals(this.group.deviceId().toString())) {
                this.reason = "deviceId " + this.group.deviceId();
                return false;
            }
            if (this.group.buckets().buckets() != null) {
                JsonArray jsonBuckets = jsonGroup.get("buckets").asArray();
                if (this.group.buckets().buckets().size() != jsonBuckets.size()) {
                    this.reason = "buckets array size of " + Integer.toString(this.group.buckets().buckets().size());
                    return false;
                }
                for (GroupBucket groupBucket : this.group.buckets().buckets()) {
                    boolean groupBucketFound = false;
                    for (int groupBucketIndex = 0; groupBucketIndex < jsonBuckets.size(); ++groupBucketIndex) {
                        String bucketType;
                        String jsonType = jsonBuckets.get(groupBucketIndex).asObject().get("type").asString();
                        if (!jsonType.equals(bucketType = groupBucket.type().name())) continue;
                        groupBucketFound = true;
                    }
                    if (groupBucketFound) continue;
                    this.reason = "group bucket " + groupBucket.toString();
                    return false;
                }
            }
            return true;
        }

        public void describeTo(Description description) {
            description.appendText(this.reason);
        }
    }

    private static class MockGroup
    implements Group {
        final DeviceId deviceId;
        final ApplicationId appId;
        final GroupKey appCookie;
        final long baseValue;
        final List<GroupBucket> bucketList;
        GroupBuckets buckets;

        public MockGroup(DeviceId deviceId, int appId, String appCookie, int id) {
            this.deviceId = deviceId;
            this.appId = new DefaultApplicationId(appId, String.valueOf(appId));
            this.appCookie = new DefaultGroupKey(appCookie.getBytes());
            this.baseValue = (long)id * 100L;
            this.bucketList = new ArrayList<GroupBucket>();
            this.buckets = new GroupBuckets(this.bucketList);
        }

        public GroupId id() {
            return new GroupId((int)this.baseValue + 55);
        }

        public Group.GroupState state() {
            return Group.GroupState.ADDED;
        }

        public long life() {
            return this.baseValue + 11L;
        }

        public long packets() {
            return this.baseValue + 22L;
        }

        public long bytes() {
            return this.baseValue + 33L;
        }

        public long referenceCount() {
            return this.baseValue + 44L;
        }

        public int age() {
            return 0;
        }

        public GroupDescription.Type type() {
            return GroupDescription.Type.ALL;
        }

        public DeviceId deviceId() {
            return this.deviceId;
        }

        public ApplicationId appId() {
            return this.appId;
        }

        public GroupKey appCookie() {
            return this.appCookie;
        }

        public Integer givenGroupId() {
            return (int)this.baseValue + 55;
        }

        public GroupBuckets buckets() {
            return this.buckets;
        }
    }
}

