/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.rest.resources;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import com.google.common.collect.ImmutableSet;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.easymock.EasyMock;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onlab.osgi.ServiceDirectory;
import org.onlab.osgi.TestServiceDirectory;
import org.onlab.packet.IpAddress;
import org.onlab.packet.MacAddress;
import org.onlab.packet.VlanId;
import org.onosproject.codec.CodecService;
import org.onosproject.codec.impl.CodecManager;
import org.onosproject.net.Annotations;
import org.onosproject.net.DefaultHost;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Host;
import org.onosproject.net.HostId;
import org.onosproject.net.HostLocation;
import org.onosproject.net.PortNumber;
import org.onosproject.net.host.HostAdminService;
import org.onosproject.net.host.HostDescription;
import org.onosproject.net.host.HostProviderRegistry;
import org.onosproject.net.host.HostProviderService;
import org.onosproject.net.host.HostService;
import org.onosproject.net.provider.Provider;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.rest.resources.ResourceTest;

public class HostResourceTest
extends ResourceTest {
    final HostAdminService mockHostService = (HostAdminService)EasyMock.createMock(HostAdminService.class);
    final HostProviderRegistry mockHostProviderRegistry = (HostProviderRegistry)EasyMock.createMock(HostProviderRegistry.class);
    final HostProviderService mockHostProviderService = (HostProviderService)EasyMock.createMock(HostProviderService.class);
    final HashSet<Host> hosts = new HashSet();

    @Before
    public void setUpTest() {
        EasyMock.expect((Object)this.mockHostService.getHosts()).andReturn(this.hosts).anyTimes();
        CodecManager codecService = new CodecManager();
        codecService.activate();
        TestServiceDirectory testDirectory = new TestServiceDirectory().add(HostService.class, (Object)this.mockHostService).add(HostAdminService.class, (Object)this.mockHostService).add(CodecService.class, (Object)codecService).add(HostProviderRegistry.class, (Object)this.mockHostProviderRegistry);
        this.setServiceDirectory((ServiceDirectory)testDirectory);
    }

    @After
    public void tearDownTest() {
        EasyMock.verify((Object[])new Object[]{this.mockHostService});
    }

    private static HostJsonMatcher matchesHost(Host host) {
        return new HostJsonMatcher(host);
    }

    private static HostJsonArrayMatcher hasHost(Host host) {
        return new HostJsonArrayMatcher(host);
    }

    @Test
    public void testHostsEmptyArray() {
        EasyMock.replay((Object[])new Object[]{this.mockHostService});
        WebTarget wt = this.target();
        String response = (String)wt.path("hosts").request().get(String.class);
        Assert.assertThat((Object)response, (Matcher)Matchers.is((Object)"{\"hosts\":[]}"));
    }

    @Test
    public void testHostsArray() {
        EasyMock.replay((Object[])new Object[]{this.mockHostService});
        ProviderId pid = new ProviderId("of", "foo");
        MacAddress mac1 = MacAddress.valueOf((String)"00:00:11:00:00:01");
        ImmutableSet ips1 = ImmutableSet.of((Object)IpAddress.valueOf((String)"1111:1111:1111:1::"));
        DefaultHost host1 = new DefaultHost(pid, HostId.hostId((MacAddress)mac1), MacAddress.valueOf((long)1L), VlanId.vlanId((short)1), new HostLocation(DeviceId.deviceId((String)"1"), PortNumber.portNumber((long)11L), 1L), (Set)ips1, new Annotations[0]);
        MacAddress mac2 = MacAddress.valueOf((String)"00:00:11:00:00:02");
        ImmutableSet ips2 = ImmutableSet.of((Object)IpAddress.valueOf((String)"2222:2222:2222:1::"), (Object)IpAddress.valueOf((String)"2222:2222:2222:2::"));
        DefaultHost host2 = new DefaultHost(pid, HostId.hostId((MacAddress)mac2), MacAddress.valueOf((long)2L), VlanId.vlanId((short)2), new HostLocation(DeviceId.deviceId((String)"2"), PortNumber.portNumber((long)22L), 2L), (Set)ips2, new Annotations[0]);
        this.hosts.add((Host)host1);
        this.hosts.add((Host)host2);
        WebTarget wt = this.target();
        String response = (String)wt.path("hosts").request().get(String.class);
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"{\"hosts\":["));
        JsonObject result = Json.parse((String)response).asObject();
        Assert.assertThat((Object)result, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)result.names(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat(result.names().get(0), (Matcher)Matchers.is((Object)"hosts"));
        JsonArray hosts = result.get("hosts").asArray();
        Assert.assertThat((Object)hosts, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)hosts, (Matcher)HostResourceTest.hasHost((Host)host1));
        Assert.assertThat((Object)hosts, (Matcher)HostResourceTest.hasHost((Host)host2));
    }

    @Test
    public void testSingleHostByIdFetch() {
        ProviderId pid = new ProviderId("of", "foo");
        MacAddress mac1 = MacAddress.valueOf((String)"00:00:11:00:00:01");
        ImmutableSet ips1 = ImmutableSet.of((Object)IpAddress.valueOf((String)"1111:1111:1111:1::"));
        DefaultHost host1 = new DefaultHost(pid, HostId.hostId((MacAddress)mac1), MacAddress.valueOf((long)1L), VlanId.vlanId((short)1), new HostLocation(DeviceId.deviceId((String)"1"), PortNumber.portNumber((long)11L), 1L), (Set)ips1, new Annotations[0]);
        this.hosts.add((Host)host1);
        EasyMock.expect((Object)this.mockHostService.getHost(HostId.hostId((String)"00:00:11:00:00:01/1"))).andReturn((Object)host1).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.mockHostService});
        WebTarget wt = this.target();
        String response = (String)wt.path("hosts/00:00:11:00:00:01%2F1").request().get(String.class);
        JsonObject result = Json.parse((String)response).asObject();
        Assert.assertThat((Object)result, (Matcher)HostResourceTest.matchesHost((Host)host1));
    }

    @Test
    public void testSingleHostByMacAndVlanFetch() {
        ProviderId pid = new ProviderId("of", "foo");
        MacAddress mac1 = MacAddress.valueOf((String)"00:00:11:00:00:01");
        ImmutableSet ips1 = ImmutableSet.of((Object)IpAddress.valueOf((String)"1111:1111:1111:1::"));
        DefaultHost host1 = new DefaultHost(pid, HostId.hostId((MacAddress)mac1), MacAddress.valueOf((long)1L), VlanId.vlanId((short)1), new HostLocation(DeviceId.deviceId((String)"1"), PortNumber.portNumber((long)11L), 1L), (Set)ips1, new Annotations[0]);
        this.hosts.add((Host)host1);
        EasyMock.expect((Object)this.mockHostService.getHost(HostId.hostId((String)"00:00:11:00:00:01/1"))).andReturn((Object)host1).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.mockHostService});
        WebTarget wt = this.target();
        String response = (String)wt.path("hosts/00:00:11:00:00:01/1").request().get(String.class);
        JsonObject result = Json.parse((String)response).asObject();
        Assert.assertThat((Object)result, (Matcher)HostResourceTest.matchesHost((Host)host1));
    }

    @Test
    public void testBadGet() {
        EasyMock.expect((Object)this.mockHostService.getHost(HostId.hostId((String)"00:00:11:00:00:01/1"))).andReturn(null).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.mockHostService});
        WebTarget wt = this.target();
        try {
            wt.path("hosts/00:00:11:00:00:01/1").request().get(String.class);
            Assert.fail((String)"Fetch of non-existent host did not throw an exception");
        }
        catch (NotFoundException ex) {
            Assert.assertThat((Object)ex.getMessage(), (Matcher)Matchers.containsString((String)"HTTP 404 Not Found"));
        }
    }

    @Test
    public void testPost() {
        this.mockHostProviderService.hostDetected((HostId)EasyMock.anyObject(), (HostDescription)EasyMock.anyObject(), EasyMock.anyBoolean());
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.mockHostProviderService});
        EasyMock.expect((Object)this.mockHostProviderRegistry.register((Provider)EasyMock.anyObject())).andReturn((Object)this.mockHostProviderService);
        this.mockHostProviderRegistry.unregister((Provider)EasyMock.anyObject());
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.mockHostProviderRegistry});
        EasyMock.replay((Object[])new Object[]{this.mockHostService});
        InputStream jsonStream = HostResourceTest.class.getResourceAsStream("post-host.json");
        WebTarget wt = this.target();
        Response response = wt.path("hosts").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.json((Object)jsonStream));
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)201));
        String location = response.getLocation().getPath();
        Assert.assertThat((Object)location, (Matcher)Matchers.startsWith((String)"/hosts/11:22:33:44:55:66/None"));
    }

    @Test
    public void testDelete() {
        HostId hostId = HostId.hostId((String)"11:22:33:44:55:66/None");
        this.mockHostService.removeHost(hostId);
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.mockHostService});
        WebTarget wt = this.target();
        Response response = wt.path("hosts/11:22:33:44:55:66/None").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).delete();
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)204));
    }

    public static class HostJsonArrayMatcher
    extends TypeSafeMatcher<JsonArray> {
        private final Host host;
        private String reason = "";

        public HostJsonArrayMatcher(Host hostValue) {
            this.host = hostValue;
        }

        public boolean matchesSafely(JsonArray json) {
            boolean hostFound = false;
            int expectedAttributes = 8;
            for (int jsonHostIndex = 0; jsonHostIndex < json.size(); ++jsonHostIndex) {
                JsonObject jsonHost = json.get(jsonHostIndex).asObject();
                if (jsonHost.names().size() != 8) {
                    this.reason = "Found a host with the wrong number of attributes";
                    return false;
                }
                String jsonHostId = jsonHost.get("id").asString();
                if (!jsonHostId.equals(this.host.id().toString())) continue;
                hostFound = true;
                Assert.assertThat((Object)jsonHost, (Matcher)HostResourceTest.matchesHost(this.host));
            }
            if (!hostFound) {
                this.reason = "Host with id " + this.host.id().toString() + " not found";
                return false;
            }
            return true;
        }

        public void describeTo(Description description) {
            description.appendText(this.reason);
        }
    }

    public static class HostJsonMatcher
    extends TypeSafeMatcher<JsonObject> {
        private final Host host;
        private String reason = "";

        public HostJsonMatcher(Host hostValue) {
            this.host = hostValue;
        }

        public boolean matchesSafely(JsonObject jsonHost) {
            String jsonId = jsonHost.get("id").asString();
            if (!jsonId.equals(this.host.id().toString())) {
                this.reason = "id " + this.host.id().toString();
                return false;
            }
            String jsonVlanId = jsonHost.get("vlan").asString();
            if (!jsonVlanId.equals(this.host.vlan().toString())) {
                this.reason = "vlan id " + this.host.vlan().toString();
                return false;
            }
            String jsonMacAddress = jsonHost.get("mac").asString();
            if (!jsonMacAddress.equals(this.host.mac().toString())) {
                this.reason = "mac address " + this.host.mac().toString();
                return false;
            }
            JsonArray jsonLocations = jsonHost.get("locations").asArray();
            Set expectedLocations = this.host.locations();
            if (jsonLocations.size() != expectedLocations.size()) {
                this.reason = "locations arrays differ in size";
                return false;
            }
            Iterator jsonIterator = jsonLocations.iterator();
            Iterator locIterator = expectedLocations.iterator();
            while (jsonIterator.hasNext()) {
                boolean result = this.verifyLocation(((JsonValue)jsonIterator.next()).asObject(), (HostLocation)locIterator.next());
                if (result) continue;
                return false;
            }
            JsonArray jsonHostIps = jsonHost.get("ipAddresses").asArray();
            Set expectedHostIps = this.host.ipAddresses();
            if (jsonHostIps.size() != expectedHostIps.size()) {
                this.reason = "IP address arrays differ in size";
                return false;
            }
            return true;
        }

        public void describeTo(Description description) {
            description.appendText(this.reason);
        }

        private boolean verifyLocation(JsonObject jsonLocation, HostLocation expectedLocation) {
            String jsonLocationElementId = jsonLocation.get("elementId").asString();
            if (!jsonLocationElementId.equals(expectedLocation.elementId().toString())) {
                this.reason = "location element id " + this.host.location().elementId().toString();
                return false;
            }
            String jsonLocationPortNumber = jsonLocation.get("port").asString();
            if (!jsonLocationPortNumber.equals(expectedLocation.port().toString())) {
                this.reason = "location portNumber " + expectedLocation.port().toString();
                return false;
            }
            return true;
        }
    }
}

