/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.rest.resources;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.easymock.EasyMock;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onlab.osgi.ServiceDirectory;
import org.onlab.osgi.TestServiceDirectory;
import org.onlab.packet.MacAddress;
import org.onosproject.codec.CodecContext;
import org.onosproject.codec.CodecService;
import org.onosproject.codec.impl.CodecManager;
import org.onosproject.codec.impl.MockCodecContext;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.core.DefaultApplicationId;
import org.onosproject.core.GroupId;
import org.onosproject.event.EventListener;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DefaultLink;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.Link;
import org.onosproject.net.NetworkResource;
import org.onosproject.net.PortNumber;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.FlowEntry;
import org.onosproject.net.flow.FlowEntryAdapter;
import org.onosproject.net.flow.FlowId;
import org.onosproject.net.flow.FlowRule;
import org.onosproject.net.flow.FlowRuleExtPayLoad;
import org.onosproject.net.flow.FlowRuleService;
import org.onosproject.net.flow.TableId;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flow.criteria.Criterion;
import org.onosproject.net.flow.instructions.Instruction;
import org.onosproject.net.intent.FakeIntentManager;
import org.onosproject.net.intent.FlowRuleIntent;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.IntentService;
import org.onosproject.net.intent.IntentState;
import org.onosproject.net.intent.IntentTestsMocks;
import org.onosproject.net.intent.Key;
import org.onosproject.net.intent.MockIdGenerator;
import org.onosproject.net.intent.PathIntent;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.rest.resources.ResourceTest;

public class IntentsResourceTest
extends ResourceTest {
    private static final String APPID = "appId";
    private static final String CRITERIA = "criteria";
    private static final String DEVICE_ID = "deviceId";
    private static final String ID = "id";
    private static final String INSTRUCTIONS = "instructions";
    private static final String PATHS = "paths";
    private static final String INSTALLABLES = "installables";
    private static final String RESOURCES = "resources";
    private static final String DEVICE = "device";
    private static final String PORT = "port";
    private static final String SRC = "src";
    private static final String DST = "dst";
    private static final String SELECTOR = "selector";
    private static final String SPACE = " ";
    private static final String TREATMENT = "treatment";
    private static final String TYPE = "type";
    final IntentService mockIntentService = (IntentService)EasyMock.createMock(IntentService.class);
    final CoreService mockCoreService = (CoreService)EasyMock.createMock(CoreService.class);
    final FlowRuleService mockFlowService = (FlowRuleService)EasyMock.createMock(FlowRuleService.class);
    final HashSet<Intent> intents = new HashSet();
    final List<Intent> installableIntents = new ArrayList<Intent>();
    private static final ApplicationId APP_ID = new DefaultApplicationId(1, "test");
    final DeviceId deviceId1 = DeviceId.deviceId((String)"1");
    final DeviceId deviceId2 = DeviceId.deviceId((String)"2");
    final DeviceId deviceId3 = DeviceId.deviceId((String)"3");
    final ConnectPoint connectPoint1 = new ConnectPoint((ElementId)this.deviceId1, PortNumber.portNumber((long)1L));
    final ConnectPoint connectPoint2 = new ConnectPoint((ElementId)this.deviceId2, PortNumber.portNumber((long)1L));
    final ConnectPoint connectPoint3 = new ConnectPoint((ElementId)this.deviceId2, PortNumber.portNumber((long)2L));
    final ConnectPoint connectPoint4 = new ConnectPoint((ElementId)this.deviceId3, PortNumber.portNumber((long)1L));
    final TrafficTreatment treatment1 = DefaultTrafficTreatment.builder().setEthDst(MacAddress.BROADCAST).build();
    final TrafficTreatment treatment2 = DefaultTrafficTreatment.builder().setEthDst(MacAddress.IPV4_MULTICAST).build();
    final TrafficSelector selector1 = DefaultTrafficSelector.builder().matchEthType((short)3).matchIPProtocol((byte)9).build();
    final TrafficSelector selector2 = DefaultTrafficSelector.builder().matchEthType((short)4).matchIPProtocol((byte)10).build();
    final MockFlowEntry flow1 = new MockFlowEntry(this.deviceId1, 1L, this.treatment1, this.selector1);
    final MockFlowEntry flow2 = new MockFlowEntry(this.deviceId1, 2L, this.treatment2, this.selector2);
    final MockFlowRule flowRule1 = new MockFlowRule(this.deviceId1, 1L, this.treatment1, this.selector1);
    final MockFlowRule flowRule2 = new MockFlowRule(this.deviceId1, 2L, this.treatment2, this.selector2);

    private static IntentJsonMatcher matchesIntent(Intent intent) {
        return new IntentJsonMatcher(intent);
    }

    private static IntentStatsJsonMatcher matchesRelatedFlowEntries(List<List<FlowEntry>> pathEntries, String expectedAppId) {
        return new IntentStatsJsonMatcher(pathEntries, expectedAppId);
    }

    private static IntentJsonArrayMatcher hasIntent(Intent intent) {
        return new IntentJsonArrayMatcher(intent);
    }

    @Before
    public void setUpTest() {
        EasyMock.expect((Object)this.mockIntentService.getIntents()).andReturn(this.intents).anyTimes();
        EasyMock.expect((Object)this.mockIntentService.getIntentState((Key)EasyMock.anyObject())).andReturn((Object)IntentState.INSTALLED).anyTimes();
        CodecManager codecService = new CodecManager();
        codecService.activate();
        TestServiceDirectory testDirectory = new TestServiceDirectory().add(IntentService.class, (Object)this.mockIntentService).add(FlowRuleService.class, (Object)this.mockFlowService).add(CodecService.class, (Object)codecService).add(CoreService.class, (Object)this.mockCoreService);
        this.setServiceDirectory((ServiceDirectory)testDirectory);
        MockIdGenerator.cleanBind();
    }

    @After
    public void tearDownTest() {
        MockIdGenerator.unbind();
        EasyMock.verify((Object[])new Object[]{this.mockIntentService});
    }

    @Test
    public void testIntentsEmptyArray() {
        EasyMock.replay((Object[])new Object[]{this.mockIntentService});
        WebTarget wt = this.target();
        String response = (String)wt.path("intents").request().get(String.class);
        Assert.assertThat((Object)response, (Matcher)Matchers.is((Object)"{\"intents\":[]}"));
    }

    @Test
    public void testIntentsArray() {
        EasyMock.replay((Object[])new Object[]{this.mockIntentService});
        IntentTestsMocks.MockIntent intent1 = new IntentTestsMocks.MockIntent(Long.valueOf(1L), Collections.emptyList());
        HashSet<MockResource> resources = new HashSet<MockResource>();
        resources.add(new MockResource(1));
        resources.add(new MockResource(2));
        resources.add(new MockResource(3));
        IntentTestsMocks.MockIntent intent2 = new IntentTestsMocks.MockIntent(Long.valueOf(2L), resources);
        this.intents.add((Intent)intent1);
        this.intents.add((Intent)intent2);
        WebTarget wt = this.target();
        String response = (String)wt.path("intents").request().get(String.class);
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"{\"intents\":["));
        JsonObject result = Json.parse((String)response).asObject();
        Assert.assertThat((Object)result, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)result.names(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat(result.names().get(0), (Matcher)Matchers.is((Object)"intents"));
        JsonArray jsonIntents = result.get("intents").asArray();
        Assert.assertThat((Object)jsonIntents, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)jsonIntents, (Matcher)IntentsResourceTest.hasIntent((Intent)intent1));
        Assert.assertThat((Object)jsonIntents, (Matcher)IntentsResourceTest.hasIntent((Intent)intent2));
    }

    @Test
    public void testIntentsSingle() {
        HashSet<MockResource> resources = new HashSet<MockResource>();
        resources.add(new MockResource(1));
        resources.add(new MockResource(2));
        resources.add(new MockResource(3));
        IntentTestsMocks.MockIntent intent = new IntentTestsMocks.MockIntent(Long.valueOf(3L), resources);
        this.intents.add((Intent)intent);
        EasyMock.expect((Object)this.mockIntentService.getIntent(Key.of((long)0L, (ApplicationId)APP_ID))).andReturn((Object)intent).anyTimes();
        EasyMock.expect((Object)this.mockIntentService.getIntent(Key.of((String)"0", (ApplicationId)APP_ID))).andReturn((Object)intent).anyTimes();
        EasyMock.expect((Object)this.mockIntentService.getIntent(Key.of((long)0L, (ApplicationId)APP_ID))).andReturn((Object)intent).anyTimes();
        EasyMock.expect((Object)this.mockIntentService.getIntent(Key.of((String)"0x0", (ApplicationId)APP_ID))).andReturn(null).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.mockIntentService});
        EasyMock.expect((Object)this.mockCoreService.getAppId(APP_ID.name())).andReturn((Object)APP_ID).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.mockCoreService});
        WebTarget wt = this.target();
        String response = (String)wt.path("intents/" + APP_ID.name() + "/0").request().get(String.class);
        JsonObject result = Json.parse((String)response).asObject();
        Assert.assertThat((Object)result, (Matcher)IntentsResourceTest.matchesIntent((Intent)intent));
        String responseNumeric = (String)wt.path("intents/" + APP_ID.name() + "/0x0").request().get(String.class);
        JsonObject resultNumeric = Json.parse((String)responseNumeric).asObject();
        Assert.assertThat((Object)resultNumeric, (Matcher)IntentsResourceTest.matchesIntent((Intent)intent));
    }

    @Test
    public void testRelatedFlowsForIntents() {
        ArrayList<MockFlowEntry> flowEntries = new ArrayList<MockFlowEntry>();
        flowEntries.add(this.flow1);
        flowEntries.add(this.flow2);
        ArrayList<List<FlowEntry>> paths = new ArrayList<List<FlowEntry>>();
        paths.add(flowEntries);
        ArrayList<MockFlowRule> flowRules = new ArrayList<MockFlowRule>();
        flowRules.add(this.flowRule1);
        flowRules.add(this.flowRule2);
        FlowRuleIntent flowRuleIntent = new FlowRuleIntent(APP_ID, null, flowRules, new HashSet(), PathIntent.ProtectionType.PRIMARY, null);
        IntentTestsMocks.MockIntent intent = new IntentTestsMocks.MockIntent(Long.valueOf(3L));
        this.installableIntents.add((Intent)flowRuleIntent);
        this.intents.add((Intent)intent);
        EasyMock.expect((Object)this.mockIntentService.getIntent(Key.of((long)0L, (ApplicationId)APP_ID))).andReturn((Object)intent).anyTimes();
        EasyMock.expect((Object)this.mockIntentService.getIntent(Key.of((String)"0", (ApplicationId)APP_ID))).andReturn((Object)intent).anyTimes();
        EasyMock.expect((Object)this.mockIntentService.getIntent(Key.of((long)0L, (ApplicationId)APP_ID))).andReturn((Object)intent).anyTimes();
        EasyMock.expect((Object)this.mockIntentService.getIntent(Key.of((String)"0x0", (ApplicationId)APP_ID))).andReturn(null).anyTimes();
        EasyMock.expect((Object)this.mockIntentService.getInstallableIntents(intent.key())).andReturn(this.installableIntents).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.mockIntentService});
        EasyMock.expect((Object)this.mockFlowService.getFlowEntries(this.deviceId1)).andReturn(flowEntries).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.mockFlowService});
        EasyMock.expect((Object)this.mockCoreService.getAppId(APP_ID.name())).andReturn((Object)APP_ID).anyTimes();
        EasyMock.expect((Object)this.mockCoreService.getAppId(Short.valueOf(APP_ID.id()))).andReturn((Object)APP_ID).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.mockCoreService});
        WebTarget wt = this.target();
        String response = (String)wt.path("intents/relatedflows/" + APP_ID.name() + "/0").request().get(String.class);
        JsonObject result = Json.parse((String)response).asObject();
        Assert.assertThat((Object)result, (Matcher)IntentsResourceTest.matchesRelatedFlowEntries(paths, APP_ID.name()));
        String responseNumeric = (String)wt.path("intents/relatedflows/" + APP_ID.name() + "/0x0").request().get(String.class);
        JsonObject resultNumeric = Json.parse((String)responseNumeric).asObject();
        Assert.assertThat((Object)resultNumeric, (Matcher)IntentsResourceTest.matchesRelatedFlowEntries(paths, APP_ID.name()));
    }

    @Test
    public void testIntentInstallables() {
        DefaultLink link1 = DefaultLink.builder().type(Link.Type.DIRECT).providerId(ProviderId.NONE).src(this.connectPoint1).dst(this.connectPoint2).build();
        DefaultLink link2 = DefaultLink.builder().type(Link.Type.DIRECT).providerId(ProviderId.NONE).src(this.connectPoint3).dst(this.connectPoint4).build();
        HashSet<DefaultLink> resources = new HashSet<DefaultLink>();
        resources.add(link1);
        resources.add(link2);
        FlowRuleIntent flowRuleIntent = new FlowRuleIntent(APP_ID, null, new ArrayList(), resources, PathIntent.ProtectionType.PRIMARY, null);
        IntentTestsMocks.MockIntent intent = new IntentTestsMocks.MockIntent(IntentTestsMocks.MockIntent.nextId());
        Long intentId = (Long)intent.id().id();
        this.installableIntents.add((Intent)flowRuleIntent);
        this.intents.add((Intent)intent);
        EasyMock.expect((Object)this.mockIntentService.getIntent(Key.of((long)intentId, (ApplicationId)APP_ID))).andReturn((Object)intent).anyTimes();
        EasyMock.expect((Object)this.mockIntentService.getIntent(Key.of((String)intentId.toString(), (ApplicationId)APP_ID))).andReturn((Object)intent).anyTimes();
        EasyMock.expect((Object)this.mockIntentService.getIntent(Key.of((long)intentId, (ApplicationId)APP_ID))).andReturn((Object)intent).anyTimes();
        EasyMock.expect((Object)this.mockIntentService.getIntent(Key.of((String)Long.toHexString(intentId), (ApplicationId)APP_ID))).andReturn(null).anyTimes();
        EasyMock.expect((Object)this.mockIntentService.getInstallableIntents(intent.key())).andReturn(this.installableIntents).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.mockIntentService});
        EasyMock.replay((Object[])new Object[]{this.mockFlowService});
        EasyMock.expect((Object)this.mockCoreService.getAppId(APP_ID.name())).andReturn((Object)APP_ID).anyTimes();
        EasyMock.expect((Object)this.mockCoreService.getAppId(Short.valueOf(APP_ID.id()))).andReturn((Object)APP_ID).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.mockCoreService});
        WebTarget wt = this.target();
        String response = (String)wt.path("intents/installables/" + APP_ID.name() + "/" + intentId).request().get(String.class);
        JsonObject result = Json.parse((String)response).asObject();
        Assert.assertThat((Object)result.get(INSTALLABLES).asArray(), (Matcher)IntentsResourceTest.hasIntent((Intent)flowRuleIntent));
        String responseNumeric = (String)wt.path("intents/installables/" + APP_ID.name() + "/" + Long.toHexString(intentId)).request().get(String.class);
        JsonObject resultNumeric = Json.parse((String)responseNumeric).asObject();
        Assert.assertThat((Object)resultNumeric.get(INSTALLABLES).asArray(), (Matcher)IntentsResourceTest.hasIntent((Intent)flowRuleIntent));
    }

    @Test
    public void testBadGet() {
        EasyMock.expect((Object)this.mockIntentService.getIntent(Key.of((long)0L, (ApplicationId)APP_ID))).andReturn(null).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.mockIntentService});
        WebTarget wt = this.target();
        try {
            wt.path("intents/0").request().get(String.class);
            Assert.fail((String)"Fetch of non-existent intent did not throw an exception");
        }
        catch (NotFoundException ex) {
            Assert.assertThat((Object)ex.getMessage(), (Matcher)Matchers.containsString((String)"HTTP 404 Not Found"));
        }
    }

    @Test
    public void testPost() {
        DefaultApplicationId testId = new DefaultApplicationId(2, "myApp");
        EasyMock.expect((Object)this.mockCoreService.getAppId("myApp")).andReturn((Object)testId);
        EasyMock.replay((Object[])new Object[]{this.mockCoreService});
        this.mockIntentService.submit((Intent)EasyMock.anyObject());
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.mockIntentService});
        InputStream jsonStream = IntentsResourceTest.class.getResourceAsStream("post-intent.json");
        WebTarget wt = this.target();
        Response response = wt.path("intents").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.json((Object)jsonStream));
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)201));
        String location = response.getLocation().getPath();
        Assert.assertThat((Object)location, (Matcher)Matchers.startsWith((String)"/intents/myApp/"));
    }

    @Test
    public void testBadPost() {
        EasyMock.replay((Object[])new Object[]{this.mockCoreService});
        EasyMock.replay((Object[])new Object[]{this.mockIntentService});
        String json = "this is invalid!";
        WebTarget wt = this.target();
        Response response = wt.path("intents").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.json((Object)json));
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)400));
    }

    @Test
    public void testRemove() {
        HashSet<MockResource> resources = new HashSet<MockResource>();
        resources.add(new MockResource(1));
        resources.add(new MockResource(2));
        resources.add(new MockResource(3));
        IntentTestsMocks.MockIntent intent = new IntentTestsMocks.MockIntent(Long.valueOf(3L), resources);
        DefaultApplicationId appId = new DefaultApplicationId(2, "app");
        FakeIntentManager fakeManager = new FakeIntentManager();
        EasyMock.expect((Object)this.mockCoreService.getAppId("app")).andReturn((Object)appId).once();
        EasyMock.replay((Object[])new Object[]{this.mockCoreService});
        this.mockIntentService.withdraw((Intent)EasyMock.anyObject());
        EasyMock.expectLastCall().andDelegateTo((Object)fakeManager).once();
        EasyMock.expect((Object)this.mockIntentService.getIntent(Key.of((long)2L, (ApplicationId)appId))).andReturn((Object)intent).once();
        EasyMock.expect((Object)this.mockIntentService.getIntent(Key.of((String)"0x2", (ApplicationId)appId))).andReturn(null).once();
        this.mockIntentService.addListener((EventListener)EasyMock.anyObject());
        EasyMock.expectLastCall().andDelegateTo((Object)fakeManager).once();
        this.mockIntentService.removeListener((EventListener)EasyMock.anyObject());
        EasyMock.expectLastCall().andDelegateTo((Object)fakeManager).once();
        EasyMock.replay((Object[])new Object[]{this.mockIntentService});
        WebTarget wt = this.target();
        Response response = wt.path("intents/app/0x2").request(new String[]{"application/json", "text/plain"}).delete();
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)204));
    }

    @Test
    public void testBadRemove() {
        DefaultApplicationId appId = new DefaultApplicationId(2, "app");
        EasyMock.expect((Object)this.mockCoreService.getAppId("app")).andReturn((Object)appId).once();
        EasyMock.replay((Object[])new Object[]{this.mockCoreService});
        EasyMock.expect((Object)this.mockIntentService.getIntent(Key.of((long)2L, (ApplicationId)appId))).andReturn(null).once();
        EasyMock.expect((Object)this.mockIntentService.getIntent(Key.of((String)"0x2", (ApplicationId)appId))).andReturn(null).once();
        EasyMock.replay((Object[])new Object[]{this.mockIntentService});
        WebTarget wt = this.target();
        Response response = wt.path("intents/app/0x2").request(new String[]{"application/json", "text/plain"}).delete();
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)204));
    }

    @Test
    public void testIntentsMiniSummary() {
        IntentTestsMocks.MockIntent intent1 = new IntentTestsMocks.MockIntent(Long.valueOf(1L), Collections.emptyList());
        HashSet<MockResource> resources = new HashSet<MockResource>();
        resources.add(new MockResource(1));
        resources.add(new MockResource(2));
        resources.add(new MockResource(3));
        IntentTestsMocks.MockIntent intent2 = new IntentTestsMocks.MockIntent(Long.valueOf(2L), resources);
        this.intents.add((Intent)intent1);
        this.intents.add((Intent)intent2);
        WebTarget wt = this.target();
        EasyMock.replay((Object[])new Object[]{this.mockIntentService});
        String response = (String)wt.path("intents/minisummary").request().get(String.class);
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"{\"All\":{"));
        JsonObject result = Json.parse((String)response).asObject();
        Assert.assertThat((Object)result, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)result.names(), (Matcher)Matchers.hasSize((int)2));
        Assert.assertThat(result.names().get(0), (Matcher)Matchers.containsString((String)"All"));
        JsonObject jsonIntents = (JsonObject)result.get("All");
        Assert.assertThat((Object)jsonIntents, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)jsonIntents.get("total").toString(), (Matcher)Matchers.containsString((String)"2"));
        jsonIntents = (JsonObject)result.get("Mock");
        Assert.assertThat((Object)jsonIntents, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)jsonIntents.get("installed").toString(), (Matcher)Matchers.containsString((String)"2"));
    }

    public static class IntentJsonArrayMatcher
    extends TypeSafeMatcher<JsonArray> {
        private final Intent intent;
        private String reason = "";

        public IntentJsonArrayMatcher(Intent intentValue) {
            this.intent = intentValue;
        }

        public boolean matchesSafely(JsonArray json) {
            boolean intentFound = false;
            int expectedAttributes = 6;
            for (int jsonIntentIndex = 0; jsonIntentIndex < json.size(); ++jsonIntentIndex) {
                JsonObject jsonIntent = json.get(jsonIntentIndex).asObject();
                if (jsonIntent.names().size() != 6) {
                    this.reason = "Found an intent with the wrong number of attributes";
                    return false;
                }
                String jsonIntentId = jsonIntent.get(IntentsResourceTest.ID).asString();
                if (!jsonIntentId.equals(this.intent.id().toString())) continue;
                intentFound = true;
                Assert.assertThat((Object)jsonIntent, (Matcher)IntentsResourceTest.matchesIntent(this.intent));
            }
            if (!intentFound) {
                this.reason = "Intent with id " + this.intent.id().toString() + " not found";
                return false;
            }
            return true;
        }

        public void describeTo(Description description) {
            description.appendText(this.reason);
        }
    }

    public static class IntentStatsJsonMatcher
    extends TypeSafeMatcher<JsonObject> {
        private final List<List<FlowEntry>> pathEntries;
        private final String expectedAppId;
        private String reason = "";

        public IntentStatsJsonMatcher(List<List<FlowEntry>> pathEntries, String expectedAppId) {
            this.pathEntries = pathEntries;
            this.expectedAppId = expectedAppId;
        }

        public boolean matchesSafely(JsonObject jsonIntent) {
            int jsonPathIndex = 0;
            JsonArray jsonPaths = jsonIntent.get(IntentsResourceTest.PATHS).asArray();
            if (this.pathEntries != null) {
                if (this.pathEntries.size() == 0) {
                    this.reason = "pathEntries array empty";
                    return false;
                }
                if (this.pathEntries.size() != jsonPaths.size()) {
                    this.reason = "path entries array size of " + Integer.toString(this.pathEntries.size());
                    return false;
                }
                for (List<FlowEntry> flowEntries : this.pathEntries) {
                    JsonArray jsonFlowEntries = jsonPaths.get(jsonPathIndex++).asArray();
                    if (flowEntries.size() != jsonFlowEntries.size()) {
                        this.reason = "flow entries array size of " + Integer.toString(this.pathEntries.size());
                        return false;
                    }
                    int jsonFlowEntryIndex = 0;
                    for (FlowEntry flow : flowEntries) {
                        String flowId;
                        JsonObject jsonFlow;
                        String jsonId;
                        if (!(jsonId = (jsonFlow = jsonFlowEntries.get(jsonFlowEntryIndex++).asObject()).get(IntentsResourceTest.ID).asString()).equals(flowId = Long.toString(flow.id().value()))) {
                            this.reason = "id " + flow.id();
                            return false;
                        }
                        String jsonAppId = jsonFlow.get(IntentsResourceTest.APPID).asString();
                        if (!jsonAppId.equals(this.expectedAppId)) {
                            this.reason = "appId " + Short.toString(flow.appId());
                            return false;
                        }
                        String jsonDeviceId = jsonFlow.get(IntentsResourceTest.DEVICE_ID).asString();
                        if (!jsonDeviceId.equals(flow.deviceId().toString())) {
                            this.reason = "deviceId " + flow.deviceId();
                            return false;
                        }
                        if (!this.checkFlowTreatment(flow, jsonFlow)) {
                            return false;
                        }
                        if (this.checkFlowSelector(flow, jsonFlow)) continue;
                        return false;
                    }
                }
            } else {
                this.reason = "pathEntries array empty";
                return false;
            }
            return true;
        }

        private boolean checkFlowTreatment(FlowEntry flow, JsonObject jsonFlow) {
            if (flow.treatment() != null) {
                JsonObject jsonTreatment = jsonFlow.get(IntentsResourceTest.TREATMENT).asObject();
                JsonArray jsonInstructions = jsonTreatment.get(IntentsResourceTest.INSTRUCTIONS).asArray();
                if (flow.treatment().immediate().size() != jsonInstructions.size()) {
                    this.reason = "instructions array size of " + flow.treatment().immediate().size();
                    return false;
                }
                for (Instruction instruction : flow.treatment().immediate()) {
                    boolean instructionFound = false;
                    for (int instructionIndex = 0; instructionIndex < jsonInstructions.size(); ++instructionIndex) {
                        String instructionType;
                        String jsonType = jsonInstructions.get(instructionIndex).asObject().get(IntentsResourceTest.TYPE).asString();
                        if (!jsonType.equals(instructionType = instruction.type().name())) continue;
                        instructionFound = true;
                    }
                    if (instructionFound) continue;
                    this.reason = "instructions " + instruction;
                    return false;
                }
            }
            return true;
        }

        private boolean checkFlowSelector(FlowEntry flow, JsonObject jsonFlow) {
            if (flow.selector() != null) {
                JsonObject jsonTreatment = jsonFlow.get(IntentsResourceTest.SELECTOR).asObject();
                JsonArray jsonCriteria = jsonTreatment.get(IntentsResourceTest.CRITERIA).asArray();
                if (flow.selector().criteria().size() != jsonCriteria.size()) {
                    this.reason = "criteria array size of " + Integer.toString(flow.selector().criteria().size());
                    return false;
                }
                for (Criterion criterion : flow.selector().criteria()) {
                    boolean criterionFound = false;
                    for (int criterionIndex = 0; criterionIndex < jsonCriteria.size(); ++criterionIndex) {
                        String criterionType;
                        String jsonType = jsonCriteria.get(criterionIndex).asObject().get(IntentsResourceTest.TYPE).asString();
                        if (!jsonType.equals(criterionType = criterion.type().name())) continue;
                        criterionFound = true;
                    }
                    if (criterionFound) continue;
                    this.reason = "criterion " + criterion;
                    return false;
                }
            }
            return true;
        }

        public void describeTo(Description description) {
            description.appendText(this.reason);
        }
    }

    public static class IntentJsonMatcher
    extends TypeSafeMatcher<JsonObject> {
        private final Intent intent;
        private String reason = "";

        public IntentJsonMatcher(Intent intentValue) {
            this.intent = intentValue;
        }

        public boolean matchesSafely(JsonObject jsonIntent) {
            String appId;
            String jsonId = jsonIntent.get(IntentsResourceTest.ID).asString();
            if (!jsonId.equals(this.intent.id().toString())) {
                this.reason = "id " + this.intent.id().toString();
                return false;
            }
            String jsonAppId = jsonIntent.get(IntentsResourceTest.APPID).asString();
            if (!jsonAppId.equals(appId = this.intent.appId().name())) {
                this.reason = "appId was " + jsonAppId;
                return false;
            }
            String jsonType = jsonIntent.get(IntentsResourceTest.TYPE).asString();
            if (!this.intent.getClass().getSimpleName().equals(jsonType)) {
                this.reason = "type MockIntent";
                return false;
            }
            String jsonState = jsonIntent.get("state").asString();
            if (!"INSTALLED".equals(jsonState)) {
                this.reason = "state INSTALLED";
                return false;
            }
            JsonArray jsonResources = jsonIntent.get(IntentsResourceTest.RESOURCES).asArray();
            if (this.intent.resources() != null) {
                if (this.intent.resources().size() != jsonResources.size()) {
                    this.reason = "resources array size of " + Integer.toString(this.intent.resources().size());
                    return false;
                }
                for (NetworkResource resource : this.intent.resources()) {
                    boolean resourceFound = false;
                    String resourceString = resource.toString();
                    if (resource instanceof Link) {
                        Link resourceLink = (Link)resource;
                        MockCodecContext codecContext = new MockCodecContext();
                        for (int resourceIndex = 0; resourceIndex < jsonResources.size(); ++resourceIndex) {
                            ObjectNode value;
                            try {
                                value = (ObjectNode)codecContext.mapper().readTree(jsonResources.get(resourceIndex).toString());
                            }
                            catch (IOException e) {
                                this.reason = "bad json";
                                return false;
                            }
                            Link link = (Link)codecContext.codec(Link.class).decode(value, (CodecContext)codecContext);
                            if (!resourceLink.equals(link)) continue;
                            resourceFound = true;
                        }
                    } else {
                        for (int resourceIndex = 0; resourceIndex < jsonResources.size(); ++resourceIndex) {
                            JsonValue value = jsonResources.get(resourceIndex);
                            if (!value.asString().equals(resourceString)) continue;
                            resourceFound = true;
                        }
                    }
                    if (resourceFound) continue;
                    this.reason = "resource " + resourceString;
                    return false;
                }
            } else if (jsonResources.size() != 0) {
                this.reason = "resources array empty";
                return false;
            }
            return true;
        }

        public void describeTo(Description description) {
            description.appendText(this.reason);
        }
    }

    private static class MockFlowRule
    implements FlowRule {
        final DeviceId deviceId;
        final long baseValue;
        TrafficTreatment treatment;
        TrafficSelector selector;

        public MockFlowRule(DeviceId deviceId, long id, TrafficTreatment treatment, TrafficSelector selector) {
            this.deviceId = deviceId;
            this.baseValue = id * 100L;
            this.treatment = treatment;
            this.selector = selector;
        }

        public FlowId id() {
            long id = this.baseValue + 55L;
            return FlowId.valueOf((long)id);
        }

        public short appId() {
            return 1;
        }

        public GroupId groupId() {
            return new GroupId(3);
        }

        public int priority() {
            return 0;
        }

        public DeviceId deviceId() {
            return this.deviceId;
        }

        public TrafficSelector selector() {
            return this.selector;
        }

        public TrafficTreatment treatment() {
            return this.treatment;
        }

        public int timeout() {
            return (int)(this.baseValue + 77L);
        }

        public int hardTimeout() {
            return 0;
        }

        public FlowRule.FlowRemoveReason reason() {
            return FlowRule.FlowRemoveReason.NO_REASON;
        }

        public boolean isPermanent() {
            return false;
        }

        public int tableId() {
            return 0;
        }

        public TableId table() {
            return DEFAULT_TABLE;
        }

        public boolean exactMatch(FlowRule rule) {
            return false;
        }

        public FlowRuleExtPayLoad payLoad() {
            return null;
        }
    }

    private static class MockFlowEntry
    extends FlowEntryAdapter {
        final DeviceId deviceId;
        final long baseValue;
        TrafficTreatment treatment;
        TrafficSelector selector;

        public MockFlowEntry(DeviceId deviceId, long id, TrafficTreatment treatment, TrafficSelector selector) {
            this.deviceId = deviceId;
            this.baseValue = id * 100L;
            this.treatment = treatment;
            this.selector = selector;
        }

        public long life() {
            return this.life(TimeUnit.SECONDS);
        }

        public FlowEntry.FlowLiveType liveType() {
            return FlowEntry.FlowLiveType.IMMEDIATE;
        }

        public long life(TimeUnit timeUnit) {
            return TimeUnit.SECONDS.convert(this.baseValue + 11L, timeUnit);
        }

        public long packets() {
            return this.baseValue + 22L;
        }

        public long bytes() {
            return this.baseValue + 33L;
        }

        public long lastSeen() {
            return this.baseValue + 44L;
        }

        public FlowId id() {
            long id = this.baseValue + 55L;
            return FlowId.valueOf((long)id);
        }

        public GroupId groupId() {
            return new GroupId(3);
        }

        public short appId() {
            return 1;
        }

        public int priority() {
            return (int)(this.baseValue + 66L);
        }

        public DeviceId deviceId() {
            return this.deviceId;
        }

        public TrafficSelector selector() {
            return this.selector;
        }

        public TrafficTreatment treatment() {
            return this.treatment;
        }

        public int timeout() {
            return (int)(this.baseValue + 77L);
        }

        public boolean exactMatch(FlowRule rule) {
            return this.appId() == rule.appId() && this.deviceId().equals((Object)rule.deviceId()) && this.id().equals((Object)rule.id()) && this.treatment.equals(rule.treatment()) && this.selector().equals(rule.selector());
        }

        public String toString() {
            return ((Long)this.id().id()).toString();
        }
    }

    private class MockResource
    implements NetworkResource {
        int id;

        MockResource(int id) {
            this.id = id;
        }

        public String toString() {
            return "Resource " + Integer.toString(this.id);
        }
    }
}

