/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.rest.resources;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import javax.ws.rs.client.WebTarget;
import org.easymock.EasyMock;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onlab.osgi.ServiceDirectory;
import org.onlab.osgi.TestServiceDirectory;
import org.onosproject.codec.CodecService;
import org.onosproject.codec.impl.CodecManager;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Link;
import org.onosproject.net.NetTestTools;
import org.onosproject.net.link.LinkService;
import org.onosproject.rest.resources.ResourceTest;

public class LinksResourceTest
extends ResourceTest {
    LinkService mockLinkService;
    Link link1 = NetTestTools.link((String)"src1", (int)1, (String)"dst1", (int)1);
    Link link2 = NetTestTools.link((String)"src2", (int)2, (String)"dst2", (int)2);
    Link link3 = NetTestTools.link((String)"src3", (int)3, (String)"dst3", (int)3);

    private static LinkJsonMatcher matchesLink(Link link) {
        return new LinkJsonMatcher(link);
    }

    private static LinkJsonArrayMatcher hasLink(Link link) {
        return new LinkJsonArrayMatcher(link);
    }

    @Before
    public void setUpTest() {
        this.mockLinkService = (LinkService)EasyMock.createMock(LinkService.class);
        CodecManager codecService = new CodecManager();
        codecService.activate();
        TestServiceDirectory testDirectory = new TestServiceDirectory().add(LinkService.class, (Object)this.mockLinkService).add(CodecService.class, (Object)codecService);
        this.setServiceDirectory((ServiceDirectory)testDirectory);
    }

    @After
    public void tearDownTest() {
        EasyMock.verify((Object[])new Object[]{this.mockLinkService});
    }

    @Test
    public void testLinksEmptyArray() {
        EasyMock.expect((Object)this.mockLinkService.getLinks()).andReturn((Object)ImmutableList.of());
        EasyMock.replay((Object[])new Object[]{this.mockLinkService});
        WebTarget wt = this.target();
        String response = (String)wt.path("links").request().get(String.class);
        Assert.assertThat((Object)response, (Matcher)Matchers.is((Object)"{\"links\":[]}"));
    }

    @Test
    public void testLinks() {
        EasyMock.expect((Object)this.mockLinkService.getLinks()).andReturn((Object)ImmutableList.of((Object)this.link1, (Object)this.link2, (Object)this.link3)).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.mockLinkService});
        WebTarget wt = this.target();
        String response = (String)wt.path("links").request().get(String.class);
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"{\"links\":["));
        JsonObject result = Json.parse((String)response).asObject();
        Assert.assertThat((Object)result, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)result.names(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat(result.names().get(0), (Matcher)Matchers.is((Object)"links"));
        JsonArray jsonLinks = result.get("links").asArray();
        Assert.assertThat((Object)jsonLinks, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)jsonLinks.size(), (Matcher)Matchers.is((Object)3));
        Assert.assertThat((Object)jsonLinks, (Matcher)LinksResourceTest.hasLink(this.link1));
        Assert.assertThat((Object)jsonLinks, (Matcher)LinksResourceTest.hasLink(this.link2));
        Assert.assertThat((Object)jsonLinks, (Matcher)LinksResourceTest.hasLink(this.link3));
    }

    @Test
    public void testLinksByDevice() {
        EasyMock.expect((Object)this.mockLinkService.getDeviceLinks((DeviceId)EasyMock.isA(DeviceId.class))).andReturn((Object)ImmutableSet.of((Object)this.link2)).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.mockLinkService});
        WebTarget wt = this.target();
        String response = (String)wt.path("links").queryParam("device", new Object[]{"src2"}).request().get(String.class);
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"{\"links\":["));
        JsonObject result = Json.parse((String)response).asObject();
        Assert.assertThat((Object)result, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)result.names(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat(result.names().get(0), (Matcher)Matchers.is((Object)"links"));
        JsonArray jsonLinks = result.get("links").asArray();
        Assert.assertThat((Object)jsonLinks, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)jsonLinks.size(), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)jsonLinks, (Matcher)LinksResourceTest.hasLink(this.link2));
    }

    @Test
    public void testLinksByDevicePort() {
        EasyMock.expect((Object)this.mockLinkService.getLinks((ConnectPoint)EasyMock.isA(ConnectPoint.class))).andReturn((Object)ImmutableSet.of((Object)this.link2)).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.mockLinkService});
        WebTarget wt = this.target();
        String response = (String)wt.path("links").queryParam("device", new Object[]{"src2"}).queryParam("port", new Object[]{"2"}).request().get(String.class);
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"{\"links\":["));
        JsonObject result = Json.parse((String)response).asObject();
        Assert.assertThat((Object)result, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)result.names(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat(result.names().get(0), (Matcher)Matchers.is((Object)"links"));
        JsonArray jsonLinks = result.get("links").asArray();
        Assert.assertThat((Object)jsonLinks, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)jsonLinks.size(), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)jsonLinks, (Matcher)LinksResourceTest.hasLink(this.link2));
    }

    @Test
    public void testLinksByDevicePortDirection() {
        EasyMock.expect((Object)this.mockLinkService.getIngressLinks((ConnectPoint)EasyMock.isA(ConnectPoint.class))).andReturn((Object)ImmutableSet.of((Object)this.link2)).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.mockLinkService});
        WebTarget wt = this.target();
        String response = (String)wt.path("links").queryParam("device", new Object[]{"src2"}).queryParam("port", new Object[]{"2"}).queryParam("direction", new Object[]{"INGRESS"}).request().get(String.class);
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"{\"links\":["));
        JsonObject result = Json.parse((String)response).asObject();
        Assert.assertThat((Object)result, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)result.names(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat(result.names().get(0), (Matcher)Matchers.is((Object)"links"));
        JsonArray jsonLinks = result.get("links").asArray();
        Assert.assertThat((Object)jsonLinks, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)jsonLinks.size(), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)jsonLinks, (Matcher)LinksResourceTest.hasLink(this.link2));
    }

    @Test
    public void testLinksByDeviceDirection() {
        EasyMock.expect((Object)this.mockLinkService.getDeviceIngressLinks((DeviceId)EasyMock.isA(DeviceId.class))).andReturn((Object)ImmutableSet.of((Object)this.link2)).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.mockLinkService});
        WebTarget wt = this.target();
        String response = (String)wt.path("links").queryParam("device", new Object[]{"src2"}).queryParam("direction", new Object[]{"INGRESS"}).request().get(String.class);
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"{\"links\":["));
        JsonObject result = Json.parse((String)response).asObject();
        Assert.assertThat((Object)result, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)result.names(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat(result.names().get(0), (Matcher)Matchers.is((Object)"links"));
        JsonArray jsonLinks = result.get("links").asArray();
        Assert.assertThat((Object)jsonLinks, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)jsonLinks.size(), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)jsonLinks, (Matcher)LinksResourceTest.hasLink(this.link2));
    }

    private static class LinkJsonArrayMatcher
    extends TypeSafeMatcher<JsonArray> {
        private final Link link;
        private String reason = "";

        public LinkJsonArrayMatcher(Link linkValue) {
            this.link = linkValue;
        }

        public boolean matchesSafely(JsonArray json) {
            int expectedAttributes = 2;
            for (int jsonLinkIndex = 0; jsonLinkIndex < json.size(); ++jsonLinkIndex) {
                JsonObject jsonLink = json.get(jsonLinkIndex).asObject();
                if (!LinksResourceTest.matchesLink(this.link).matchesSafely(jsonLink)) continue;
                return true;
            }
            return false;
        }

        public void describeTo(Description description) {
            description.appendText(this.reason);
        }
    }

    public static class LinkJsonMatcher
    extends TypeSafeMatcher<JsonObject> {
        private final Link link;
        private String reason = "";

        public LinkJsonMatcher(Link linkValue) {
            this.link = linkValue;
        }

        public boolean matchesSafely(JsonObject jsonLink) {
            JsonObject jsonSrc = jsonLink.get("src").asObject();
            String jsonSrcDevice = jsonSrc.get("device").asString();
            String jsonSrcPort = jsonSrc.get("port").asString();
            JsonObject jsonDst = jsonLink.get("dst").asObject();
            String jsonDstDevice = jsonDst.get("device").asString();
            String jsonDstPort = jsonDst.get("port").asString();
            return jsonSrcDevice.equals(this.link.src().deviceId().toString()) && jsonSrcPort.equals(this.link.src().port().toString()) && jsonDstDevice.equals(this.link.dst().deviceId().toString()) && jsonDstPort.equals(this.link.dst().port().toString());
        }

        public void describeTo(Description description) {
            description.appendText(this.reason);
        }
    }
}

