/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.rest.resources;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.InputStream;
import java.util.List;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.easymock.EasyMock;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onlab.osgi.ServiceDirectory;
import org.onlab.osgi.TestServiceDirectory;
import org.onosproject.cluster.NodeId;
import org.onosproject.cluster.RoleInfo;
import org.onosproject.codec.CodecService;
import org.onosproject.codec.impl.CodecManager;
import org.onosproject.mastership.MastershipAdminService;
import org.onosproject.mastership.MastershipService;
import org.onosproject.net.Annotations;
import org.onosproject.net.DefaultDevice;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.MastershipRole;
import org.onosproject.net.device.DeviceService;
import org.onosproject.rest.resources.MetersResourceTest;
import org.onosproject.rest.resources.ResourceTest;

public final class MastershipResourceTest
extends ResourceTest {
    private final MastershipService mockService = (MastershipService)EasyMock.createMock(MastershipService.class);
    private final DeviceService mockDeviceService = (DeviceService)EasyMock.createMock(DeviceService.class);
    private final MastershipAdminService mockAdminService = (MastershipAdminService)EasyMock.createMock(MastershipAdminService.class);
    private final DeviceId deviceId1 = DeviceId.deviceId((String)"dev:1");
    private final DeviceId deviceId2 = DeviceId.deviceId((String)"dev:2");
    private final DeviceId deviceId3 = DeviceId.deviceId((String)"dev:3");
    final Device device1 = new DefaultDevice(null, this.deviceId1, Device.Type.OTHER, "", "", "", "", null, new Annotations[0]);
    private final NodeId nodeId1 = NodeId.nodeId((String)"node:1");
    private final NodeId nodeId2 = NodeId.nodeId((String)"node:2");
    private final NodeId nodeId3 = NodeId.nodeId((String)"node:3");
    private final MastershipRole role1 = MastershipRole.MASTER;

    private RoleInfo createMockRoleInfo() {
        NodeId master = NodeId.nodeId((String)"master");
        ImmutableList backups = ImmutableList.of((Object)this.nodeId1, (Object)this.nodeId2, (Object)this.nodeId3);
        return new RoleInfo(master, (List)backups);
    }

    private static RoleInfoJsonMatcher matchesRoleInfo(RoleInfo roleInfo) {
        return new RoleInfoJsonMatcher(roleInfo);
    }

    @Before
    public void setUpTest() {
        CodecManager codecService = new CodecManager();
        codecService.activate();
        TestServiceDirectory testDirectory = new TestServiceDirectory().add(MastershipService.class, (Object)this.mockService).add(MastershipAdminService.class, (Object)this.mockAdminService).add(DeviceService.class, (Object)this.mockDeviceService).add(CodecService.class, (Object)codecService);
        this.setServiceDirectory((ServiceDirectory)testDirectory);
    }

    @Test
    public void testGetLocalRole() {
        EasyMock.expect((Object)this.mockService.getLocalRole((DeviceId)EasyMock.anyObject())).andReturn((Object)this.role1).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.mockService});
        WebTarget wt = this.target();
        String response = (String)wt.path("mastership/" + this.deviceId1.toString() + "/local").request().get(String.class);
        JsonObject result = Json.parse((String)response).asObject();
        Assert.assertThat((Object)result, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)result.names(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat(result.names().get(0), (Matcher)Matchers.is((Object)"role"));
        String role = result.get("role").asString();
        Assert.assertThat((Object)role, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)role, (Matcher)Matchers.is((Object)"MASTER"));
    }

    @Test
    public void testGetMasterForNull() {
        EasyMock.expect((Object)this.mockService.getMasterFor((DeviceId)EasyMock.anyObject())).andReturn(null).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.mockService});
        WebTarget wt = this.target();
        Response response = wt.path("mastership/" + this.deviceId1.toString() + "/master").request().get();
        Assert.assertEquals((long)404L, (long)response.getStatus());
    }

    @Test
    public void testGetMasterFor() {
        EasyMock.expect((Object)this.mockService.getMasterFor((DeviceId)EasyMock.anyObject())).andReturn((Object)this.nodeId1).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.mockService});
        WebTarget wt = this.target();
        String response = (String)wt.path("mastership/" + this.deviceId1.toString() + "/master").request().get(String.class);
        JsonObject result = Json.parse((String)response).asObject();
        Assert.assertThat((Object)result, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)result.names(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat(result.names().get(0), (Matcher)Matchers.is((Object)"nodeId"));
        String node = result.get("nodeId").asString();
        Assert.assertThat((Object)node, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)node, (Matcher)Matchers.is((Object)"node:1"));
    }

    @Test
    public void testGetNodesForNull() {
        EasyMock.expect((Object)this.mockService.getNodesFor((DeviceId)EasyMock.anyObject())).andReturn(null).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.mockService});
        WebTarget wt = this.target();
        Response response = wt.path("mastership/" + this.deviceId1.toString() + "/role").request().get();
        Assert.assertEquals((long)404L, (long)response.getStatus());
    }

    @Test
    public void testGetNodesFor() {
        RoleInfo mockRoleInfo = this.createMockRoleInfo();
        EasyMock.expect((Object)this.mockService.getNodesFor((DeviceId)EasyMock.anyObject())).andReturn((Object)mockRoleInfo).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.mockService});
        WebTarget wt = this.target();
        String response = (String)wt.path("mastership/" + this.deviceId1.toString() + "/role").request().get(String.class);
        JsonObject result = Json.parse((String)response).asObject();
        Assert.assertThat((Object)result, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)result, (Matcher)MastershipResourceTest.matchesRoleInfo(mockRoleInfo));
    }

    @Test
    public void testGetDevicesOf() {
        ImmutableSet deviceIds = ImmutableSet.of((Object)this.deviceId1, (Object)this.deviceId2, (Object)this.deviceId3);
        EasyMock.expect((Object)this.mockService.getDevicesOf((NodeId)EasyMock.anyObject())).andReturn((Object)deviceIds).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.mockService});
        WebTarget wt = this.target();
        String response = (String)wt.path("mastership/" + this.deviceId1.toString() + "/device").request().get(String.class);
        JsonObject result = Json.parse((String)response).asObject();
        Assert.assertThat((Object)result, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)result.names(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat(result.names().get(0), (Matcher)Matchers.is((Object)"deviceIds"));
        JsonArray jsonDevices = result.get("deviceIds").asArray();
        Assert.assertThat((Object)jsonDevices, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)jsonDevices.size(), (Matcher)Matchers.is((Object)3));
    }

    @Test
    public void testRequestRoleFor() {
        EasyMock.expect((Object)this.mockService.requestRoleForSync((DeviceId)EasyMock.anyObject())).andReturn((Object)this.role1).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.mockService});
        EasyMock.expect((Object)this.mockDeviceService.getDevice(this.deviceId1)).andReturn((Object)this.device1);
        EasyMock.replay((Object[])new Object[]{this.mockDeviceService});
        WebTarget wt = this.target();
        String response = (String)wt.path("mastership/" + this.deviceId1.toString() + "/request").request().get(String.class);
        JsonObject result = Json.parse((String)response).asObject();
        Assert.assertThat((Object)result, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)result.names(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat(result.names().get(0), (Matcher)Matchers.is((Object)"role"));
        String role = result.get("role").asString();
        Assert.assertThat((Object)role, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)role, (Matcher)Matchers.is((Object)"MASTER"));
    }

    @Test
    public void testRelinquishMastership() {
        this.mockService.relinquishMastershipSync((DeviceId)EasyMock.anyObject());
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.mockService});
        WebTarget wt = this.target();
        Response response = wt.path("mastership/" + this.deviceId1.toString() + "/relinquish").request().get();
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)201));
        String location = response.getLocation().toString();
        Assert.assertThat((Object)location, (Matcher)Matchers.startsWith((String)this.deviceId1.toString()));
    }

    @Test
    public void testSetRole() {
        this.mockAdminService.setRoleSync((NodeId)EasyMock.anyObject(), (DeviceId)EasyMock.anyObject(), (MastershipRole)EasyMock.anyObject());
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.mockAdminService});
        WebTarget wt = this.target();
        InputStream jsonStream = MetersResourceTest.class.getResourceAsStream("put-set-roles.json");
        Response response = wt.path("mastership").request().put(Entity.json((Object)jsonStream));
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
    }

    @Test
    public void testBalanceRoles() {
        this.mockAdminService.balanceRoles();
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.mockAdminService});
        WebTarget wt = this.target();
        Response response = wt.path("mastership").request().get();
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
    }

    private static final class RoleInfoJsonMatcher
    extends TypeSafeMatcher<JsonObject> {
        private final RoleInfo roleInfo;
        private String reason = "";

        private RoleInfoJsonMatcher(RoleInfo roleInfo) {
            this.roleInfo = roleInfo;
        }

        protected boolean matchesSafely(JsonObject jsonNode) {
            String nodeId;
            String jsonNodeId = jsonNode.get("master") != null ? jsonNode.get("master").asString() : null;
            if (!StringUtils.equals((CharSequence)jsonNodeId, (CharSequence)(nodeId = (String)this.roleInfo.master().id()))) {
                this.reason = "master's node id was " + jsonNodeId;
                return false;
            }
            JsonArray jsonBackupNodeIds = jsonNode.get("backups").asArray();
            if (jsonBackupNodeIds.size() != this.roleInfo.backups().size()) {
                this.reason = "backup nodes size was " + jsonBackupNodeIds.size();
                return false;
            }
            for (NodeId backupNodeId : this.roleInfo.backups()) {
                boolean backupFound = false;
                for (int idx = 0; idx < jsonBackupNodeIds.size(); ++idx) {
                    if (!((String)backupNodeId.id()).equals(jsonBackupNodeIds.get(idx).asString())) continue;
                    backupFound = true;
                    break;
                }
                if (backupFound) continue;
                this.reason = "backup not found " + (String)backupNodeId.id();
                return false;
            }
            return true;
        }

        public void describeTo(Description description) {
            description.appendText(this.reason);
        }
    }
}

