/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.rest.resources;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.google.common.collect.ImmutableSet;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.easymock.EasyMock;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onlab.osgi.ServiceDirectory;
import org.onlab.osgi.TestServiceDirectory;
import org.onosproject.codec.CodecService;
import org.onosproject.codec.impl.CodecManager;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.core.DefaultApplicationId;
import org.onosproject.net.Annotations;
import org.onosproject.net.DefaultDevice;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.NetTestTools;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.meter.Band;
import org.onosproject.net.meter.DefaultBand;
import org.onosproject.net.meter.Meter;
import org.onosproject.net.meter.MeterCellId;
import org.onosproject.net.meter.MeterId;
import org.onosproject.net.meter.MeterRequest;
import org.onosproject.net.meter.MeterService;
import org.onosproject.net.meter.MeterState;
import org.onosproject.rest.resources.ResourceTest;

public class MetersResourceTest
extends ResourceTest {
    final MeterService mockMeterService = (MeterService)EasyMock.createMock(MeterService.class);
    CoreService mockCoreService = (CoreService)EasyMock.createMock(CoreService.class);
    final DeviceService mockDeviceService = (DeviceService)EasyMock.createMock(DeviceService.class);
    final HashMap<DeviceId, Set<Meter>> meters = new HashMap();
    final DeviceId deviceId1 = DeviceId.deviceId((String)"1");
    final DeviceId deviceId2 = DeviceId.deviceId((String)"2");
    final DeviceId deviceId3 = DeviceId.deviceId((String)"3");
    final DeviceId deviceId4 = DeviceId.deviceId((String)"of:0000000000000001");
    final Device device1 = new DefaultDevice(null, this.deviceId1, Device.Type.OTHER, "", "", "", "", null, new Annotations[0]);
    final Device device2 = new DefaultDevice(null, this.deviceId2, Device.Type.OTHER, "", "", "", "", null, new Annotations[0]);
    final Device device4 = new DefaultDevice(null, this.deviceId4, Device.Type.OTHER, "", "", "", "", null, new Annotations[0]);
    final MockMeter meter1 = new MockMeter(this.deviceId1, 1, 111L, 1);
    final MockMeter meter2 = new MockMeter(this.deviceId1, 2, 222L, 2);
    final MockMeter meter3 = new MockMeter(this.deviceId2, 3, 333L, 3);
    final MockMeter meter4 = new MockMeter(this.deviceId2, 4, 444L, 4);
    final MockMeter meter5 = new MockMeter(this.deviceId3, 5, 555L, 5);

    private void setupMockMeters() {
        HashSet<MockMeter> meters1 = new HashSet<MockMeter>();
        meters1.add(this.meter1);
        meters1.add(this.meter2);
        HashSet<MockMeter> meters2 = new HashSet<MockMeter>();
        meters2.add(this.meter3);
        meters2.add(this.meter4);
        this.meters.put(this.deviceId1, meters1);
        this.meters.put(this.deviceId2, meters2);
        HashSet allMeters = new HashSet();
        for (DeviceId deviceId : this.meters.keySet()) {
            allMeters.addAll(this.meters.get(deviceId));
        }
        EasyMock.expect((Object)this.mockMeterService.getAllMeters()).andReturn(allMeters).anyTimes();
    }

    @Before
    public void setUpTest() {
        EasyMock.expect((Object)this.mockDeviceService.getDevice(this.deviceId1)).andReturn((Object)this.device1);
        EasyMock.expect((Object)this.mockDeviceService.getDevice(this.deviceId2)).andReturn((Object)this.device2);
        EasyMock.expect((Object)this.mockDeviceService.getDevice(this.deviceId4)).andReturn((Object)this.device4);
        EasyMock.expect((Object)this.mockDeviceService.getDevices()).andReturn((Object)ImmutableSet.of((Object)this.device1, (Object)this.device2, (Object)this.device4));
        EasyMock.expect((Object)this.mockCoreService.getAppId(Short.valueOf(EasyMock.anyShort()))).andReturn((Object)NetTestTools.APP_ID).anyTimes();
        EasyMock.expect((Object)this.mockCoreService.registerApplication("org.onosproject.rest")).andReturn((Object)NetTestTools.APP_ID).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.mockCoreService});
        CodecManager codecService = new CodecManager();
        codecService.activate();
        TestServiceDirectory testDirectory = new TestServiceDirectory().add(MeterService.class, (Object)this.mockMeterService).add(DeviceService.class, (Object)this.mockDeviceService).add(CodecService.class, (Object)codecService).add(CoreService.class, (Object)this.mockCoreService);
        this.setServiceDirectory((ServiceDirectory)testDirectory);
    }

    @After
    public void tearDownTest() {
        EasyMock.verify((Object[])new Object[]{this.mockMeterService});
        EasyMock.verify((Object[])new Object[]{this.mockCoreService});
    }

    private static MeterJsonMatcher matchesMeter(Meter meter) {
        return new MeterJsonMatcher(meter);
    }

    private static MeterJsonArrayMatcher hasMeter(Meter meter) {
        return new MeterJsonArrayMatcher(meter);
    }

    @Test
    public void testMeterEmptyArray() {
        EasyMock.expect((Object)this.mockMeterService.getAllMeters()).andReturn(null).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.mockMeterService});
        EasyMock.replay((Object[])new Object[]{this.mockDeviceService});
        WebTarget wt = this.target();
        String response = (String)wt.path("meters").request().get(String.class);
        Assert.assertThat((Object)response, (Matcher)Matchers.is((Object)"{\"meters\":[]}"));
    }

    @Test
    public void testMetersPopulatedArray() {
        this.setupMockMeters();
        EasyMock.replay((Object[])new Object[]{this.mockMeterService});
        EasyMock.replay((Object[])new Object[]{this.mockDeviceService});
        WebTarget wt = this.target();
        String response = (String)wt.path("meters").request().get(String.class);
        JsonObject result = Json.parse((String)response).asObject();
        Assert.assertThat((Object)result, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)result.names(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat(result.names().get(0), (Matcher)Matchers.is((Object)"meters"));
        JsonArray jsonMeters = result.get("meters").asArray();
        Assert.assertThat((Object)jsonMeters, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)jsonMeters, (Matcher)MetersResourceTest.hasMeter(this.meter1));
        Assert.assertThat((Object)jsonMeters, (Matcher)MetersResourceTest.hasMeter(this.meter2));
        Assert.assertThat((Object)jsonMeters, (Matcher)MetersResourceTest.hasMeter(this.meter3));
        Assert.assertThat((Object)jsonMeters, (Matcher)MetersResourceTest.hasMeter(this.meter4));
    }

    @Test
    public void testMeterSingleDevice() {
        this.setupMockMeters();
        HashSet<MockMeter> meters1 = new HashSet<MockMeter>();
        meters1.add(this.meter1);
        meters1.add(this.meter2);
        EasyMock.expect((Object)this.mockMeterService.getMeters((DeviceId)EasyMock.anyObject())).andReturn(meters1).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.mockMeterService});
        EasyMock.replay((Object[])new Object[]{this.mockDeviceService});
        WebTarget wt = this.target();
        String response = (String)wt.path("meters/" + this.deviceId1.toString()).request().get(String.class);
        JsonObject result = Json.parse((String)response).asObject();
        Assert.assertThat((Object)result, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)result.names(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat(result.names().get(0), (Matcher)Matchers.is((Object)"meters"));
        JsonArray jsonMeters = result.get("meters").asArray();
        Assert.assertThat((Object)jsonMeters, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)jsonMeters, (Matcher)MetersResourceTest.hasMeter(this.meter1));
        Assert.assertThat((Object)jsonMeters, (Matcher)MetersResourceTest.hasMeter(this.meter2));
    }

    @Test
    public void testMeterSingleDeviceWithId() {
        this.setupMockMeters();
        EasyMock.expect((Object)this.mockMeterService.getMeter((DeviceId)EasyMock.anyObject(), (MeterId)EasyMock.anyObject())).andReturn((Object)this.meter5).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.mockMeterService});
        EasyMock.replay((Object[])new Object[]{this.mockDeviceService});
        WebTarget wt = this.target();
        String response = (String)wt.path("meters/" + this.deviceId3.toString() + "/" + this.meter5.id().id()).request().get(String.class);
        JsonObject result = Json.parse((String)response).asObject();
        Assert.assertThat((Object)result, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)result.names(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat(result.names().get(0), (Matcher)Matchers.is((Object)"meters"));
        JsonArray jsonMeters = result.get("meters").asArray();
        Assert.assertThat((Object)jsonMeters, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)jsonMeters, (Matcher)MetersResourceTest.hasMeter(this.meter5));
    }

    @Test
    public void testMeterByDeviceIdAndMeterId() {
        this.setupMockMeters();
        EasyMock.expect((Object)this.mockMeterService.getMeter((DeviceId)EasyMock.anyObject(), (MeterId)EasyMock.anyObject())).andReturn(null).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.mockMeterService});
        WebTarget wt = this.target();
        Response response = wt.path("meters/" + this.deviceId3.toString() + "/888").request().get();
        Assert.assertEquals((long)404L, (long)response.getStatus());
    }

    @Test
    public void testPost() {
        this.mockMeterService.submit((MeterRequest)EasyMock.anyObject());
        EasyMock.expectLastCall().andReturn((Object)this.meter5).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.mockMeterService});
        EasyMock.replay((Object[])new Object[]{this.mockDeviceService});
        WebTarget wt = this.target();
        InputStream jsonStream = MetersResourceTest.class.getResourceAsStream("post-meter.json");
        Response response = wt.path("meters/of:0000000000000001").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.json((Object)jsonStream));
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)201));
        String location = response.getLocation().getPath();
        Assert.assertThat((Object)location, (Matcher)Matchers.startsWith((String)"/meters/of:0000000000000001/"));
    }

    @Test
    public void testPostWithWrongDevice() {
        this.mockMeterService.submit((MeterRequest)EasyMock.anyObject());
        EasyMock.expectLastCall().andReturn((Object)this.meter5).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.mockMeterService});
        EasyMock.replay((Object[])new Object[]{this.mockDeviceService});
        WebTarget wt = this.target();
        InputStream jsonStream = MetersResourceTest.class.getResourceAsStream("post-meter.json");
        Response response = wt.path("meters/of:0000000000000002").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.json((Object)jsonStream));
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)400));
    }

    @Test
    public void testDelete() {
        this.setupMockMeters();
        EasyMock.expect((Object)this.mockMeterService.getMeter((DeviceId)EasyMock.anyObject(), (MeterId)EasyMock.anyObject())).andReturn((Object)this.meter5).anyTimes();
        this.mockMeterService.withdraw((MeterRequest)EasyMock.anyObject(), (MeterId)EasyMock.anyObject());
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.mockMeterService});
        WebTarget wt = this.target();
        String location = "/meters/3/555";
        Response deleteResponse = wt.path(location).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).delete();
        Assert.assertThat((Object)deleteResponse.getStatus(), (Matcher)Matchers.is((Object)204));
    }

    public static class MeterJsonArrayMatcher
    extends TypeSafeMatcher<JsonArray> {
        private final Meter meter;
        private String reason = "";

        public MeterJsonArrayMatcher(Meter meterValue) {
            this.meter = meterValue;
        }

        protected boolean matchesSafely(JsonArray json) {
            boolean meterFound = false;
            for (int jsonMeterIndex = 0; jsonMeterIndex < json.size(); ++jsonMeterIndex) {
                JsonObject jsonMeter = json.get(jsonMeterIndex).asObject();
                String meterId = this.meter.id().toString();
                String jsonMeterId = jsonMeter.get("id").asString();
                if (!jsonMeterId.equals(meterId)) continue;
                meterFound = true;
                Assert.assertThat((Object)jsonMeter, (Matcher)MetersResourceTest.matchesMeter(this.meter));
            }
            if (!meterFound) {
                this.reason = "Meter with id " + this.meter.id().toString() + " not found";
                return false;
            }
            return true;
        }

        public void describeTo(Description description) {
            description.appendText(this.reason);
        }
    }

    public static class MeterJsonMatcher
    extends TypeSafeMatcher<JsonObject> {
        private final Meter meter;
        private String reason = "";

        public MeterJsonMatcher(Meter meterValue) {
            this.meter = meterValue;
        }

        protected boolean matchesSafely(JsonObject jsonMeter) {
            String appId;
            String jsonAppId = jsonMeter.get("appId").asString();
            if (!jsonAppId.equals(appId = this.meter.appId().name())) {
                this.reason = "appId " + this.meter.appId().name();
                return false;
            }
            String jsonDeviceId = jsonMeter.get("deviceId").asString();
            if (!jsonDeviceId.equals(this.meter.deviceId().toString())) {
                this.reason = "deviceId " + this.meter.deviceId();
                return false;
            }
            if (this.meter.bands() != null) {
                JsonArray jsonBands = jsonMeter.get("bands").asArray();
                if (this.meter.bands().size() != jsonBands.size()) {
                    this.reason = "bands array size of " + Integer.toString(this.meter.bands().size());
                    return false;
                }
                for (Band band : this.meter.bands()) {
                    boolean bandFound = false;
                    for (int bandIndex = 0; bandIndex < jsonBands.size(); ++bandIndex) {
                        String bandType;
                        String jsonType = jsonBands.get(bandIndex).asObject().get("type").asString();
                        if (!jsonType.equals(bandType = band.type().name())) continue;
                        bandFound = true;
                    }
                    if (bandFound) continue;
                    this.reason = "meter band " + band.toString();
                    return false;
                }
            }
            return true;
        }

        public void describeTo(Description description) {
            description.appendText(this.reason);
        }
    }

    private static class MockMeter
    implements Meter {
        final DeviceId deviceId;
        final ApplicationId appId;
        final MeterId meterId;
        final long baseValue;
        final List<Band> bandList;

        public MockMeter(DeviceId deviceId, int appId, long meterId, int id) {
            this.deviceId = deviceId;
            this.appId = new DefaultApplicationId(appId, String.valueOf(appId));
            this.baseValue = (long)id * 200L;
            this.meterId = MeterId.meterId((long)meterId);
            Band band = DefaultBand.builder().ofType(Band.Type.REMARK).withRate(10L).dropPrecedence((short)20).burstSize(30L).build();
            this.bandList = new ArrayList<Band>();
            this.bandList.add(band);
        }

        public DeviceId deviceId() {
            return this.deviceId;
        }

        public MeterId id() {
            return this.meterId;
        }

        public MeterCellId meterCellId() {
            return this.id();
        }

        public ApplicationId appId() {
            return this.appId;
        }

        public Meter.Unit unit() {
            return Meter.Unit.KB_PER_SEC;
        }

        public boolean isBurst() {
            return false;
        }

        public Collection<Band> bands() {
            return this.bandList;
        }

        public MeterState state() {
            return MeterState.ADDED;
        }

        public long life() {
            return this.baseValue + 11L;
        }

        public long referenceCount() {
            return this.baseValue + 22L;
        }

        public long packetsSeen() {
            return this.baseValue + 33L;
        }

        public long bytesSeen() {
            return this.baseValue + 44L;
        }
    }
}

