/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.rest.resources;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.Timer;
import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.google.common.collect.ImmutableMap;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.client.WebTarget;
import org.easymock.EasyMock;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onlab.metrics.MetricsService;
import org.onlab.osgi.ServiceDirectory;
import org.onlab.osgi.TestServiceDirectory;
import org.onosproject.codec.CodecService;
import org.onosproject.codec.impl.CodecManager;
import org.onosproject.rest.resources.ResourceTest;

public class MetricsResourceTest
extends ResourceTest {
    MetricsService mockMetricsService;

    @Before
    public void setUpTest() {
        this.mockMetricsService = (MetricsService)EasyMock.createMock(MetricsService.class);
        CodecManager codecService = new CodecManager();
        codecService.activate();
        TestServiceDirectory testDirectory = new TestServiceDirectory().add(MetricsService.class, (Object)this.mockMetricsService).add(CodecService.class, (Object)codecService);
        this.setServiceDirectory((ServiceDirectory)testDirectory);
    }

    @After
    public void tearDownTest() {
        EasyMock.verify((Object[])new Object[]{this.mockMetricsService});
    }

    @Test
    public void testGetAllMetrics() {
        Counter onosCounter = new Counter();
        onosCounter.inc();
        Meter onosMeter = new Meter();
        onosMeter.mark();
        Timer onosTimer = new Timer();
        onosTimer.update(1L, TimeUnit.MILLISECONDS);
        ImmutableMap metrics = new ImmutableMap.Builder().put((Object)"onosCounter", (Object)onosCounter).put((Object)"onosMeter", (Object)onosMeter).put((Object)"onosTimer", (Object)onosTimer).build();
        EasyMock.expect((Object)this.mockMetricsService.getMetrics()).andReturn((Object)metrics).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.mockMetricsService});
        WebTarget wt = this.target();
        String response = (String)wt.path("metrics").request().get(String.class);
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"{\"metrics\":["));
        JsonObject result = Json.parse((String)response).asObject();
        Assert.assertThat((Object)result, (Matcher)Matchers.notNullValue());
        JsonArray jsonMetrics = result.get("metrics").asArray();
        Assert.assertThat((Object)jsonMetrics, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)jsonMetrics.size(), (Matcher)Matchers.is((Object)3));
        Assert.assertTrue((boolean)MetricsResourceTest.matchesMetric((Metric)metrics.get((Object)"onosCounter")).matchesSafely(jsonMetrics.get(0).asObject()));
        Assert.assertTrue((boolean)MetricsResourceTest.matchesMetric((Metric)metrics.get((Object)"onosMeter")).matchesSafely(jsonMetrics.get(1).asObject()));
        Assert.assertTrue((boolean)MetricsResourceTest.matchesMetric((Metric)metrics.get((Object)"onosTimer")).matchesSafely(jsonMetrics.get(2).asObject()));
    }

    private static MetricJsonMatcher matchesMetric(Metric metric) {
        return new MetricJsonMatcher(metric);
    }

    public static class MetricJsonMatcher
    extends TypeSafeMatcher<JsonObject> {
        private final Metric metric;
        private String reason = "";

        public MetricJsonMatcher(Metric metricValue) {
            this.metric = metricValue;
        }

        public boolean matchesSafely(JsonObject jsonObject) {
            JsonObject jsonMetric = jsonObject.get("metric").asObject();
            if (jsonMetric.get("counter") != null) {
                JsonObject jsonCounter = jsonMetric.get("counter").asObject();
                Counter counter = (Counter)this.metric;
                if (jsonCounter.get("counter").asLong() != counter.getCount()) {
                    this.reason = "counter " + counter.getCount();
                    return false;
                }
            }
            if (jsonMetric.get("meter") != null) {
                JsonObject jsonMeter = jsonMetric.get("meter").asObject();
                Meter meter = (Meter)this.metric;
                if (jsonMeter.get("counter").asLong() != meter.getCount()) {
                    this.reason = "counter " + meter.getCount();
                    return false;
                }
                if (jsonMeter.get("1_min_rate").asDouble() != meter.getOneMinuteRate()) {
                    this.reason = "1 minute rate " + meter.getOneMinuteRate();
                    return false;
                }
                if (jsonMeter.get("5_min_rate").asDouble() != meter.getOneMinuteRate()) {
                    this.reason = "5 minute rate " + meter.getFiveMinuteRate();
                    return false;
                }
                if (jsonMeter.get("15_min_rate").asDouble() != meter.getFifteenMinuteRate()) {
                    this.reason = "15 minute rate " + meter.getFifteenMinuteRate();
                    return false;
                }
            }
            if (jsonMetric.get("timer") != null) {
                JsonObject jsonTimer = jsonMetric.get("timer").asObject();
                Timer timer = (Timer)this.metric;
                if (jsonTimer.get("counter").asLong() != timer.getCount()) {
                    this.reason = "counter " + timer.getCount();
                    return false;
                }
                if (jsonTimer.get("1_min_rate").asDouble() != timer.getOneMinuteRate()) {
                    this.reason = "1 minute rate " + timer.getOneMinuteRate();
                    return false;
                }
                if (jsonTimer.get("5_min_rate").asDouble() != timer.getOneMinuteRate()) {
                    this.reason = "5 minute rate " + timer.getFiveMinuteRate();
                    return false;
                }
                if (jsonTimer.get("15_min_rate").asDouble() != timer.getFifteenMinuteRate()) {
                    this.reason = "15 minute rate " + timer.getFifteenMinuteRate();
                    return false;
                }
                if (jsonTimer.get("mean").asDouble() != this.nanoToMs(timer.getSnapshot().getMean())) {
                    this.reason = "mean " + timer.getSnapshot().getMean();
                    return false;
                }
                if (jsonTimer.get("min").asDouble() != this.nanoToMs(timer.getSnapshot().getMin())) {
                    this.reason = "min " + timer.getSnapshot().getMin();
                    return false;
                }
                if (jsonTimer.get("max").asDouble() != this.nanoToMs(timer.getSnapshot().getMax())) {
                    this.reason = "max " + timer.getSnapshot().getMax();
                    return false;
                }
                if (jsonTimer.get("stddev").asDouble() != this.nanoToMs(timer.getSnapshot().getStdDev())) {
                    this.reason = "stddev " + timer.getSnapshot().getStdDev();
                    return false;
                }
            }
            return true;
        }

        public void describeTo(Description description) {
            description.appendText(this.reason);
        }

        private double nanoToMs(double nano) {
            return nano / 1000000.0;
        }
    }
}

