/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.rest.resources;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.google.common.collect.ImmutableSet;
import java.io.InputStream;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.easymock.EasyMock;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onlab.osgi.ServiceDirectory;
import org.onlab.osgi.TestServiceDirectory;
import org.onlab.packet.IpAddress;
import org.onosproject.codec.CodecService;
import org.onosproject.codec.impl.CodecManager;
import org.onosproject.net.mcast.McastRoute;
import org.onosproject.net.mcast.MulticastRouteService;
import org.onosproject.rest.resources.ResourceTest;

public class MulticastRouteResourceTest
extends ResourceTest {
    final MulticastRouteService mockMulticastRouteService = (MulticastRouteService)EasyMock.createMock(MulticastRouteService.class);
    private McastRoute route1;
    private McastRoute route2;
    private McastRoute route3;

    private void initMcastRouteMocks() {
        IpAddress source1 = IpAddress.valueOf((String)"1.1.1.1");
        IpAddress source2 = IpAddress.valueOf((String)"2.2.2.2");
        IpAddress source3 = IpAddress.valueOf((String)"3.3.3.3");
        IpAddress group = IpAddress.valueOf((String)"224.0.0.1");
        this.route1 = new McastRoute(source1, group, McastRoute.Type.PIM);
        this.route2 = new McastRoute(source2, group, McastRoute.Type.IGMP);
        this.route3 = new McastRoute(source3, group, McastRoute.Type.STATIC);
    }

    @Before
    public void setupTest() {
        CodecManager codecService = new CodecManager();
        codecService.activate();
        TestServiceDirectory testDirectory = new TestServiceDirectory().add(MulticastRouteService.class, (Object)this.mockMulticastRouteService).add(CodecService.class, (Object)codecService);
        this.setServiceDirectory((ServiceDirectory)testDirectory);
    }

    private static McastRouteJsonMatcher matchesMcastRoute(McastRoute route) {
        return new McastRouteJsonMatcher(route);
    }

    private static McastRouteJsonArrayMatcher hasMcastRoute(McastRoute route) {
        return new McastRouteJsonArrayMatcher(route);
    }

    @Test
    public void testMcastRoutePopulatedArray() {
        this.initMcastRouteMocks();
        ImmutableSet mcastRoutes = ImmutableSet.of((Object)this.route1, (Object)this.route2, (Object)this.route3);
        EasyMock.expect((Object)this.mockMulticastRouteService.getRoutes()).andReturn((Object)mcastRoutes).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.mockMulticastRouteService});
        WebTarget wt = this.target();
        String response = (String)wt.path("mcast").request().get(String.class);
        JsonObject result = Json.parse((String)response).asObject();
        Assert.assertThat((Object)result, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)result.names(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat(result.names().get(0), (Matcher)Matchers.is((Object)"routes"));
        JsonArray jsonMcastRoutes = result.get("routes").asArray();
        Assert.assertThat((Object)jsonMcastRoutes, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)jsonMcastRoutes, (Matcher)MulticastRouteResourceTest.hasMcastRoute(this.route1));
        Assert.assertThat((Object)jsonMcastRoutes, (Matcher)MulticastRouteResourceTest.hasMcastRoute(this.route2));
        Assert.assertThat((Object)jsonMcastRoutes, (Matcher)MulticastRouteResourceTest.hasMcastRoute(this.route3));
    }

    @Test
    public void testMcastRoutePost() {
        this.mockMulticastRouteService.add((McastRoute)EasyMock.anyObject());
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.mockMulticastRouteService});
        WebTarget wt = this.target();
        InputStream jsonStream = MulticastRouteResourceTest.class.getResourceAsStream("mcastroute.json");
        Response response = wt.path("mcast/").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.json((Object)jsonStream));
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)201));
        EasyMock.verify((Object[])new Object[]{this.mockMulticastRouteService});
    }

    @Test
    public void testMcastRouteDelete() {
        this.mockMulticastRouteService.remove((McastRoute)EasyMock.anyObject());
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.mockMulticastRouteService});
        WebTarget wt = (WebTarget)this.target().property("jersey.config.client.suppressHttpComplianceValidation", (Object)true);
        InputStream jsonStream = MulticastRouteResourceTest.class.getResourceAsStream("mcastroute.json");
        wt.request().method("DELETE", Entity.json((Object)jsonStream));
    }

    public static class McastRouteJsonArrayMatcher
    extends TypeSafeMatcher<JsonArray> {
        private final McastRoute route;
        private String reason = "";

        public McastRouteJsonArrayMatcher(McastRoute mcastRoute) {
            this.route = mcastRoute;
        }

        protected boolean matchesSafely(JsonArray json) {
            boolean found = false;
            for (int index = 0; index < json.size(); ++index) {
                JsonObject jsonMcastRoute = json.get(index).asObject();
                String source = this.route.source().toString();
                String group = this.route.group().toString();
                String type = this.route.type().toString();
                String jsonSource = jsonMcastRoute.get("source").asString();
                String jsonGroup = jsonMcastRoute.get("group").asString();
                String jsonType = jsonMcastRoute.get("type").asString();
                if (!jsonSource.equals(source) || !jsonGroup.equals(group) || !jsonType.equals(type)) continue;
                found = true;
                Assert.assertThat((Object)jsonMcastRoute, (Matcher)MulticastRouteResourceTest.matchesMcastRoute(this.route));
            }
            return found;
        }

        public void describeTo(Description description) {
            description.appendText(this.reason);
        }
    }

    public static class McastRouteJsonMatcher
    extends TypeSafeMatcher<JsonObject> {
        private final McastRoute route;
        private String reason = "";

        public McastRouteJsonMatcher(McastRoute mcastRoute) {
            this.route = mcastRoute;
        }

        protected boolean matchesSafely(JsonObject jsonMcastRoute) {
            String type;
            String group;
            String source;
            String jsonSource = jsonMcastRoute.get("source").asString();
            if (!jsonSource.equals(source = this.route.source().toString())) {
                this.reason = "Mcast route source was " + jsonSource;
                return false;
            }
            String jsonGroup = jsonMcastRoute.get("group").asString();
            if (!jsonGroup.equals(group = this.route.group().toString())) {
                this.reason = "Mcast route group was " + jsonSource;
                return false;
            }
            String jsonType = jsonMcastRoute.get("type").asString();
            if (!jsonType.equals(type = this.route.type().toString())) {
                this.reason = "Mcast route type was " + jsonSource;
                return false;
            }
            return true;
        }

        public void describeTo(Description description) {
            description.appendText(this.reason);
        }
    }
}

