/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.rest.resources;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableSet;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.easymock.EasyMock;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onlab.osgi.ServiceDirectory;
import org.onlab.osgi.TestServiceDirectory;
import org.onosproject.net.DefaultDevice;
import org.onosproject.net.Device;
import org.onosproject.net.Link;
import org.onosproject.net.config.Config;
import org.onosproject.net.config.NetworkConfigService;
import org.onosproject.net.config.NetworkConfigServiceAdapter;
import org.onosproject.net.config.SubjectFactory;
import org.onosproject.rest.resources.IntentsResourceTest;
import org.onosproject.rest.resources.ResourceTest;

public class NetworkConfigWebResourceTest
extends ResourceTest {
    private MockNetworkConfigService mockNetworkConfigService;
    private final SubjectFactory<Device> mockDevicesSubjectFactory = new SubjectFactory<Device>(Device.class, "devices"){

        public Device createSubject(String subjectKey) {
            DefaultDevice device = (DefaultDevice)EasyMock.createMock(DefaultDevice.class);
            EasyMock.replay((Object[])new Object[]{device});
            return device;
        }

        public Class<Device> subjectClass() {
            return Device.class;
        }
    };
    private final SubjectFactory<Link> mockLinksSubjectFactory = new SubjectFactory<Link>(Link.class, "links"){

        public Link createSubject(String subjectKey) {
            return null;
        }

        public Class<Link> subjectClass() {
            return Link.class;
        }
    };

    @Before
    public void setUpMocks() {
        this.mockNetworkConfigService = new MockNetworkConfigService();
        TestServiceDirectory testDirectory = new TestServiceDirectory().add(NetworkConfigService.class, (Object)this.mockNetworkConfigService);
        this.setServiceDirectory((ServiceDirectory)testDirectory);
    }

    private void setUpConfigData() {
        this.mockNetworkConfigService.devicesSubjects.add("device1");
        this.mockNetworkConfigService.devicesConfigs.add(new MockDeviceConfig("v1", "v2"));
    }

    @Test
    public void testEmptyConfigs() {
        WebTarget wt = this.target();
        String response = (String)wt.path("network/configuration").request().get(String.class);
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"\"devices\":{}"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"\"links\":{}"));
    }

    @Test
    public void testEmptyConfig() {
        WebTarget wt = this.target();
        String response = (String)wt.path("network/configuration/devices").request().get(String.class);
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.is((Object)"{}"));
    }

    @Test
    public void testNonExistentConfig() {
        WebTarget wt = this.target();
        try {
            String response = (String)wt.path("network/configuration/nosuchkey").request().get(String.class);
            Assert.fail((String)("GET of non-existent key does not produce an exception " + response));
        }
        catch (NotFoundException e) {
            MatcherAssert.assertThat((Object)e.getResponse().getStatus(), (Matcher)Matchers.is((Object)404));
        }
    }

    private void checkBasicAttributes(JsonValue basic) {
        Assert.assertThat((Object)basic.asObject().get("field1").asString(), (Matcher)Matchers.is((Object)"v1"));
        Assert.assertThat((Object)basic.asObject().get("field2").asString(), (Matcher)Matchers.is((Object)"v2"));
    }

    @Test
    public void testConfigs() {
        this.setUpConfigData();
        WebTarget wt = this.target();
        String response = (String)wt.path("network/configuration").request().get(String.class);
        JsonObject result = Json.parse((String)response).asObject();
        Assert.assertThat((Object)result, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)result.names(), (Matcher)Matchers.hasSize((int)2));
        JsonValue devices = result.get("devices");
        Assert.assertThat((Object)devices, (Matcher)Matchers.notNullValue());
        JsonValue device1 = devices.asObject().get("device1");
        Assert.assertThat((Object)device1, (Matcher)Matchers.notNullValue());
        JsonValue basic = device1.asObject().get("basic");
        Assert.assertThat((Object)basic, (Matcher)Matchers.notNullValue());
        this.checkBasicAttributes(basic);
    }

    @Test
    public void testSingleSubjectKeyConfig() {
        this.setUpConfigData();
        WebTarget wt = this.target();
        String response = (String)wt.path("network/configuration/devices").request().get(String.class);
        JsonObject result = Json.parse((String)response).asObject();
        Assert.assertThat((Object)result, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)result.names(), (Matcher)Matchers.hasSize((int)1));
        JsonValue device1 = result.asObject().get("device1");
        Assert.assertThat((Object)device1, (Matcher)Matchers.notNullValue());
        JsonValue basic = device1.asObject().get("basic");
        Assert.assertThat((Object)basic, (Matcher)Matchers.notNullValue());
        this.checkBasicAttributes(basic);
    }

    @Test
    public void testSingleSubjectConfig() {
        this.setUpConfigData();
        WebTarget wt = this.target();
        String response = (String)wt.path("network/configuration/devices/device1").request().get(String.class);
        JsonObject result = Json.parse((String)response).asObject();
        Assert.assertThat((Object)result, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)result.names(), (Matcher)Matchers.hasSize((int)1));
        JsonValue basic = result.asObject().get("basic");
        Assert.assertThat((Object)basic, (Matcher)Matchers.notNullValue());
        this.checkBasicAttributes(basic);
    }

    @Test
    public void testSingleSubjectSingleConfig() {
        this.setUpConfigData();
        WebTarget wt = this.target();
        String response = (String)wt.path("network/configuration/devices/device1/basic").request().get(String.class);
        JsonObject result = Json.parse((String)response).asObject();
        Assert.assertThat((Object)result, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)result.names(), (Matcher)Matchers.hasSize((int)2));
        this.checkBasicAttributes((JsonValue)result);
    }

    @Test
    public void testBadPost() {
        String json = "this is invalid!";
        WebTarget wt = this.target();
        Response response = wt.path("network/configuration").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.json((Object)json));
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)400));
    }

    @Test
    public void testPost() {
        InputStream jsonStream = IntentsResourceTest.class.getResourceAsStream("post-config.json");
        WebTarget wt = this.target();
        Response response = wt.path("network/configuration").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.json((Object)jsonStream));
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
    }

    @Test
    public void testBadSyntaxPost() {
        InputStream jsonStream = IntentsResourceTest.class.getResourceAsStream("post-config-bad-syntax.json");
        WebTarget wt = this.target();
        Response response = wt.path("network/configuration").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.json((Object)jsonStream));
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)207));
    }

    class MockNetworkConfigService
    extends NetworkConfigServiceAdapter {
        Set devicesSubjects = new HashSet();
        Set devicesConfigs = new HashSet();
        Set linksSubjects = new HashSet();
        Set linksConfigs = new HashSet();

        MockNetworkConfigService() {
        }

        public Set<Class> getSubjectClasses() {
            return ImmutableSet.of(Device.class, Link.class);
        }

        public SubjectFactory getSubjectFactory(Class subjectClass) {
            if (subjectClass == Device.class) {
                return NetworkConfigWebResourceTest.this.mockDevicesSubjectFactory;
            }
            if (subjectClass == Link.class) {
                return NetworkConfigWebResourceTest.this.mockLinksSubjectFactory;
            }
            return null;
        }

        public SubjectFactory getSubjectFactory(String subjectClassKey) {
            if ("devices".equals(subjectClassKey)) {
                return NetworkConfigWebResourceTest.this.mockDevicesSubjectFactory;
            }
            if ("links".equals(subjectClassKey)) {
                return NetworkConfigWebResourceTest.this.mockLinksSubjectFactory;
            }
            return null;
        }

        public <S> Set<S> getSubjects(Class<S> subjectClass) {
            if (subjectClass == Device.class) {
                return this.devicesSubjects;
            }
            if (subjectClass == Link.class) {
                return this.linksSubjects;
            }
            return null;
        }

        public <S> Set<? extends Config<S>> getConfigs(S subject) {
            if (subject instanceof Device || subject.toString().contains("device")) {
                return this.devicesConfigs;
            }
            if (subject.toString().contains("link")) {
                return this.linksConfigs;
            }
            return null;
        }

        public <S, C extends Config<S>> C getConfig(S subject, Class<C> configClass) {
            if (configClass == MockDeviceConfig.class) {
                return (C)((Config)this.devicesConfigs.toArray()[0]);
            }
            return null;
        }

        public Class<? extends Config> getConfigClass(String subjectClassKey, String configKey) {
            return MockDeviceConfig.class;
        }
    }

    public class MockDeviceConfig
    extends Config<Device> {
        final String field1Value;
        final String field2Value;

        MockDeviceConfig(String value1, String value2) {
            this.field1Value = value1;
            this.field2Value = value2;
        }

        public String key() {
            return "basic";
        }

        public JsonNode node() {
            return new ObjectMapper().createObjectNode().put("field1", this.field1Value).put("field2", this.field2Value);
        }
    }
}

