/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.rest.resources;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.google.common.collect.ImmutableSet;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import javax.ws.rs.client.WebTarget;
import org.easymock.EasyMock;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeDiagnosingMatcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onlab.osgi.ServiceDirectory;
import org.onlab.osgi.TestServiceDirectory;
import org.onosproject.codec.CodecService;
import org.onosproject.codec.impl.CodecManager;
import org.onosproject.net.ElementId;
import org.onosproject.net.Link;
import org.onosproject.net.NetTestTools;
import org.onosproject.net.Path;
import org.onosproject.net.topology.PathService;
import org.onosproject.rest.resources.ResourceTest;

public class PathsResourceTest
extends ResourceTest {
    Path path1 = NetTestTools.createPath((String[])new String[]{"dev1", "dev2"});
    Path path2 = NetTestTools.createPath((String[])new String[]{"dev2", "dev3"});
    Set<Path> paths = ImmutableSet.of((Object)this.path1, (Object)this.path2);
    final PathService mockPathService = (PathService)EasyMock.createMock(PathService.class);

    private PathJsonMatcher matchesPath(Path path) {
        return new PathJsonMatcher(path);
    }

    @Before
    public void setUpTest() {
        CodecManager codecService = new CodecManager();
        codecService.activate();
        TestServiceDirectory testDirectory = new TestServiceDirectory().add(PathService.class, (Object)this.mockPathService).add(CodecService.class, (Object)codecService);
        this.setServiceDirectory((ServiceDirectory)testDirectory);
    }

    @After
    public void tearDownTest() {
        EasyMock.verify((Object[])new Object[]{this.mockPathService});
    }

    private void runTest(ElementId srcElement, ElementId dstElement) throws UnsupportedEncodingException {
        EasyMock.expect((Object)this.mockPathService.getPaths(srcElement, dstElement)).andReturn(this.paths).once();
        EasyMock.replay((Object[])new Object[]{this.mockPathService});
        String srcId = URLEncoder.encode(srcElement.toString(), StandardCharsets.UTF_8.name());
        String dstId = URLEncoder.encode(dstElement.toString(), StandardCharsets.UTF_8.name());
        String url = "paths/" + srcId + "/" + dstId;
        WebTarget wt = this.target();
        String response = (String)wt.path(url).request().get(String.class);
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"{\"paths\":["));
        JsonObject result = Json.parse((String)response).asObject();
        Assert.assertThat((Object)result, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)result.names(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat(result.names().get(0), (Matcher)Matchers.is((Object)"paths"));
        JsonArray jsonPaths = result.get("paths").asArray();
        Assert.assertThat((Object)jsonPaths, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)jsonPaths.size(), (Matcher)Matchers.is((Object)2));
        JsonObject path1Json = jsonPaths.get(0).asObject();
        Assert.assertThat((Object)path1Json, (Matcher)this.matchesPath(this.path1));
        JsonObject path2Json = jsonPaths.get(1).asObject();
        Assert.assertThat((Object)path2Json, (Matcher)this.matchesPath(this.path2));
    }

    @Test
    public void hostToHost() throws UnsupportedEncodingException {
        this.runTest((ElementId)NetTestTools.hid((String)"01:23:45:67:89:AB/2"), (ElementId)NetTestTools.hid((String)"AB:89:67:45:23:01/4"));
    }

    @Test
    public void hostToDevice() throws UnsupportedEncodingException {
        this.runTest((ElementId)NetTestTools.hid((String)"01:23:45:67:89:AB/2"), (ElementId)NetTestTools.did((String)"switch1"));
    }

    @Test
    public void deviceToHost() throws UnsupportedEncodingException {
        this.runTest((ElementId)NetTestTools.did((String)"switch1"), (ElementId)NetTestTools.hid((String)"01:23:45:67:89:AB/2"));
    }

    @Test
    public void deviceToDevice() throws UnsupportedEncodingException {
        this.runTest((ElementId)NetTestTools.did((String)"switch1"), (ElementId)NetTestTools.did((String)"switch2"));
    }

    private final class PathJsonMatcher
    extends TypeSafeDiagnosingMatcher<JsonObject> {
        private final Path path;

        private PathJsonMatcher(Path pathValue) {
            this.path = pathValue;
        }

        public boolean matchesSafely(JsonObject pathJson, Description description) {
            double jsonCost = pathJson.get("cost").asDouble();
            if (jsonCost != this.path.cost()) {
                description.appendText("src device was " + jsonCost);
                return false;
            }
            JsonArray jsonLinks = pathJson.get("links").asArray();
            Assert.assertThat((Object)jsonLinks.size(), (Matcher)Matchers.is((Object)this.path.links().size()));
            for (int linkIndex = 0; linkIndex < jsonLinks.size(); ++linkIndex) {
                Link link = (Link)this.path.links().get(linkIndex);
                JsonObject jsonLink = jsonLinks.get(0).asObject();
                JsonObject jsonLinkSrc = jsonLink.get("src").asObject();
                String srcDevice = jsonLinkSrc.get("device").asString();
                if (!srcDevice.equals(link.src().deviceId().toString())) {
                    description.appendText("src device was " + jsonLinkSrc);
                    return false;
                }
                JsonObject jsonLinkDst = jsonLink.get("dst").asObject();
                String dstDevice = jsonLinkDst.get("device").asString();
                if (dstDevice.equals(link.dst().deviceId().toString())) continue;
                description.appendText("dst device was " + jsonLinkDst);
                return false;
            }
            return true;
        }

        public void describeTo(Description description) {
            description.appendText(this.path.toString());
        }
    }
}

