/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.rest.resources;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.easymock.EasyMock;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onlab.osgi.ServiceDirectory;
import org.onlab.osgi.TestServiceDirectory;
import org.onosproject.cluster.NodeId;
import org.onosproject.codec.CodecService;
import org.onosproject.codec.impl.CodecManager;
import org.onosproject.net.Annotations;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.DeviceId;
import org.onosproject.net.region.Region;
import org.onosproject.net.region.RegionAdminService;
import org.onosproject.net.region.RegionId;
import org.onosproject.net.region.RegionService;
import org.onosproject.rest.resources.ResourceTest;

public class RegionsResourceTest
extends ResourceTest {
    final RegionService mockRegionService = (RegionService)EasyMock.createMock(RegionService.class);
    final RegionAdminService mockRegionAdminService = (RegionAdminService)EasyMock.createMock(RegionAdminService.class);
    final RegionId regionId1 = RegionId.regionId((String)"1");
    final RegionId regionId2 = RegionId.regionId((String)"2");
    final RegionId regionId3 = RegionId.regionId((String)"3");
    final MockRegion region1 = new MockRegion(this.regionId1, "r1", Region.Type.RACK);
    final MockRegion region2 = new MockRegion(this.regionId2, "r2", Region.Type.ROOM);
    final MockRegion region3 = new MockRegion(this.regionId3, "r3", Region.Type.CAMPUS);

    @Before
    public void setupTest() {
        CodecManager codecService = new CodecManager();
        codecService.activate();
        TestServiceDirectory testDirectory = new TestServiceDirectory().add(RegionService.class, (Object)this.mockRegionService).add(RegionAdminService.class, (Object)this.mockRegionAdminService).add(CodecService.class, (Object)codecService);
        this.setServiceDirectory((ServiceDirectory)testDirectory);
    }

    private static RegionJsonMatcher matchesRegion(Region region) {
        return new RegionJsonMatcher(region);
    }

    private static RegionJsonArrayMatcher hasRegion(Region region) {
        return new RegionJsonArrayMatcher(region);
    }

    @Test
    public void testRegionEmptyArray() {
        EasyMock.expect((Object)this.mockRegionService.getRegions()).andReturn((Object)ImmutableSet.of()).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.mockRegionService});
        WebTarget wt = this.target();
        String response = (String)wt.path("regions").request().get(String.class);
        Assert.assertThat((Object)response, (Matcher)Matchers.is((Object)"{\"regions\":[]}"));
        EasyMock.verify((Object[])new Object[]{this.mockRegionService});
    }

    @Test
    public void testRegionsPopulatedArray() {
        ImmutableSet regions = ImmutableSet.of((Object)this.region1, (Object)this.region2, (Object)this.region3);
        EasyMock.expect((Object)this.mockRegionService.getRegions()).andReturn((Object)regions).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.mockRegionService});
        WebTarget wt = this.target();
        String response = (String)wt.path("regions").request().get(String.class);
        JsonObject result = Json.parse((String)response).asObject();
        Assert.assertThat((Object)result, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)result.names(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat(result.names().get(0), (Matcher)Matchers.is((Object)"regions"));
        JsonArray jsonRegions = result.get("regions").asArray();
        Assert.assertThat((Object)jsonRegions, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)jsonRegions, (Matcher)RegionsResourceTest.hasRegion(this.region1));
        Assert.assertThat((Object)jsonRegions, (Matcher)RegionsResourceTest.hasRegion(this.region2));
        Assert.assertThat((Object)jsonRegions, (Matcher)RegionsResourceTest.hasRegion(this.region3));
        EasyMock.verify((Object[])new Object[]{this.mockRegionService});
    }

    @Test
    public void testGetRegionById() {
        EasyMock.expect((Object)this.mockRegionService.getRegion((RegionId)EasyMock.anyObject())).andReturn((Object)this.region1).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.mockRegionService});
        WebTarget wt = this.target();
        String response = (String)wt.path("regions/" + this.regionId1.toString()).request().get(String.class);
        JsonObject result = Json.parse((String)response).asObject();
        Assert.assertThat((Object)result, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)result, (Matcher)RegionsResourceTest.matchesRegion(this.region1));
        EasyMock.verify((Object[])new Object[]{this.mockRegionService});
    }

    @Test
    public void testRegionPost() {
        this.mockRegionAdminService.createRegion((RegionId)EasyMock.anyObject(), (String)EasyMock.anyObject(), (Region.Type)EasyMock.anyObject(), (List)EasyMock.anyObject());
        EasyMock.expectLastCall().andReturn((Object)this.region2).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.mockRegionAdminService});
        WebTarget wt = this.target();
        InputStream jsonStream = RegionsResourceTest.class.getResourceAsStream("post-region.json");
        Response response = wt.path("regions").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.json((Object)jsonStream));
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)201));
        EasyMock.verify((Object[])new Object[]{this.mockRegionAdminService});
    }

    @Test
    public void testRegionPut() {
        this.mockRegionAdminService.updateRegion((RegionId)EasyMock.anyObject(), (String)EasyMock.anyObject(), (Region.Type)EasyMock.anyObject(), (List)EasyMock.anyObject());
        EasyMock.expectLastCall().andReturn((Object)this.region1).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.mockRegionAdminService});
        WebTarget wt = this.target();
        InputStream jsonStream = RegionsResourceTest.class.getResourceAsStream("post-region.json");
        Response response = wt.path("regions/" + this.region1.id().toString()).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).put(Entity.json((Object)jsonStream));
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
        EasyMock.verify((Object[])new Object[]{this.mockRegionAdminService});
    }

    @Test
    public void testRegionDelete() {
        this.mockRegionAdminService.removeRegion((RegionId)EasyMock.anyObject());
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.mockRegionAdminService});
        WebTarget wt = this.target();
        Response response = wt.path("regions/" + this.region1.id().toString()).request().delete();
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)204));
        EasyMock.verify((Object[])new Object[]{this.mockRegionAdminService});
    }

    @Test
    public void testGetRegionDevices() {
        DeviceId deviceId1 = DeviceId.deviceId((String)"1");
        DeviceId deviceId2 = DeviceId.deviceId((String)"2");
        DeviceId deviceId3 = DeviceId.deviceId((String)"3");
        ImmutableSet deviceIds = ImmutableSet.of((Object)deviceId1, (Object)deviceId2, (Object)deviceId3);
        EasyMock.expect((Object)this.mockRegionService.getRegionDevices((RegionId)EasyMock.anyObject())).andReturn((Object)deviceIds).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.mockRegionService});
        WebTarget wt = this.target();
        String response = (String)wt.path("regions/" + this.region1.id().toString() + "/devices").request().get(String.class);
        JsonObject result = Json.parse((String)response).asObject();
        Assert.assertThat((Object)result, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)result.names(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat(result.names().get(0), (Matcher)Matchers.is((Object)"deviceIds"));
        JsonArray jsonDeviceIds = result.get("deviceIds").asArray();
        Assert.assertThat((Object)jsonDeviceIds.size(), (Matcher)Matchers.is((Object)3));
        Assert.assertThat((Object)jsonDeviceIds.get(0).asString(), (Matcher)Matchers.is((Object)"1"));
        Assert.assertThat((Object)jsonDeviceIds.get(1).asString(), (Matcher)Matchers.is((Object)"2"));
        Assert.assertThat((Object)jsonDeviceIds.get(2).asString(), (Matcher)Matchers.is((Object)"3"));
        EasyMock.verify((Object[])new Object[]{this.mockRegionService});
    }

    @Test
    public void testAddDevicesPostWithoutRegion() {
        EasyMock.expect((Object)this.mockRegionService.getRegion((RegionId)EasyMock.anyObject())).andReturn(null).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.mockRegionService});
        WebTarget wt = this.target();
        InputStream jsonStream = RegionsResourceTest.class.getResourceAsStream("region-deviceIds.json");
        Response response = wt.path("regions/" + this.region1.id() + "/devices").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.json((Object)jsonStream));
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)404));
        EasyMock.verify((Object[])new Object[]{this.mockRegionService});
    }

    @Test
    public void testAddDevicesPost() {
        this.mockRegionAdminService.addDevices((RegionId)EasyMock.anyObject(), (Collection)EasyMock.anyObject());
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.mockRegionAdminService});
        EasyMock.expect((Object)this.mockRegionService.getRegion((RegionId)EasyMock.anyObject())).andReturn((Object)this.region1).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.mockRegionService});
        WebTarget wt = this.target();
        InputStream jsonStream = RegionsResourceTest.class.getResourceAsStream("region-deviceIds.json");
        Response response = wt.path("regions/" + this.region1.id().toString() + "/devices").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.json((Object)jsonStream));
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)201));
        EasyMock.verify((Object[])new Object[]{this.mockRegionAdminService});
    }

    @Test
    public void testRemoveDevicesDelete() {
        this.mockRegionAdminService.removeDevices((RegionId)EasyMock.anyObject(), (Collection)EasyMock.anyObject());
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.mockRegionAdminService});
        EasyMock.expect((Object)this.mockRegionService.getRegion((RegionId)EasyMock.anyObject())).andReturn((Object)this.region1).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.mockRegionService});
        WebTarget wt = (WebTarget)this.target().property("jersey.config.client.suppressHttpComplianceValidation", (Object)true);
        InputStream jsonStream = RegionsResourceTest.class.getResourceAsStream("region-deviceIds.json");
        Response response = wt.path("regions/" + this.region1.id().toString() + "/devices").request().method("DELETE", Entity.json((Object)jsonStream));
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)204));
        EasyMock.verify((Object[])new Object[]{this.mockRegionAdminService});
    }

    public static class RegionJsonArrayMatcher
    extends TypeSafeMatcher<JsonArray> {
        private final Region region;
        private String reason = "";

        public RegionJsonArrayMatcher(Region regionValue) {
            this.region = regionValue;
        }

        protected boolean matchesSafely(JsonArray json) {
            boolean regionFound = false;
            for (int jsonRegionIndex = 0; jsonRegionIndex < json.size(); ++jsonRegionIndex) {
                JsonObject jsonRegion = json.get(jsonRegionIndex).asObject();
                String regionId = this.region.id().toString();
                String jsonRegionId = jsonRegion.get("id").asString();
                if (!jsonRegionId.equals(regionId)) continue;
                regionFound = true;
                Assert.assertThat((Object)jsonRegion, (Matcher)RegionsResourceTest.matchesRegion(this.region));
            }
            if (!regionFound) {
                this.reason = "Region with id " + this.region.id().toString() + " not found";
                return false;
            }
            return true;
        }

        public void describeTo(Description description) {
            description.appendText(this.reason);
        }
    }

    public static class RegionJsonMatcher
    extends TypeSafeMatcher<JsonObject> {
        private final Region region;
        private String reason = "";

        public RegionJsonMatcher(Region regionValue) {
            this.region = regionValue;
        }

        protected boolean matchesSafely(JsonObject jsonRegion) {
            String name;
            String type;
            String regionId;
            String jsonRegionId = jsonRegion.get("id").asString();
            if (!jsonRegionId.equals(regionId = this.region.id().toString())) {
                this.reason = "region id was " + jsonRegionId;
                return false;
            }
            String jsonType = jsonRegion.get("type").asString();
            if (!jsonType.equals(type = this.region.type().toString())) {
                this.reason = "type was " + jsonType;
                return false;
            }
            String jsonName = jsonRegion.get("name").asString();
            if (!jsonName.equals(name = this.region.name())) {
                this.reason = "name was " + jsonName;
                return false;
            }
            JsonArray jsonMasters = jsonRegion.get("masters").asArray();
            if (jsonMasters.size() != this.region.masters().size()) {
                this.reason = "masters size was " + jsonMasters.size();
                return false;
            }
            for (Set set : this.region.masters()) {
                boolean masterFound = false;
                for (int masterIndex = 0; masterIndex < jsonMasters.size(); ++masterIndex) {
                    masterFound = this.checkEquality(jsonMasters.get(masterIndex).asArray(), set);
                }
                if (masterFound) continue;
                this.reason = "master not found " + set.toString();
                return false;
            }
            return true;
        }

        public void describeTo(Description description) {
            description.appendText(this.reason);
        }

        private Set<NodeId> jsonToSet(JsonArray nodes) {
            HashSet nodeIds = Sets.newHashSet();
            nodes.forEach(node -> nodeIds.add(NodeId.nodeId((String)node.asString())));
            return nodeIds;
        }

        private boolean checkEquality(JsonArray nodes, Set<NodeId> nodeIds) {
            Set<NodeId> jsonSet = this.jsonToSet(nodes);
            if (jsonSet.size() == nodes.size()) {
                return jsonSet.containsAll(nodeIds);
            }
            return false;
        }
    }

    private static class MockRegion
    implements Region {
        private final RegionId id;
        private final String name;
        private final Region.Type type;
        private final List<Set<NodeId>> masters;

        public MockRegion(RegionId id, String name, Region.Type type) {
            this.id = id;
            this.name = name;
            this.type = type;
            NodeId nodeId1 = NodeId.nodeId((String)"1");
            NodeId nodeId2 = NodeId.nodeId((String)"2");
            NodeId nodeId3 = NodeId.nodeId((String)"3");
            NodeId nodeId4 = NodeId.nodeId((String)"4");
            ImmutableSet nodeIds1 = ImmutableSet.of((Object)nodeId1);
            ImmutableSet nodeIds2 = ImmutableSet.of((Object)nodeId1, (Object)nodeId2);
            ImmutableSet nodeIds3 = ImmutableSet.of((Object)nodeId1, (Object)nodeId2, (Object)nodeId3);
            ImmutableSet nodeIds4 = ImmutableSet.of((Object)nodeId1, (Object)nodeId2, (Object)nodeId3, (Object)nodeId4);
            this.masters = ImmutableList.of((Object)nodeIds1, (Object)nodeIds2, (Object)nodeIds3, (Object)nodeIds4);
        }

        public RegionId id() {
            return this.id;
        }

        public String name() {
            return this.name;
        }

        public Region.Type type() {
            return this.type;
        }

        public List<Set<NodeId>> masters() {
            return this.masters;
        }

        public Annotations annotations() {
            return DefaultAnnotations.EMPTY;
        }
    }
}

