/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.rest.resources;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.stream.IntStream;
import javax.ws.rs.client.WebTarget;
import org.easymock.EasyMock;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onlab.osgi.ServiceDirectory;
import org.onlab.osgi.TestServiceDirectory;
import org.onosproject.codec.CodecService;
import org.onosproject.codec.impl.CodecManager;
import org.onosproject.net.Link;
import org.onosproject.net.NetTestTools;
import org.onosproject.net.link.LinkService;
import org.onosproject.net.statistic.DefaultLoad;
import org.onosproject.net.statistic.StatisticService;
import org.onosproject.rest.resources.ResourceTest;

public class StatisticsResourceTest
extends ResourceTest {
    Link link1 = NetTestTools.link((String)"src1", (int)1, (String)"dst1", (int)1);
    Link link2 = NetTestTools.link((String)"src2", (int)2, (String)"dst2", (int)2);
    Link link3 = NetTestTools.link((String)"src3", (int)3, (String)"dst3", (int)3);
    LinkService mockLinkService;
    StatisticService mockStatisticService;

    @Before
    public void setUpTest() {
        this.mockLinkService = (LinkService)EasyMock.createMock(LinkService.class);
        EasyMock.expect((Object)this.mockLinkService.getLinks()).andReturn((Object)ImmutableList.of((Object)this.link1, (Object)this.link2, (Object)this.link3));
        EasyMock.expect((Object)this.mockLinkService.getLinks(NetTestTools.connectPoint((String)"0000000000000001", (int)2))).andReturn((Object)ImmutableSet.of((Object)this.link3));
        this.mockStatisticService = (StatisticService)EasyMock.createMock(StatisticService.class);
        EasyMock.expect((Object)this.mockStatisticService.load(this.link1)).andReturn((Object)new DefaultLoad(2L, 1L, 1L));
        EasyMock.expect((Object)this.mockStatisticService.load(this.link2)).andReturn((Object)new DefaultLoad(22L, 11L, 1L));
        EasyMock.expect((Object)this.mockStatisticService.load(this.link3)).andReturn((Object)new DefaultLoad(222L, 111L, 1L));
        EasyMock.replay((Object[])new Object[]{this.mockLinkService, this.mockStatisticService});
        CodecManager codecService = new CodecManager();
        codecService.activate();
        TestServiceDirectory testDirectory = new TestServiceDirectory().add(LinkService.class, (Object)this.mockLinkService).add(StatisticService.class, (Object)this.mockStatisticService).add(CodecService.class, (Object)codecService);
        this.setServiceDirectory((ServiceDirectory)testDirectory);
    }

    private void checkValues(JsonObject load, int rate, int latest, boolean valid, String device) throws UnsupportedEncodingException {
        Assert.assertThat((Object)load, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)load.get("rate").asInt(), (Matcher)Matchers.is((Object)rate));
        Assert.assertThat((Object)load.get("latest").asInt(), (Matcher)Matchers.is((Object)latest));
        Assert.assertThat((Object)load.get("valid").asBoolean(), (Matcher)Matchers.is((Object)valid));
        Assert.assertThat((Object)load.get("time").asLong(), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Long.valueOf(System.currentTimeMillis())));
        Assert.assertThat((Object)URLDecoder.decode(load.get("link").asString(), "UTF-8"), (Matcher)Matchers.containsString((String)("device=of:" + device)));
    }

    @Test
    public void testSingleLoadGet() throws UnsupportedEncodingException {
        WebTarget wt = this.target();
        String response = (String)wt.path("statistics/flows/link").queryParam("device", new Object[]{"of:0000000000000001"}).queryParam("port", new Object[]{"2"}).request().get(String.class);
        JsonObject result = Json.parse((String)response).asObject();
        Assert.assertThat((Object)result, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)result.names(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat(result.names().get(0), (Matcher)Matchers.is((Object)"loads"));
        JsonArray jsonLoads = result.get("loads").asArray();
        Assert.assertThat((Object)jsonLoads, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)jsonLoads.size(), (Matcher)Matchers.is((Object)1));
        JsonObject load1 = jsonLoads.get(0).asObject();
        this.checkValues(load1, 111, 222, true, "src3");
    }

    @Test
    public void testLoadsGet() throws UnsupportedEncodingException {
        WebTarget wt = this.target();
        String response = (String)wt.path("statistics/flows/link/").request().get(String.class);
        JsonObject result = Json.parse((String)response).asObject();
        Assert.assertThat((Object)result, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)result.names(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat(result.names().get(0), (Matcher)Matchers.is((Object)"loads"));
        JsonArray jsonLoads = result.get("loads").asArray();
        Assert.assertThat((Object)jsonLoads, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)jsonLoads.size(), (Matcher)Matchers.is((Object)3));
        HashMap currentMap = new HashMap();
        IntStream.range(0, jsonLoads.size()).forEach(index -> currentMap.put(jsonLoads.get(index).asObject().get("latest").asInt(), jsonLoads.get(index).asObject()));
        JsonObject load1 = (JsonObject)currentMap.get(2);
        this.checkValues(load1, 1, 2, true, "src1");
        JsonObject load2 = (JsonObject)currentMap.get(22);
        this.checkValues(load2, 11, 22, true, "src2");
        JsonObject load3 = (JsonObject)currentMap.get(222);
        this.checkValues(load3, 111, 222, true, "src3");
    }
}

