/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.rest.resources;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.google.common.collect.ImmutableSet;
import java.io.InputStream;
import java.util.HashSet;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.easymock.EasyMock;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onlab.osgi.ServiceDirectory;
import org.onlab.osgi.TestServiceDirectory;
import org.onosproject.codec.CodecService;
import org.onosproject.codec.impl.CodecManager;
import org.onosproject.incubator.net.virtual.TenantId;
import org.onosproject.incubator.net.virtual.VirtualNetworkAdminService;
import org.onosproject.rest.resources.ResourceTest;

public class TenantWebResourceTest
extends ResourceTest {
    private final VirtualNetworkAdminService mockVnetAdminService = (VirtualNetworkAdminService)EasyMock.createMock(VirtualNetworkAdminService.class);
    final HashSet<TenantId> tenantIdSet = new HashSet();
    private static final String ID = "id";
    private final TenantId tenantId1 = TenantId.tenantId((String)"TenantId1");
    private final TenantId tenantId2 = TenantId.tenantId((String)"TenantId2");
    private final TenantId tenantId3 = TenantId.tenantId((String)"TenantId3");
    private final TenantId tenantId4 = TenantId.tenantId((String)"TenantId4");

    @Before
    public void setUpTest() {
        CodecManager codecService = new CodecManager();
        codecService.activate();
        TestServiceDirectory testDirectory = new TestServiceDirectory().add(VirtualNetworkAdminService.class, (Object)this.mockVnetAdminService).add(CodecService.class, (Object)codecService);
        this.setServiceDirectory((ServiceDirectory)testDirectory);
    }

    private static TenantIdJsonMatcher matchesTenantId(TenantId tenantId) {
        return new TenantIdJsonMatcher(tenantId);
    }

    private static TenantIdJsonArrayMatcher hasTenantId(TenantId tenantId) {
        return new TenantIdJsonArrayMatcher(tenantId);
    }

    @Test
    public void testGetTenantsEmptyArray() {
        EasyMock.expect((Object)this.mockVnetAdminService.getTenantIds()).andReturn((Object)ImmutableSet.of()).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.mockVnetAdminService});
        WebTarget wt = this.target();
        String response = (String)wt.path("tenants").request().get(String.class);
        Assert.assertThat((Object)response, (Matcher)Matchers.is((Object)"{\"tenants\":[]}"));
        EasyMock.verify((Object[])new Object[]{this.mockVnetAdminService});
    }

    @Test
    public void testGetTenantIdsArray() {
        this.tenantIdSet.add(this.tenantId1);
        this.tenantIdSet.add(this.tenantId2);
        this.tenantIdSet.add(this.tenantId3);
        this.tenantIdSet.add(this.tenantId4);
        EasyMock.expect((Object)this.mockVnetAdminService.getTenantIds()).andReturn(this.tenantIdSet).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.mockVnetAdminService});
        WebTarget wt = this.target();
        String response = (String)wt.path("tenants").request().get(String.class);
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"{\"tenants\":["));
        JsonObject result = Json.parse((String)response).asObject();
        Assert.assertThat((Object)result, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)result.names(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat(result.names().get(0), (Matcher)Matchers.is((Object)"tenants"));
        JsonArray tenantIds = result.get("tenants").asArray();
        Assert.assertThat((Object)tenantIds, (Matcher)Matchers.notNullValue());
        Assert.assertEquals((String)"Device keys array is not the correct size.", (long)this.tenantIdSet.size(), (long)tenantIds.size());
        this.tenantIdSet.forEach(tenantId -> Assert.assertThat((Object)tenantIds, (Matcher)TenantWebResourceTest.hasTenantId(tenantId)));
        EasyMock.verify((Object[])new Object[]{this.mockVnetAdminService});
    }

    @Test
    public void testPost() {
        this.mockVnetAdminService.registerTenantId((TenantId)EasyMock.anyObject());
        this.tenantIdSet.add(this.tenantId2);
        EasyMock.expect((Object)this.mockVnetAdminService.getTenantIds()).andReturn(this.tenantIdSet).anyTimes();
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.mockVnetAdminService});
        WebTarget wt = this.target();
        InputStream jsonStream = TenantWebResourceTest.class.getResourceAsStream("post-tenant.json");
        Response response = wt.path("tenants").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.json((Object)jsonStream));
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)201));
        String location = response.getLocation().getPath();
        Assert.assertThat((Object)location, (Matcher)Matchers.startsWith((String)("/tenants/" + this.tenantId2)));
        EasyMock.verify((Object[])new Object[]{this.mockVnetAdminService});
    }

    @Test
    public void testPostNullTenantId() {
        EasyMock.replay((Object[])new Object[]{this.mockVnetAdminService});
        WebTarget wt = this.target();
        try {
            String response = (String)wt.path("tenants").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.json(null), String.class);
            Assert.fail((String)"POST of null tenant id did not throw an exception");
        }
        catch (BadRequestException ex) {
            Assert.assertThat((Object)ex.getMessage(), (Matcher)Matchers.containsString((String)"HTTP 400 Bad Request"));
        }
        EasyMock.verify((Object[])new Object[]{this.mockVnetAdminService});
    }

    @Test
    public void testDelete() {
        EasyMock.expect((Object)this.mockVnetAdminService.getTenantIds()).andReturn((Object)ImmutableSet.of((Object)this.tenantId2)).anyTimes();
        this.mockVnetAdminService.unregisterTenantId((TenantId)EasyMock.anyObject());
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.mockVnetAdminService});
        WebTarget wt = (WebTarget)this.target().property("jersey.config.client.suppressHttpComplianceValidation", (Object)true);
        Response response = wt.path("tenants/" + this.tenantId2).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).delete();
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)204));
        EasyMock.verify((Object[])new Object[]{this.mockVnetAdminService});
    }

    @Test
    public void testDeleteNonExistentDeviceKey() {
        EasyMock.expect((Object)this.mockVnetAdminService.getTenantIds()).andReturn((Object)ImmutableSet.of()).anyTimes();
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.mockVnetAdminService});
        WebTarget wt = this.target();
        try {
            wt.path("tenants/NON_EXISTENT_TENANT_ID").request().delete(String.class);
            Assert.fail((String)"Delete of a non-existent tenant did not throw an exception");
        }
        catch (NotFoundException ex) {
            Assert.assertThat((Object)ex.getMessage(), (Matcher)Matchers.containsString((String)"HTTP 404 Not Found"));
        }
        EasyMock.verify((Object[])new Object[]{this.mockVnetAdminService});
    }

    public static class TenantIdJsonArrayMatcher
    extends TypeSafeMatcher<JsonArray> {
        private final TenantId tenantId;
        private String reason = "";

        public TenantIdJsonArrayMatcher(TenantId tenantIdValue) {
            this.tenantId = tenantIdValue;
        }

        public boolean matchesSafely(JsonArray json) {
            boolean tenantIdFound = false;
            boolean expectedAttributes = true;
            for (int tenantIdIndex = 0; tenantIdIndex < json.size(); ++tenantIdIndex) {
                JsonObject jsonHost = json.get(tenantIdIndex).asObject();
                if (jsonHost.names().size() < 1) {
                    this.reason = "Found a tenant id with the wrong number of attributes";
                    return false;
                }
                String jsonDeviceKeyId = jsonHost.get(TenantWebResourceTest.ID).asString();
                if (!jsonDeviceKeyId.equals(this.tenantId.id())) continue;
                tenantIdFound = true;
                Assert.assertThat((Object)jsonHost, (Matcher)TenantWebResourceTest.matchesTenantId(this.tenantId));
            }
            if (!tenantIdFound) {
                this.reason = "Tenant id " + (String)this.tenantId.id() + " was not found";
                return false;
            }
            return true;
        }

        public void describeTo(Description description) {
            description.appendText(this.reason);
        }
    }

    public static class TenantIdJsonMatcher
    extends TypeSafeMatcher<JsonObject> {
        private final TenantId tenantId;
        private String reason = "";

        public TenantIdJsonMatcher(TenantId tenantIdValue) {
            this.tenantId = tenantIdValue;
        }

        public boolean matchesSafely(JsonObject jsonHost) {
            String jsonId = jsonHost.get(TenantWebResourceTest.ID).asString();
            if (!jsonId.equals(this.tenantId.id())) {
                this.reason = "id " + (String)this.tenantId.id();
                return false;
            }
            return true;
        }

        public void describeTo(Description description) {
            description.appendText(this.reason);
        }
    }
}

