/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.rest.resources;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.ws.rs.client.WebTarget;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onlab.osgi.ServiceDirectory;
import org.onlab.osgi.TestServiceDirectory;
import org.onosproject.codec.CodecService;
import org.onosproject.codec.impl.CodecManager;
import org.onosproject.net.Annotations;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DefaultPort;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Element;
import org.onosproject.net.Link;
import org.onosproject.net.NetTestTools;
import org.onosproject.net.Port;
import org.onosproject.net.PortNumber;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.device.DeviceServiceAdapter;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.net.topology.ClusterId;
import org.onosproject.net.topology.DefaultTopologyCluster;
import org.onosproject.net.topology.DefaultTopologyVertex;
import org.onosproject.net.topology.Topology;
import org.onosproject.net.topology.TopologyCluster;
import org.onosproject.net.topology.TopologyService;
import org.onosproject.net.topology.TopologyServiceAdapter;
import org.onosproject.net.topology.TopologyVertex;
import org.onosproject.rest.resources.ResourceTest;

public class TopologyResourceTest
extends ResourceTest {
    @Before
    public void setUpTest() {
        MockTopologyService topologyService = new MockTopologyService();
        MockDeviceService mockDeviceService = new MockDeviceService();
        CodecManager codecService = new CodecManager();
        codecService.activate();
        TestServiceDirectory testDirectory = new TestServiceDirectory().add(DeviceService.class, (Object)mockDeviceService).add(TopologyService.class, (Object)topologyService).add(CodecService.class, (Object)codecService);
        this.setServiceDirectory((ServiceDirectory)testDirectory);
    }

    @Test
    public void getTopology() {
        WebTarget wt = this.target();
        String response = (String)wt.path("topology").request().get(String.class);
        JsonObject result = Json.parse((String)response).asObject();
        Assert.assertThat((Object)result, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)result.names(), (Matcher)Matchers.hasSize((int)4));
        Assert.assertThat((Object)result.get("time").asLong(), (Matcher)Matchers.is((Object)11111L));
        Assert.assertThat((Object)result.get("clusters").asLong(), (Matcher)Matchers.is((Object)2L));
        Assert.assertThat((Object)result.get("devices").asLong(), (Matcher)Matchers.is((Object)6L));
        Assert.assertThat((Object)result.get("links").asLong(), (Matcher)Matchers.is((Object)4L));
    }

    @Test
    public void getTopologyClusters() {
        WebTarget wt = this.target();
        String response = (String)wt.path("topology/clusters").request().get(String.class);
        JsonObject result = Json.parse((String)response).asObject();
        Assert.assertThat((Object)result, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)result.names(), (Matcher)Matchers.hasSize((int)1));
        JsonArray clusters = result.get("clusters").asArray();
        Assert.assertThat((Object)clusters, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)clusters.size(), (Matcher)Matchers.is((Object)2));
    }

    @Test
    public void getCluster() {
        WebTarget wt = this.target();
        String response = (String)wt.path("topology/clusters/0").request().get(String.class);
        JsonObject result = Json.parse((String)response).asObject();
        Assert.assertThat((Object)result, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)result.get("id").asLong(), (Matcher)Matchers.is((Object)0L));
        Assert.assertThat((Object)result.get("deviceCount").asLong(), (Matcher)Matchers.is((Object)2L));
        Assert.assertThat((Object)result.get("linkCount").asLong(), (Matcher)Matchers.is((Object)1L));
        Assert.assertThat((Object)result.get("root").asString(), (Matcher)Matchers.containsString((String)"rootnode"));
        Assert.assertThat((Object)result.names(), (Matcher)Matchers.hasSize((int)4));
    }

    @Test
    public void getClusterDevices() {
        WebTarget wt = this.target();
        String response = (String)wt.path("topology/clusters/0/devices").request().get(String.class);
        JsonObject result = Json.parse((String)response).asObject();
        Assert.assertThat((Object)result, (Matcher)Matchers.notNullValue());
        JsonArray devices = result.get("devices").asArray();
        Assert.assertThat((Object)devices.size(), (Matcher)Matchers.is((Object)2));
        Assert.assertThat((Object)devices.get(0).asString(), (Matcher)Matchers.is((Object)"of:dev1"));
        Assert.assertThat((Object)devices.get(1).asString(), (Matcher)Matchers.is((Object)"of:dev2"));
    }

    @Test
    public void getClusterLinks() {
        WebTarget wt = this.target();
        String response = (String)wt.path("topology/clusters/1/links").request().get(String.class);
        JsonObject result = Json.parse((String)response).asObject();
        Assert.assertThat((Object)result, (Matcher)Matchers.notNullValue());
        JsonArray links = result.get("links").asArray();
        Assert.assertThat((Object)links.size(), (Matcher)Matchers.is((Object)3));
        JsonObject link0 = links.get(0).asObject();
        JsonObject src0 = link0.get("src").asObject();
        String device0 = src0.get("device").asString();
        Assert.assertThat((Object)device0, (Matcher)Matchers.is((Object)"of:src1"));
        JsonObject link2 = links.get(2).asObject();
        JsonObject src2 = link2.get("src").asObject();
        String device2 = src2.get("device").asString();
        Assert.assertThat((Object)device2, (Matcher)Matchers.is((Object)"of:src3"));
    }

    @Test
    public void getBroadcast() {
        WebTarget wt = this.target();
        String response = (String)wt.path("topology/broadcast/dev1:1").request().get(String.class);
        JsonObject result = Json.parse((String)response).asObject();
        Assert.assertThat((Object)result, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)result.get("broadcast").asBoolean(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void getInfrastructure() {
        WebTarget wt = this.target();
        String response = (String)wt.path("topology/infrastructure/dev2:1").request().get(String.class);
        JsonObject result = Json.parse((String)response).asObject();
        Assert.assertThat((Object)result, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)result.get("infrastructure").asBoolean(), (Matcher)Matchers.is((Object)true));
    }

    private static class MockDeviceService
    extends DeviceServiceAdapter {
        private MockDeviceService() {
        }

        public Device getDevice(DeviceId deviceId) {
            String deviceId1 = "dev2";
            Device device = NetTestTools.device((String)deviceId1);
            return device;
        }

        public Port getPort(DeviceId deviceId, PortNumber portNumber) {
            String deviceIdString = "dev2";
            Device device = NetTestTools.device((String)deviceIdString);
            DefaultPort port = new DefaultPort((Element)device, PortNumber.portNumber((long)1L), true, new Annotations[0]);
            return port;
        }
    }

    private static class MockTopologyService
    extends TopologyServiceAdapter {
        final DefaultTopologyVertex root = new DefaultTopologyVertex(NetTestTools.did((String)"rootnode"));
        final Topology topology = new MockTopology();
        final TopologyCluster cluster1 = new DefaultTopologyCluster(ClusterId.clusterId((int)0), 2, 1, (TopologyVertex)this.root);
        final TopologyCluster cluster2 = new DefaultTopologyCluster(ClusterId.clusterId((int)1), 4, 3, (TopologyVertex)this.root);

        private MockTopologyService() {
        }

        public Topology currentTopology() {
            return this.topology;
        }

        public Set<TopologyCluster> getClusters(Topology topology) {
            return ImmutableSet.of((Object)this.cluster1, (Object)this.cluster2);
        }

        public TopologyCluster getCluster(Topology topology, ClusterId clusterId) {
            return this.cluster1;
        }

        public Set<DeviceId> getClusterDevices(Topology topology, TopologyCluster cluster) {
            DeviceId device1 = NetTestTools.did((String)"dev1");
            DeviceId device2 = NetTestTools.did((String)"dev2");
            return ImmutableSet.of((Object)device1, (Object)device2);
        }

        public Set<Link> getClusterLinks(Topology topology, TopologyCluster cluster) {
            Link link1 = NetTestTools.link((String)"src1", (int)1, (String)"dst1", (int)1);
            Link link2 = NetTestTools.link((String)"src2", (int)1, (String)"dst2", (int)1);
            Link link3 = NetTestTools.link((String)"src3", (int)1, (String)"dst3", (int)1);
            return ImmutableSet.of((Object)link1, (Object)link2, (Object)link3);
        }

        public boolean isInfrastructure(Topology topology, ConnectPoint connectPoint) {
            return "dev2".equals(connectPoint.elementId().toString());
        }

        public boolean isBroadcastPoint(Topology topology, ConnectPoint connectPoint) {
            return "dev1".equals(connectPoint.elementId().toString());
        }
    }

    private static class MockTopology
    implements Topology {
        private MockTopology() {
        }

        public long time() {
            return 11111L;
        }

        public long creationTime() {
            return 22222L;
        }

        public long computeCost() {
            return 0L;
        }

        public int clusterCount() {
            return 2;
        }

        public int deviceCount() {
            return 6;
        }

        public int linkCount() {
            return 4;
        }

        public ProviderId providerId() {
            return ProviderId.NONE;
        }
    }
}

