/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.rest.resources;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.InputStream;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.easymock.EasyMock;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onlab.osgi.ServiceDirectory;
import org.onlab.osgi.TestServiceDirectory;
import org.onlab.packet.IpAddress;
import org.onlab.packet.MacAddress;
import org.onlab.packet.VlanId;
import org.onosproject.codec.CodecService;
import org.onosproject.codec.impl.CodecManager;
import org.onosproject.incubator.net.virtual.DefaultVirtualDevice;
import org.onosproject.incubator.net.virtual.DefaultVirtualHost;
import org.onosproject.incubator.net.virtual.DefaultVirtualLink;
import org.onosproject.incubator.net.virtual.DefaultVirtualNetwork;
import org.onosproject.incubator.net.virtual.DefaultVirtualPort;
import org.onosproject.incubator.net.virtual.NetworkId;
import org.onosproject.incubator.net.virtual.TenantId;
import org.onosproject.incubator.net.virtual.VirtualDevice;
import org.onosproject.incubator.net.virtual.VirtualHost;
import org.onosproject.incubator.net.virtual.VirtualLink;
import org.onosproject.incubator.net.virtual.VirtualNetwork;
import org.onosproject.incubator.net.virtual.VirtualNetworkAdminService;
import org.onosproject.incubator.net.virtual.VirtualNetworkService;
import org.onosproject.incubator.net.virtual.VirtualPort;
import org.onosproject.net.Annotations;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.DefaultDevice;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.Host;
import org.onosproject.net.HostId;
import org.onosproject.net.HostLocation;
import org.onosproject.net.Link;
import org.onosproject.net.NetTestTools;
import org.onosproject.net.PortNumber;
import org.onosproject.rest.resources.HostResourceTest;
import org.onosproject.rest.resources.LinksResourceTest;
import org.onosproject.rest.resources.ResourceTest;
import org.onosproject.rest.resources.TenantWebResourceTest;

public class VirtualNetworkWebResourceTest
extends ResourceTest {
    private final VirtualNetworkAdminService mockVnetAdminService = (VirtualNetworkAdminService)EasyMock.createMock(VirtualNetworkAdminService.class);
    private final VirtualNetworkService mockVnetService = (VirtualNetworkService)EasyMock.createMock(VirtualNetworkService.class);
    private CodecManager codecService;
    private final HashSet<VirtualDevice> vdevSet = new HashSet();
    private final HashSet<VirtualPort> vportSet = new HashSet();
    private static final String ID = "networkId";
    private static final String TENANT_ID = "tenantId";
    private static final String DEVICE_ID = "deviceId";
    private static final String PORT_NUM = "portNum";
    private static final String PHYS_DEVICE_ID = "physDeviceId";
    private static final String PHYS_PORT_NUM = "physPortNum";
    private final TenantId tenantId2 = TenantId.tenantId((String)"TenantId2");
    private final TenantId tenantId3 = TenantId.tenantId((String)"TenantId3");
    private final TenantId tenantId4 = TenantId.tenantId((String)"TenantId4");
    private final NetworkId networkId1 = NetworkId.networkId((long)1L);
    private final NetworkId networkId2 = NetworkId.networkId((long)2L);
    private final NetworkId networkId3 = NetworkId.networkId((long)3L);
    private final NetworkId networkId4 = NetworkId.networkId((long)4L);
    private final VirtualNetwork vnet1 = new DefaultVirtualNetwork(this.networkId1, this.tenantId3);
    private final VirtualNetwork vnet2 = new DefaultVirtualNetwork(this.networkId2, this.tenantId3);
    private final VirtualNetwork vnet3 = new DefaultVirtualNetwork(this.networkId3, this.tenantId3);
    private final VirtualNetwork vnet4 = new DefaultVirtualNetwork(this.networkId4, this.tenantId3);
    private final DeviceId devId1 = DeviceId.deviceId((String)"devid1");
    private final DeviceId devId2 = DeviceId.deviceId((String)"devid2");
    private final DeviceId devId22 = DeviceId.deviceId((String)"dev22");
    private final VirtualDevice vdev1 = new DefaultVirtualDevice(this.networkId3, this.devId1);
    private final VirtualDevice vdev2 = new DefaultVirtualDevice(this.networkId3, this.devId2);
    private final Device dev1 = NetTestTools.device((String)"dev1");
    private final Device dev2 = NetTestTools.device((String)"dev2");
    private final Device dev22 = NetTestTools.device((String)"dev22");
    private final ConnectPoint cp1 = new ConnectPoint((ElementId)this.dev1.id(), PortNumber.portNumber((long)1L));
    private final ConnectPoint cp2 = new ConnectPoint((ElementId)this.dev2.id(), PortNumber.portNumber((long)2L));
    private final VirtualPort vport22 = new DefaultVirtualPort(this.networkId3, this.dev22, PortNumber.portNumber((long)22L), this.cp1);
    private final VirtualPort vport23 = new DefaultVirtualPort(this.networkId3, this.dev22, PortNumber.portNumber((long)23L), this.cp2);
    private final ConnectPoint cp11 = NetTestTools.connectPoint((String)this.devId1.toString(), (int)21);
    private final ConnectPoint cp21 = NetTestTools.connectPoint((String)this.devId2.toString(), (int)22);
    private final ConnectPoint cp12 = NetTestTools.connectPoint((String)this.devId1.toString(), (int)2);
    private final ConnectPoint cp22 = NetTestTools.connectPoint((String)this.devId2.toString(), (int)22);
    private final VirtualLink vlink1 = DefaultVirtualLink.builder().networkId(this.networkId3).src(this.cp22).dst(this.cp11).build();
    private final VirtualLink vlink2 = DefaultVirtualLink.builder().networkId(this.networkId3).src(this.cp12).dst(this.cp21).build();
    private final MacAddress mac1 = MacAddress.valueOf((String)"00:11:00:00:00:01");
    private final MacAddress mac2 = MacAddress.valueOf((String)"00:22:00:00:00:02");
    private final VlanId vlan1 = VlanId.vlanId((short)11);
    private final VlanId vlan2 = VlanId.vlanId((short)22);
    private final IpAddress ip1 = IpAddress.valueOf((String)"10.0.0.1");
    private final IpAddress ip2 = IpAddress.valueOf((String)"10.0.0.2");
    private final IpAddress ip3 = IpAddress.valueOf((String)"10.0.0.3");
    private final HostId hId1 = HostId.hostId((MacAddress)this.mac1, (VlanId)this.vlan1);
    private final HostId hId2 = HostId.hostId((MacAddress)this.mac2, (VlanId)this.vlan2);
    private final HostLocation loc1 = new HostLocation(this.devId1, PortNumber.portNumber((long)100L), 123L);
    private final HostLocation loc2 = new HostLocation(this.devId2, PortNumber.portNumber((long)200L), 123L);
    private final Set<IpAddress> ipSet1 = Sets.newHashSet((Object[])new IpAddress[]{this.ip1, this.ip2});
    private final Set<IpAddress> ipSet2 = Sets.newHashSet((Object[])new IpAddress[]{this.ip1, this.ip3});
    private final VirtualHost vhost1 = new DefaultVirtualHost(this.networkId1, this.hId1, this.mac1, this.vlan1, this.loc1, this.ipSet1);
    private final VirtualHost vhost2 = new DefaultVirtualHost(this.networkId2, this.hId2, this.mac2, this.vlan2, this.loc2, this.ipSet2);

    @Before
    public void setUpTest() {
        this.codecService = new CodecManager();
        this.codecService.activate();
        TestServiceDirectory testDirectory = new TestServiceDirectory().add(VirtualNetworkAdminService.class, (Object)this.mockVnetAdminService).add(VirtualNetworkService.class, (Object)this.mockVnetService).add(CodecService.class, (Object)this.codecService);
        this.setServiceDirectory((ServiceDirectory)testDirectory);
    }

    private static <T> JsonObjectMatcher matchesVnetEntity(T obj, List<String> jsonFieldNames, BiFunction<T, String, String> getValue) {
        return new JsonObjectMatcher(obj, jsonFieldNames, getValue);
    }

    private VnetJsonArrayMatcher hasVnet(VirtualNetwork vnet) {
        return new VnetJsonArrayMatcher(vnet);
    }

    @Test
    public void testGetVirtualNetworksEmptyArray() {
        EasyMock.expect((Object)this.mockVnetAdminService.getTenantIds()).andReturn((Object)ImmutableSet.of()).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.mockVnetAdminService});
        EasyMock.expect((Object)this.mockVnetService.getVirtualNetworks(this.tenantId4)).andReturn((Object)ImmutableSet.of()).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.mockVnetService});
        WebTarget wt = this.target();
        String response = (String)wt.path("vnets").request().get(String.class);
        Assert.assertThat((Object)response, (Matcher)Matchers.is((Object)"{\"vnets\":[]}"));
        EasyMock.verify((Object[])new Object[]{this.mockVnetService});
        EasyMock.verify((Object[])new Object[]{this.mockVnetAdminService});
    }

    @Test
    public void testGetVirtualNetworksArray() {
        ImmutableSet vnetSet = ImmutableSet.of((Object)this.vnet1, (Object)this.vnet2, (Object)this.vnet3, (Object)this.vnet4);
        EasyMock.expect((Object)this.mockVnetAdminService.getTenantIds()).andReturn((Object)ImmutableSet.of((Object)this.tenantId3)).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.mockVnetAdminService});
        EasyMock.expect((Object)this.mockVnetService.getVirtualNetworks(this.tenantId3)).andReturn((Object)vnetSet).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.mockVnetService});
        WebTarget wt = this.target();
        String response = (String)wt.path("vnets").request().get(String.class);
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"{\"vnets\":["));
        JsonObject result = Json.parse((String)response).asObject();
        Assert.assertThat((Object)result, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)result.names(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat(result.names().get(0), (Matcher)Matchers.is((Object)"vnets"));
        JsonArray vnetJsonArray = result.get("vnets").asArray();
        Assert.assertThat((Object)vnetJsonArray, (Matcher)Matchers.notNullValue());
        Assert.assertEquals((String)"Virtual networks array is not the correct size.", (long)vnetSet.size(), (long)vnetJsonArray.size());
        vnetSet.forEach(vnet -> Assert.assertThat((Object)vnetJsonArray, (Matcher)this.hasVnet((VirtualNetwork)vnet)));
        EasyMock.verify((Object[])new Object[]{this.mockVnetService});
        EasyMock.verify((Object[])new Object[]{this.mockVnetAdminService});
    }

    @Test
    public void testGetVirtualNetworksByTenantId() {
        ImmutableSet vnetSet = ImmutableSet.of((Object)this.vnet1, (Object)this.vnet2, (Object)this.vnet3, (Object)this.vnet4);
        EasyMock.expect((Object)this.mockVnetAdminService.getTenantIds()).andReturn((Object)ImmutableSet.of((Object)this.tenantId3)).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.mockVnetAdminService});
        EasyMock.expect((Object)this.mockVnetService.getVirtualNetworks(this.tenantId3)).andReturn((Object)vnetSet).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.mockVnetService});
        WebTarget wt = this.target();
        String response = (String)wt.path("vnets/" + (String)this.tenantId3.id()).request().get(String.class);
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"{\"vnets\":["));
        JsonObject result = Json.parse((String)response).asObject();
        Assert.assertThat((Object)result, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)result.names(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat(result.names().get(0), (Matcher)Matchers.is((Object)"vnets"));
        JsonArray vnetJsonArray = result.get("vnets").asArray();
        Assert.assertThat((Object)vnetJsonArray, (Matcher)Matchers.notNullValue());
        Assert.assertEquals((String)"Virtual networks array is not the correct size.", (long)vnetSet.size(), (long)vnetJsonArray.size());
        vnetSet.forEach(vnet -> Assert.assertThat((Object)vnetJsonArray, (Matcher)this.hasVnet((VirtualNetwork)vnet)));
        EasyMock.verify((Object[])new Object[]{this.mockVnetService});
        EasyMock.verify((Object[])new Object[]{this.mockVnetAdminService});
    }

    @Test
    public void testGetVirtualNetworksByNonExistentTenantId() {
        String tenantIdName = "NON_EXISTENT_TENANT_ID";
        EasyMock.expect((Object)this.mockVnetAdminService.getTenantIds()).andReturn((Object)ImmutableSet.of((Object)this.tenantId3)).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.mockVnetAdminService});
        EasyMock.expect((Object)this.mockVnetService.getVirtualNetworks((TenantId)EasyMock.anyObject())).andReturn((Object)ImmutableSet.of()).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.mockVnetService});
        WebTarget wt = this.target();
        try {
            wt.path("vnets/" + tenantIdName).request().get(String.class);
            Assert.fail((String)"Get of a non-existent virtual network did not throw an exception");
        }
        catch (NotFoundException ex) {
            Assert.assertThat((Object)ex.getMessage(), (Matcher)Matchers.containsString((String)"HTTP 404 Not Found"));
        }
        EasyMock.verify((Object[])new Object[]{this.mockVnetService});
        EasyMock.verify((Object[])new Object[]{this.mockVnetAdminService});
    }

    @Test
    public void testPostVirtualNetwork() {
        EasyMock.expect((Object)this.mockVnetAdminService.createVirtualNetwork(this.tenantId2)).andReturn((Object)this.vnet1);
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.mockVnetAdminService});
        WebTarget wt = this.target();
        InputStream jsonStream = TenantWebResourceTest.class.getResourceAsStream("post-tenant.json");
        Response response = wt.path("vnets").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.json((Object)jsonStream));
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)201));
        String location = response.getLocation().getPath();
        Assert.assertThat((Object)location, (Matcher)Matchers.startsWith((String)("/vnets/" + this.vnet1.id().toString())));
        EasyMock.verify((Object[])new Object[]{this.mockVnetAdminService});
    }

    @Test
    public void testPostVirtualNetworkNullTenantId() {
        EasyMock.replay((Object[])new Object[]{this.mockVnetAdminService});
        WebTarget wt = this.target();
        try {
            wt.path("vnets").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.json(null), String.class);
            Assert.fail((String)"POST of null virtual network did not throw an exception");
        }
        catch (BadRequestException ex) {
            Assert.assertThat((Object)ex.getMessage(), (Matcher)Matchers.containsString((String)"HTTP 400 Bad Request"));
        }
        EasyMock.verify((Object[])new Object[]{this.mockVnetAdminService});
    }

    @Test
    public void testDeleteVirtualNetwork() {
        this.mockVnetAdminService.removeVirtualNetwork((NetworkId)EasyMock.anyObject());
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.mockVnetAdminService});
        WebTarget wt = (WebTarget)this.target().property("jersey.config.client.suppressHttpComplianceValidation", (Object)true);
        Response response = wt.path("vnets/2").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).delete();
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)204));
        EasyMock.verify((Object[])new Object[]{this.mockVnetAdminService});
    }

    @Test
    public void testDeleteNetworkNonExistentNetworkId() {
        EasyMock.expect((Object)this.mockVnetAdminService.getTenantIds()).andReturn((Object)ImmutableSet.of()).anyTimes();
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.mockVnetAdminService});
        WebTarget wt = this.target();
        try {
            wt.path("vnets/NON_EXISTENT_NETWORK_ID").request().delete(String.class);
            Assert.fail((String)"Delete of a non-existent virtual network did not throw an exception");
        }
        catch (NotFoundException ex) {
            Assert.assertThat((Object)ex.getMessage(), (Matcher)Matchers.containsString((String)"HTTP 404 Not Found"));
        }
        EasyMock.verify((Object[])new Object[]{this.mockVnetAdminService});
    }

    @Test
    public void testGetVirtualDevicesEmptyArray() {
        NetworkId networkId = this.networkId4;
        EasyMock.expect((Object)this.mockVnetService.getVirtualDevices(networkId)).andReturn((Object)ImmutableSet.of()).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.mockVnetService});
        WebTarget wt = this.target();
        String location = "vnets/" + networkId.toString() + "/devices";
        String response = (String)wt.path(location).request().get(String.class);
        Assert.assertThat((Object)response, (Matcher)Matchers.is((Object)"{\"devices\":[]}"));
        EasyMock.verify((Object[])new Object[]{this.mockVnetService});
    }

    @Test
    public void testGetVirtualDevicesArray() {
        NetworkId networkId = this.networkId3;
        this.vdevSet.add(this.vdev1);
        this.vdevSet.add(this.vdev2);
        EasyMock.expect((Object)this.mockVnetService.getVirtualDevices(networkId)).andReturn(this.vdevSet).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.mockVnetService});
        WebTarget wt = this.target();
        String location = "vnets/" + networkId.toString() + "/devices";
        String response = (String)wt.path(location).request().get(String.class);
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"{\"devices\":["));
        JsonObject result = Json.parse((String)response).asObject();
        Assert.assertThat((Object)result, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)result.names(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat(result.names().get(0), (Matcher)Matchers.is((Object)"devices"));
        JsonArray vnetJsonArray = result.get("devices").asArray();
        Assert.assertThat((Object)vnetJsonArray, (Matcher)Matchers.notNullValue());
        Assert.assertEquals((String)"Virtual devices array is not the correct size.", (long)this.vdevSet.size(), (long)vnetJsonArray.size());
        this.vdevSet.forEach(vdev -> Assert.assertThat((Object)vnetJsonArray, (Matcher)this.hasVdev((VirtualDevice)vdev)));
        EasyMock.verify((Object[])new Object[]{this.mockVnetService});
    }

    private VdevJsonArrayMatcher hasVdev(VirtualDevice vdev) {
        return new VdevJsonArrayMatcher(vdev);
    }

    @Test
    public void testPostVirtualDevice() {
        NetworkId networkId = this.networkId3;
        DeviceId deviceId = this.devId2;
        EasyMock.expect((Object)this.mockVnetAdminService.createVirtualDevice(networkId, deviceId)).andReturn((Object)this.vdev2);
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.mockVnetAdminService});
        WebTarget wt = this.target();
        InputStream jsonStream = VirtualNetworkWebResourceTest.class.getResourceAsStream("post-virtual-device.json");
        String reqLocation = "vnets/" + networkId.toString() + "/devices";
        Response response = wt.path(reqLocation).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.json((Object)jsonStream));
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)201));
        String location = response.getLocation().getPath();
        Assert.assertThat((Object)location, (Matcher)Matchers.startsWith((String)("/" + reqLocation + "/" + this.vdev2.id().toString())));
        EasyMock.verify((Object[])new Object[]{this.mockVnetAdminService});
    }

    @Test
    public void testPostVirtualDeviceNullJsonStream() {
        NetworkId networkId = this.networkId3;
        EasyMock.replay((Object[])new Object[]{this.mockVnetAdminService});
        WebTarget wt = this.target();
        try {
            String reqLocation = "vnets/" + networkId.toString() + "/devices";
            wt.path(reqLocation).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.json(null), String.class);
            Assert.fail((String)"POST of null virtual device did not throw an exception");
        }
        catch (BadRequestException ex) {
            Assert.assertThat((Object)ex.getMessage(), (Matcher)Matchers.containsString((String)"HTTP 400 Bad Request"));
        }
        EasyMock.verify((Object[])new Object[]{this.mockVnetAdminService});
    }

    @Test
    public void testDeleteVirtualDevice() {
        NetworkId networkId = this.networkId3;
        DeviceId deviceId = this.devId2;
        this.mockVnetAdminService.removeVirtualDevice(networkId, deviceId);
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.mockVnetAdminService});
        WebTarget wt = (WebTarget)this.target().property("jersey.config.client.suppressHttpComplianceValidation", (Object)true);
        String reqLocation = "vnets/" + networkId.toString() + "/devices/" + deviceId.toString();
        Response response = wt.path(reqLocation).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).delete();
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)204));
        EasyMock.verify((Object[])new Object[]{this.mockVnetAdminService});
    }

    @Test
    public void testGetVirtualPortsEmptyArray() {
        NetworkId networkId = this.networkId4;
        DeviceId deviceId = this.devId2;
        EasyMock.expect((Object)this.mockVnetService.getVirtualPorts(networkId, deviceId)).andReturn((Object)ImmutableSet.of()).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.mockVnetService});
        WebTarget wt = this.target();
        String location = "vnets/" + networkId.toString() + "/devices/" + deviceId.toString() + "/ports";
        String response = (String)wt.path(location).request().get(String.class);
        Assert.assertThat((Object)response, (Matcher)Matchers.is((Object)"{\"ports\":[]}"));
        EasyMock.verify((Object[])new Object[]{this.mockVnetService});
    }

    @Test
    public void testGetVirtualPortsArray() {
        NetworkId networkId = this.networkId3;
        DeviceId deviceId = this.dev22.id();
        this.vportSet.add(this.vport23);
        this.vportSet.add(this.vport22);
        EasyMock.expect((Object)this.mockVnetService.getVirtualPorts(networkId, deviceId)).andReturn(this.vportSet).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.mockVnetService});
        WebTarget wt = this.target();
        String location = "vnets/" + networkId.toString() + "/devices/" + deviceId.toString() + "/ports";
        String response = (String)wt.path(location).request().get(String.class);
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"{\"ports\":["));
        JsonObject result = Json.parse((String)response).asObject();
        Assert.assertThat((Object)result, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)result.names(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat(result.names().get(0), (Matcher)Matchers.is((Object)"ports"));
        JsonArray vnetJsonArray = result.get("ports").asArray();
        Assert.assertThat((Object)vnetJsonArray, (Matcher)Matchers.notNullValue());
        Assert.assertEquals((String)"Virtual ports array is not the correct size.", (long)this.vportSet.size(), (long)vnetJsonArray.size());
        this.vportSet.forEach(vport -> Assert.assertThat((Object)vnetJsonArray, (Matcher)this.hasVport((VirtualPort)vport)));
        EasyMock.verify((Object[])new Object[]{this.mockVnetService});
    }

    private VportJsonArrayMatcher hasVport(VirtualPort vport) {
        return new VportJsonArrayMatcher(vport);
    }

    @Test
    public void testPostVirtualPort() {
        NetworkId networkId = this.networkId3;
        DeviceId deviceId = this.devId22;
        DefaultAnnotations annotations = DefaultAnnotations.builder().build();
        DefaultDevice physDevice = new DefaultDevice(null, DeviceId.deviceId((String)"dev1"), null, null, null, null, null, null, new Annotations[]{annotations});
        ConnectPoint cp1 = new ConnectPoint((ElementId)physDevice.id(), PortNumber.portNumber((long)1L));
        EasyMock.expect((Object)this.mockVnetAdminService.createVirtualPort(networkId, deviceId, PortNumber.portNumber((long)22L), cp1)).andReturn((Object)this.vport22);
        EasyMock.replay((Object[])new Object[]{this.mockVnetAdminService});
        WebTarget wt = this.target();
        InputStream jsonStream = VirtualNetworkWebResourceTest.class.getResourceAsStream("post-virtual-port.json");
        String reqLocation = "vnets/" + networkId.toString() + "/devices/" + deviceId.toString() + "/ports";
        Response response = wt.path(reqLocation).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.json((Object)jsonStream));
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)201));
        EasyMock.verify((Object[])new Object[]{this.mockVnetAdminService});
    }

    @Test
    public void testPostVirtualPortNullJsonStream() {
        NetworkId networkId = this.networkId3;
        DeviceId deviceId = this.devId2;
        EasyMock.replay((Object[])new Object[]{this.mockVnetAdminService});
        WebTarget wt = this.target();
        try {
            String reqLocation = "vnets/" + networkId.toString() + "/devices/" + deviceId.toString() + "/ports";
            wt.path(reqLocation).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.json(null), String.class);
            Assert.fail((String)"POST of null virtual port did not throw an exception");
        }
        catch (BadRequestException ex) {
            Assert.assertThat((Object)ex.getMessage(), (Matcher)Matchers.containsString((String)"HTTP 400 Bad Request"));
        }
        EasyMock.verify((Object[])new Object[]{this.mockVnetAdminService});
    }

    @Test
    public void testDeleteVirtualPort() {
        NetworkId networkId = this.networkId3;
        DeviceId deviceId = this.devId2;
        PortNumber portNum = PortNumber.portNumber((long)2L);
        this.mockVnetAdminService.removeVirtualPort(networkId, deviceId, portNum);
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.mockVnetAdminService});
        WebTarget wt = (WebTarget)this.target().property("jersey.config.client.suppressHttpComplianceValidation", (Object)true);
        String reqLocation = "vnets/" + networkId.toString() + "/devices/" + deviceId.toString() + "/ports/" + portNum.toLong();
        Response response = wt.path(reqLocation).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).delete();
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)204));
        EasyMock.verify((Object[])new Object[]{this.mockVnetAdminService});
    }

    @Test
    public void testGetVirtualLinksEmptyArray() {
        NetworkId networkId = this.networkId4;
        EasyMock.expect((Object)this.mockVnetService.getVirtualLinks(networkId)).andReturn((Object)ImmutableSet.of()).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.mockVnetService});
        WebTarget wt = this.target();
        String location = "vnets/" + networkId.toString() + "/links";
        String response = (String)wt.path(location).request().get(String.class);
        Assert.assertThat((Object)response, (Matcher)Matchers.is((Object)"{\"links\":[]}"));
        EasyMock.verify((Object[])new Object[]{this.mockVnetService});
    }

    @Test
    public void testGetVirtualLinksArray() {
        NetworkId networkId = this.networkId3;
        ImmutableSet vlinkSet = ImmutableSet.of((Object)this.vlink1, (Object)this.vlink2);
        EasyMock.expect((Object)this.mockVnetService.getVirtualLinks(networkId)).andReturn((Object)vlinkSet).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.mockVnetService});
        WebTarget wt = this.target();
        String location = "vnets/" + networkId.toString() + "/links";
        String response = (String)wt.path(location).request().get(String.class);
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"{\"links\":["));
        JsonObject result = Json.parse((String)response).asObject();
        Assert.assertThat((Object)result, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)result.names(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat(result.names().get(0), (Matcher)Matchers.is((Object)"links"));
        JsonArray vnetJsonArray = result.get("links").asArray();
        Assert.assertThat((Object)vnetJsonArray, (Matcher)Matchers.notNullValue());
        Assert.assertEquals((String)"Virtual links array is not the correct size.", (long)vlinkSet.size(), (long)vnetJsonArray.size());
        vlinkSet.forEach(vlink -> Assert.assertThat((Object)vnetJsonArray, (Matcher)this.hasVlink((VirtualLink)vlink)));
        EasyMock.verify((Object[])new Object[]{this.mockVnetService});
    }

    private static VirtualLinkJsonMatcher matchesVirtualLink(VirtualLink vlink) {
        return new VirtualLinkJsonMatcher(vlink);
    }

    private VirtualLinkJsonArrayMatcher hasVlink(VirtualLink vlink) {
        return new VirtualLinkJsonArrayMatcher(vlink);
    }

    @Test
    public void testPostVirtualLink() {
        NetworkId networkId = this.networkId3;
        EasyMock.expect((Object)this.mockVnetAdminService.createVirtualLink(networkId, this.cp22, this.cp11)).andReturn((Object)this.vlink1);
        EasyMock.replay((Object[])new Object[]{this.mockVnetAdminService});
        WebTarget wt = this.target();
        InputStream jsonStream = VirtualNetworkWebResourceTest.class.getResourceAsStream("post-virtual-link.json");
        String reqLocation = "vnets/" + networkId.toString() + "/links";
        Response response = wt.path(reqLocation).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.json((Object)jsonStream));
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)201));
        String location = response.getLocation().getPath();
        Assert.assertThat((Object)location, (Matcher)Matchers.startsWith((String)("/" + reqLocation)));
        EasyMock.verify((Object[])new Object[]{this.mockVnetAdminService});
    }

    @Test
    public void testPostVirtualLinkNullJsonStream() {
        NetworkId networkId = this.networkId3;
        EasyMock.replay((Object[])new Object[]{this.mockVnetAdminService});
        WebTarget wt = this.target();
        try {
            String reqLocation = "vnets/" + networkId.toString() + "/links";
            wt.path(reqLocation).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.json(null), String.class);
            Assert.fail((String)"POST of null virtual link did not throw an exception");
        }
        catch (BadRequestException ex) {
            Assert.assertThat((Object)ex.getMessage(), (Matcher)Matchers.containsString((String)"HTTP 400 Bad Request"));
        }
        EasyMock.verify((Object[])new Object[]{this.mockVnetAdminService});
    }

    @Test
    public void testDeleteVirtualLink() {
        NetworkId networkId = this.networkId3;
        this.mockVnetAdminService.removeVirtualLink(networkId, this.cp22, this.cp11);
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.mockVnetAdminService});
        WebTarget wt = (WebTarget)this.target().property("jersey.config.client.suppressHttpComplianceValidation", (Object)true);
        InputStream jsonStream = VirtualNetworkWebResourceTest.class.getResourceAsStream("post-virtual-link.json");
        String reqLocation = "vnets/" + networkId.toString() + "/links";
        Response response = wt.path(reqLocation).request().method("DELETE", Entity.json((Object)jsonStream));
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)204));
        EasyMock.verify((Object[])new Object[]{this.mockVnetAdminService});
    }

    @Test
    public void testGetVirtualHostsEmptyArray() {
        NetworkId networkId = this.networkId4;
        EasyMock.expect((Object)this.mockVnetService.getVirtualHosts(networkId)).andReturn((Object)ImmutableSet.of()).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.mockVnetService});
        WebTarget wt = this.target();
        String location = "vnets/" + networkId.toString() + "/hosts";
        String response = (String)wt.path(location).request().get(String.class);
        Assert.assertThat((Object)response, (Matcher)Matchers.is((Object)"{\"hosts\":[]}"));
        EasyMock.verify((Object[])new Object[]{this.mockVnetService});
    }

    @Test
    public void testGetVirtualHostsArray() {
        NetworkId networkId = this.networkId3;
        ImmutableSet vhostSet = ImmutableSet.of((Object)this.vhost1, (Object)this.vhost2);
        EasyMock.expect((Object)this.mockVnetService.getVirtualHosts(networkId)).andReturn((Object)vhostSet).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.mockVnetService});
        WebTarget wt = this.target();
        String location = "vnets/" + networkId.toString() + "/hosts";
        String response = (String)wt.path(location).request().get(String.class);
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"{\"hosts\":["));
        JsonObject result = Json.parse((String)response).asObject();
        Assert.assertThat((Object)result, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)result.names(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat(result.names().get(0), (Matcher)Matchers.is((Object)"hosts"));
        JsonArray vnetJsonArray = result.get("hosts").asArray();
        Assert.assertThat((Object)vnetJsonArray, (Matcher)Matchers.notNullValue());
        Assert.assertEquals((String)"Virtual hosts array is not the correct size.", (long)vhostSet.size(), (long)vnetJsonArray.size());
        vhostSet.forEach(vhost -> Assert.assertThat((Object)vnetJsonArray, (Matcher)this.hasVhost((VirtualHost)vhost)));
        EasyMock.verify((Object[])new Object[]{this.mockVnetService});
    }

    private static VirtualHostJsonMatcher matchesVirtualHost(VirtualHost vhost) {
        return new VirtualHostJsonMatcher(vhost);
    }

    private VirtualHostJsonArrayMatcher hasVhost(VirtualHost vhost) {
        return new VirtualHostJsonArrayMatcher(vhost);
    }

    @Test
    public void testPostVirtualHost() {
        NetworkId networkId = this.networkId3;
        EasyMock.expect((Object)this.mockVnetAdminService.createVirtualHost(networkId, this.hId1, this.mac1, this.vlan1, this.loc1, this.ipSet1)).andReturn((Object)this.vhost1);
        EasyMock.replay((Object[])new Object[]{this.mockVnetAdminService});
        WebTarget wt = this.target();
        InputStream jsonStream = VirtualNetworkWebResourceTest.class.getResourceAsStream("post-virtual-host.json");
        String reqLocation = "vnets/" + networkId.toString() + "/hosts";
        Response response = wt.path(reqLocation).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.json((Object)jsonStream));
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)201));
        String location = response.getLocation().getPath();
        Assert.assertThat((Object)location, (Matcher)Matchers.startsWith((String)("/" + reqLocation)));
        EasyMock.verify((Object[])new Object[]{this.mockVnetAdminService});
    }

    @Test
    public void testPostVirtualHostNullJsonStream() {
        NetworkId networkId = this.networkId3;
        EasyMock.replay((Object[])new Object[]{this.mockVnetAdminService});
        WebTarget wt = this.target();
        try {
            String reqLocation = "vnets/" + networkId.toString() + "/hosts";
            wt.path(reqLocation).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.json(null), String.class);
            Assert.fail((String)"POST of null virtual host did not throw an exception");
        }
        catch (BadRequestException ex) {
            Assert.assertThat((Object)ex.getMessage(), (Matcher)Matchers.containsString((String)"HTTP 400 Bad Request"));
        }
        EasyMock.verify((Object[])new Object[]{this.mockVnetAdminService});
    }

    @Test
    public void testDeleteVirtualHost() {
        NetworkId networkId = this.networkId3;
        this.mockVnetAdminService.removeVirtualHost(networkId, this.hId1);
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.mockVnetAdminService});
        WebTarget wt = (WebTarget)this.target().property("jersey.config.client.suppressHttpComplianceValidation", (Object)true);
        InputStream jsonStream = VirtualNetworkWebResourceTest.class.getResourceAsStream("post-virtual-host.json");
        String reqLocation = "vnets/" + networkId.toString() + "/hosts";
        Response response = wt.path(reqLocation).request().method("DELETE", Entity.json((Object)jsonStream));
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)204));
        EasyMock.verify((Object[])new Object[]{this.mockVnetAdminService});
    }

    private static final class VirtualHostJsonArrayMatcher
    extends TypeSafeMatcher<JsonArray> {
        private final VirtualHost vhost;
        private String reason = "";

        private VirtualHostJsonArrayMatcher(VirtualHost vhostValue) {
            this.vhost = vhostValue;
        }

        public boolean matchesSafely(JsonArray json) {
            for (int jsonHostIndex = 0; jsonHostIndex < json.size(); ++jsonHostIndex) {
                JsonObject jsonHost = json.get(jsonHostIndex).asObject();
                if (!VirtualNetworkWebResourceTest.matchesVirtualHost(this.vhost).matchesSafely(jsonHost)) continue;
                return true;
            }
            return false;
        }

        public void describeTo(Description description) {
            description.appendText(this.reason);
        }
    }

    private static final class VirtualHostJsonMatcher
    extends HostResourceTest.HostJsonMatcher {
        private final VirtualHost vhost;
        private String reason = "";

        private VirtualHostJsonMatcher(VirtualHost vhostValue) {
            super((Host)vhostValue);
            this.vhost = vhostValue;
        }

        @Override
        public boolean matchesSafely(JsonObject jsonHost) {
            String networkId;
            if (!super.matchesSafely(jsonHost)) {
                return false;
            }
            String jsonNetworkId = jsonHost.get(VirtualNetworkWebResourceTest.ID).asString();
            if (!jsonNetworkId.equals(networkId = this.vhost.networkId().toString())) {
                this.reason = "networkId was " + jsonNetworkId;
                return false;
            }
            return true;
        }

        @Override
        public void describeTo(Description description) {
            description.appendText(this.reason);
        }
    }

    private static final class VirtualLinkJsonArrayMatcher
    extends TypeSafeMatcher<JsonArray> {
        private final VirtualLink vlink;
        private String reason = "";

        private VirtualLinkJsonArrayMatcher(VirtualLink vlinkValue) {
            this.vlink = vlinkValue;
        }

        public boolean matchesSafely(JsonArray json) {
            for (int jsonLinkIndex = 0; jsonLinkIndex < json.size(); ++jsonLinkIndex) {
                JsonObject jsonLink = json.get(jsonLinkIndex).asObject();
                if (!VirtualNetworkWebResourceTest.matchesVirtualLink(this.vlink).matchesSafely(jsonLink)) continue;
                return true;
            }
            return false;
        }

        public void describeTo(Description description) {
            description.appendText(this.reason);
        }
    }

    private static final class VirtualLinkJsonMatcher
    extends LinksResourceTest.LinkJsonMatcher {
        private final VirtualLink vlink;
        private String reason = "";

        private VirtualLinkJsonMatcher(VirtualLink vlinkValue) {
            super((Link)vlinkValue);
            this.vlink = vlinkValue;
        }

        @Override
        public boolean matchesSafely(JsonObject jsonLink) {
            String networkId;
            if (!super.matchesSafely(jsonLink)) {
                return false;
            }
            String jsonNetworkId = jsonLink.get(VirtualNetworkWebResourceTest.ID).asString();
            if (!jsonNetworkId.equals(networkId = this.vlink.networkId().toString())) {
                this.reason = "networkId was " + jsonNetworkId;
                return false;
            }
            return true;
        }

        @Override
        public void describeTo(Description description) {
            description.appendText(this.reason);
        }
    }

    private static final class VportJsonArrayMatcher
    extends JsonArrayMatcher<VirtualPort> {
        private VportJsonArrayMatcher(VirtualPort vportIn) {
            super(vportIn, vport -> "Virtual port " + vport.networkId().toString() + " " + vport.element().id().toString() + " " + vport.number().toString(), (vport, jsonObject) -> jsonObject.get(VirtualNetworkWebResourceTest.ID).asString().equals(vport.networkId().toString()) && jsonObject.get(VirtualNetworkWebResourceTest.PORT_NUM).asString().equals(vport.number().toString()) && jsonObject.get(VirtualNetworkWebResourceTest.DEVICE_ID).asString().equals(vport.element().id().toString()), (List<String>)ImmutableList.of((Object)VirtualNetworkWebResourceTest.ID, (Object)VirtualNetworkWebResourceTest.DEVICE_ID, (Object)VirtualNetworkWebResourceTest.PORT_NUM, (Object)VirtualNetworkWebResourceTest.PHYS_DEVICE_ID, (Object)VirtualNetworkWebResourceTest.PHYS_PORT_NUM), (vport, s) -> s.equals(VirtualNetworkWebResourceTest.ID) ? vport.networkId().toString() : (s.equals(VirtualNetworkWebResourceTest.DEVICE_ID) ? vport.element().id().toString() : (s.equals(VirtualNetworkWebResourceTest.PORT_NUM) ? vport.number().toString() : (s.equals(VirtualNetworkWebResourceTest.PHYS_DEVICE_ID) ? vport.realizedBy().deviceId().toString() : (s.equals(VirtualNetworkWebResourceTest.PHYS_PORT_NUM) ? vport.realizedBy().port().toString() : null)))));
        }
    }

    private static final class VdevJsonArrayMatcher
    extends JsonArrayMatcher<VirtualDevice> {
        private VdevJsonArrayMatcher(VirtualDevice vdevIn) {
            super(vdevIn, vdev -> "Virtual device " + vdev.networkId().toString() + " " + vdev.id().toString(), (vdev, jsonObject) -> jsonObject.get(VirtualNetworkWebResourceTest.ID).asString().equals(vdev.networkId().toString()) && jsonObject.get(VirtualNetworkWebResourceTest.DEVICE_ID).asString().equals(vdev.id().toString()), (List<String>)ImmutableList.of((Object)VirtualNetworkWebResourceTest.ID, (Object)VirtualNetworkWebResourceTest.DEVICE_ID), (vdev, s) -> s.equals(VirtualNetworkWebResourceTest.ID) ? vdev.networkId().toString() : (s.equals(VirtualNetworkWebResourceTest.DEVICE_ID) ? vdev.id().toString() : null));
        }
    }

    private static final class VnetJsonArrayMatcher
    extends JsonArrayMatcher<VirtualNetwork> {
        private VnetJsonArrayMatcher(VirtualNetwork vnetIn) {
            super(vnetIn, vnet -> "Virtual network " + vnet.id().toString(), (vnet, jsonObject) -> jsonObject.get(VirtualNetworkWebResourceTest.ID).asString().equals(vnet.id().toString()), (List<String>)ImmutableList.of((Object)VirtualNetworkWebResourceTest.ID, (Object)VirtualNetworkWebResourceTest.TENANT_ID), (vnet, s) -> s.equals(VirtualNetworkWebResourceTest.ID) ? vnet.id().toString() : (s.equals(VirtualNetworkWebResourceTest.TENANT_ID) ? vnet.tenantId().toString() : null));
        }
    }

    protected static class JsonArrayMatcher<T>
    extends TypeSafeMatcher<JsonArray> {
        private final T vnetEntity;
        private String reason = "";
        private Function<T, String> getKey;
        private BiPredicate<T, JsonObject> checkKey;
        private List<String> jsonFieldNames;
        private BiFunction<T, String, String> getValue;

        protected JsonArrayMatcher(T vnetEntityValue, Function<T, String> getKey1, BiPredicate<T, JsonObject> checkKey1, List<String> jsonFieldNames1, BiFunction<T, String, String> getValue1) {
            this.vnetEntity = vnetEntityValue;
            this.getKey = getKey1;
            this.checkKey = checkKey1;
            this.jsonFieldNames = jsonFieldNames1;
            this.getValue = getValue1;
        }

        public boolean matchesSafely(JsonArray json) {
            boolean itemFound = false;
            int expectedAttributes = this.jsonFieldNames.size();
            for (int jsonArrayIndex = 0; jsonArrayIndex < json.size(); ++jsonArrayIndex) {
                JsonObject jsonHost = json.get(jsonArrayIndex).asObject();
                if (jsonHost.names().size() < expectedAttributes) {
                    this.reason = "Found a virtual network with the wrong number of attributes";
                    return false;
                }
                if (this.checkKey == null || !this.checkKey.test(this.vnetEntity, jsonHost)) continue;
                itemFound = true;
                Assert.assertThat((Object)jsonHost, (Matcher)VirtualNetworkWebResourceTest.matchesVnetEntity(this.vnetEntity, this.jsonFieldNames, this.getValue));
            }
            if (!itemFound) {
                this.reason = this.getKey.apply(this.vnetEntity) + " was not found";
                return false;
            }
            return true;
        }

        public void describeTo(Description description) {
            description.appendText(this.reason);
        }
    }

    private static final class JsonObjectMatcher<T>
    extends TypeSafeMatcher<JsonObject> {
        private final T vnetEntity;
        private List<String> jsonFieldNames;
        private String reason = "";
        private BiFunction<T, String, String> getValue;

        private JsonObjectMatcher(T vnetEntityValue, List<String> jsonFieldNames1, BiFunction<T, String, String> getValue1) {
            this.vnetEntity = vnetEntityValue;
            this.jsonFieldNames = jsonFieldNames1;
            this.getValue = getValue1;
        }

        public boolean matchesSafely(JsonObject jsonHost) {
            return this.jsonFieldNames.stream().allMatch(s -> this.checkField(jsonHost, (String)s, this.getValue.apply(this.vnetEntity, (String)s)));
        }

        private boolean checkField(JsonObject jsonHost, String jsonFieldName, String objectValue) {
            String jsonValue = jsonHost.get(jsonFieldName).asString();
            if (!jsonValue.equals(objectValue)) {
                this.reason = jsonFieldName + " " + objectValue;
                return false;
            }
            return true;
        }

        public void describeTo(Description description) {
            description.appendText(this.reason);
        }
    }
}

