/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.rest.resources;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import org.apache.commons.io.IOUtils;
import org.onlab.osgi.DefaultServiceDirectory;
import org.onlab.osgi.ServiceDirectory;
import org.onlab.osgi.ServiceNotFoundException;
import org.onlab.util.Tools;
import org.onosproject.security.AuditService;

public class AuditFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    private ObjectMapper mapper = new ObjectMapper();
    private final String separator = "\", \"";
    private final String logCompSeperator = "\" : \"";
    private static boolean disableForTests = false;
    private static ServiceDirectory services = new DefaultServiceDirectory();

    public static void disableForTests() {
        disableForTests = true;
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        if (this.auditService() != null) {
            String requestBody = requestContext.hasEntity() ? Tools.readTreeFromStream((ObjectMapper)this.mapper, (InputStream)requestContext.getEntityStream()).toString() : "";
            requestContext.setProperty("requestBody", (Object)requestBody);
            requestContext.setProperty("auditMessage", (Object)("{\"Path\" : \"" + requestContext.getUriInfo().getPath() + "\", \"" + "Method" + "\" : \"" + requestContext.getMethod() + "\", \"" + (requestContext.getMethod().equals("PUT") ? "Path_Parameters\" : \"" + requestContext.getUriInfo().getPathParameters().toString() + "\", \"" + "Query_Parameters" + "\" : \"" + requestContext.getUriInfo().getQueryParameters().toString() + "\", \"" + "Request_Body" + "\" : \"" + requestBody : "")));
            requestContext.setEntityStream(IOUtils.toInputStream((String)requestBody));
        }
    }

    public void filter(ContainerRequestContext containerRequestContext, ContainerResponseContext containerResponseContext) throws IOException {
        AuditService auditService = this.auditService();
        if (auditService != null) {
            containerRequestContext.setProperty("auditMessage", (Object)(containerRequestContext.getProperty("auditMessage") + "\", \"" + "Status" + "\" : \"" + containerResponseContext.getStatusInfo().toString() + "\"}"));
            String user = containerRequestContext.getSecurityContext().getUserPrincipal().getName();
            String action = containerRequestContext.getProperty("auditMessage").toString();
            auditService.logUserAction(user, action);
        }
    }

    private AuditService auditService() {
        AuditService auditService = null;
        try {
            auditService = disableForTests ? null : (AuditService)services.get(AuditService.class);
        }
        catch (ServiceNotFoundException e) {
            return null;
        }
        return auditService != null && auditService.isAuditing() ? auditService : null;
    }
}

