/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.rest.resources;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.stream.IntStream;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.onlab.util.HexString;
import org.onlab.util.Tools;
import org.onosproject.codec.CodecContext;
import org.onosproject.codec.JsonCodec;
import org.onosproject.net.DeviceId;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.group.DefaultGroupDescription;
import org.onosproject.net.group.DefaultGroupKey;
import org.onosproject.net.group.Group;
import org.onosproject.net.group.GroupBucket;
import org.onosproject.net.group.GroupBuckets;
import org.onosproject.net.group.GroupDescription;
import org.onosproject.net.group.GroupKey;
import org.onosproject.net.group.GroupService;
import org.onosproject.rest.AbstractWebResource;

/*
 * Exception performing whole class analysis ignored.
 */
@Path(value="groups")
public class GroupsWebResource
extends AbstractWebResource {
    @Context
    private UriInfo uriInfo;
    private static final String DEVICE_INVALID = "Invalid deviceId in group creation request";
    private static final String GROUP_NOT_FOUND = "Group was not found";
    private final ObjectNode root = this.mapper().createObjectNode();
    private final ArrayNode groupsNode = this.root.putArray("groups");

    private GroupKey createKey(String appCookieString) {
        if (!appCookieString.startsWith("0x")) {
            throw new IllegalArgumentException("APP_COOKIE must be a hex string starts with 0x");
        }
        return new DefaultGroupKey(HexString.fromHexString((String)appCookieString.split("0x")[1], (String)""));
    }

    @GET
    @Produces(value={"application/json"})
    public Response getGroups() {
        GroupService groupService = (GroupService)this.get(GroupService.class);
        Iterable devices = ((DeviceService)this.get(DeviceService.class)).getDevices();
        devices.forEach(device -> {
            Iterable groups = groupService.getGroups(device.id());
            if (groups != null) {
                groups.forEach(group -> this.groupsNode.add((JsonNode)this.codec(Group.class).encode(group, (CodecContext)this)));
            }
        });
        return GroupsWebResource.ok((Object)this.root).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="{deviceId}")
    public Response getGroupsByDeviceId(@PathParam(value="deviceId") String deviceId) {
        GroupService groupService = (GroupService)this.get(GroupService.class);
        Iterable groups = groupService.getGroups(DeviceId.deviceId((String)deviceId));
        groups.forEach(group -> this.groupsNode.add((JsonNode)this.codec(Group.class).encode(group, (CodecContext)this)));
        return GroupsWebResource.ok((Object)this.root).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="{deviceId}/{appCookie}")
    public Response getGroupByDeviceIdAndAppCookie(@PathParam(value="deviceId") String deviceId, @PathParam(value="appCookie") String appCookie) {
        GroupService groupService = (GroupService)this.get(GroupService.class);
        DeviceId deviceIdInstance = DeviceId.deviceId((String)deviceId);
        GroupKey appCookieInstance = this.createKey(appCookie);
        Group group = (Group)Tools.nullIsNotFound((Object)groupService.getGroup(deviceIdInstance, appCookieInstance), (String)"Group was not found");
        this.groupsNode.add((JsonNode)this.codec(Group.class).encode((Object)group, (CodecContext)this));
        return GroupsWebResource.ok((Object)this.root).build();
    }

    @POST
    @Path(value="{deviceId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createGroup(@PathParam(value="deviceId") String deviceId, InputStream stream) {
        GroupService groupService = (GroupService)this.get(GroupService.class);
        try {
            ObjectNode jsonTree = Tools.readTreeFromStream((ObjectMapper)this.mapper(), (InputStream)stream);
            JsonNode specifiedDeviceId = jsonTree.get("deviceId");
            if (specifiedDeviceId != null && !specifiedDeviceId.asText().equals(deviceId)) {
                throw new IllegalArgumentException("Invalid deviceId in group creation request");
            }
            jsonTree.put("deviceId", deviceId);
            Group group = (Group)this.codec(Group.class).decode(jsonTree, (CodecContext)this);
            DefaultGroupDescription description = new DefaultGroupDescription(group.deviceId(), group.type(), group.buckets(), group.appCookie(), (Integer)group.id().id(), group.appId());
            groupService.addGroup((GroupDescription)description);
            UriBuilder locationBuilder = this.uriInfo.getBaseUriBuilder().path("groups").path(deviceId).path(Long.toString(((Integer)group.id().id()).intValue()));
            return Response.created((URI)locationBuilder.build(new Object[0])).build();
        }
        catch (IOException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    @DELETE
    @Path(value="{deviceId}/{appCookie}")
    public Response deleteGroupByDeviceIdAndAppCookie(@PathParam(value="deviceId") String deviceId, @PathParam(value="appCookie") String appCookie) {
        GroupService groupService = (GroupService)this.get(GroupService.class);
        DeviceId deviceIdInstance = DeviceId.deviceId((String)deviceId);
        GroupKey appCookieInstance = this.createKey(appCookie);
        groupService.removeGroup(deviceIdInstance, appCookieInstance, null);
        return Response.noContent().build();
    }

    private void updateGroupBuckets(String deviceIdString, String appCookieString, InputStream stream) throws IOException {
        GroupService groupService = (GroupService)this.get(GroupService.class);
        DeviceId deviceId = DeviceId.deviceId((String)deviceIdString);
        GroupKey groupKey = this.createKey(appCookieString);
        Group group = (Group)Tools.nullIsNotFound((Object)groupService.getGroup(deviceId, groupKey), (String)"Group was not found");
        ObjectNode jsonTree = Tools.readTreeFromStream((ObjectMapper)this.mapper(), (InputStream)stream);
        GroupBuckets buckets = null;
        ArrayList groupBucketList = new ArrayList();
        JsonNode bucketsJson = jsonTree.get("buckets");
        JsonCodec groupBucketCodec = this.codec(GroupBucket.class);
        if (bucketsJson != null) {
            IntStream.range(0, bucketsJson.size()).forEach(i -> {
                ObjectNode bucketJson = (ObjectNode)bucketsJson.get(i);
                groupBucketList.add(groupBucketCodec.decode(bucketJson, (CodecContext)this));
            });
            buckets = new GroupBuckets(groupBucketList);
        }
        groupService.addBucketsToGroup(deviceId, groupKey, buckets, groupKey, group.appId());
    }

    @POST
    @Path(value="{deviceId}/{appCookie}/buckets")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response addBucket(@PathParam(value="deviceId") String deviceIdString, @PathParam(value="appCookie") String appCookieString, InputStream stream) {
        try {
            this.updateGroupBuckets(deviceIdString, appCookieString, stream);
            return Response.noContent().build();
        }
        catch (IOException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    private void removeGroupBuckets(String deviceIdString, String appCookieString, String bucketIds) {
        DeviceId deviceId = DeviceId.deviceId((String)deviceIdString);
        GroupKey groupKey = this.createKey(appCookieString);
        GroupService groupService = (GroupService)this.get(GroupService.class);
        Group group = (Group)Tools.nullIsNotFound((Object)groupService.getGroup(deviceId, groupKey), (String)"Group was not found");
        ArrayList groupBucketList = new ArrayList();
        ImmutableList bucketsToRemove = ImmutableList.copyOf((Object[])bucketIds.split(","));
        bucketsToRemove.forEach(bucketIdToRemove -> group.buckets().buckets().stream().filter(bucket -> Integer.toString(bucket.hashCode()).equals(bucketIdToRemove)).forEach(groupBucketList::add));
        groupService.removeBucketsFromGroup(deviceId, groupKey, new GroupBuckets(groupBucketList), groupKey, group.appId());
    }

    @DELETE
    @Path(value="{deviceId}/{appCookie}/buckets/{bucketIds}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response deleteBuckets(@PathParam(value="deviceId") String deviceIdString, @PathParam(value="appCookie") String appCookieString, @PathParam(value="bucketIds") String bucketIds) {
        this.removeGroupBuckets(deviceIdString, appCookieString, bucketIds);
        return Response.noContent().build();
    }
}

