/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.rest.resources;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.onlab.util.Tools;
import org.onosproject.codec.CodecContext;
import org.onosproject.incubator.net.virtual.NetworkId;
import org.onosproject.incubator.net.virtual.TenantId;
import org.onosproject.incubator.net.virtual.VirtualDevice;
import org.onosproject.incubator.net.virtual.VirtualHost;
import org.onosproject.incubator.net.virtual.VirtualLink;
import org.onosproject.incubator.net.virtual.VirtualNetwork;
import org.onosproject.incubator.net.virtual.VirtualNetworkAdminService;
import org.onosproject.incubator.net.virtual.VirtualNetworkService;
import org.onosproject.incubator.net.virtual.VirtualPort;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.PortNumber;
import org.onosproject.rest.AbstractWebResource;
import org.onosproject.rest.resources.TenantWebResource;

/*
 * Exception performing whole class analysis ignored.
 */
@Path(value="vnets")
public class VirtualNetworkWebResource
extends AbstractWebResource {
    private static final String MISSING_FIELD = "Missing ";
    private static final String INVALID_FIELD = "Invalid ";
    private final VirtualNetworkAdminService vnetAdminService = (VirtualNetworkAdminService)this.get(VirtualNetworkAdminService.class);
    private final VirtualNetworkService vnetService = (VirtualNetworkService)this.get(VirtualNetworkService.class);
    @Context
    private UriInfo uriInfo;

    @GET
    @Produces(value={"application/json"})
    public Response getVirtualNetworks() {
        Set tenantIds = this.vnetAdminService.getTenantIds();
        List allVnets = tenantIds.stream().map(tenantId -> this.vnetService.getVirtualNetworks(tenantId)).flatMap(Collection::stream).collect(Collectors.toList());
        return VirtualNetworkWebResource.ok((Object)this.encodeArray(VirtualNetwork.class, "vnets", allVnets)).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="{tenantId}")
    public Response getVirtualNetworkById(@PathParam(value="tenantId") String tenantId) {
        TenantId existingTid = TenantWebResource.getExistingTenantId((VirtualNetworkAdminService)this.vnetAdminService, (TenantId)TenantId.tenantId((String)tenantId));
        Set vnets = this.vnetService.getVirtualNetworks(existingTid);
        return VirtualNetworkWebResource.ok((Object)this.encodeArray(VirtualNetwork.class, "vnets", (Iterable)vnets)).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createVirtualNetwork(InputStream stream) {
        try {
            TenantId tid = TenantId.tenantId((String)this.getFromJsonStream(stream, "id").asText());
            VirtualNetwork newVnet = this.vnetAdminService.createVirtualNetwork(tid);
            UriBuilder locationBuilder = this.uriInfo.getBaseUriBuilder().path("vnets").path(newVnet.id().toString());
            return Response.created((URI)locationBuilder.build(new Object[0])).build();
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @DELETE
    @Path(value="{networkId}")
    public Response removeVirtualNetwork(@PathParam(value="networkId") long networkId) {
        NetworkId nid = NetworkId.networkId((long)networkId);
        this.vnetAdminService.removeVirtualNetwork(nid);
        return Response.noContent().build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="{networkId}/devices")
    public Response getVirtualDevices(@PathParam(value="networkId") long networkId) {
        NetworkId nid = NetworkId.networkId((long)networkId);
        Set vdevs = this.vnetService.getVirtualDevices(nid);
        return VirtualNetworkWebResource.ok((Object)this.encodeArray(VirtualDevice.class, "devices", (Iterable)vdevs)).build();
    }

    @POST
    @Path(value="{networkId}/devices")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createVirtualDevice(@PathParam(value="networkId") long networkId, InputStream stream) {
        try {
            ObjectNode jsonTree = Tools.readTreeFromStream((ObjectMapper)this.mapper(), (InputStream)stream);
            VirtualDevice vdevReq = (VirtualDevice)this.codec(VirtualDevice.class).decode(jsonTree, (CodecContext)this);
            JsonNode specifiedNetworkId = jsonTree.get("networkId");
            if (specifiedNetworkId == null || specifiedNetworkId.asLong() != networkId) {
                throw new IllegalArgumentException("Invalid networkId");
            }
            VirtualDevice vdevRes = this.vnetAdminService.createVirtualDevice(vdevReq.networkId(), vdevReq.id());
            UriBuilder locationBuilder = this.uriInfo.getBaseUriBuilder().path("vnets").path(specifiedNetworkId.asText()).path("devices").path(vdevRes.id().toString());
            return Response.created((URI)locationBuilder.build(new Object[0])).build();
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @DELETE
    @Path(value="{networkId}/devices/{deviceId}")
    public Response removeVirtualDevice(@PathParam(value="networkId") long networkId, @PathParam(value="deviceId") String deviceId) {
        NetworkId nid = NetworkId.networkId((long)networkId);
        DeviceId did = DeviceId.deviceId((String)deviceId);
        this.vnetAdminService.removeVirtualDevice(nid, did);
        return Response.noContent().build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="{networkId}/devices/{deviceId}/ports")
    public Response getVirtualPorts(@PathParam(value="networkId") long networkId, @PathParam(value="deviceId") String deviceId) {
        NetworkId nid = NetworkId.networkId((long)networkId);
        Set vports = this.vnetService.getVirtualPorts(nid, DeviceId.deviceId((String)deviceId));
        return VirtualNetworkWebResource.ok((Object)this.encodeArray(VirtualPort.class, "ports", (Iterable)vports)).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="{networkId}/devices/{deviceId}/ports")
    public Response createVirtualPort(@PathParam(value="networkId") long networkId, @PathParam(value="deviceId") String virtDeviceId, InputStream stream) {
        try {
            ObjectNode jsonTree = Tools.readTreeFromStream((ObjectMapper)this.mapper(), (InputStream)stream);
            JsonNode specifiedNetworkId = jsonTree.get("networkId");
            JsonNode specifiedDeviceId = jsonTree.get("deviceId");
            if (specifiedNetworkId == null || specifiedNetworkId.asLong() != networkId) {
                throw new IllegalArgumentException("Invalid networkId");
            }
            if (specifiedDeviceId == null || !specifiedDeviceId.asText().equals(virtDeviceId)) {
                throw new IllegalArgumentException("Invalid deviceId");
            }
            JsonNode specifiedPortNum = jsonTree.get("portNum");
            JsonNode specifiedPhysDeviceId = jsonTree.get("physDeviceId");
            JsonNode specifiedPhysPortNum = jsonTree.get("physPortNum");
            NetworkId nid = NetworkId.networkId((long)networkId);
            DeviceId vdevId = DeviceId.deviceId((String)virtDeviceId);
            ConnectPoint realizedBy = new ConnectPoint((ElementId)DeviceId.deviceId((String)specifiedPhysDeviceId.asText()), PortNumber.portNumber((String)specifiedPhysPortNum.asText()));
            VirtualPort vport = this.vnetAdminService.createVirtualPort(nid, vdevId, PortNumber.portNumber((String)specifiedPortNum.asText()), realizedBy);
            UriBuilder locationBuilder = this.uriInfo.getBaseUriBuilder().path("vnets").path(specifiedNetworkId.asText()).path("devices").path(specifiedDeviceId.asText()).path("ports").path(vport.number().toString());
            return Response.created((URI)locationBuilder.build(new Object[0])).build();
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @DELETE
    @Path(value="{networkId}/devices/{deviceId}/ports/{portNum}")
    public Response removeVirtualPort(@PathParam(value="networkId") long networkId, @PathParam(value="deviceId") String deviceId, @PathParam(value="portNum") long portNum) {
        NetworkId nid = NetworkId.networkId((long)networkId);
        this.vnetAdminService.removeVirtualPort(nid, DeviceId.deviceId((String)deviceId), PortNumber.portNumber((long)portNum));
        return Response.noContent().build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="{networkId}/links")
    public Response getVirtualLinks(@PathParam(value="networkId") long networkId) {
        NetworkId nid = NetworkId.networkId((long)networkId);
        Set vlinks = this.vnetService.getVirtualLinks(nid);
        return VirtualNetworkWebResource.ok((Object)this.encodeArray(VirtualLink.class, "links", (Iterable)vlinks)).build();
    }

    @POST
    @Path(value="{networkId}/links")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createVirtualLink(@PathParam(value="networkId") long networkId, InputStream stream) {
        try {
            ObjectNode jsonTree = Tools.readTreeFromStream((ObjectMapper)this.mapper(), (InputStream)stream);
            JsonNode specifiedNetworkId = jsonTree.get("networkId");
            if (specifiedNetworkId == null || specifiedNetworkId.asLong() != networkId) {
                throw new IllegalArgumentException("Invalid networkId");
            }
            VirtualLink vlinkReq = (VirtualLink)this.codec(VirtualLink.class).decode(jsonTree, (CodecContext)this);
            this.vnetAdminService.createVirtualLink(vlinkReq.networkId(), vlinkReq.src(), vlinkReq.dst());
            UriBuilder locationBuilder = this.uriInfo.getBaseUriBuilder().path("vnets").path(specifiedNetworkId.asText()).path("links");
            return Response.created((URI)locationBuilder.build(new Object[0])).build();
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @DELETE
    @Path(value="{networkId}/links")
    @Consumes(value={"application/json"})
    public Response removeVirtualLink(@PathParam(value="networkId") long networkId, InputStream stream) {
        try {
            ObjectNode jsonTree = Tools.readTreeFromStream((ObjectMapper)this.mapper(), (InputStream)stream);
            JsonNode specifiedNetworkId = jsonTree.get("networkId");
            if (specifiedNetworkId != null && specifiedNetworkId.asLong() != networkId) {
                throw new IllegalArgumentException("Invalid networkId");
            }
            VirtualLink vlinkReq = (VirtualLink)this.codec(VirtualLink.class).decode(jsonTree, (CodecContext)this);
            this.vnetAdminService.removeVirtualLink(vlinkReq.networkId(), vlinkReq.src(), vlinkReq.dst());
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        return Response.noContent().build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="{networkId}/hosts")
    public Response getVirtualHosts(@PathParam(value="networkId") long networkId) {
        NetworkId nid = NetworkId.networkId((long)networkId);
        Set vhosts = this.vnetService.getVirtualHosts(nid);
        return VirtualNetworkWebResource.ok((Object)this.encodeArray(VirtualHost.class, "hosts", (Iterable)vhosts)).build();
    }

    @POST
    @Path(value="{networkId}/hosts")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createVirtualHost(@PathParam(value="networkId") long networkId, InputStream stream) {
        try {
            ObjectNode jsonTree = Tools.readTreeFromStream((ObjectMapper)this.mapper(), (InputStream)stream);
            JsonNode specifiedNetworkId = jsonTree.get("networkId");
            if (specifiedNetworkId == null || specifiedNetworkId.asLong() != networkId) {
                throw new IllegalArgumentException("Invalid networkId");
            }
            VirtualHost vhostReq = (VirtualHost)this.codec(VirtualHost.class).decode(jsonTree, (CodecContext)this);
            this.vnetAdminService.createVirtualHost(vhostReq.networkId(), vhostReq.id(), vhostReq.mac(), vhostReq.vlan(), vhostReq.location(), vhostReq.ipAddresses());
            UriBuilder locationBuilder = this.uriInfo.getBaseUriBuilder().path("vnets").path(specifiedNetworkId.asText()).path("hosts");
            return Response.created((URI)locationBuilder.build(new Object[0])).build();
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @DELETE
    @Path(value="{networkId}/hosts")
    @Consumes(value={"application/json"})
    public Response removeVirtualHost(@PathParam(value="networkId") long networkId, InputStream stream) {
        try {
            ObjectNode jsonTree = Tools.readTreeFromStream((ObjectMapper)this.mapper(), (InputStream)stream);
            JsonNode specifiedNetworkId = jsonTree.get("networkId");
            if (specifiedNetworkId != null && specifiedNetworkId.asLong() != networkId) {
                throw new IllegalArgumentException("Invalid networkId");
            }
            VirtualHost vhostReq = (VirtualHost)this.codec(VirtualHost.class).decode(jsonTree, (CodecContext)this);
            this.vnetAdminService.removeVirtualHost(vhostReq.networkId(), vhostReq.id());
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        return Response.noContent().build();
    }

    private JsonNode getFromJsonStream(InputStream stream, String jsonFieldName) throws IOException {
        ObjectNode jsonTree = Tools.readTreeFromStream((ObjectMapper)this.mapper(), (InputStream)stream);
        JsonNode jsonNode = jsonTree.get(jsonFieldName);
        if (jsonNode == null) {
            throw new IllegalArgumentException("Missing " + jsonFieldName);
        }
        return jsonNode;
    }
}

