/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.rest.impl;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Set;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Service;
import org.onosproject.rest.ApiDocProvider;
import org.onosproject.rest.ApiDocService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class ApiDocManager
implements ApiDocService {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Map<String, ApiDocProvider> providers = Maps.newConcurrentMap();

    @Activate
    public void activate() {
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.log.info("Stopped");
    }

    public void register(ApiDocProvider provider) {
        this.providers.put(provider.key(), provider);
        this.log.info("{} registered at {}", (Object)provider.name(), (Object)provider.key());
    }

    public void unregister(ApiDocProvider provider) {
        this.providers.remove(provider.name());
        this.log.info("{} unregistered", (Object)provider.name());
    }

    public Set<ApiDocProvider> getDocProviders() {
        return ImmutableSet.copyOf(this.providers.values());
    }

    public ApiDocProvider getDocProvider(String key) {
        return (ApiDocProvider)this.providers.get(key);
    }
}

