/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.rest.resources;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.onlab.util.Tools;
import org.onosproject.codec.CodecContext;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.Port;
import org.onosproject.net.PortNumber;
import org.onosproject.net.device.DeviceAdminService;
import org.onosproject.net.device.DeviceService;
import org.onosproject.rest.AbstractWebResource;

/*
 * Exception performing whole class analysis ignored.
 */
@Path(value="devices")
public class DevicesWebResource
extends AbstractWebResource {
    private static final String ENABLED = "enabled";
    private static final String DEVICE_NOT_FOUND = "Device is not found";
    private static final String INVALID_JSON = "Invalid JSON data";

    @GET
    @Produces(value={"application/json"})
    public Response getDevices() {
        Iterable devices = ((DeviceService)this.get(DeviceService.class)).getDevices();
        return DevicesWebResource.ok((Object)this.encodeArray(Device.class, "devices", devices)).build();
    }

    @GET
    @Path(value="{id}")
    @Produces(value={"application/json"})
    public Response getDevice(@PathParam(value="id") String id) {
        Device device = (Device)Tools.nullIsNotFound((Object)((DeviceService)this.get(DeviceService.class)).getDevice(DeviceId.deviceId((String)id)), (String)"Device is not found");
        return DevicesWebResource.ok((Object)this.codec(Device.class).encode((Object)device, (CodecContext)this)).build();
    }

    @DELETE
    @Path(value="{id}")
    @Produces(value={"application/json"})
    public Response removeDevice(@PathParam(value="id") String id) {
        Device device = (Device)Tools.nullIsNotFound((Object)((DeviceService)this.get(DeviceService.class)).getDevice(DeviceId.deviceId((String)id)), (String)"Device is not found");
        ObjectNode result = this.codec(Device.class).encode((Object)device, (CodecContext)this);
        ((DeviceAdminService)this.get(DeviceAdminService.class)).removeDevice(DeviceId.deviceId((String)id));
        return DevicesWebResource.ok((Object)result).build();
    }

    @GET
    @Path(value="{id}/ports")
    @Produces(value={"application/json"})
    public Response getDevicePorts(@PathParam(value="id") String id) {
        DeviceService service = (DeviceService)this.get(DeviceService.class);
        Device device = (Device)Tools.nullIsNotFound((Object)service.getDevice(DeviceId.deviceId((String)id)), (String)"Device is not found");
        List ports = (List)Preconditions.checkNotNull((Object)service.getPorts(DeviceId.deviceId((String)id)), (Object)"Ports could not be retrieved");
        ObjectNode result = this.codec(Device.class).encode((Object)device, (CodecContext)this);
        result.set("ports", (JsonNode)this.codec(Port.class).encode((Iterable)ports, (CodecContext)this));
        return DevicesWebResource.ok((Object)result).build();
    }

    @POST
    @Path(value="{id}/portstate/{port_id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response setPortState(@PathParam(value="id") String id, @PathParam(value="port_id") String portId, InputStream stream) {
        try {
            DeviceId deviceId = DeviceId.deviceId((String)id);
            PortNumber portNumber = PortNumber.portNumber((String)portId);
            Tools.nullIsNotFound((Object)((DeviceService)this.get(DeviceService.class)).getPort(new ConnectPoint((ElementId)deviceId, portNumber)), (String)"Device is not found");
            ObjectNode root = Tools.readTreeFromStream((ObjectMapper)this.mapper(), (InputStream)stream);
            JsonNode node = root.path("enabled");
            if (!node.isMissingNode()) {
                ((DeviceAdminService)this.get(DeviceAdminService.class)).changePortState(deviceId, portNumber, node.asBoolean());
                return Response.ok().build();
            }
            throw new IllegalArgumentException("Invalid JSON data");
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException(ioe);
        }
    }
}

