/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.rest.resources;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.onlab.util.Tools;
import org.onosproject.codec.CodecContext;
import org.onosproject.net.DeviceId;
import org.onosproject.net.flowobjective.FilteringObjective;
import org.onosproject.net.flowobjective.FlowObjectiveService;
import org.onosproject.net.flowobjective.ForwardingObjective;
import org.onosproject.net.flowobjective.NextObjective;
import org.onosproject.rest.AbstractWebResource;

/*
 * Exception performing whole class analysis ignored.
 */
@Path(value="flowobjectives")
public class FlowObjectiveWebResource
extends AbstractWebResource {
    @Context
    private UriInfo uriInfo;
    private static final String DEVICE_INVALID = "Invalid deviceId in objective creation request";
    private static final String POLICY_INVALID = "Invalid policy";
    private final FlowObjectiveService flowObjectiveService = (FlowObjectiveService)this.get(FlowObjectiveService.class);
    private final ObjectNode root = this.mapper().createObjectNode();

    @POST
    @Path(value="{deviceId}/filter")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createFilteringObjective(@QueryParam(value="appId") String appId, @PathParam(value="deviceId") String deviceId, InputStream stream) {
        try {
            UriBuilder locationBuilder = null;
            ObjectNode jsonTree = Tools.readTreeFromStream((ObjectMapper)this.mapper(), (InputStream)stream);
            this.validateDeviceId(deviceId, jsonTree);
            if (appId != null) {
                jsonTree.put("appId", appId);
            }
            DeviceId did = DeviceId.deviceId((String)deviceId);
            FilteringObjective filteringObjective = (FilteringObjective)this.codec(FilteringObjective.class).decode(jsonTree, (CodecContext)this);
            this.flowObjectiveService.filter(did, filteringObjective);
            locationBuilder = this.uriInfo.getBaseUriBuilder().path("flowobjectives").path(did.toString()).path("filter").path(Integer.toString(filteringObjective.id()));
            return Response.created((URI)locationBuilder.build(new Object[0])).build();
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @POST
    @Path(value="{deviceId}/forward")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createForwardingObjective(@QueryParam(value="appId") String appId, @PathParam(value="deviceId") String deviceId, InputStream stream) {
        try {
            UriBuilder locationBuilder = null;
            ObjectNode jsonTree = (ObjectNode)this.mapper().readTree(stream);
            this.validateDeviceId(deviceId, jsonTree);
            if (appId != null) {
                jsonTree.put("appId", appId);
            }
            DeviceId did = DeviceId.deviceId((String)deviceId);
            ForwardingObjective forwardingObjective = (ForwardingObjective)this.codec(ForwardingObjective.class).decode(jsonTree, (CodecContext)this);
            this.flowObjectiveService.forward(did, forwardingObjective);
            locationBuilder = this.uriInfo.getBaseUriBuilder().path("flowobjectives").path(did.toString()).path("forward").path(Integer.toString(forwardingObjective.id()));
            return Response.created((URI)locationBuilder.build(new Object[0])).build();
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @POST
    @Path(value="{deviceId}/next")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createNextObjective(@QueryParam(value="appId") String appId, @PathParam(value="deviceId") String deviceId, InputStream stream) {
        try {
            UriBuilder locationBuilder = null;
            ObjectNode jsonTree = (ObjectNode)this.mapper().readTree(stream);
            this.validateDeviceId(deviceId, jsonTree);
            if (appId != null) {
                jsonTree.put("appId", appId);
            }
            DeviceId did = DeviceId.deviceId((String)deviceId);
            NextObjective nextObjective = (NextObjective)this.codec(NextObjective.class).decode(jsonTree, (CodecContext)this);
            this.flowObjectiveService.next(did, nextObjective);
            locationBuilder = this.uriInfo.getBaseUriBuilder().path("flowobjectives").path(did.toString()).path("next").path(Integer.toString(nextObjective.id()));
            return Response.created((URI)locationBuilder.build(new Object[0])).build();
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @GET
    @Path(value="next")
    @Produces(value={"application/json"})
    public Response getNextId() {
        this.root.put("nextId", this.flowObjectiveService.allocateNextId());
        return FlowObjectiveWebResource.ok((Object)this.root).build();
    }

    @POST
    @Path(value="policy")
    @Consumes(value={"application/json"})
    public Response initPolicy(InputStream stream) {
        try {
            ObjectNode jsonTree = (ObjectNode)this.mapper().readTree(stream);
            JsonNode policyJson = jsonTree.get("policy");
            if (policyJson == null || policyJson.asText().isEmpty()) {
                throw new IllegalArgumentException("Invalid policy");
            }
            this.flowObjectiveService.initPolicy(policyJson.asText());
            return Response.ok().build();
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private void validateDeviceId(String deviceId, ObjectNode node) {
        JsonNode specifiedDeviceId = node.get("deviceId");
        if (specifiedDeviceId != null && !specifiedDeviceId.asText().equals(deviceId)) {
            throw new IllegalArgumentException("Invalid deviceId in objective creation request");
        }
    }
}

