/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.rest.resources;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.onlab.util.Tools;
import org.onosproject.cluster.NodeId;
import org.onosproject.cluster.RoleInfo;
import org.onosproject.codec.CodecContext;
import org.onosproject.mastership.MastershipAdminService;
import org.onosproject.mastership.MastershipService;
import org.onosproject.net.DeviceId;
import org.onosproject.net.MastershipRole;
import org.onosproject.net.device.DeviceService;
import org.onosproject.rest.AbstractWebResource;

/*
 * Exception performing whole class analysis ignored.
 */
@Path(value="mastership")
public final class MastershipWebResource
extends AbstractWebResource {
    private static final String DEVICE_IDS = "deviceIds";
    private static final String DEVICE_ID = "deviceId";
    private static final String NODE_ID = "nodeId";
    private static final String DEVICE_ID_INVALID = "Invalid deviceId for setting role";
    private static final String NODE_ID_INVALID = "Invalid nodeId for setting role";
    private static final String DEVICE_ID_NOT_FOUND = "Device Id is not found";
    private static final String NODE_ID_NOT_FOUND = "Node id is not found";
    private static final String ROLE_INFO_NOT_FOUND = "Role info is not found";
    private static final String MASTERSHIP_ROLE_NOT_FOUND = "Mastership role is not found";
    private final DeviceService deviceService = (DeviceService)this.get(DeviceService.class);
    private final MastershipService mastershipService = (MastershipService)this.get(MastershipService.class);
    private final MastershipAdminService mastershipAdminService = (MastershipAdminService)this.get(MastershipAdminService.class);

    @GET
    @Produces(value={"application/json"})
    @Path(value="{deviceId}/local")
    public Response getLocalRole(@PathParam(value="deviceId") String deviceId) {
        MastershipRole role = this.mastershipService.getLocalRole(DeviceId.deviceId((String)deviceId));
        ObjectNode root = this.codec(MastershipRole.class).encode((Object)role, (CodecContext)this);
        return MastershipWebResource.ok((Object)root).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="{deviceId}/master")
    public Response getMasterFor(@PathParam(value="deviceId") String deviceId) {
        NodeId id = (NodeId)Tools.nullIsNotFound((Object)this.mastershipService.getMasterFor(DeviceId.deviceId((String)deviceId)), (String)"Node id is not found");
        ObjectNode root = this.mapper().createObjectNode();
        root.put("nodeId", (String)id.id());
        return MastershipWebResource.ok((Object)root).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="{deviceId}/role")
    public Response getNodesFor(@PathParam(value="deviceId") String deviceId) {
        RoleInfo info = (RoleInfo)Tools.nullIsNotFound((Object)this.mastershipService.getNodesFor(DeviceId.deviceId((String)deviceId)), (String)"Role info is not found");
        ObjectNode root = this.codec(RoleInfo.class).encode((Object)info, (CodecContext)this);
        return MastershipWebResource.ok((Object)root).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="{nodeId}/device")
    public Response getDeviceOf(@PathParam(value="nodeId") String nodeId) {
        ObjectNode root = this.mapper().createObjectNode();
        ArrayNode devicesNode = root.putArray("deviceIds");
        Set devices = this.mastershipService.getDevicesOf(NodeId.nodeId((String)nodeId));
        if (devices != null) {
            devices.forEach(id -> devicesNode.add(id.toString()));
        }
        return MastershipWebResource.ok((Object)root).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="{deviceId}/request")
    public Response requestRoleFor(@PathParam(value="deviceId") String deviceId) {
        DeviceId id = DeviceId.deviceId((String)deviceId);
        Tools.nullIsNotFound((Object)this.deviceService.getDevice(id), (String)"Device Id is not found");
        MastershipRole role = (MastershipRole)Tools.nullIsNotFound((Object)this.mastershipService.requestRoleForSync(id), (String)"Mastership role is not found");
        ObjectNode root = this.codec(MastershipRole.class).encode((Object)role, (CodecContext)this);
        return MastershipWebResource.ok((Object)root).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="{deviceId}/relinquish")
    public Response relinquishMastership(@PathParam(value="deviceId") String deviceId) {
        DeviceId id = DeviceId.deviceId((String)deviceId);
        this.mastershipService.relinquishMastershipSync(id);
        return Response.created((URI)id.uri()).build();
    }

    @PUT
    @Consumes(value={"application/json"})
    public Response setRole(InputStream stream) {
        try {
            ObjectNode jsonTree = Tools.readTreeFromStream((ObjectMapper)this.mapper(), (InputStream)stream);
            JsonNode deviceIdJson = jsonTree.get("deviceId");
            JsonNode nodeIdJson = jsonTree.get("nodeId");
            MastershipRole role = (MastershipRole)this.codec(MastershipRole.class).decode(jsonTree, (CodecContext)this);
            if (deviceIdJson == null) {
                throw new IllegalArgumentException("Invalid deviceId for setting role");
            }
            if (nodeIdJson == null) {
                throw new IllegalArgumentException("Invalid nodeId for setting role");
            }
            this.mastershipAdminService.setRoleSync(NodeId.nodeId((String)nodeIdJson.asText()), DeviceId.deviceId((String)deviceIdJson.asText()), role);
            return Response.ok().build();
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @GET
    @Produces(value={"application/json"})
    public Response balanceRoles() {
        this.mastershipAdminService.balanceRoles();
        return Response.ok().build();
    }
}

