/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.rest.resources;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricFilter;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Ordering;
import com.google.common.collect.TreeMultimap;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.onlab.metrics.MetricsService;
import org.onlab.util.ItemNotFoundException;
import org.onosproject.codec.CodecContext;
import org.onosproject.rest.AbstractWebResource;

/*
 * Exception performing whole class analysis ignored.
 */
@Path(value="metrics")
public class MetricsWebResource
extends AbstractWebResource {
    private static final String E_METRIC_NAME_NOT_FOUND = "Metric Name is not found";
    private final MetricsService service = (MetricsService)this.get(MetricsService.class);
    private final ObjectNode root = this.mapper().createObjectNode();

    @GET
    @Produces(value={"application/json"})
    public Response getAllMetrics() {
        ArrayNode metricsNode = this.root.putArray("metrics");
        this.service.getMetrics().forEach((name, metric) -> {
            ObjectNode item = this.mapper().createObjectNode();
            item.put("name", name);
            item.set("metric", (JsonNode)this.codec(Metric.class).encode(metric, (CodecContext)this));
            metricsNode.add((JsonNode)item);
        });
        return MetricsWebResource.ok((Object)this.root).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="{metricName}")
    public Response getMetricByName(@PathParam(value="metricName") String metricName) {
        ObjectNode metricNode = this.root.putObject("metric");
        MetricFilter filter = metricName != null ? (name, metric) -> name.equals(metricName) : MetricFilter.ALL;
        TreeMultimap matched = this.listMetrics(this.service, filter);
        if (matched.isEmpty()) {
            throw new ItemNotFoundException("Metric Name is not found");
        }
        ((Collection)matched.asMap().get(metricName)).forEach(m -> metricNode.set(metricName, (JsonNode)this.codec(Metric.class).encode(m, (CodecContext)this)));
        return MetricsWebResource.ok((Object)this.root).build();
    }

    private TreeMultimap<String, Metric> listMetrics(MetricsService metricsService, MetricFilter filter) {
        TreeMultimap metrics = TreeMultimap.create(Comparator.naturalOrder(), (Comparator)Ordering.arbitrary());
        Map counters = metricsService.getCounters(filter);
        for (Map.Entry entry : counters.entrySet()) {
            metrics.put((Object)((String)entry.getKey()), (Object)((Metric)entry.getValue()));
        }
        Map gauges = metricsService.getGauges(filter);
        for (Map.Entry entry : gauges.entrySet()) {
            metrics.put((Object)((String)entry.getKey()), (Object)((Metric)entry.getValue()));
        }
        Map map = metricsService.getHistograms(filter);
        for (Map.Entry entry : map.entrySet()) {
            metrics.put((Object)((String)entry.getKey()), (Object)((Metric)entry.getValue()));
        }
        Map map2 = metricsService.getMeters(filter);
        for (Map.Entry entry : map2.entrySet()) {
            metrics.put((Object)((String)entry.getKey()), (Object)((Metric)entry.getValue()));
        }
        Map map3 = metricsService.getTimers(filter);
        for (Map.Entry entry : map3.entrySet()) {
            metrics.put((Object)((String)entry.getKey()), (Object)((Metric)entry.getValue()));
        }
        return metrics;
    }
}

