/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.rest.resources;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.onlab.util.ItemNotFoundException;
import org.onlab.util.Tools;
import org.onosproject.incubator.net.virtual.TenantId;
import org.onosproject.incubator.net.virtual.VirtualNetworkAdminService;
import org.onosproject.rest.AbstractWebResource;

/*
 * Exception performing whole class analysis ignored.
 */
@Path(value="tenants")
public class TenantWebResource
extends AbstractWebResource {
    private static final String MISSING_TENANTID = "Missing tenant identifier";
    private static final String TENANTID_NOT_FOUND = "Tenant identifier not found";
    private static final String INVALID_TENANTID = "Invalid tenant identifier ";
    @Context
    private UriInfo uriInfo;
    private final VirtualNetworkAdminService vnetAdminService = (VirtualNetworkAdminService)this.get(VirtualNetworkAdminService.class);

    @GET
    @Produces(value={"application/json"})
    public Response getVirtualNetworkTenantIds() {
        Set tenantIds = this.vnetAdminService.getTenantIds();
        return TenantWebResource.ok((Object)this.encodeArray(TenantId.class, "tenants", (Iterable)tenantIds)).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response addTenantId(InputStream stream) {
        try {
            TenantId tid = this.getTenantIdFromJsonStream(stream);
            this.vnetAdminService.registerTenantId(tid);
            TenantId resultTid = TenantWebResource.getExistingTenantId((VirtualNetworkAdminService)this.vnetAdminService, (TenantId)tid);
            UriBuilder locationBuilder = this.uriInfo.getBaseUriBuilder().path("tenants").path((String)resultTid.id());
            return Response.created((URI)locationBuilder.build(new Object[0])).build();
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @DELETE
    @Path(value="{tenantId}")
    public Response removeTenantId(@PathParam(value="tenantId") String tenantId) {
        TenantId tid = TenantId.tenantId((String)tenantId);
        TenantId existingTid = TenantWebResource.getExistingTenantId((VirtualNetworkAdminService)this.vnetAdminService, (TenantId)tid);
        this.vnetAdminService.unregisterTenantId(existingTid);
        return Response.noContent().build();
    }

    private TenantId getTenantIdFromJsonStream(InputStream stream) throws IOException {
        ObjectNode jsonTree = Tools.readTreeFromStream((ObjectMapper)this.mapper(), (InputStream)stream);
        JsonNode specifiedTenantId = jsonTree.get("id");
        if (specifiedTenantId == null) {
            throw new IllegalArgumentException("Missing tenant identifier");
        }
        return TenantId.tenantId((String)specifiedTenantId.asText());
    }

    protected static TenantId getExistingTenantId(VirtualNetworkAdminService vnetAdminSvc, TenantId tidIn) {
        return vnetAdminSvc.getTenantIds().stream().filter(tenantId -> tenantId.equals((Object)tidIn)).findFirst().orElseThrow(() -> new ItemNotFoundException("Tenant identifier not found"));
    }
}

