/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.rest.resources;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Set;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.onlab.util.Tools;
import org.onosproject.codec.CodecContext;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.Link;
import org.onosproject.net.PortNumber;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.topology.ClusterId;
import org.onosproject.net.topology.Topology;
import org.onosproject.net.topology.TopologyCluster;
import org.onosproject.net.topology.TopologyService;
import org.onosproject.rest.AbstractWebResource;

/*
 * Exception performing whole class analysis ignored.
 */
@Path(value="topology")
public class TopologyWebResource
extends AbstractWebResource {
    private static final String CLUSTER_NOT_FOUND = "Cluster is not found";

    @GET
    @Produces(value={"application/json"})
    public Response getTopology() {
        Topology topology = ((TopologyService)this.get(TopologyService.class)).currentTopology();
        ObjectNode root = this.codec(Topology.class).encode((Object)topology, (CodecContext)this);
        return TopologyWebResource.ok((Object)root).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="clusters")
    public Response getClusters() {
        TopologyService service = (TopologyService)this.get(TopologyService.class);
        Topology topology = service.currentTopology();
        Set clusters = service.getClusters(topology);
        ObjectNode root = this.encodeArray(TopologyCluster.class, "clusters", (Iterable)clusters);
        return TopologyWebResource.ok((Object)root).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="clusters/{id}")
    public Response getCluster(@PathParam(value="id") int clusterId) {
        Topology topology = ((TopologyService)this.get(TopologyService.class)).currentTopology();
        TopologyCluster cluster = this.getTopologyCluster(clusterId, topology);
        ObjectNode root = this.codec(TopologyCluster.class).encode((Object)cluster, (CodecContext)this);
        return TopologyWebResource.ok((Object)root).build();
    }

    private TopologyCluster getTopologyCluster(int clusterId, Topology topology) {
        return (TopologyCluster)Tools.nullIsNotFound((Object)((TopologyService)this.get(TopologyService.class)).getCluster(topology, ClusterId.clusterId((int)clusterId)), (String)"Cluster is not found");
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="clusters/{id}/devices")
    public Response getClusterDevices(@PathParam(value="id") int clusterId) {
        TopologyService service = (TopologyService)this.get(TopologyService.class);
        Topology topology = service.currentTopology();
        TopologyCluster cluster = this.getTopologyCluster(clusterId, topology);
        ArrayList deviceIds = Lists.newArrayList((Iterable)service.getClusterDevices(topology, cluster));
        ObjectNode root = this.mapper().createObjectNode();
        ArrayNode devicesNode = root.putArray("devices");
        deviceIds.forEach(id -> devicesNode.add(id.toString()));
        return TopologyWebResource.ok((Object)root).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="clusters/{id}/links")
    public Response getClusterLinks(@PathParam(value="id") int clusterId) {
        Topology topology = ((TopologyService)this.get(TopologyService.class)).currentTopology();
        TopologyCluster cluster = this.getTopologyCluster(clusterId, topology);
        ArrayList links = Lists.newArrayList((Iterable)((TopologyService)this.get(TopologyService.class)).getClusterLinks(topology, cluster));
        return TopologyWebResource.ok((Object)this.encodeArray(Link.class, "links", (Iterable)links)).build();
    }

    private static String getPortNumber(String deviceString) {
        int separator = deviceString.lastIndexOf(58);
        if (separator <= 0) {
            return "";
        }
        return deviceString.substring(separator + 1, deviceString.length());
    }

    private static String getDeviceId(String deviceString) {
        int separator = deviceString.lastIndexOf(58);
        if (separator <= 0) {
            return "";
        }
        return deviceString.substring(0, separator);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="broadcast/{connectPoint}")
    public Response getConnectPointBroadcast(@PathParam(value="connectPoint") String connectPointString) {
        Topology topology = ((TopologyService)this.get(TopologyService.class)).currentTopology();
        DeviceId deviceId = DeviceId.deviceId((String)TopologyWebResource.getDeviceId((String)connectPointString));
        Tools.nullIsNotFound((Object)((DeviceService)this.get(DeviceService.class)).getDevice(deviceId), (String)("Device not found " + connectPointString));
        PortNumber portNumber = PortNumber.portNumber((String)TopologyWebResource.getPortNumber((String)connectPointString));
        Tools.nullIsNotFound((Object)((DeviceService)this.get(DeviceService.class)).getPort(deviceId, portNumber), (String)("Port not found " + connectPointString));
        ConnectPoint connectPoint = new ConnectPoint((ElementId)deviceId, portNumber);
        boolean isBroadcast = ((TopologyService)this.get(TopologyService.class)).isBroadcastPoint(topology, connectPoint);
        return TopologyWebResource.ok((Object)this.mapper().createObjectNode().put("broadcast", isBroadcast)).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="infrastructure/{connectPoint}")
    public Response getConnectPointInfrastructure(@PathParam(value="connectPoint") String connectPointString) {
        Topology topology = ((TopologyService)this.get(TopologyService.class)).currentTopology();
        DeviceId deviceId = DeviceId.deviceId((String)TopologyWebResource.getDeviceId((String)connectPointString));
        Tools.nullIsNotFound((Object)((DeviceService)this.get(DeviceService.class)).getDevice(deviceId), (String)("Device not found " + connectPointString));
        PortNumber portNumber = PortNumber.portNumber((String)TopologyWebResource.getPortNumber((String)connectPointString));
        Tools.nullIsNotFound((Object)((DeviceService)this.get(DeviceService.class)).getPort(deviceId, portNumber), (String)("Port not found " + connectPointString));
        ConnectPoint connectPoint = new ConnectPoint((ElementId)deviceId, portNumber);
        boolean isInfrastructure = ((TopologyService)this.get(TopologyService.class)).isInfrastructure(topology, connectPoint);
        return TopologyWebResource.ok((Object)this.mapper().createObjectNode().put("infrastructure", isInfrastructure)).build();
    }
}

